/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.soa.utils.service;

import gov.va.med.soa.utils.service.ServiceVersion;
import java.io.Serializable;

public class ServiceVersionVO
implements Serializable,
ServiceVersion {
    static final long serialVersionUID = -477025449910614825L;
    private String majorVersion;
    private String minorVersion;
    private String revisionNumber;
    private String buildNumber;

    public ServiceVersionVO() {
    }

    public ServiceVersionVO(String major, String minor, String rev, String build) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.revisionNumber = rev;
        this.buildNumber = build;
    }

    public ServiceVersionVO(int major, int minor, int rev, int build) {
        this.majorVersion = String.valueOf(major);
        this.minorVersion = String.valueOf(minor);
        this.revisionNumber = String.valueOf(rev);
        this.buildNumber = String.valueOf(build);
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isCompatible(ServiceVersion version) {
        if (version.getMajorVersion() != this.majorVersion) {
            return false;
        }
        if (version.getMinorVersion() != this.minorVersion) {
            return false;
        }
        return version.getRevisionNumber() == this.revisionNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.majorVersion);
        sb.append(".");
        sb.append(this.minorVersion);
        sb.append(".");
        sb.append(this.revisionNumber);
        sb.append(".");
        sb.append(this.buildNumber);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServiceVersion)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ServiceVersion serviceVersion = (ServiceVersion)o;
        return this.isCompatible(serviceVersion);
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setMajorVersion(String majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setRevisionNumber(String revisionNumber) {
        this.revisionNumber = revisionNumber;
    }
}

