/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.soa.utils.service;

import gov.va.med.soa.utils.enum.ServiceStateEnum;
import gov.va.med.soa.utils.enum.TechnologyType;
import gov.va.med.soa.utils.service.ServiceInfo;
import gov.va.med.soa.utils.service.ServiceInfoRequestVO;
import gov.va.med.soa.utils.service.ServiceLocationVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class ServiceInfoVO
extends ServiceInfoRequestVO
implements ServiceInfo {
    static final long serialVersionUID = -6019806629605466435L;
    protected int id = -1;
    protected String description = "default";
    protected TechnologyType technology = TechnologyType.UNKNOWN;
    protected String serviceProvider = "default";
    protected ArrayList locations = new ArrayList();

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("\n\tDescription: ").append(this.description);
        buf.append("\n\tTechnology: ").append(this.technology.toString());
        buf.append("\n\tLocations:");
        Iterator iter = this.locations.iterator();
        while (iter.hasNext()) {
            ServiceLocationVO location = (ServiceLocationVO)iter.next();
            buf.append("\n\n").append(location.toString());
        }
        return buf.toString();
    }

    public TechnologyType getTechnology() {
        return this.technology;
    }

    public void setTechnology(TechnologyType technologyTypeEnum) {
        this.technology = technologyTypeEnum;
    }

    public void setTechnology(String technologyType) {
        this.technology = TechnologyType.fromString(technologyType);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(String newProvider) {
        this.serviceProvider = newProvider;
    }

    public Collection getLocations() {
        return this.locations;
    }

    public void setLocations(Collection newLocations) {
        this.locations = new ArrayList();
        this.locations.addAll(newLocations);
    }

    public void addLocation(ServiceLocationVO newLocation) {
        if (this.locations == null) {
            this.locations = new ArrayList();
        }
        this.locations.add(newLocation);
    }

    public void sortAvailableLocations() {
        TreeMap<Integer, ServiceLocationVO> sortedList = new TreeMap<Integer, ServiceLocationVO>();
        if (this.locations != null) {
            for (int i = 0; i < this.locations.size(); ++i) {
                ServiceLocationVO si = (ServiceLocationVO)this.locations.get(i);
                ServiceStateEnum state = si.getState();
                if (state == null || !state.equals(ServiceStateEnum.AVAILABLE)) continue;
                sortedList.put(new Integer(si.getPriority()), si);
            }
        }
        this.locations = new ArrayList(sortedList.values());
    }

    public ServiceLocationVO getServiceLocation(int i) {
        return (ServiceLocationVO)this.locations.get(i);
    }

    public void removeServiceLocation(int i) {
        this.locations.remove(i);
    }
}

