/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.soa.utils.enum;

import java.io.Serializable;

public class ServiceStateEnum
implements Serializable {
    static final long serialVersionUID = -7339013824917508945L;
    public static final int _UNKNOWN = -1;
    public static final int _RETIRED = 0;
    public static final int _AVAILABLE = 1;
    public static final int _BALK = 2;
    private static final String _UNKNOWN_STR = "UNKNOWN";
    private static final String _RETIRED_STR = "RETIRED";
    private static final String _AVAILABLE_STR = "AVAILABLE";
    private static final String _BALK_STR = "BALK";
    public static ServiceStateEnum UNKNOWN = new ServiceStateEnum(-1);
    public static ServiceStateEnum RETIRED = new ServiceStateEnum(0);
    public static ServiceStateEnum AVAILABLE = new ServiceStateEnum(1);
    public static ServiceStateEnum BALK = new ServiceStateEnum(2);
    private int currentServiceState;

    private ServiceStateEnum(int serviceState) {
        this.currentServiceState = serviceState;
    }

    public String toString() {
        switch (this.currentServiceState) {
            case 0: {
                return _RETIRED_STR;
            }
            case 1: {
                return _AVAILABLE_STR;
            }
            case 2: {
                return _BALK_STR;
            }
        }
        return _UNKNOWN_STR;
    }

    public static ServiceStateEnum fromInt(int i) {
        switch (i) {
            case 0: {
                return RETIRED;
            }
            case 1: {
                return AVAILABLE;
            }
            case 2: {
                return BALK;
            }
        }
        return UNKNOWN;
    }

    public static ServiceStateEnum fromString(String s) {
        if (s == null) {
            return UNKNOWN;
        }
        if (s.equalsIgnoreCase(_RETIRED_STR)) {
            return RETIRED;
        }
        if (s.equalsIgnoreCase(_AVAILABLE_STR)) {
            return AVAILABLE;
        }
        if (s.equalsIgnoreCase(_BALK_STR)) {
            return BALK;
        }
        return UNKNOWN;
    }

    public int value() {
        return this.currentServiceState;
    }

    public boolean equals(Object reference) {
        if (!(reference instanceof ServiceStateEnum)) {
            return false;
        }
        return this.value() == ((ServiceStateEnum)reference).value();
    }

    public ServiceStateEnum() {
    }

    public int getCurrentServiceState() {
        return this.currentServiceState;
    }

    public void setCurrentServiceState(int currentServiceState) {
        this.currentServiceState = currentServiceState;
    }
}

