/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.utils;

import gov.va.med.caip.client.exceptions.CaipJMSUtilityException;
import gov.va.med.caip.client.exceptions.CaipServiceException;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class JMSUtilities {
    public static TextMessage createTextMessage(Session session) throws CaipJMSUtilityException {
        try {
            return session.createTextMessage();
        }
        catch (JMSException e) {
            throw new CaipJMSUtilityException(e);
        }
    }

    public static ObjectMessage createObjectMessage(Session session) throws CaipJMSUtilityException {
        try {
            return session.createObjectMessage();
        }
        catch (JMSException e) {
            throw new CaipJMSUtilityException(e);
        }
    }

    public static BytesMessage createBytesMessage(Session session) throws CaipJMSUtilityException {
        try {
            return session.createBytesMessage();
        }
        catch (JMSException e) {
            throw new CaipJMSUtilityException(e);
        }
    }

    public static MapMessage createMapMessage(Session session) throws CaipJMSUtilityException {
        try {
            return session.createMapMessage();
        }
        catch (JMSException e) {
            throw new CaipJMSUtilityException(e);
        }
    }

    public static void sendMessage(Connection conn, Session session, Destination dest, Message msg) throws CaipServiceException, CaipJMSUtilityException {
        block4: {
            try {
                if (conn instanceof QueueConnection) {
                    QueueConnection qconn = (QueueConnection)conn;
                    QueueSession qsession = (QueueSession)session;
                    Queue queue = (Queue)dest;
                    QueueSender qsender = qsession.createSender(queue);
                    qconn.start();
                    qsender.send(msg);
                    qconn.stop();
                    break block4;
                }
                if (conn instanceof TopicConnection) {
                    TopicConnection tconn = (TopicConnection)conn;
                    TopicSession tsession = (TopicSession)session;
                    Topic topic = (Topic)dest;
                    TopicPublisher tpublisher = tsession.createPublisher(topic);
                    tconn.start();
                    tpublisher.publish(msg);
                    tconn.stop();
                    break block4;
                }
                throw new CaipServiceException("Unsupported Connection Factory");
            }
            catch (JMSException e) {
                throw new CaipJMSUtilityException(e);
            }
        }
    }
}

