/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.utils;

import gov.va.med.caip.client.config.BusinessDelegateDDInfo;
import gov.va.med.caip.client.config.PerformanceMetricsInfo;
import gov.va.med.caip.client.utils.AuditTimerType;
import gov.va.med.soa.utils.service.ServiceInfo;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class CAIPAuditTimer {
    private AuditTimerType _timerType;
    private PerformanceMetricsInfo _pmi = null;
    private long _startTimeMillis = 0L;
    private long _stopTimeMillis = 0L;
    private long _timeElapsedMillis = 0L;
    private Logger _log = Logger.getLogger((Class)(class$gov$va$med$caip$client$utils$CAIPAuditTimer == null ? (class$gov$va$med$caip$client$utils$CAIPAuditTimer = CAIPAuditTimer.class$("gov.va.med.caip.client.utils.CAIPAuditTimer")) : class$gov$va$med$caip$client$utils$CAIPAuditTimer));
    static /* synthetic */ Class class$gov$va$med$caip$client$utils$CAIPAuditTimer;

    public CAIPAuditTimer(PerformanceMetricsInfo pmi, AuditTimerType timerType, boolean startTimer) {
        this._pmi = pmi;
        this._timerType = timerType;
        if (startTimer) {
            this.start();
        }
    }

    public void start() {
        if (this.isAuditTarget()) {
            this._startTimeMillis = System.currentTimeMillis();
        }
    }

    private boolean isAuditTarget() {
        boolean result = false;
        if (this._pmi == null) {
            if (this._timerType == AuditTimerType.TIMER_CONFIG) {
                result = true;
            }
        } else if (this._timerType == AuditTimerType.TIMER_CONFIG && this._pmi.isTimeConfigureCaip() || this._timerType == AuditTimerType.TIMER_NDS_LOOKUP && this._pmi.isTimeNDSLookup() || this._timerType == AuditTimerType.TIMER_NARROW && this._pmi.isTimeServiceNarrowingRebinding() || this._timerType == AuditTimerType.TIMER_INVOKE && this._pmi.isTimeProxyInvocation()) {
            result = true;
        }
        return result;
    }

    public void stopAndLog() {
        this.stopAndLog((ServiceInfo)null);
    }

    public void stopAndLog(BusinessDelegateDDInfo info) {
        this.stopAndLog(info, null);
    }

    public void stopAndLog(BusinessDelegateDDInfo businessDelegateDDInfo, String method) {
        this.stop();
        if (this.isAuditTarget()) {
            StringBuffer msg = this.getLogHeader();
            if (businessDelegateDDInfo != null) {
                msg.append("Implementation class = " + businessDelegateDDInfo.getImplementationClassName() + "\n");
                msg.append("Signature = " + businessDelegateDDInfo.getSignature() + "\n");
                msg.append("Technology type = " + businessDelegateDDInfo.getTechnologyType() + "\n");
            }
            if (method != null && method.length() > 0) {
                msg.append("Method = ");
                msg.append(method);
                msg.append("\n");
            }
            this.log(msg);
        }
    }

    public void stopAndLog(ServiceInfo serviceInfo) {
        this.stop();
        if (this.isAuditTarget()) {
            StringBuffer msg = this.getLogHeader();
            if (serviceInfo != null) {
                msg.append("Implementation class = " + serviceInfo.getName() + "\n");
                msg.append("Signature = " + serviceInfo.getSignature() + "\n");
                msg.append("Technology type = " + serviceInfo.getTechnology() + "\n");
            }
            this.log(msg);
        }
    }

    private StringBuffer getLogHeader() {
        StringBuffer msg = new StringBuffer("\nAudit Timer\n");
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this._startTimeMillis);
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss:SSS");
        msg.append(sdf.format(gc.getTime()));
        msg.append("\n");
        msg.append("Action = ");
        msg.append(this._timerType.getDescription());
        msg.append("\n");
        msg.append("Elapsed milliseconds = ");
        msg.append(this._timeElapsedMillis);
        msg.append("\n");
        return msg;
    }

    public long stop() {
        if (this._startTimeMillis == 0L) {
            this._timeElapsedMillis = -1L;
        } else {
            this._stopTimeMillis = System.currentTimeMillis();
            this._timeElapsedMillis = this._stopTimeMillis - this._startTimeMillis;
        }
        return this._timeElapsedMillis;
    }

    private void log(StringBuffer message) {
        this._log.info((Object)message.toString());
    }

    public long getTimeElapsedMillis() {
        return this._timeElapsedMillis;
    }

    public void setPerformaceMetricsInfo(PerformanceMetricsInfo pmi) {
        this._pmi = pmi;
    }

    public void setLogger(Logger logger) {
        this._log = logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

