/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.factory;

import gov.va.med.caip.client.businessdelegate.BusinessDelegate;
import gov.va.med.caip.client.config.BusinessDelegateDDInfo;
import gov.va.med.caip.client.config.PerformanceMetricsInfo;
import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.caip.client.factory.BusinessDelegateFactory;
import gov.va.med.caip.client.utils.AuditTimerType;
import gov.va.med.caip.client.utils.CAIPAuditTimer;
import gov.va.med.soa.utils.service.ServiceInfoVO;
import gov.va.med.soa.utils.service.ServiceLocationVO;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DelegateProxy
implements InvocationHandler {
    BusinessDelegate _concrete;
    BusinessDelegateDDInfo _bdInfo;
    PerformanceMetricsInfo _performanceMetricsInfo;
    ServiceInfoVO _ndsServiceList = null;
    int _serviceIndex = 0;
    private static final Logger _log = Logger.getLogger((Class)(class$gov$va$med$caip$client$factory$DelegateProxy == null ? (class$gov$va$med$caip$client$factory$DelegateProxy = DelegateProxy.class$("gov.va.med.caip.client.factory.DelegateProxy")) : class$gov$va$med$caip$client$factory$DelegateProxy));
    static /* synthetic */ Class class$gov$va$med$caip$client$factory$DelegateProxy;

    public DelegateProxy(BusinessDelegate obj, BusinessDelegateDDInfo bdInfo, PerformanceMetricsInfo performanceMetricsInfo) {
        this._concrete = obj;
        this._bdInfo = bdInfo;
        this._performanceMetricsInfo = performanceMetricsInfo;
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        return this.invoke(proxy, method, params, true, true);
    }

    private Object invoke(Object proxy, Method method, Object[] params, boolean firstTime, boolean altFirstTime) throws Throwable {
        Object response;
        block14: {
            CAIPAuditTimer timer = new CAIPAuditTimer(this._performanceMetricsInfo, AuditTimerType.TIMER_INVOKE, true);
            response = null;
            try {
                response = method.invoke((Object)this._concrete, params);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof CaipInvocationException) {
                    if (firstTime) {
                        _log.info((Object)"Invoke of currently bound service failed. Attempting rebind on primary service.");
                        this._ndsServiceList = BusinessDelegateFactory.rebindService(this._concrete, this._bdInfo);
                        this._serviceIndex = 0;
                        response = this.invoke(proxy, method, params, false, true);
                        break block14;
                    }
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Rebind failed. Attempting failover. Pruned relative service index = " + this._serviceIndex));
                    }
                    if (this._ndsServiceList != null && this._serviceIndex < this._ndsServiceList.getLocations().size()) {
                        ServiceLocationVO serviceLocation = this._ndsServiceList.getServiceLocation(this._serviceIndex);
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Failover target = " + serviceLocation.getTarget() + ". NDS priority=" + serviceLocation.getPriority()));
                        }
                        BusinessDelegateFactory.rebindServiceFailover(this._concrete, this._ndsServiceList, serviceLocation, this._bdInfo);
                        if (altFirstTime) {
                            altFirstTime = false;
                        } else {
                            _log.info((Object)"Second attempt to use current failover target.");
                            ++this._serviceIndex;
                            altFirstTime = true;
                        }
                        response = this.invoke(proxy, method, params, false, altFirstTime);
                        break block14;
                    }
                    _log.info((Object)"No more alternate services available for failover.");
                    throw t;
                }
                throw t;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                timer.stopAndLog(this._bdInfo, method.getName());
            }
        }
        return response;
    }

    private static Class[] getInterfaces(Object obj) {
        int i;
        ArrayList v = new ArrayList();
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] classes = clazz.getInterfaces();
            for (i = 0; i < classes.length; ++i) {
                v.add(classes[i]);
            }
        }
        Class[] resp = new Class[v.size()];
        for (i = 0; i < v.size(); ++i) {
            resp[i] = (Class)v.get(i);
        }
        return resp;
    }

    public static Object newInstance(BusinessDelegate obj, BusinessDelegateDDInfo bdInfo, PerformanceMetricsInfo pmi) {
        Object newInstance;
        ClassLoader classLoader = obj.getClass().getClassLoader();
        try {
            newInstance = Proxy.newProxyInstance(classLoader, DelegateProxy.getInterfaces(obj), (InvocationHandler)new DelegateProxy(obj, bdInfo, pmi));
        }
        catch (IllegalArgumentException e) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Could not find proxy class in CAIP classpath. Checking Thread's context loader.");
            }
            classLoader = Thread.currentThread().getContextClassLoader();
            newInstance = Proxy.newProxyInstance(classLoader, DelegateProxy.getInterfaces(obj), (InvocationHandler)new DelegateProxy(obj, bdInfo, pmi));
        }
        return newInstance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

