/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.ivmdm.IVMMigration;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.external.IVMSummaryFactory;
import gov.va.med.esr.service.external.person.IVMCandidateInfo;
import gov.va.med.esr.service.external.person.PersonInfo;
import gov.va.med.esr.service.external.person.VamcInfo;
import gov.va.med.esr.service.external.person.collections.VamcDataCollection;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class IVMSummaryFactoryImpl
implements IVMSummaryFactory {
    private IVMDMService ivmService;
    private PersonService personService = null;

    @Override
    public IVMCandidateInfo[] buildIVMCandidatesInfo(Date date) throws ServiceException {
        Set candidateSet = null;
        candidateSet = this.ivmService.findIVMMigrationData(date);
        IVMCandidateInfo[] eeIVMCandidateInfo = new IVMCandidateInfo[candidateSet.size()];
        Iterator itr = candidateSet != null ? candidateSet.iterator() : null;
        int i = 0;
        while (itr != null && itr.hasNext()) {
            IVMCandidateInfo ivmCandidateInfo = new IVMCandidateInfo();
            IVMMigration ivmData = (IVMMigration)itr.next();
            if (ivmData.getPersonEntityKey() != null) {
                ivmCandidateInfo.setVpid(this.getPersonService().getVPIDByPersonId(ivmData.getPersonEntityKey()).getVPID());
                ivmCandidateInfo.setIncomeYear(ivmData.getIncomeYear());
                ivmCandidateInfo.setTransactionId(ivmData.getEntityKey().getKeyValueAsString());
                this.ivmService.saveIVMMigration(ivmData, MessageStatus.AWAITING_ACKNOWLEDGEMENT);
            }
            eeIVMCandidateInfo[i] = ivmCandidateInfo;
            ++i;
        }
        return eeIVMCandidateInfo;
    }

    @Override
    public boolean updateIVMStatus(BigDecimal transactionId, String status) throws ServiceException {
        IVMMigration ivmRecord = this.ivmService.findIVMMigration(transactionId);
        boolean updated = false;
        if (ivmRecord != null) {
            updated = true;
            if (status == null || status.equals("")) {
                ivmRecord.setMigrationDate(new Date());
                ivmRecord.setLoadFailureReason(status);
                this.ivmService.saveIVMMigration(ivmRecord, MessageStatus.COMPLETE);
            } else {
                ivmRecord.setLoadFailureReason(status);
                this.ivmService.saveIVMMigration(ivmRecord, MessageStatus.ERROR);
            }
        }
        return updated;
    }

    @Override
    public PersonInfo applyPersonInfo(Person person, Set sites) {
        PersonInfo personInfo = new PersonInfo();
        this.getVeteranData(person, personInfo);
        this.getVamcData(person, personInfo, sites);
        return personInfo;
    }

    private void getVamcData(Person person, PersonInfo personInfo, Set sites) {
        VamcInfo[] vamc = new VamcInfo[sites.size()];
        int i = 0;
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            vamc[i] = this.getVAMCIdData(person, (SiteIdentity)iter.next());
            ++i;
        }
        if (vamc.length > 0) {
            personInfo.setVamcData(new VamcDataCollection(vamc));
        }
    }

    private VamcInfo getVAMCIdData(Person person, SiteIdentity siteIdentity) {
        VamcInfo vamcData = new VamcInfo();
        VAFacility facility = siteIdentity.getVaFacility();
        vamcData.setFacilityNumber(facility.getStationNumber() == null ? null : facility.getStationNumber());
        vamcData.setDfnNumber(siteIdentity.getDfn() == null ? null : siteIdentity.getDfn());
        PatientVisitSummary summary = PatientVisitSummary.getLastestVisitedSummary((Collection)person.getPatientVisitSummaries(facility));
        vamcData.setLastVisitDate(summary == null ? null : summary.getLastVisitDate());
        vamcData.setVamcReportDate(summary == null ? null : summary.getModifiedOn());
        return vamcData;
    }

    public IVMDMService getIvmService() {
        return this.ivmService;
    }

    public void setIvmService(IVMDMService ivmService) {
        this.ivmService = ivmService;
    }

    private void getVeteranData(Person person, PersonInfo personInfo) {
        this.addNameData(personInfo, person.getLegalName());
        SSN ssn = person.getOfficialSsn();
        this.addSsnTextData(personInfo, ssn);
        BirthRecord dob = person.getBirthRecord();
        personInfo.setGender(person.getGender() == null ? null : person.getGender().getName());
        personInfo.setDob(dob == null ? null : (dob.getBirthDate() == null ? null : dob.getBirthDate().getStandardFormat()));
        this.addSsnStatusData(personInfo, ssn);
    }

    private void addSsnStatusData(PersonInfo personInfo, SSN ssn) {
        SSAVerificationStatus ssaVerStatus = ssn == null ? null : ssn.getSsaVerificationStatus();
        personInfo.setSsaVerificationStatus(ssaVerStatus == null ? null : ssaVerStatus.getDescription());
        personInfo.setSsaVerificationDate(ssn == null ? null : ssn.getSsaVerificationDate());
    }

    private void addSsnTextData(PersonInfo personInfo, SSN ssn) {
        String ssnText = ssn == null ? null : ssn.getSsnText();
        ssnText = ssnText == null ? null : ssnText.replaceAll("-", "");
        personInfo.setSsnText(ssnText);
    }

    private void addNameData(PersonInfo personInfo, Name name) {
        personInfo.setLastName(name == null ? null : name.getFamilyName());
        personInfo.setFirstName(name == null ? null : name.getGivenName());
        personInfo.setMiddleName(name == null ? null : name.getMiddleName());
        personInfo.setPrefix(name == null ? null : name.getPrefix());
        personInfo.setSuffix(name == null ? null : name.getSuffix());
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

