/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.namingdirectory.client;

import gov.va.med.namingdirectory.NamingDirectoryHome;
import gov.va.med.namingdirectory.NamingDirectoryRemote;
import gov.va.med.namingdirectory.client.AddServicesCommand;
import gov.va.med.namingdirectory.client.Command;
import gov.va.med.namingdirectory.client.ListServicesCommand;
import gov.va.med.namingdirectory.client.RemoveServiceCommand;
import gov.va.med.namingdirectory.client.UpdateServiceCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class NDSUtilities {
    private String url = null;
    private String serviceProvider = null;
    private Hashtable commands = new Hashtable();
    private NamingDirectoryRemote ndsRemote = null;
    static /* synthetic */ Class class$gov$va$med$namingdirectory$NamingDirectoryHome;

    public NDSUtilities(String[] args) {
        if (args.length < 2) {
            NDSUtilities.showUsageAndExit();
        }
        this.url = args[0];
        this.serviceProvider = args[1];
        this.initializeCommands();
        this.initializeNDS();
    }

    private void initializeNDS() {
        try {
            Properties prop = new Properties();
            prop.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            prop.put("java.naming.provider.url", this.url);
            prop.put("java.naming.security.principal", "weblogic");
            prop.put("java.naming.security.credentials", "weblogic");
            InitialContext ctx = new InitialContext(prop);
            NamingDirectoryHome ndsHome = (NamingDirectoryHome)PortableRemoteObject.narrow((Object)ctx.lookup("ejb/gov.va.med.namingdirectory.NamingDirectory-IR2"), (Class)(class$gov$va$med$namingdirectory$NamingDirectoryHome == null ? (class$gov$va$med$namingdirectory$NamingDirectoryHome = NDSUtilities.class$("gov.va.med.namingdirectory.NamingDirectoryHome")) : class$gov$va$med$namingdirectory$NamingDirectoryHome));
            this.ndsRemote = ndsHome.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.exit(-1);
        }
    }

    private void initializeCommands() {
        this.commands.put("a", new AddServicesCommand());
        this.commands.put("l", new ListServicesCommand());
        this.commands.put("r", new RemoveServiceCommand());
        this.commands.put("u", new UpdateServiceCommand());
    }

    public static void main(String[] args) {
        NDSUtilities ndsUtilities = new NDSUtilities(args);
        ndsUtilities.acceptInput();
    }

    private void acceptInput() {
        boolean continueAcceptingInput = true;
        while (continueAcceptingInput) {
            System.out.print("NDSUtilities > ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                String input = br.readLine();
                if (input.length() == 0) {
                    System.out.println("Please enter a command.  Enter 'h' for help");
                    continue;
                }
                String command = input.substring(0, 1);
                Command commandToRun = (Command)this.commands.get(command);
                if (commandToRun == null) {
                    if (command.equals("q")) {
                        continueAcceptingInput = false;
                        break;
                    }
                    if (command.equals("h")) {
                        this.showHelp();
                        continue;
                    }
                    System.out.println("Unrecognized command: " + command);
                    continue;
                }
                String commandParameters = null;
                if (input.length() > 2) {
                    commandParameters = input.substring(2);
                }
                commandToRun.run(this.ndsRemote, this.serviceProvider, commandParameters);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        }
    }

    private void showHelp() {
        System.out.println("Commands Available:");
        Iterator iter = this.commands.values().iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            System.out.println("\t" + command.helpMessage());
        }
        System.out.println("\th - Shows this message");
        System.out.println("\tq - Quits the application");
    }

    private static void showUsageAndExit() {
        System.out.println("Usage:  java gov.va.med.namingdirectory.client.NDSUtilities <url> <service provider>");
        System.out.println("\turl is the url to the naming and directory service");
        System.out.println("\tservice provider is the name of the service team entering the service.");
        System.exit(-1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

