/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.namingdirectory.client;

import gov.va.med.namingdirectory.NamingDirectoryRemote;
import gov.va.med.namingdirectory.client.Command;
import gov.va.med.soa.utils.service.ServiceInfoVO;
import java.util.Collection;
import java.util.Iterator;

class ListServicesCommand
extends Command {
    ListServicesCommand() {
    }

    public void run(NamingDirectoryRemote ndsRemote, String serviceProvider, String input) {
        String[] parameters = this.tokenizeInput(input);
        try {
            Collection services = null;
            if (parameters == null) {
                ServiceInfoVO serviceInfo = new ServiceInfoVO();
                serviceInfo.setServiceProvider(serviceProvider);
                services = ndsRemote.listServicesByServiceProvider(serviceInfo);
            } else if (parameters[0].equals("all")) {
                services = ndsRemote.listAllServices();
            } else {
                System.out.println("Unrecognized parameter: '" + input + "'");
                return;
            }
            if (services.isEmpty()) {
                System.out.println("No services found");
            } else {
                Iterator serviceIterator = services.iterator();
                while (serviceIterator.hasNext()) {
                    System.out.println(serviceIterator.next().toString());
                    System.out.println();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public String helpMessage() {
        return "l [all] - Lists services defined by the provider in NDS.  Optional 'all' parameter shows all services";
    }
}

