/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.trigger;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.CommonTriggerIdentity;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import java.util.List;

public class ClockTriggerEvent
extends PersonTriggerEvent {
    private static final long serialVersionUID = -5262693326968221439L;
    public static final String CANCEL_CLOCK = "triggerEvent.cancelClock";
    public static final String START_CLOCK = "triggerEvent.startClock";
    private String triggerName;
    private String triggerGroup;
    private String jobDetailBeanName;
    private double hoursDelay;
    private List clockData;

    public ClockTriggerEvent(String clockName, PersonEntityKey personId) {
        super(new CommonTriggerIdentity(CommonTrigger.DestinationType.COMMON));
        this.setName(clockName);
        super.setPersonId(personId);
    }

    public List getClockData() {
        return this.clockData;
    }

    public void setClockData(List clockData) {
        this.clockData = clockData;
    }

    public double getHoursDelay() {
        return this.hoursDelay;
    }

    public void setHoursDelay(double hoursDelay) {
        this.hoursDelay = hoursDelay;
    }

    public String getTriggerGroup() {
        return this.triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getJobDetailBeanName() {
        return this.jobDetailBeanName;
    }

    public void setJobDetailBeanName(String jobDetailBeanName) {
        this.jobDetailBeanName = jobDetailBeanName;
    }

    public double getAdjustedHoursDelay() {
        long effectiveClockStartTime = this.getCreationDate();
        if (effectiveClockStartTime == 0L) {
            return this.getHoursDelay();
        }
        long difference = System.currentTimeMillis() - effectiveClockStartTime;
        double hoursToRemoveFromDelay = difference / 3600000L;
        if (hoursToRemoveFromDelay < 1.0) {
            return this.getHoursDelay();
        }
        if (hoursToRemoveFromDelay >= this.getHoursDelay()) {
            return 0.0;
        }
        return this.getHoursDelay() - hoursToRemoveFromDelay;
    }
}

