/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.builder.entity.BooleanBuilder;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.common.persistent.system.SystemParameterDAO;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SystemParameterServiceImpl
extends AbstractRuleAwareServiceImpl
implements SystemParameterService {
    private SystemParameterDAO systemParameterDAO = null;
    private String esrVersion = "Undefined";
    private String defaultEsrImplementationDate = "01/01/2007";

    @Override
    public List findAll() throws ServiceException {
        try {
            return this.getSystemParameterDAO().findAll();
        }
        catch (DAOException e) {
            throw new ServiceException("Can not retrive System Parameters", (Throwable)e);
        }
    }

    @Override
    public SystemParameter getByName(String parameterName) throws ServiceException {
        try {
            return this.getSystemParameterDAO().getByName(parameterName);
        }
        catch (DAOException e) {
            throw new ServiceException("Can not retrive System Parameter " + parameterName, (Throwable)e);
        }
    }

    @Override
    public Set save(Set parameters) throws ServiceException {
        boolean AOTreatmentAuthorityExpired = false;
        boolean ECTreatmentAuthorityExpired = false;
        try {
            List onFileSystemParameters = this.findAll();
            this.ensureEntityChanged(parameters, onFileSystemParameters);
            HashMap<String, SystemParameter> onFileMap = new HashMap<String, SystemParameter>();
            HashSet<SystemParameter> onFileSet = new HashSet<SystemParameter>();
            for (SystemParameter systemParameter : onFileSystemParameters) {
                onFileMap.put(systemParameter.getName(), systemParameter);
                onFileSet.add(systemParameter);
            }
            for (SystemParameter incoming : parameters) {
                SystemParameter onFile = (SystemParameter)onFileMap.get(incoming.getName());
                if (incoming.getName().equals("Agent Orange Special Treatment Authority Indicator") && Boolean.FALSE.equals(this.getBoolean(incoming.getValue())) && Boolean.TRUE.equals(this.getBoolean(onFile.getValue()))) {
                    AOTreatmentAuthorityExpired = true;
                }
                if (incoming.getName().equals("SW Asia Cond. Special Treatment Authority Ind") && Boolean.FALSE.equals(this.getBoolean(incoming.getValue())) && Boolean.TRUE.equals(this.getBoolean(onFile.getValue()))) {
                    ECTreatmentAuthorityExpired = true;
                }
                this.merge(incoming, onFile);
            }
            this.setExpirationDate(onFileMap, "Agent Orange Special Treatment Authority Exp Date", AOTreatmentAuthorityExpired);
            this.setExpirationDate(onFileMap, "SW Asia Cond. Special Treatment Authority Exp Date", ECTreatmentAuthorityExpired);
            return this.getSystemParameterDAO().update(onFileSet);
        }
        catch (DAOException e) {
            throw new ServiceException("Can not update System Parameters ", (Throwable)e);
        }
    }

    public SystemParameterDAO getSystemParameterDAO() {
        return this.systemParameterDAO;
    }

    public void setSystemParameterDAO(SystemParameterDAO systemParameterDAO) {
        this.systemParameterDAO = systemParameterDAO;
    }

    @Override
    public String getEsrVersion() throws ServiceException {
        return this.esrVersion;
    }

    public void setEsrVersion(String esrVersion) {
        this.esrVersion = esrVersion;
    }

    public void setDefaultEsrImplementationDate(String value) throws ServiceException {
        if (StringUtils.isNotEmpty((String)value)) {
            this.defaultEsrImplementationDate = value;
        }
    }

    protected Date getDateParameter(String paramName) throws ServiceException {
        return this.getDateParameter(paramName, null);
    }

    protected Date getDateParameter(String paramName, String defaultDateStr) throws ServiceException {
        Date dateParam = null;
        String dateStr = defaultDateStr;
        SystemParameter par = this.getByName(paramName);
        if (par != null && StringUtils.isNotEmpty((String)par.getValue().trim())) {
            dateStr = par.getValue().trim();
        }
        if (dateStr != null) {
            try {
                String[] dateFormats = new String[]{"MM/dd/yyyy"};
                dateParam = DateUtils.parseDate((String)dateStr, (String[])dateFormats);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to parse " + paramName + " from " + dateStr, (Throwable)e);
            }
        }
        return dateParam;
    }

    protected Boolean getBooleanParameter(String paramName) throws ServiceException {
        Boolean boolParam = null;
        SystemParameter parameter = this.getByName(paramName);
        if (parameter != null) {
            boolParam = this.getBoolean(parameter.getValue());
        }
        return boolParam;
    }

    protected Boolean getBoolean(String paramValue) throws ServiceException {
        Boolean boolParam = null;
        if (paramValue != null) {
            try {
                boolParam = new BooleanBuilder().build(paramValue);
            }
            catch (BuilderException eb) {
                throw new ServiceException("Unable to parse parameter value " + paramValue + ".", (Throwable)eb);
            }
        }
        return boolParam;
    }

    @Override
    public Date getEsrImplementationDate() throws ServiceException {
        return this.getDateParameter("ESR Implementation Date", this.defaultEsrImplementationDate);
    }

    @Override
    public Boolean getAOTreatmentAuthorityIndicator() throws ServiceException {
        return this.getBooleanParameter("Agent Orange Special Treatment Authority Indicator");
    }

    @Override
    public Boolean getECTreamentAuthorityIndicator() throws ServiceException {
        return this.getBooleanParameter("SW Asia Cond. Special Treatment Authority Ind");
    }

    @Override
    public Date getAOTreatmentAuthorityExpirationDate() throws ServiceException {
        return this.getDateParameter("Agent Orange Special Treatment Authority Exp Date");
    }

    @Override
    public Date getECTreatmentAuthorityExpirationDate() throws ServiceException {
        return this.getDateParameter("SW Asia Cond. Special Treatment Authority Exp Date");
    }

    @Override
    public Date getEnrollmentRegulationDate() throws ServiceException {
        SystemParameter par = this.getByName("Enrollment Regulation Date");
        String dateStr = "";
        if (par != null && StringUtils.isNotEmpty((String)par.getValue())) {
            dateStr = par.getValue();
        }
        try {
            String[] dateFormats = new String[]{"MM/dd/yyyy"};
            Date regDate = DateUtils.parseDate((String)dateStr, (String[])dateFormats);
            return regDate;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to parse Enrollment Regulation date from " + dateStr, (Throwable)e);
        }
    }

    @Override
    public Date getVFAStartDate() throws ServiceException {
        SystemParameter par = this.getByName("VFA Start Date");
        String dateStr = "";
        if (par != null && StringUtils.isNotEmpty((String)par.getValue())) {
            dateStr = par.getValue();
        }
        try {
            String[] dateFormats = new String[]{"MM/dd/yyyy"};
            Date regDate = DateUtils.parseDate((String)dateStr, (String[])dateFormats);
            return regDate;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to parse VFA Start Date from " + dateStr, (Throwable)e);
        }
    }

    private void merge(SystemParameter incoming, SystemParameter onFile) {
        onFile.setValue(incoming.getValue());
        onFile.setUnit(incoming.getUnit());
    }

    private void setExpirationDate(Map map, String paramType, boolean isExpired) {
        SystemParameter expDate = (SystemParameter)map.get(paramType);
        if (isExpired) {
            expDate.setValue(DateUtils.format((Date)new Date(), (String)"MM/dd/yyyy"));
        } else if (StringUtils.isEmpty((String)expDate.getValue())) {
            expDate.setValue(" ");
        }
    }

    @Override
    public Boolean getVOAAnonymousLevel1ProcessIndicator() throws ServiceException {
        return this.getBooleanParameter("VOA Anonymous/Level 1 Process Indicator");
    }

    @Override
    public Boolean getMSDSServiceIndicator() throws ServiceException {
        return this.getBooleanParameter("MSDS Service Indicator");
    }

    @Override
    public Boolean getMSDSReconIndicator() throws ServiceException {
        return this.getBooleanParameter("MSDS Reconciliation Indicator");
    }

    @Override
    public String getHandBookReleaseCtl() throws ServiceException {
        SystemParameter par = this.getByName("Default Handbook Batch Release Control Number");
        String releaseCtl = par.getValue();
        return releaseCtl;
    }

    @Override
    public void updateDefaultHandBookReleaseCtl(String releaseCtl) throws ServiceException {
        try {
            SystemParameter par = this.getByName("Default Handbook Batch Release Control Number");
            par.setValue(releaseCtl);
            this.systemParameterDAO.saveObject(par);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error updating handbook release control number " + (Object)((Object)ex));
        }
    }

    @Override
    public boolean isHandBookRollOutOver() throws ServiceException {
        SystemParameter par = this.getByName("HANDBOOK ROLL OUT OVER");
        String rollout = par.getValue();
        return "Y".equals(rollout);
    }

    @Override
    public Boolean getVBADataSharingIndicator() throws ServiceException {
        return this.getBooleanParameter("VBA Data Sharing Indicator");
    }

    @Override
    public Boolean getHBPDataSharingIndicator() throws ServiceException {
        return this.getBooleanParameter("HBP Data sharing indicator");
    }

    @Override
    public Boolean getIVMFinalLetterIndicator() throws ServiceException {
        return this.getBooleanParameter("IVM Final Letter Indicator");
    }

    @Override
    public Boolean getEsSidIndicator() throws ServiceException {
        return this.getBooleanParameter("ES SID Indicator");
    }

    @Override
    public Boolean getDODIndicator() throws ServiceException {
        return this.getBooleanParameter("Use MVI Date of Death Service Indicator");
    }

    @Override
    public Boolean getDODSharing() throws ServiceException {
        return this.getBooleanParameter("Transmit Date of Death Indicator");
    }

    @Override
    public String getCLVistARolloutStr() throws ServiceException {
        SystemParameter par = this.getByName("CL_VISTA_FULL_ROLLOUT");
        String clVistARollout = par.getValue();
        return clVistARollout;
    }
}

