/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.ScheduledTaskService;
import gov.va.med.esr.service.trigger.ClockTriggerEvent;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StopWatchLogger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.RandomUtils;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class ScheduledTaskServiceImpl
extends AbstractComponent
implements ScheduledTaskService {
    private static final long serialVersionUID = -7330225195956530898L;
    private static final int ONE_DAY_HOURS = 24;
    private static final int ONE_HOUR_MINS = 60;
    private SchedulingService schedulingService = null;
    private TriggerEventCacheManager triggerEventCacheManager;
    private boolean asyncClockMode;
    private String scheduledJobVOAClockProcessName = null;
    private String scheduledJobPHClockProcessName = null;
    private String scheduledJobSSNClockProcessName = null;
    private String scheduledJobWfClockProcessName = null;
    private String scheduledJobZ11ClockProcessName = null;
    private int scatterClockFactor;
    private boolean allowClocksToScatterAcrossDayBoundary = false;
    private int disallowClocksToScatterIfProcessingAfterHour = 20;
    private double ph14DayLetterDays = 14.0;
    private double ph37DayLetterDays = 37.0;
    private double ssnVerificationLetterDays = 30.0;
    private double pseudoSsnLetterDays = 30.0;
    private double pseudoSsnReminderLetterDays = 30.0;
    private double voa3DayPendingDays = 3.0;
    private double msQueryPendingHours = 72.0;
    private double z11PendingTraitsMins = 10.0;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.schedulingService, (String)"schedulingService is required");
        Validate.notNull((Object)this.triggerEventCacheManager, (String)"triggerEventCacheManager is required");
        Validate.notNull((Object)this.scheduledJobPHClockProcessName, (String)"scheduledJobPHClockProcessName is required.");
        Validate.notNull((Object)this.scheduledJobSSNClockProcessName, (String)"scheduledJobSSNClockProcessName is required.");
        Validate.isTrue((this.voa3DayPendingDays > 0.0 ? 1 : 0) != 0, (String)"voa3DayPendingDays must be greater than zero.", (double)this.voa3DayPendingDays);
        Validate.isTrue((this.ph14DayLetterDays > 0.0 ? 1 : 0) != 0, (String)"ph14DayLetterDays must be greater than zero.", (double)this.ph14DayLetterDays);
        Validate.isTrue((this.ph37DayLetterDays > 0.0 ? 1 : 0) != 0, (String)"ph37DayLetterDays must be greater than zero.", (double)this.ph37DayLetterDays);
        Validate.isTrue((this.ssnVerificationLetterDays > 0.0 ? 1 : 0) != 0, (String)"ssnVerificationLetterDays must be greater than zero.", (double)this.ssnVerificationLetterDays);
        Validate.isTrue((this.pseudoSsnLetterDays > 0.0 ? 1 : 0) != 0, (String)"pseudoSsnLetterDays must be greater than zero.", (double)this.pseudoSsnLetterDays);
        Validate.isTrue((this.pseudoSsnReminderLetterDays > 0.0 ? 1 : 0) != 0, (String)"pseudoSsnReminderLetterDays must be greater than zero.", (double)this.pseudoSsnReminderLetterDays);
        Validate.isTrue((this.z11PendingTraitsMins > 0.0 ? 1 : 0) != 0, (String)"z11PendingTraitsMins must be greater than zero.", (double)this.z11PendingTraitsMins);
        this.voa3DayPendingDays *= 24.0;
        this.ph14DayLetterDays *= 24.0;
        this.ph37DayLetterDays *= 24.0;
        this.ssnVerificationLetterDays *= 24.0;
        this.pseudoSsnLetterDays *= 24.0;
        this.pseudoSsnReminderLetterDays *= 24.0;
        this.z11PendingTraitsMins /= 60.0;
    }

    @Override
    public void cancelClock(Person person, Clock.Type type, Clock.Group group) throws ServiceException {
        this.cancelClock(person, type, group, null);
    }

    @Override
    public void cancelClock(Person person, Clock.Type type, Clock.Group group, String subject) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"The person must not be null");
        Validate.notNull((Object)person.getEntityKey(), (String)"The person must already exist in database");
        Validate.notNull((Object)((Object)type), (String)"The clock type must not be null");
        Validate.notNull((Object)((Object)group), (String)"The group name must not be null");
        String triggerName = person.getPersonEntityKey().getKeyValueAsString() + type.getName();
        if (subject != null) {
            triggerName = triggerName + subject;
        }
        this.doCancelClock(person.getPersonEntityKey(), triggerName, group.getName());
    }

    @Override
    public void cancelClock(ClockTriggerEvent event) throws ServiceException {
        try {
            this.getSchedulingService().unschedule(event.getTriggerName(), event.getTriggerGroup());
        }
        catch (Exception e) {
            throw new ServiceException("Unable to cancel clock from ClockTriggerEvent for trigger: " + event.getTriggerName(), (Throwable)e);
        }
    }

    private void doCancelClock(PersonEntityKey personId, String triggerName, String triggerGroup) throws ServiceException {
        try {
            if (!this.asyncClockMode) {
                this.getSchedulingService().unschedule(triggerName, triggerGroup);
            } else if (this.getSchedulingService().getTrigger(triggerName, triggerGroup) != null) {
                ClockTriggerEvent event = new ClockTriggerEvent("triggerEvent.cancelClock", personId);
                event.setTriggerName(triggerName);
                event.setTriggerGroup(triggerGroup);
                HashSet<ClockTriggerEvent> events = new HashSet<ClockTriggerEvent>();
                events.add(event);
                this.triggerEventCacheManager.storeTriggerEvents(events);
            }
        }
        catch (SchedulerException e) {
            throw new ServiceException("Unable to cancel a job", (Throwable)e);
        }
    }

    @Override
    public void startClock(Person person, double hours, Clock.Type type, Clock.Group group, String jobDetailBeanName) throws ServiceException {
        this.startClock(person, hours, type, group, jobDetailBeanName, null);
    }

    @Override
    public void startClock(Person person, double hours, Clock.Type type, Clock.Group group, String jobDetailBeanName, String subject) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"The person must not be null");
        Validate.notNull((Object)person.getEntityKey(), (String)"The person must already exist in database");
        Validate.notNull((Object)((Object)type), (String)"The clock type must not be null");
        Validate.notNull((Object)((Object)group), (String)"The group name must not be null");
        this.startClock(person.getPersonEntityKey(), hours, type, group, jobDetailBeanName, subject);
    }

    @Override
    public void startClock(PersonEntityKey personId, double hours, Clock.Type type, Clock.Group group, String jobDetailBeanName, String subject) throws ServiceException {
        StopWatchLogger watch = null;
        Validate.notNull((Object)personId, (String)"The person must already exist in database");
        Validate.notNull((Object)((Object)type), (String)"The clock type must not be null");
        Validate.notNull((Object)((Object)group), (String)"The group name must not be null");
        String triggerName = personId.getKeyValueAsString() + type.getName();
        if (subject != null) {
            triggerName = triggerName + subject;
        }
        if (this.logger.isDebugEnabled()) {
            watch = new StopWatchLogger("ScheduledTaskService starting clock for: " + triggerName);
            watch.start();
        }
        this.doStartClock(personId, type, hours, triggerName, group, jobDetailBeanName, subject);
        if (this.logger.isDebugEnabled()) {
            watch.stopAndLog();
        }
    }

    @Override
    public void startPseudoSSNReasonClock(Person person, String subject) throws ServiceException {
        this.startClock(person, this.getPseudoSsnLetterDays(), Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK, Clock.Group.SSN_CLOCK_GROUP, this.scheduledJobSSNClockProcessName, subject);
    }

    @Override
    public void cancelPseudoSSNReasonClock(Person person, String subject) throws ServiceException {
        this.cancelClock(person, Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK, Clock.Group.SSN_CLOCK_GROUP, subject);
    }

    @Override
    public void startPseudoSSNVerificationClock(Person person, String subject) throws ServiceException {
        this.startClock(person, this.getSsnVerificationLetterDays(), Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK, Clock.Group.SSN_CLOCK_GROUP, this.scheduledJobSSNClockProcessName, subject);
    }

    @Override
    public void startSSNInvalidLetterClock(Person person, String subject) throws ServiceException {
        this.startClock(person, this.getSsnVerificationLetterDays(), Clock.Type.SSN_30_DAY_VALIDATION_CLOCK, Clock.Group.SSN_CLOCK_GROUP, this.scheduledJobSSNClockProcessName, subject);
    }

    @Override
    public void startPHLetterClock(Person person) throws ServiceException {
        this.startClock(person, this.getPh37DayLetterDays(), Clock.Type.PH_37_DAY_CLOCK, Clock.Group.PH_CLOCK_GROUP, this.scheduledJobPHClockProcessName);
    }

    @Override
    public void startPHPendingClock(Person person) throws ServiceException {
        this.startClock(person, this.getPh14DayLetterDays(), Clock.Type.PH_14_DAY_CLOCK, Clock.Group.PH_CLOCK_GROUP, this.scheduledJobPHClockProcessName);
    }

    @Override
    public void startVOAPendingClock(Person person) throws ServiceException {
        this.startClock(person, this.getPh14DayLetterDays(), Clock.Type.VOA_3_DAY_CLOCK, Clock.Group.VOA_CLOCK_GROUP, this.scheduledJobVOAClockProcessName);
    }

    @Override
    public void startMilServiceQueryClock(Person person) throws ServiceException {
        this.startClock(person, this.getMsQueryPendingHours(), Clock.Type.WF_72_HOUR_CLOCK, Clock.Group.WF_CLOCK_GROUP, this.getScheduledJobWfClockProcessName());
    }

    public void startSSNReminderLetterClock(Person person) throws ServiceException {
        this.startClock(person, this.getPseudoSsnReminderLetterDays(), Clock.Type.SSN_45_DAY_CLOCK, Clock.Group.SSN_CLOCK_GROUP, this.scheduledJobSSNClockProcessName);
    }

    @Override
    public void startZ11PendingTraitsClock(Person person) throws ServiceException {
        this.startClock(person, this.getZ11PendingTraitsMins(), Clock.Type.Z11_10_MIN_CLOCK, Clock.Group.Z11_CLOCK_GROUP, this.scheduledJobZ11ClockProcessName);
    }

    @Override
    public void startClock(ClockTriggerEvent event) throws ServiceException {
        StopWatchLogger watch = null;
        try {
            Trigger trigger = this.schedulingService.getTrigger(event.getTriggerName(), event.getTriggerGroup());
            if (trigger != null && !Clock.Group.WF_CLOCK_GROUP.getName().equals(trigger.getGroup())) {
                return;
            }
            JobDetail jobDetail = (JobDetail)this.getComponent(event.getJobDetailBeanName());
            jobDetail.setName(event.getTriggerName());
            jobDetail.setGroup(event.getTriggerGroup());
            if (this.logger.isDebugEnabled()) {
                watch = new StopWatchLogger("ScheduledTaskService starting clock for: " + event.getTriggerName());
                watch.start();
            }
            if (trigger != null && Clock.Group.WF_CLOCK_GROUP.getName().equals(trigger.getGroup())) {
                long millis = Math.round(event.getAdjustedHoursDelay() * 60.0) * 60L * 1000L;
                trigger.setStartTime(new Date(System.currentTimeMillis() + millis));
                this.schedulingService.reschedule(trigger.getJobName(), trigger.getGroup(), trigger);
            } else {
                this.schedulingService.schedule(jobDetail, event.getClockData(), event.getAdjustedHoursDelay(), event.getTriggerName(), event.getTriggerGroup());
            }
            if (this.logger.isDebugEnabled()) {
                watch.stopAndLog();
            }
        }
        catch (Exception e) {
            throw new ServiceException("Unable to start clock from ClockTriggerEvent for trigger: " + event.getTriggerName(), (Throwable)e);
        }
    }

    private void doStartClock(PersonEntityKey personId, Clock.Type type, double hours, String name, Clock.Group group, String jobDetailBeanName, String subject) throws ServiceException {
        try {
            Trigger trigger = this.getSchedulingService().getTrigger(name, group.getName());
            if (trigger != null && !Clock.Group.WF_CLOCK_GROUP.getName().equals(trigger.getGroup())) {
                return;
            }
        }
        catch (SchedulerException e) {
            throw new ServiceException("Unable to check if scheduled", (Throwable)e);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(personId.getKeyValueAsString());
        list.add(type.getName());
        if (subject != null) {
            list.add(subject);
        }
        hours = this.calculateHours(hours);
        try {
            if (!this.asyncClockMode) {
                JobDetail jobDetail = (JobDetail)this.getComponent(jobDetailBeanName);
                jobDetail.setName(name);
                jobDetail.setGroup(group.getName());
                this.getSchedulingService().schedule(jobDetail, list, hours, name, group.getName());
            } else {
                ClockTriggerEvent event = new ClockTriggerEvent("triggerEvent.startClock", personId);
                event.setHoursDelay(hours);
                event.setTriggerName(name);
                event.setTriggerGroup(group.getName());
                event.setClockData(list);
                event.setJobDetailBeanName(jobDetailBeanName);
                HashSet<ClockTriggerEvent> events = new HashSet<ClockTriggerEvent>();
                events.add(event);
                this.triggerEventCacheManager.storeTriggerEvents(events);
            }
        }
        catch (SchedulerException e) {
            throw new ServiceException("Unable to schedule job", (Throwable)e);
        }
    }

    private double calculateHours(double hours) {
        int currentHour = Calendar.getInstance().get(11);
        if (this.scatterClockFactor <= 0 || currentHour >= this.disallowClocksToScatterIfProcessingAfterHour) {
            return hours;
        }
        double newHours = hours;
        if (this.allowClocksToScatterAcrossDayBoundary) {
            double percentage = RandomUtils.nextDouble();
            newHours = hours + (double)this.scatterClockFactor * percentage;
        } else {
            double percentage = RandomUtils.nextDouble();
            newHours = hours + Math.min((double)this.scatterClockFactor, 23.99 - (double)currentHour) * percentage;
        }
        return newHours;
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public double getPh14DayLetterDays() {
        return this.ph14DayLetterDays;
    }

    public void setPh14DayLetterDays(double ph14DayLetterDays) {
        this.ph14DayLetterDays = ph14DayLetterDays;
    }

    public double getPh37DayLetterDays() {
        return this.ph37DayLetterDays;
    }

    public void setPh37DayLetterDays(double ph37DayLetterDays) {
        this.ph37DayLetterDays = ph37DayLetterDays;
    }

    public double getPseudoSsnLetterDays() {
        return this.pseudoSsnLetterDays;
    }

    public void setPseudoSsnLetterDays(double pseudoSsnLetterDays) {
        this.pseudoSsnLetterDays = pseudoSsnLetterDays;
    }

    public double getPseudoSsnReminderLetterDays() {
        return this.pseudoSsnReminderLetterDays;
    }

    public void setPseudoSsnReminderLetterDays(double pseudoSsnReminderLetterDays) {
        this.pseudoSsnReminderLetterDays = pseudoSsnReminderLetterDays;
    }

    public double getSsnVerificationLetterDays() {
        return this.ssnVerificationLetterDays;
    }

    public void setSsnVerificationLetterDays(double ssnVerificationLetterDays) {
        this.ssnVerificationLetterDays = ssnVerificationLetterDays;
    }

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public boolean isAsyncClockMode() {
        return this.asyncClockMode;
    }

    public void setAsyncClockMode(boolean asyncClockMode) {
        this.asyncClockMode = asyncClockMode;
    }

    public String getScheduledJobPHClockProcessName() {
        return this.scheduledJobPHClockProcessName;
    }

    public void setScheduledJobPHClockProcessName(String scheduledJobPHClockProcessName) {
        this.scheduledJobPHClockProcessName = scheduledJobPHClockProcessName;
    }

    public String getScheduledJobSSNClockProcessName() {
        return this.scheduledJobSSNClockProcessName;
    }

    public void setScheduledJobSSNClockProcessName(String scheduledJobSSNClockProcessName) {
        this.scheduledJobSSNClockProcessName = scheduledJobSSNClockProcessName;
    }

    public int getScatterClockFactor() {
        return this.scatterClockFactor;
    }

    public void setScatterClockFactor(int scatterClockFactor) {
        this.scatterClockFactor = scatterClockFactor;
    }

    public boolean isAllowClocksToScatterAcrossDayBoundary() {
        return this.allowClocksToScatterAcrossDayBoundary;
    }

    public void setAllowClocksToScatterAcrossDayBoundary(boolean allowClocksToScatterAcrossDayBoundary) {
        this.allowClocksToScatterAcrossDayBoundary = allowClocksToScatterAcrossDayBoundary;
    }

    public int getDisallowClocksToScatterIfProcessingAfterHour() {
        return this.disallowClocksToScatterIfProcessingAfterHour;
    }

    public void setDisallowClocksToScatterIfProcessingAfterHour(int disallowClocksToScatterIfProcessingAfterHour) {
        this.disallowClocksToScatterIfProcessingAfterHour = disallowClocksToScatterIfProcessingAfterHour;
    }

    public double getVoa3DayPendingDays() {
        return this.voa3DayPendingDays;
    }

    public void setVoa3DayPendingDays(double voa3DayPendingDays) {
        this.voa3DayPendingDays = voa3DayPendingDays;
    }

    public String getScheduledJobWfClockProcessName() {
        return this.scheduledJobWfClockProcessName;
    }

    public void setScheduledJobWfClockProcessName(String scheduledJobWfClockProcessName) {
        this.scheduledJobWfClockProcessName = scheduledJobWfClockProcessName;
    }

    public String getScheduledJobZ11ClockProcessName() {
        return this.scheduledJobZ11ClockProcessName;
    }

    public void setScheduledJobZ11ClockProcessName(String scheduledJobZ11ClockProcessName) {
        this.scheduledJobZ11ClockProcessName = scheduledJobZ11ClockProcessName;
    }

    public double getMsQueryPendingHours() {
        return this.msQueryPendingHours;
    }

    public void setMsQueryPendingHours(double msQueryPendingHours) {
        this.msQueryPendingHours = msQueryPendingHours;
    }

    public double getZ11PendingTraitsMins() {
        return this.z11PendingTraitsMins;
    }

    public void setZ11PendingTraitsMins(double pendingTraitsMins) {
        this.z11PendingTraitsMins = pendingTraitsMins;
    }
}

