/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.impl.PSDelegateServiceImpl;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StopWatchLogger;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class ReportPSDelegateServiceImpl
extends PSDelegateServiceImpl {
    private static final int MAX_RECORDS = 10;
    private static final int UPPER_LIMIT = 11;
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final long serialVersionUID = -3600716622840392949L;
    private DAOOperations genericDAO = null;
    private String selectAndFromClause = "select VPID_VALUE from rpt_psim_traits ";

    @Override
    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.genericDAO, (String)"genericDAO is a required property for ReportPSDelegateServiceImpl");
    }

    public DAOOperations getGenericDAO() {
        return this.genericDAO;
    }

    public void setGenericDAO(DAOOperations genericDAO) {
        this.genericDAO = genericDAO;
    }

    protected Set doSearch(PersonIdentityTraits criteria, String matchType) throws ServiceException {
        try {
            return this.searchPersonTraits(criteria, matchType);
        }
        catch (MaxRecordsExceededException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to perform a LOCAL search for identity traits", (Throwable)e);
        }
    }

    private Set searchPersonTraits(PersonIdentityTraits criteria, String matchType) throws Exception {
        Set<PersonIdentityTraits> results = new HashSet();
        String whereClause = this.buildWhereClause(criteria, matchType);
        String query = this.selectAndFromClause + whereClause;
        List list = null;
        try {
            StopWatchLogger watch = new StopWatchLogger("Searching RPT_PSIM_TRAITS with criteria=" + whereClause + "]");
            watch.start();
            list = this.getGenericDAO().executeSQLQuery(query);
            watch.stopAndLog("returned " + (list != null ? list.size() : 0) + " records");
        }
        catch (Exception e) {
            throw new ServiceException("Generic DAO query of psim traits failed ", (Throwable)e);
        }
        if (list.size() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"No results found in LOCAL search, searching PSIM. ");
            }
            results = super.doSearch(criteria, false, true);
        }
        if (list.size() > 10) {
            throw new MaxRecordsExceededException(-1, 10, "LOCAL search by identity traits exceeded allowable limit of 10 matched records.");
        }
        for (String VPID2 : list) {
            PersonIdentityTraits personIdentityTraits = this.createPersonTraits(VPID2);
            results.add(personIdentityTraits);
        }
        return results;
    }

    private String buildWhereClause(PersonIdentityTraits criteria, String matchType) {
        Name name;
        StringBuffer whereClause = new StringBuffer(" where rownum <= 11");
        SSN ssn = criteria.getSsn();
        if (ssn != null) {
            SSNType ssnType;
            if (StringUtils.isNotEmpty((String)criteria.getSsnText())) {
                whereClause.append(" AND SSN = '" + criteria.getSsnText() + "'");
            }
            if ((ssnType = ssn.getType()) != null) {
                whereClause.append(" AND SSN_TYPE_CODE = '" + ssnType.getCode() + "'");
            }
            if (ssn.getPseudoSSNReason() != null && StringUtils.isNotEmpty((String)ssn.getPseudoSSNReason().getCode())) {
                whereClause.append(" AND PSEUDO_SSN_REASON_CODE = '" + ssn.getPseudoSSNReason().getCode() + "'");
            }
            if (ssn.getSsaVerificationStatus() != null && StringUtils.isNotEmpty((String)ssn.getSsaVerificationStatus().getCode())) {
                whereClause.append(" AND SSN_VRFN_STATUS_CODE = '" + ssn.getSsaVerificationStatus().getCode() + "'");
            }
        }
        if ((name = criteria.getLegalName()) != null) {
            if (StringUtils.isNotEmpty((String)name.getGivenName())) {
                whereClause.append(" AND FIRST_NAME = '" + name.getGivenName().toUpperCase() + "'");
            }
            if (StringUtils.isNotEmpty((String)name.getFamilyName())) {
                whereClause.append(" AND LAST_NAME = '" + name.getFamilyName().toUpperCase() + "'");
            }
            if (StringUtils.isNotEmpty((String)name.getMiddleName())) {
                whereClause.append(" AND MIDDLE_NAME = '" + name.getMiddleName().toUpperCase() + "'");
            }
            if (StringUtils.isNotEmpty((String)name.getPrefix())) {
                whereClause.append(" AND PREFIX = '" + name.getPrefix().toUpperCase() + "'");
            }
            if (StringUtils.isNotEmpty((String)name.getSuffix())) {
                whereClause.append(" AND SUFFIX = '" + name.getSuffix().toUpperCase() + "'");
            }
        }
        if (criteria.getGender() != null && StringUtils.isNotEmpty((String)criteria.getGender().getCode())) {
            whereClause.append(" AND GENDER_CODE = '" + criteria.getGender().getCode() + "'");
        }
        if (criteria.getBirthRecord() != null && criteria.getBirthRecord().getBirthDate() != null) {
            String birthDate = DateUtils.format((Date)criteria.getBirthRecord().getBirthDate().getDate(), (String)DATE_FORMAT);
            whereClause.append(" AND DATE_OF_BIRTH = '" + birthDate + "'");
        }
        return whereClause.toString();
    }

    private PersonIdentityTraits createPersonTraits(String VPID2) throws Exception {
        VPIDEntityKey entityKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID2);
        return super.getIdentityTraits(entityKey);
    }
}

