/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.PersonUnmergeInfo;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.persistent.person.PersonMergeDAO;
import gov.va.med.esr.common.persistent.person.PersonUnmergeDAO;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonUnmergeService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.DateUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class PersonUnmergeServiceImpl
extends AbstractRuleAwareServiceImpl
implements PersonUnmergeService {
    private static final long serialVersionUID = -6546285562247188667L;
    private PersonDAO personDAO = null;
    private PersonMergeDAO personMergeDAO = null;
    private PersonUnmergeDAO personUnmergeDAO = null;
    private MessagingService messagingService = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.messagingService, (String)"Missing required messagingService");
        Validate.notNull((Object)this.personDAO, (String)"Missing required personDAO");
        Validate.notNull((Object)this.personUnmergeDAO, (String)"Missing required personUnmergeDAO");
    }

    @Override
    public PersonUnmergeInfo getPersonUnmergeInfo(EntityKey personUnmergeInfoEntityKey) throws ServiceException {
        PersonUnmergeInfo info = null;
        try {
            info = (PersonUnmergeInfo)((Object)this.personUnmergeDAO.getByKey(personUnmergeInfoEntityKey));
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get PersonUnmergeInfo for: " + personUnmergeInfoEntityKey.toString(), (Throwable)ex);
        }
        if (info != null) {
            this.fillPersonIdentityTraits(info);
        }
        return info;
    }

    @Override
    public void processPersonUnmergeInfo(PersonUnmergeInfo info) throws ServiceException {
        this.querySiteForFreshData(info);
        try {
            PersonMergeInfo existInfo = this.personMergeDAO.findByPersonIds(info.getPerson1EntityKey(), info.getPerson2EntityKey());
            if (existInfo != null && !existInfo.isMergeCompleted()) {
                this.personMergeDAO.removeObject(existInfo.getEntityKey());
                return;
            }
            PersonUnmergeInfo existUnmergeInfo = this.personUnmergeDAO.findByPersonIds(info.getPerson1EntityKey(), info.getPerson2EntityKey());
            if (existUnmergeInfo != null) {
                return;
            }
            this.personUnmergeDAO.saveObject((Object)info);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to save PersonUnmergeInfo: " + info.toString(), (Throwable)ex);
        }
    }

    private void querySiteForFreshData(PersonUnmergeInfo info) throws ServiceException {
        String lockedReason;
        PersonIdEntityKey key = info.getToPersonEntityKey();
        Person person = this.getPersonService().getPerson(key);
        PersonLockedReason lockedReasonObj = person.getPersonLockedReason();
        String string = lockedReason = lockedReasonObj != null ? lockedReasonObj.getReason() : null;
        if (!PersonLockedReason.PERSON_NO_ENROLLMENT_DETERMINATION.getReason().equals(lockedReason)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Due to external MOVE event and the need to start over with site data, ESR is clearing out E&E data for Person [" + key.getKeyValueAsString() + "]"));
            }
            person.getEnrollmentDetermination().setPerson(null);
            person.setEnrollmentDetermination(null);
            if (person.getEligibilityVerification() != null) {
                person.getEligibilityVerification().setEligibilityStatus(this.getLookupService().getEligibilityStatusByCode(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode()));
                person.getEligibilityVerification().setAacIndicator(null);
            }
            this.getPersonService().save(person, true);
        }
        IncomeTest current = this.getHelperService().getCurrentIncomeTest(person);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getCurrentDate());
        cal.add(1, -1);
        Integer incomeYear = current != null ? current.getIncomeYear() : new Integer(cal.get(1));
        this.getMessagingService().triggerQRYZ07(person, this.getLookupService().getVaFacilityByStationNumber(info.getStationNumber()), incomeYear, true);
    }

    private void fillPersonIdentityTraits(PersonUnmergeInfo info) throws ServiceException {
        try {
            PersonIdEntityKey key1 = info.getPerson1EntityKey();
            VPIDEntityKey vpid1 = this.personDAO.getVPIDByPersonId(key1);
            info.setPerson1IdentityTraits(this.getPsDelegateService().getIdentityTraits(vpid1));
            PersonIdEntityKey key2 = info.getPerson2EntityKey();
            VPIDEntityKey vpid2 = this.personDAO.getVPIDByPersonId(key2);
            info.setPerson2IdentityTraits(this.getPsDelegateService().getIdentityTraits(vpid2));
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to convert PersinIDEntityKey with VPIDEntityKey: " + info.toString(), (Throwable)e);
        }
    }

    @Override
    public void deletePersonUnmergeInfo(PersonUnmergeInfo info) throws ServiceException {
        try {
            this.personUnmergeDAO.removeObject(info.getEntityKey());
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to delete PersonUnmergeInfo: " + info.toString(), (Throwable)e);
        }
    }

    @Override
    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        ArrayList results = null;
        try {
            results = this.personUnmergeDAO.loadAll(PersonUnmergeInfo.class);
            if (results == null) {
                results = new ArrayList();
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to loadAll PersonUnmergeInfo objects from the DAO.", (Throwable)ex);
        }
        searchQueryInfo.setTotalNumberOfEntries(results.size());
        HashMap<PersonIdEntityKey, VPIDEntityKey> personIdMap = new HashMap<PersonIdEntityKey, VPIDEntityKey>();
        for (int i = 0; i < results.size(); ++i) {
            Object obj = results.get(i);
            if (obj == null || !(obj instanceof PersonUnmergeInfo)) continue;
            PersonUnmergeInfo info = (PersonUnmergeInfo)((Object)obj);
            PersonIdEntityKey personId1 = info.getPerson1EntityKey();
            PersonIdEntityKey personId2 = info.getPerson2EntityKey();
            try {
                VPIDEntityKey vpid1 = this.personDAO.getVPIDByPersonId(personId1);
                VPIDEntityKey vpid2 = this.personDAO.getVPIDByPersonId(personId2);
                personIdMap.put(personId1, vpid1);
                personIdMap.put(personId2, vpid2);
                continue;
            }
            catch (DAOException ex) {
                throw new ServiceException("Failed to getVPIDByPersonId from the DAO.", (Throwable)ex);
            }
        }
        Map traits = this.getPsDelegateService().getIdentityTraits(personIdMap.values());
        for (int i = 0; i < results.size(); ++i) {
            Object obj = results.get(i);
            if (obj == null || !(obj instanceof PersonUnmergeInfo)) continue;
            PersonUnmergeInfo info = (PersonUnmergeInfo)((Object)obj);
            PersonIdEntityKey personId1 = info.getPerson1EntityKey();
            PersonIdEntityKey personId2 = info.getPerson2EntityKey();
            VPIDEntityKey vpid1 = (VPIDEntityKey)personIdMap.get(personId1);
            VPIDEntityKey vpid2 = (VPIDEntityKey)personIdMap.get(personId2);
            info.setPerson1IdentityTraits((PersonIdentityTraits)((Object)traits.get(vpid1.getVPID())));
            info.setPerson2IdentityTraits((PersonIdentityTraits)((Object)traits.get(vpid2.getVPID())));
        }
        searchQueryInfo.setSearchTypePerformed("readAll");
        searchQueryInfo.setSortPerformed(false);
        searchQueryInfo.setSortColumnNotSupported(false);
        return results;
    }

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public PersonMergeDAO getPersonMergeDAO() {
        return this.personMergeDAO;
    }

    public void setPersonMergeDAO(PersonMergeDAO personMergeDAO) {
        this.personMergeDAO = personMergeDAO;
    }

    public PersonUnmergeDAO getPersonUnmergeDAO() {
        return this.personUnmergeDAO;
    }

    public void setPersonUnmergeDAO(PersonUnmergeDAO personUnmergeDAO) {
        this.personUnmergeDAO = personUnmergeDAO;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }
}

