/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.PersonUnmergeInfo;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.persistent.person.PersonMergeDAO;
import gov.va.med.esr.common.persistent.person.PersonUnmergeDAO;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonMergeWorklistSearchQueryInfo;
import gov.va.med.esr.service.PersonSearchQueryInfo;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.Validate;

public class PersonMergeServiceImpl
extends AbstractRuleAwareServiceImpl
implements PersonMergeService {
    private static final long serialVersionUID = -6546285562247193447L;
    public PSDelegateService delegateService = null;
    private PersonService personService = null;
    private PersonDAO personDAO = null;
    private PersonMergeDAO personMergeDAO = null;
    private PersonUnmergeDAO personUnmergeDAO = null;
    private String eligibilityEnrollmentServiceName = null;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;

    public PSDelegateService getDelegateService() {
        return this.delegateService;
    }

    public void setDelegateService(PSDelegateService service) {
        this.delegateService = service;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personDAO, (String)"Missing required personDAO");
        Validate.notNull((Object)this.personMergeDAO, (String)"Missing required personMergeDAO");
        Validate.notNull((Object)this.personUnmergeDAO, (String)"Missing required personUnmergeDAO");
    }

    @Override
    public PersonMergeInfo getPersonMergeInfo(EntityKey personMergeInfoEntityKey) throws ServiceException {
        PersonMergeInfo info = null;
        try {
            info = (PersonMergeInfo)((Object)this.personMergeDAO.getByKey(personMergeInfoEntityKey));
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get PersonMergeInfo for: " + personMergeInfoEntityKey.toString(), (Throwable)ex);
        }
        if (info != null) {
            this.fillPersonIdentityTraits(info);
        }
        return info;
    }

    private void fillPersonIdentityTraits(PersonMergeInfo info) throws ServiceException {
        try {
            PersonIdEntityKey key1 = info.getPrimaryPersonEntityKey();
            VPIDEntityKey vpid1 = this.personDAO.getVPIDByPersonId(key1);
            info.setPrimaryPersonIdentityTraits(this.getPsDelegateService().getIdentityTraits(vpid1));
            PersonIdEntityKey key2 = info.getDeprecatedPersonEntityKey();
            VPIDEntityKey vpid2 = this.personDAO.getVPIDByPersonId(key2);
            info.setDeprecatedPersonIdentityTraits(this.getDeprecatedIdentityTraits(vpid1, vpid2));
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to convert PersinIDEntityKey with VPIDEntityKey: " + info.toString(), (Throwable)e);
        }
    }

    private PersonIdentityTraits getDeprecatedIdentityTraits(VPIDEntityKey survivingVPID, VPIDEntityKey deprecatedVPID) throws ServiceException {
        Validate.notNull((Object)survivingVPID, (String)"Surviving VPID can not be null.");
        Validate.notNull((Object)deprecatedVPID, (String)"Deprecated VPID can not be null.");
        List history = null;
        try {
            history = this.getPsDelegateService().getIdentityTraitsUpdateHistory(survivingVPID);
        }
        catch (ServiceException e) {
            throw new ServiceException("Failed to deprecated PersonIdentityTraits when calling getIdentityTraitsUpdateHistory for: " + survivingVPID.toString(), (Throwable)e);
        }
        for (int i = 0; history != null && i < history.size(); ++i) {
            PersonIdentityTraits traits = (PersonIdentityTraits)((Object)history.get(i));
            if (traits == null || !traits.isDeprecated() || !deprecatedVPID.equals(traits.getVpid())) continue;
            return traits;
        }
        return null;
    }

    @Override
    public Person updatePerson(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        boolean dataIsFromUI = true;
        Person merged = this.getMergeRuleService().mergePerson(incoming, onFile, dataIsFromUI);
        Person calculated = this.getEligibilityEnrollmentService().assessEEImpact(merged, dataIsFromUI, false);
        this.getEventRuleService().handleCommonPostEvents(calculated, dataIsFromUI);
        try {
            PersonMergeInfo info = this.personMergeDAO.getPersonMergeInfo((PersonIdEntityKey)calculated.getPersonEntityKey());
            if (info != null) {
                info.setRecordLocked(Boolean.FALSE);
                this.updateStartDateIfNeeded(info);
                info.setMergeEndDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
                this.updatePersonMergeInfo(info);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to delete PersonMergeInfo related to: " + incoming.getPersonEntityKey().toString(), (Throwable)ex);
        }
        return this.getPersonService().save(calculated);
    }

    @Override
    public void deletePersonMergeInfo(PersonMergeInfo info) throws ServiceException {
        try {
            this.personMergeDAO.removeObject(info.getEntityKey());
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to delete PersonMergeInfo: " + info.toString(), (Throwable)e);
        }
    }

    @Override
    public PersonMergeInfo getPersonMergeInfo(PersonIdEntityKey primaryPersonIdEntityKey) throws ServiceException {
        PersonMergeInfo info = null;
        try {
            info = this.personMergeDAO.getPersonMergeInfo(primaryPersonIdEntityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get PersonMergeInfo for: " + primaryPersonIdEntityKey.toString(), (Throwable)ex);
        }
        if (info != null) {
            this.fillPersonIdentityTraits(info);
        }
        return info;
    }

    @Override
    public PersonMergeInfo getPersonMergeDataInfo(PersonIdEntityKey primaryPersonIdEntityKey) throws ServiceException {
        PersonMergeInfo info = null;
        try {
            info = this.personMergeDAO.getPersonMergeInfo(primaryPersonIdEntityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get PersonMergeInfo for: " + primaryPersonIdEntityKey.toString(), (Throwable)ex);
        }
        return info;
    }

    @Override
    public boolean hasActiveMerge(PersonIdEntityKey primaryPersonIdEntityKey) throws ServiceException {
        PersonMergeInfo info = null;
        boolean hasActiveMerge = false;
        try {
            info = this.personMergeDAO.getPersonMergeInfo(primaryPersonIdEntityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get PersonMergeInfo for: " + primaryPersonIdEntityKey.toString(), (Throwable)ex);
        }
        if (info != null && info.isRecordLocked() != null) {
            hasActiveMerge = info.isRecordLocked();
        }
        return hasActiveMerge;
    }

    @Override
    public PersonMergeInfo updatePersonMergeInfo(PersonMergeInfo info) throws ServiceException {
        return this.updatePersonMergeInfoImpl(info, false);
    }

    @Override
    public PersonMergeInfo updatePersonMergeInfoByPrimaryDepIDs(PersonEntityKey primaryId, PersonEntityKey deprecatedId) throws ServiceException {
        PersonMergeInfo info = null;
        try {
            List results = this.personMergeDAO.findByPrimaryDeprecatedIds((PersonIdEntityKey)primaryId, (PersonIdEntityKey)deprecatedId);
            if (results != null) {
                for (int i = 0; i < results.size(); ++i) {
                    info = (PersonMergeInfo)((Object)results.get(i));
                    info.setRecordLocked(Boolean.FALSE);
                    this.updateStartDateIfNeeded(info);
                    info.setMergeEndDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
                    this.updatePersonMergeInfo(info);
                }
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to update PersonMergeInfo related to: " + info.toString(), (Throwable)ex);
        }
        return info;
    }

    @Override
    public PersonMergeInfo saveInProgress(PersonMergeInfo info) throws ServiceException {
        this.updateStartDateIfNeeded(info);
        return this.updatePersonMergeInfoImpl(info, true);
    }

    private PersonMergeInfo updatePersonMergeInfoImpl(PersonMergeInfo info, boolean ensureEntityChanged) throws ServiceException {
        try {
            if (ensureEntityChanged) {
                PersonMergeInfo onFilePersonMergeInfo = this.getPersonMergeInfo(info.getEntityKey());
                this.ensureEntityChanged((AbstractEntity)info, (AbstractEntity)onFilePersonMergeInfo);
                this.personMergeDAO.evict((Object)onFilePersonMergeInfo);
            }
            this.personMergeDAO.update((Object)info);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to update PersonMergeInfo: " + info.toString(), (Throwable)ex);
        }
        return this.getPersonMergeInfo(info.getEntityKey());
    }

    public void updateStartDateIfNeeded(PersonMergeInfo info) {
        if (!info.isMergeInProgress()) {
            info.setMergeStartDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
        }
    }

    public boolean hasEnrollmentData(VPIDEntityKey vpid) {
        boolean hasData = true;
        EnrollmentDetermination ed = null;
        try {
            ed = this.personDAO.getByVPID(vpid).getEnrollmentDetermination();
        }
        catch (DAOException daoe) {
            this.logger.error((Object)("Exception occured while retrieving the person with VPID = " + vpid), (Throwable)daoe);
        }
        if (ed == null) {
            hasData = false;
        }
        return hasData;
    }

    @Override
    public void processPersonMergeInfo(PersonMergeInfo info, VPIDEntityKey deprecatedVPID, VPIDEntityKey survivingVPID) throws ServiceException {
        try {
            PersonMergeInfo existInfo;
            if (!this.hasEnrollmentData(survivingVPID) && !this.hasEnrollmentData(deprecatedVPID)) {
                return;
            }
            PersonUnmergeInfo existUnmergeInfo = this.personUnmergeDAO.findByPersonIds(info.getPrimaryPersonEntityKey(), info.getDeprecatedPersonEntityKey());
            if (existUnmergeInfo != null) {
                this.personUnmergeDAO.removeObject(existUnmergeInfo.getEntityKey());
            }
            if ((existInfo = this.personMergeDAO.findByPersonIds(info.getPrimaryPersonEntityKey(), info.getDeprecatedPersonEntityKey())) != null) {
                if (existInfo.getPrimaryPersonEntityKey().equals(info.getDeprecatedPersonEntityKey())) {
                    this.deletePersonMergeInfo(existInfo);
                } else if (existInfo.getPrimaryPersonEntityKey().equals(info.getPrimaryPersonEntityKey())) {
                    return;
                }
            }
            this.updatePersonMergeInfo(info);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to save PersonMergeInfo: " + info.toString(), (Throwable)ex);
        }
    }

    @Override
    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        if (searchQueryInfo != null && searchQueryInfo instanceof PersonMergeWorklistSearchQueryInfo) {
            return this.searchByPersonMergeWorklistSearchQueryInfo((PersonMergeWorklistSearchQueryInfo)searchQueryInfo);
        }
        ArrayList results = null;
        try {
            results = this.personMergeDAO.loadAllNotCompleted(searchQueryInfo);
            if (results == null) {
                results = new ArrayList();
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to loadAll PersonMergeInfo objects from the DAO.", (Throwable)ex);
        }
        HashMap<PersonIdEntityKey, VPIDEntityKey> personIdMap = new HashMap<PersonIdEntityKey, VPIDEntityKey>();
        for (int i = 0; i < results.size(); ++i) {
            Object obj = results.get(i);
            if (obj == null || !(obj instanceof PersonMergeInfo)) continue;
            PersonMergeInfo info = (PersonMergeInfo)((Object)obj);
            PersonIdEntityKey personId1 = info.getPrimaryPersonEntityKey();
            try {
                VPIDEntityKey vpid1 = this.personDAO.getVPIDByPersonId(personId1);
                personIdMap.put(personId1, vpid1);
                continue;
            }
            catch (DAOException ex) {
                throw new ServiceException("Failed to getVPIDByPersonId from the DAO.", (Throwable)ex);
            }
        }
        Map traits = null;
        try {
            traits = this.getPsDelegateService().getIdentityTraits(personIdMap.values());
        }
        catch (ServiceException se) {
            this.logger.error((Object)"PSIM service Exception while getIdentityTraits(list).", (Throwable)se);
        }
        for (int i = 0; i < results.size(); ++i) {
            Object obj = results.get(i);
            if (obj == null || !(obj instanceof PersonMergeInfo)) continue;
            PersonMergeInfo info = (PersonMergeInfo)((Object)obj);
            PersonIdEntityKey personId1 = info.getPrimaryPersonEntityKey();
            VPIDEntityKey vpid1 = (VPIDEntityKey)personIdMap.get(personId1);
            PersonIdentityTraits identityTraits = null;
            if (traits != null) {
                identityTraits = (PersonIdentityTraits)((Object)traits.get(vpid1.getVPID()));
            }
            try {
                if (identityTraits == null) {
                    identityTraits = this.getPsDelegateService().getIdentityTraits(vpid1);
                }
            }
            catch (ServiceException se) {
                this.logger.error((Object)"PSIM service Exception while getIdentityTraits(vpid).", (Throwable)se);
            }
            info.setPrimaryPersonIdentityTraits(identityTraits);
            PersonIdEntityKey personId2 = info.getDeprecatedPersonEntityKey();
            try {
                VPIDEntityKey vpid2 = this.personDAO.getVPIDByPersonId(personId2);
                info.setDeprecatedPersonIdentityTraits(this.getDeprecatedIdentityTraits(vpid1, vpid2));
                continue;
            }
            catch (DAOException ex) {
                throw new ServiceException("Failed to getVPIDByPersonId from the DAO.", (Throwable)ex);
            }
        }
        searchQueryInfo.setSortPerformed(true);
        return results;
    }

    private List searchByPersonMergeWorklistSearchQueryInfo(PersonMergeWorklistSearchQueryInfo personMergeWorklistSearchQueryInfo) throws ServiceException {
        PersonSearchQueryInfo personSearchQueryInfo = new PersonSearchQueryInfo();
        try {
            BeanUtils.copyProperties((Object)personSearchQueryInfo, (Object)personMergeWorklistSearchQueryInfo);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException((Throwable)e);
        }
        List results = new ArrayList();
        personMergeWorklistSearchQueryInfo.setSortPerformed(false);
        personMergeWorklistSearchQueryInfo.setTotalNumberOfEntries(results.size());
        personMergeWorklistSearchQueryInfo.setSearchTypePerformed("readAll");
        List personList = this.personService.search(personSearchQueryInfo);
        if (personList.size() > 0) {
            Iterator personIterator = personList.iterator();
            ArrayList<PersonEntityKey> personEntityKeyList = new ArrayList<PersonEntityKey>();
            Hashtable<String, Person> personEntityKeyHashTable = new Hashtable<String, Person>();
            while (personIterator.hasNext()) {
                Person person = (Person)((Object)personIterator.next());
                personEntityKeyList.add(person.getPersonEntityKey());
                personEntityKeyHashTable.put(person.getPersonEntityKey().getKeyValueAsString(), person);
            }
            try {
                results = this.personMergeDAO.findNotCompletedByPrimaryPersonEntityKeys(personEntityKeyList, personMergeWorklistSearchQueryInfo);
            }
            catch (DAOException ex) {
                throw new ServiceException("Failed to find PersonMergeInfo objects from the DAO.", (Throwable)ex);
            }
            for (PersonMergeInfo personMergeInfo : results) {
                Person person;
                List personResults;
                PersonSearchQueryInfo personSearchQueryInfoPerson;
                VPIDEntityKey vpid;
                Person person2;
                if (personEntityKeyHashTable.containsKey(personMergeInfo.getPrimaryPersonEntityKey().getKeyValueAsString())) {
                    person2 = (Person)((Object)personEntityKeyHashTable.get(personMergeInfo.getPrimaryPersonEntityKey().getKeyValueAsString()));
                    personMergeInfo.setPrimaryPerson(person2);
                } else {
                    vpid = this.personService.getVPIDByPersonId(personMergeInfo.getPrimaryPersonEntityKey());
                    personSearchQueryInfoPerson = new PersonSearchQueryInfo();
                    personSearchQueryInfoPerson.setSearchOptimizationType("readAll");
                    personSearchQueryInfoPerson.setRemoveEmptyStrings(true);
                    personSearchQueryInfoPerson.setSortElements(personMergeWorklistSearchQueryInfo.getSortElements());
                    personSearchQueryInfoPerson.setVpid(vpid.getVPID());
                    personResults = this.personService.search(personSearchQueryInfoPerson);
                    person = (Person)((Object)personResults.get(0));
                    personMergeInfo.setPrimaryPerson(person);
                }
                if (personEntityKeyHashTable.containsKey(personMergeInfo.getDeprecatedPersonEntityKey().getKeyValueAsString())) {
                    person2 = (Person)((Object)personEntityKeyHashTable.get(personMergeInfo.getDeprecatedPersonEntityKey().getKeyValueAsString()));
                    personMergeInfo.setDeprecatedPerson(person2);
                    continue;
                }
                vpid = this.personService.getVPIDByPersonId(personMergeInfo.getDeprecatedPersonEntityKey());
                personSearchQueryInfoPerson = new PersonSearchQueryInfo();
                personSearchQueryInfoPerson.setSearchOptimizationType("readAll");
                personSearchQueryInfoPerson.setRemoveEmptyStrings(true);
                personSearchQueryInfoPerson.setSortElements(personMergeWorklistSearchQueryInfo.getSortElements());
                personSearchQueryInfoPerson.setVpid(vpid.getVPID());
                personResults = this.personService.search(personSearchQueryInfoPerson);
                person = (Person)((Object)personResults.get(0));
                personMergeInfo.setDeprecatedPerson(person);
            }
        }
        return results;
    }

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public PersonMergeDAO getPersonMergeDAO() {
        return this.personMergeDAO;
    }

    public void setPersonMergeDAO(PersonMergeDAO personMergeDAO) {
        this.personMergeDAO = personMergeDAO;
    }

    public PersonUnmergeDAO getPersonUnmergeDAO() {
        return this.personUnmergeDAO;
    }

    public void setPersonUnmergeDAO(PersonUnmergeDAO personUnmergeDAO) {
        this.personUnmergeDAO = personUnmergeDAO;
    }

    public String getEligibilityEnrollmentServiceName() {
        return this.eligibilityEnrollmentServiceName;
    }

    public void setEligibilityEnrollmentServiceName(String eligibilityEnrollmentServiceName) {
        this.eligibilityEnrollmentServiceName = eligibilityEnrollmentServiceName;
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        if (this.eligibilityEnrollmentService == null) {
            this.eligibilityEnrollmentService = (EligibilityEnrollmentService)this.getApplicationContext().getBean(this.getEligibilityEnrollmentServiceName(), EligibilityEnrollmentService.class);
        }
        return this.eligibilityEnrollmentService;
    }

    @Override
    public PersonService getPersonService() {
        return this.personService;
    }

    @Override
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public boolean hasDeprecatedRecord(PersonIdEntityKey deprecatedPersonIdEntityKey) throws ServiceException {
        PersonMergeInfo info = null;
        boolean deprecated = false;
        try {
            info = this.personMergeDAO.getPersonMergeInfoByDeprecatedId(deprecatedPersonIdEntityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get PersonMergeInfo for: " + deprecatedPersonIdEntityKey.toString(), (Throwable)ex);
        }
        return info != null;
    }
}

