/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.ivmdm.IVMClearLoadErrorStatistics;
import gov.va.med.esr.common.model.ivmdm.IVMDMExtractBatch;
import gov.va.med.esr.common.model.ivmdm.IVMMigration;
import gov.va.med.esr.common.model.ivmdm.IVMMigrationArchive;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.external.person.IVMCandidateInfo;
import gov.va.med.esr.service.external.person.IvmLetterCandidateInfo;
import gov.va.med.esr.service.external.person.IvmLetterStatusInfo;
import gov.va.med.esr.service.external.person.collections.IvmLetterStatusCollection;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class IVMDMServiceImpl
extends AbstractComponent
implements IVMDMService {
    private static final long serialVersionUID = 63420326746244993L;
    private static final String QUERY_FIND_CONVERSION_BASE = "ivmReversalQuery_findConversionBase";
    private static final String QUERY_GET_IVM_MIGRATION_BY_PERSON_INCOME_YEAR = "ivmDMQuery_GetIVMMigrationByPersonAndIncomeYear";
    private static final String QUERY_GET_IVM_MIGRATION_MARKED_FOR_DELETE = "ivmDMQuery_GetIVMMigrationMarkedForDelete";
    private static final String QUERY_GET_IVM_MIGRATION_BY_PERSON_INCOME_YEAR_STATUS = "ivmDMQuery_GetIVMMigrationByPersonAndIncomeYearAndStatus";
    private static final String QUERY_GET_LATEST_MIGRATED_YEAR_BY_PERSON = "ivmDMQuery_GetLastedMigratedYearByPerson";
    private static final String QUERY_GET_MOST_RECENT_MIGRATED_YEAR_BY_PERSON = "ivmDMQuery_GetMostRecentMigratedYearByPerson";
    private static final String QUERY_CHECK_SELECTION_CRITERIA = "ivmDMQuery_checkSelectionCriteria";
    private static final String QUERY_GET_IVM_MIGRATION_BY_ICN_INCOME_YEAR = "ivmDMQuery_GetIVMMigrationByICNAndIncomeYear";
    private static final String QUERY_GET_IVM_MIGRATION_BY_IDENTIFIER = "ivmMigrationQuery_Identifier";
    private static final String QUERY_GET_IVM_CANDIDATES = "ivmDMQuery_GetIVMCandidatesObj";
    private static final String QUERY_GET_IVM_LETTER_CANDIDATES = "ivmLetterStatusQuery_GetIVMLetterCandidatesObj";
    private static final String QUERY_GET_IVM_DATA_FOR_ADVICE = "ivmDMQuery_GetIVMMigrationsWithCompleteOrPendingStatus";
    private static final String ICN_PARAM_NAME = "icn";
    private static final String PERSON_ID_PARAM_NAME = "personId";
    private static final String INCOME_YEAR_PARAM_NAME = "incomeYear";
    private static final String IDENTIFIER_PARAM_NAME = "identifier";
    private static final String IVM_DATE_PARAM_NAME = "ivmdate";
    private static final String STATUS_PARAM_NAME = "status";
    private static final String IVM_LIMIT_PARAM_NAME = "ivmlimit";
    private static final String STATUS_COMPLETE = "Complete";
    private DAOOperations genericDAO;
    private PSDelegateService psDelegateService;
    private SystemParameterService systemParamService;
    private LookupService lookupService;
    private PersonService personService;
    private CommsLogService commsLogService;
    private int ivmCandidateLimit;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.genericDAO, (String)"DAOOperations is required.");
        Validate.notNull((Object)this.systemParamService, (String)"SystemParameterService is required.");
        Validate.notNull((Object)this.lookupService, (String)"LookupService is required.");
        Validate.notNull((Object)this.psDelegateService, (String)"PSDelegateService is required.");
    }

    @Override
    public IVMMigration findIVMMigration(PersonEntityKey person, Integer incomeYear) throws ServiceException {
        Validate.notNull((Object)person, (String)"A person must not be null");
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        try {
            String[] paramNames = new String[]{PERSON_ID_PARAM_NAME, INCOME_YEAR_PARAM_NAME};
            Object[] paramValues = new Object[]{new BigDecimal(person.getKeyValueAsString()), incomeYear};
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_MIGRATION_BY_PERSON_INCOME_YEAR, paramNames, paramValues);
            return list.isEmpty() ? null : (IVMMigration)((Object)list.get(0));
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Migrations for person " + person.getKeyValue(), (Throwable)e);
        }
    }

    @Override
    public IVMMigration findIVMMigrationMarkedForDelete(PersonEntityKey person, Integer incomeYear) throws ServiceException {
        Validate.notNull((Object)person, (String)"A person must not be null");
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        try {
            String[] paramNames = new String[]{PERSON_ID_PARAM_NAME, INCOME_YEAR_PARAM_NAME};
            Object[] paramValues = new Object[]{new BigDecimal(person.getKeyValueAsString()), incomeYear};
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_MIGRATION_MARKED_FOR_DELETE, paramNames, paramValues);
            return list.isEmpty() ? null : (IVMMigration)((Object)list.get(0));
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Migrations for person " + person.getKeyValue(), (Throwable)e);
        }
    }

    @Override
    public IVMMigration findIVMMigration(String icn, Integer incomeYear) throws ServiceException {
        Validate.notNull((Object)icn, (String)"A ICN must not be null");
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        try {
            String[] paramNames = new String[]{ICN_PARAM_NAME, INCOME_YEAR_PARAM_NAME};
            Object[] paramValues = new Object[]{icn, incomeYear};
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_MIGRATION_BY_ICN_INCOME_YEAR, paramNames, paramValues);
            return list != null && list.size() > 0 ? (IVMMigration)((Object)list.get(0)) : null;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Migrations for icn " + icn, (Throwable)e);
        }
    }

    @Override
    public IVMMigration findIVMMigration(BigDecimal identifier) throws ServiceException {
        Validate.notNull((Object)identifier, (String)"An Identifier must not be null");
        try {
            String[] paramNames = new String[]{IDENTIFIER_PARAM_NAME};
            Object[] paramValues = new Object[]{identifier};
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_MIGRATION_BY_IDENTIFIER, paramNames, paramValues);
            return list != null && list.size() > 0 ? (IVMMigration)((Object)list.get(0)) : null;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Migrations for identifier " + identifier, (Throwable)e);
        }
    }

    @Override
    public void saveClearLoadErrorStatistics(IVMClearLoadErrorStatistics ivmCLEStats) throws ServiceException {
        Validate.notNull((Object)((Object)ivmCLEStats), (String)"A IVMClearLoadErrorStatistics must not be null");
        try {
            this.genericDAO.saveObject((Object)ivmCLEStats);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save a IVM Clear Load Error Statistics  ", (Throwable)e);
        }
    }

    @Override
    public void saveIVMMigration(IVMMigration ivmMigration) throws ServiceException {
        Validate.notNull((Object)((Object)ivmMigration), (String)"A IVM migration must not be null");
        try {
            this.genericDAO.saveObject((Object)ivmMigration);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save a IVM migration ", (Throwable)e);
        }
    }

    @Override
    public void saveIVMMigration(IVMMigration ivmMigration, MessageStatus.Code status) throws ServiceException {
        Validate.notNull((Object)((Object)ivmMigration), (String)"A IVM migration must not be null");
        Validate.notNull((Object)((Object)status), (String)"IVM Migration Status must not be null");
        ivmMigration.setStatus(this.lookupService.getMessageStatusByCode(status));
        try {
            this.genericDAO.saveObject((Object)ivmMigration);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save a IVM migration ", (Throwable)e);
        }
    }

    @Override
    public void saveIVMMigration(Date extractStartTime, PersonEntityKey personKey, String icn, Integer year) throws ServiceException {
        IVMMigration ivmMigration = this.findIVMMigration(personKey, year);
        if (ivmMigration == null) {
            ivmMigration = new IVMMigration();
        }
        ivmMigration.setMigrationDate(extractStartTime);
        ivmMigration.setIcn(icn);
        ivmMigration.setIncomeYear(year);
        ivmMigration.setPersonEntityKey(personKey);
        ivmMigration.setLoadFailureReason(null);
        ivmMigration.setRemigrate(false);
        try {
            this.genericDAO.saveObject((Object)ivmMigration);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save a IVM migration ", (Throwable)e);
        }
    }

    @Override
    public void saveIVMDMExtractBatch(IVMDMExtractBatch ivmdmExtract) throws ServiceException {
        Validate.notNull((Object)((Object)ivmdmExtract), (String)"A IVM DM Extract batch must not be null");
        try {
            this.genericDAO.saveObject((Object)ivmdmExtract);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save a list of IVM DM Extract batch ", (Throwable)e);
        }
    }

    @Override
    public Set findExtractIncomeYears(PersonEntityKey personKey, Integer incomeYear, VPIDEntityKey vpidKey) throws ServiceException {
        Integer currentYear = new Integer(this.getCurrentIY());
        Integer nextYear = new Integer(currentYear + 1);
        if (incomeYear != null) {
            return this.handleIncomeYearSpecificChange(personKey, incomeYear, vpidKey, currentYear, nextYear);
        }
        return this.handleNonIncomeYearSpecificChange(personKey, vpidKey, currentYear, nextYear);
    }

    @Override
    public int getCurrentActiveIVMIncomeYear() throws ServiceException {
        return this.getCurrentIY();
    }

    @Override
    public int getNextVMIncomeYear() throws ServiceException {
        int currentYear = this.getCurrentIY();
        return currentYear + 1;
    }

    @Override
    public Set findIVMMigrationData(Date date) throws ServiceException {
        HashSet<IVMMigration> ivmMigrationData = new HashSet<IVMMigration>();
        Validate.notNull((Object)date, (String)"A date must not be null");
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Going to get environment property for limit data ");
            }
            long limit = this.getIvmCandidateLimit();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Completed get environment property for limit data: ");
            }
            String[] paramNames = new String[]{IVM_LIMIT_PARAM_NAME};
            Object[] paramValues = new Object[]{limit};
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Going to execute retrieve candidate query ");
            }
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_CANDIDATES, paramNames, paramValues);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Completed executing query and received list of candidates ");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Going to check if list is empty ");
            }
            if (list.isEmpty()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"List is EMPTY");
                }
                return ivmMigrationData;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Completed check for empty list ");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Going to loop through list and add to ivm migration data set for returning to IVM ");
            }
            for (IVMMigration ivm : list) {
                ivmMigrationData.add(ivm);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Completed looping ");
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Candidates", (Throwable)e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Going to return set to IVM ");
        }
        return ivmMigrationData;
    }

    @Override
    public Set findIVMLetterStatusData() throws ServiceException {
        HashSet<CommsLogEntry> ivmLetterStatusData = new HashSet<CommsLogEntry>();
        try {
            List list = this.genericDAO.find(QUERY_GET_IVM_LETTER_CANDIDATES);
            if (list.isEmpty()) {
                return ivmLetterStatusData;
            }
            for (CommsLogEntry entry : list) {
                ivmLetterStatusData.add(entry);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Completed looping ");
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Candidates", (Throwable)e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Going to return set to IVM ");
        }
        return ivmLetterStatusData;
    }

    private Set handleNonIncomeYearSpecificChange(PersonEntityKey personKey, VPIDEntityKey vpidKey, Integer currentYear, Integer nextYear) throws ServiceException {
        Set incomeYears = this.getNonIYSpecificChangeYears(personKey, vpidKey, currentYear, nextYear);
        Integer[] yearsArray = incomeYears.toArray(new Integer[0]);
        for (int i = 0; i < yearsArray.length; ++i) {
            Integer year = yearsArray[i];
            IVMMigration ivmMigration = this.findIVMMigration(personKey, year);
            if (ivmMigration == null || ivmMigration.getLoadFailureReason() == null) continue;
            incomeYears.remove(year);
        }
        return incomeYears;
    }

    private Set getNonIYSpecificChangeYears(PersonEntityKey personKey, VPIDEntityKey vpidKey, Integer currentYear, Integer nextYear) throws ServiceException {
        Integer latestMigratedYear;
        HashSet<Integer> incomeYears = new HashSet<Integer>();
        boolean meetCurrentIY = this.runSelectionCriteria(personKey, currentYear, vpidKey);
        boolean meetNextIY = this.runSelectionCriteria(personKey, nextYear, vpidKey);
        if (meetCurrentIY) {
            incomeYears.add(currentYear);
        }
        if (meetNextIY) {
            incomeYears.add(nextYear);
        }
        if (!meetCurrentIY && !meetNextIY && (latestMigratedYear = this.getLatestMigratedYear(personKey)) != null) {
            incomeYears.add(latestMigratedYear);
        }
        return incomeYears;
    }

    private Set handleIncomeYearSpecificChange(PersonEntityKey personKey, Integer incomeYear, VPIDEntityKey vpidKey, Integer currentYear, Integer nextYear) throws ServiceException {
        HashSet<Integer> incomeYears = new HashSet<Integer>();
        IVMMigration ivmMigration = this.findIVMMigration(personKey, incomeYear);
        if (ivmMigration != null) {
            if (ivmMigration.getMigrationDate() != null && ivmMigration.getLoadFailureReason() == null) {
                incomeYears.add(incomeYear);
            }
        } else if ((incomeYear.intValue() == currentYear.intValue() || incomeYear.intValue() == nextYear.intValue()) && this.runSelectionCriteria(personKey, incomeYear, vpidKey)) {
            incomeYears.add(incomeYear);
        }
        return incomeYears;
    }

    @Override
    public boolean meetSelectionCriteria(PersonEntityKey personKey, String icn, Integer incomeYear) throws ServiceException {
        VPIDEntityKey vpidKey = CommonEntityKeyFactory.createVPIDEntityKey(icn);
        return this.runSelectionCriteria(personKey, incomeYear, vpidKey);
    }

    private boolean runSelectionCriteria(PersonEntityKey personKey, Integer incomeYear, VPIDEntityKey vpidKey) throws ServiceException {
        try {
            boolean allowed = this.meetPartialSelectionCriteria((EntityKey)personKey, incomeYear);
            return allowed && this.isSsnStatusVerified(vpidKey);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to check selection criteria", (Throwable)ex);
        }
    }

    private boolean meetPartialSelectionCriteria(EntityKey entityKey, Integer incomeYear) throws DAOException {
        String[] paramNames = new String[]{PERSON_ID_PARAM_NAME, INCOME_YEAR_PARAM_NAME};
        Object[] paramValues = new Object[]{entityKey.getKeyValue(), incomeYear};
        List result = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_CHECK_SELECTION_CRITERIA, paramNames, paramValues);
        return (Integer)result.get(0) > 0;
    }

    private boolean isSsnStatusVerified(VPIDEntityKey vpidEntityKey) throws Exception {
        PersonIdentityTraits iTraits = this.psDelegateService.getIdentityTraits(vpidEntityKey);
        SSN ssn = iTraits.getSsn();
        return ssn == null ? false : ssn.isSsaVerificationStatusVerified();
    }

    private int getCurrentIY() throws ServiceException {
        String incomeYearCutOff = this.systemParamService.getByName("IVM DM IY Cut Off Date").getValue();
        int cutOffMonth = Integer.parseInt(incomeYearCutOff.substring(0, 2).trim());
        int cutOffDay = Integer.parseInt(incomeYearCutOff.substring(2).trim());
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentMonth = calendar.get(2);
        int currentDay = calendar.get(5);
        boolean afterCutOff = currentMonth >= cutOffMonth && currentDay >= cutOffDay;
        return afterCutOff ? currentYear - 1 : currentYear - 2;
    }

    @Override
    public Integer getMostRecentIVMMigratedYear(PersonEntityKey person) throws ServiceException {
        BigDecimal param = new BigDecimal(person.getKeyValueAsString());
        try {
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_MOST_RECENT_MIGRATED_YEAR_BY_PERSON, PERSON_ID_PARAM_NAME, (Object)param);
            return list.isEmpty() ? null : (Integer)list.get(0);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get most recent migrated year for person " + param, (Throwable)e);
        }
    }

    @Override
    public IVMMigration findIVMMigration(PersonEntityKey personKey, Integer incomeYear, MessageStatus.Code status) throws ServiceException {
        Validate.notNull((Object)personKey, (String)"A person key must not be null");
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        Validate.notNull((Object)((Object)status), (String)"status must not be null");
        try {
            String[] paramNames = new String[]{PERSON_ID_PARAM_NAME, INCOME_YEAR_PARAM_NAME, STATUS_PARAM_NAME};
            Object[] paramValues = new Object[]{new BigDecimal(personKey.getKeyValueAsString()), incomeYear, status.getCode()};
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_MIGRATION_BY_PERSON_INCOME_YEAR_STATUS, paramNames, paramValues);
            return list.isEmpty() ? null : (IVMMigration)((Object)list.get(0));
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM Migrations for person " + personKey.getKeyValue(), (Throwable)e);
        }
    }

    @Override
    public Integer getLatestHECLegacyYear(PersonEntityKey person) throws ServiceException {
        return this.getLatestMigratedYear(person);
    }

    @Override
    public Set findIVMMigrationsWithCompleteOrPendingStatus(PersonEntityKey person) throws ServiceException {
        HashSet<IVMMigration> data = new HashSet<IVMMigration>();
        Validate.notNull((Object)person, (String)"A person key must not be null");
        try {
            String[] paramNames = new String[]{PERSON_ID_PARAM_NAME};
            Object[] paramValues = new Object[]{new BigDecimal(person.getKeyValueAsString())};
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_IVM_DATA_FOR_ADVICE, paramNames, paramValues);
            if (list.isEmpty()) {
                return data;
            }
            for (IVMMigration ivm : list) {
                data.add(ivm);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of IVM migration records", (Throwable)e);
        }
        return data;
    }

    private Integer getLatestMigratedYear(PersonEntityKey person) throws ServiceException {
        BigDecimal param = new BigDecimal(person.getKeyValueAsString());
        try {
            List list = this.genericDAO.findByNamedQueryAndNamedParam(QUERY_GET_LATEST_MIGRATED_YEAR_BY_PERSON, PERSON_ID_PARAM_NAME, (Object)param);
            return list.isEmpty() ? null : (Integer)list.get(0);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get lastest migrated year for person " + param, (Throwable)e);
        }
    }

    @Override
    public boolean updateErrorReasonData(Integer incomeYear, String icn, String date, String errorReason) throws ServiceException {
        IVMMigration ivmMigration = this.findIVMMigration(icn, incomeYear);
        if (ivmMigration != null) {
            if (StringUtils.isNotEmpty((String)errorReason)) {
                ivmMigration.setLoadFailureReason(errorReason);
            }
            if (StringUtils.isEmpty((String)date)) {
                ivmMigration.setMigrationDate(null);
            }
            ivmMigration.setRemigrate(false);
            try {
                this.genericDAO.saveObject((Object)ivmMigration);
            }
            catch (DAOException e) {
                throw new ServiceException("Failed to save a IVM Migration for " + ivmMigration.getEntityKey().getKeyValueAsString(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateClearLoadError(String icn, String incomeYear, IVMClearLoadErrorStatistics loadErrorStats) throws ServiceException {
        IVMMigration ivmMigration = this.findIVMMigration(icn, new Integer(incomeYear));
        if (!this.isErrorReasonExists(ivmMigration)) {
            loadErrorStats.incrementNoErrorReasonsExistsCount();
        } else {
            ivmMigration.setLoadFailureReason(null);
            if (this.shouldRemigrate(ivmMigration)) {
                ivmMigration.setRemigrate(true);
            } else {
                loadErrorStats.incrementNoLongerMeetingCriteriaCount();
                ivmMigration.setRemigrate(false);
            }
            try {
                this.genericDAO.saveObject((Object)ivmMigration);
            }
            catch (DAOException e) {
                throw new ServiceException("Failed to save a IVM Migration for " + ivmMigration.getEntityKey().getKeyValueAsString(), (Throwable)e);
            }
        }
    }

    @Override
    public IVMCandidateInfo[] updateIVMCandidateRetrieval(Set candidateSet) throws ServiceException {
        IVMCandidateInfo[] eeIVMCandidateInfo = new IVMCandidateInfo[candidateSet.size()];
        Iterator itr = candidateSet != null ? candidateSet.iterator() : null;
        int i = 0;
        while (itr != null && itr.hasNext()) {
            IVMCandidateInfo ivmCandidateInfo = new IVMCandidateInfo();
            IVMMigration ivmCandidate = (IVMMigration)((Object)itr.next());
            if (ivmCandidate != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Going to person service for: " + (Object)((Object)ivmCandidate)));
                }
                ivmCandidateInfo.setVpid(this.getPersonService().getVPIDByPersonId(ivmCandidate.getPersonEntityKey()).getVPID());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Completed person service call for: " + (Object)((Object)ivmCandidate)));
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Going to set income year for: " + (Object)((Object)ivmCandidate)));
                }
                ivmCandidateInfo.setIncomeYear(ivmCandidate.getIncomeYear());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Completed set income year for: " + (Object)((Object)ivmCandidate)));
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Going to set transaction retrieving entity key: " + (Object)((Object)ivmCandidate)));
                }
                ivmCandidateInfo.setTransactionId(ivmCandidate.getEntityKey().getKeyValueAsString());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Completed set transaction retrieving entity key: " + (Object)((Object)ivmCandidate)));
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Going to decide on saving " + (Object)((Object)ivmCandidate)));
                }
                if (!MessageStatus.AWAITING_ACKNOWLEDGEMENT.getName().equals(ivmCandidate.getStatus().getCode())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Going to save ivm migration " + (Object)((Object)ivmCandidate)));
                    }
                    this.saveIVMMigration(ivmCandidate, MessageStatus.AWAITING_ACKNOWLEDGEMENT);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Completed save ivm migration " + (Object)((Object)ivmCandidate)));
                    }
                }
                this.logger.info((Object)("Ended task within loop for =" + (Object)((Object)ivmCandidate)));
            }
            eeIVMCandidateInfo[i] = ivmCandidateInfo;
            ++i;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Outside while loop - Returning candidate info array to caller =" + eeIVMCandidateInfo.length));
        }
        return eeIVMCandidateInfo;
    }

    @Override
    public IvmLetterCandidateInfo[] updateIVMLetterCandidateRetrieval(Set letterCandidates) throws ServiceException {
        IvmLetterCandidateInfo[] ivmLetterCandidateInfos = new IvmLetterCandidateInfo[letterCandidates.size()];
        Iterator itr = letterCandidates != null ? letterCandidates.iterator() : null;
        int i = 0;
        while (itr != null && itr.hasNext()) {
            IvmLetterCandidateInfo ivmLetterCandidateInfo = new IvmLetterCandidateInfo();
            CommsLogEntry entry = (CommsLogEntry)((Object)itr.next());
            if (entry != null) {
                IvmLetterStatusInfo[] ivmLetterStatusInfos;
                ivmLetterCandidateInfo.setVpid(this.getPersonService().getVPIDByPersonId(entry.getPersonIdEntityKey()).getVPID());
                ivmLetterCandidateInfo.setIvmCaseNumber(entry.getIvmCaseNumber());
                ivmLetterCandidateInfo.setIvmLetterCode(entry.getFormNumber());
                ivmLetterCandidateInfo.setIvmLetterMailedDate(entry.getMailingDate());
                List links = entry.getMailingStatusLinks();
                IvmLetterStatusInfo[] ivmLetterStatusInfoArray = ivmLetterStatusInfos = links != null ? new IvmLetterStatusInfo[links.size()] : new IvmLetterStatusInfo[]{};
                if (links != null) {
                    int j = 0;
                    for (MailingStatusLink link : links) {
                        IvmLetterStatusInfo ivmLetterStatusInfo = new IvmLetterStatusInfo();
                        ivmLetterStatusInfo.setCommunicationId(entry.getCommsLogIdString());
                        ivmLetterStatusInfo.setRecordModifiedDate(link.getCreatedOn());
                        ivmLetterStatusInfo.setLetterCommunicationStatus(link.getMailingStatus().getCode());
                        ivmLetterStatusInfos[j] = ivmLetterStatusInfo;
                        ++j;
                    }
                }
                IvmLetterStatusCollection ivmLetterStatusCollection = new IvmLetterStatusCollection(ivmLetterStatusInfos);
                ivmLetterCandidateInfo.setIvmLetterStatuses(ivmLetterStatusCollection);
            }
            ivmLetterCandidateInfos[i] = ivmLetterCandidateInfo;
            ++i;
        }
        return ivmLetterCandidateInfos;
    }

    @Override
    public void updateCommLogEntriesSentToIVMFlag(Set letterCandidates) throws ServiceException {
        Iterator itr;
        IvmLetterCandidateInfo[] ivmLetterCandidateInfos = new IvmLetterCandidateInfo[letterCandidates.size()];
        Iterator iterator = itr = letterCandidates != null ? letterCandidates.iterator() : null;
        while (itr != null && itr.hasNext()) {
            CommsLogEntry entry = (CommsLogEntry)((Object)itr.next());
            entry.setSentToIVM(Boolean.FALSE);
            this.getCommsLogService().update(entry);
        }
    }

    @Override
    public boolean updateIVMStatus(BigDecimal transactionId, String status) throws ServiceException {
        IVMMigration ivmRecord = this.findIVMMigration(transactionId);
        String errMsg = status;
        if (status != null && status.length() > 1500) {
            errMsg = status.substring(0, 1500);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("IVM Record found = record id: " + ivmRecord.getEntityKey() + " , uncoming transation id: " + transactionId));
        }
        boolean updated = false;
        if (ivmRecord != null) {
            updated = true;
            if (status == null || status.equals("")) {
                ivmRecord.setMigrationDate(new Date());
                ivmRecord.setLoadFailureReason(status);
                this.saveIVMMigration(ivmRecord, MessageStatus.COMPLETE);
                this.archivePreviousMigrations(ivmRecord);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Saved Status to complete for transaction id:  = " + transactionId));
                }
            } else {
                ivmRecord.setLoadFailureReason(errMsg);
                this.saveIVMMigration(ivmRecord, MessageStatus.ERROR);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Saved Status to Error for transaction id:  = " + transactionId));
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Completed archiving/updating for transaction id:  = " + transactionId));
        }
        return updated;
    }

    public void archivePreviousMigrations(IVMMigration ivmRecord) throws ServiceException {
        Set previousMigrations = this.findIVMMigrationsWithCompleteOrPendingStatus(ivmRecord.getPersonEntityKey());
        for (IVMMigration prev : previousMigrations) {
            if (!prev.getIncomeYear().equals(ivmRecord.getIncomeYear()) || !prev.getStatus().getDescription().equals(STATUS_COMPLETE)) continue;
            try {
                if (prev.getEntityKey().equals(ivmRecord.getEntityKey())) continue;
                IVMMigrationArchive ar = new IVMMigrationArchive(prev);
                this.genericDAO.saveObject((Object)ar);
                this.genericDAO.removeObject(prev.getEntityKey());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Archived IVM MIGRATE_ID:=" + prev.getEntityKey().getKeyValueAsString()));
            }
            catch (DAOException e) {
                throw new ServiceException("Failed to ARCHIVE a completed IVM migration: " + ivmRecord.getEntityKey().getKeyValueAsString(), (Throwable)e);
            }
        }
    }

    private boolean shouldRemigrate(IVMMigration ivmMigration) throws ServiceException {
        Validate.notNull((Object)((Object)ivmMigration), (String)"IVMMigration Object must not be null.");
        if (ivmMigration.getMigrationDate() != null) {
            return true;
        }
        return this.meetSelectionCriteria(ivmMigration.getPersonEntityKey(), ivmMigration.getIcn(), ivmMigration.getIncomeYear());
    }

    private boolean isErrorReasonExists(IVMMigration ivmMigration) {
        return ivmMigration != null && ivmMigration.getLoadFailureReason() != null;
    }

    public DAOOperations getGenericDAO() {
        return this.genericDAO;
    }

    public void setGenericDAO(DAOOperations dao) {
        this.genericDAO = dao;
    }

    public void setSystemParameterService(SystemParameterService systemParamService) {
        this.systemParamService = systemParamService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public int getIvmCandidateLimit() {
        return this.ivmCandidateLimit;
    }

    public void setIvmCandidateLimit(int ivmCandidateLimit) {
        this.ivmCandidateLimit = ivmCandidateLimit;
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }
}

