/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.batchprocess.HandBookBatchRequestConsumerProcess;
import gov.va.med.esr.common.batchprocess.HealthBenefitPlanData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.DeliveryPreferenceEmail;
import gov.va.med.esr.common.model.comms.Directory;
import gov.va.med.esr.common.model.comms.Document;
import gov.va.med.esr.common.model.comms.DocumentAccessLog;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.comms.FileInfo;
import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HandBookMailStatus;
import gov.va.med.esr.common.model.comms.HandbookBatchFileProcessStatistics;
import gov.va.med.esr.common.model.comms.HandbookBatchRequestStatistics;
import gov.va.med.esr.common.model.comms.HealthBenefitPlan;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceSourceOfChange;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.lookup.DocumentType;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.common.model.lookup.HandBookRequestStatusType;
import gov.va.med.esr.common.model.lookup.VeteranIdentifierType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.common.persistent.comms.DeliveryPreferenceDAO;
import gov.va.med.esr.common.persistent.comms.DocumentReceiptDAO;
import gov.va.med.esr.common.persistent.comms.FileInfoDAO;
import gov.va.med.esr.common.persistent.comms.HandBookMailQueueDAO;
import gov.va.med.esr.common.persistent.comms.HandbookBatchFileProcessStatisticsDAO;
import gov.va.med.esr.common.persistent.comms.HandbookBatchRequestDAO;
import gov.va.med.esr.common.persistent.comms.HandbookBatchStatisticsDAO;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;
import gov.va.med.esr.common.persistent.history.HandBookHistoryDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.DuplicatePrintRequestServiceException;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.external.person.DeliveryPreferenceInfo;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.esr.vcg.webservice.generated.GetHandbookRequest;
import gov.va.med.esr.vcg.webservice.generated.GetHandbookResponse;
import gov.va.med.esr.vcg.webservice.generated.HandbookServicePortType;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.HealthBenefitsPlanProcessStatistics;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.springframework.util.FileCopyUtils;

public class HandBookServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements HandBookService {
    private static final long serialVersionUID = 1267686755986748702L;
    public static final String DUPE_CHECK_DELIMITER = ":";
    private static Principal USER_SERVICE_DP = new UserPrincipalImpl("Veteran Self Service");
    private DocumentReceiptDAO documentReceiptDao = null;
    private CommsTemplateDAO templDAO = null;
    private HandBookMailQueueDAO mailQueueDAO = null;
    private CommsLetterRequestService letterRequestService = null;
    private PersonHelperService personHelperService = null;
    private HandbookBatchRequestDAO handbookBatchRequestDAO = null;
    private HandbookBatchStatisticsDAO handbookBatchStatisticsDAO = null;
    private HandbookBatchFileProcessStatisticsDAO handbookBatchFileProcessStatisticsDAO = null;
    private HandBookHistoryDAO mailQueueHistoryDAO = null;
    private HistoryDAO addressHistoryDAO = null;
    private AddressDAO addressDAO = null;
    private DemographicService demographicService = null;
    private String environmentName = null;
    private String localVBRLocation;
    private HandBookBatchRequestConsumerProcess processInvoker;
    private DeliveryPreferenceDAO deliveryPreferenceDAO = null;
    private HistoryDAO deliveryPreferenceHistoryDAO = null;
    private CommsTemplate commsTemplate400H = null;
    private FileInfoDAO fileInfoDAO;
    private String vcgWsdlLocation;
    private String vcgWsdlServiceName;
    private String vcgWsdlServiceNamespace;

    @Override
    public List getHandbookInformation(String vpid) throws ServiceException, DAOException {
        List results = this.getDocumentReceiptDao().findDocumentReceipts(vpid);
        return results;
    }

    public FileInfoDAO getFileInfoDAO() {
        return this.fileInfoDAO;
    }

    public void setFileInfoDAO(FileInfoDAO fileInfoDAO) {
        this.fileInfoDAO = fileInfoDAO;
    }

    @Override
    public List getLatestHandbookInformation(String vpid) throws ServiceException, DAOException {
        List results = this.getDocumentReceiptDao().findLatestDocumentReceipts(vpid);
        return results;
    }

    @Override
    public Directory findActiveVBRDirectory() throws ServiceException {
        try {
            return this.getDocumentReceiptDao().getActiveVBRDirectoty();
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void saveDocumentReceipt(DocumentReceipt documentReceipt) throws ServiceException {
        try {
            this.getDocumentReceiptDao().saveObject((Object)documentReceipt);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void deleteDocumentReceipt(DocumentReceipt documentReceipt) throws ServiceException {
        try {
            this.getDocumentReceiptDao().deleteDocumentReceipt(documentReceipt);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String getVBRFileLocation(Directory dir) {
        if ("Local".equals(this.getEnvironmentName())) {
            return this.getLocalVBRLocation();
        }
        return dir.getMountPoint().getName() + dir.getName();
    }

    @Override
    public void processHealthBenefitsPlanRecord(HealthBenefitPlanData healthBenefitPlanData, String pdfFileLocation, DataFileProcessExecutionContext context) throws ServiceException {
        HealthBenefitsPlanProcessStatistics stats = (HealthBenefitsPlanProcessStatistics)context.getProcessStatistics();
        DocumentType handBookFileType = (DocumentType)this.getLookupService().getByCode(DocumentType.class, DocumentType.CODE_HANDBOOK_BY_CMS.getCode());
        DocumentType benefitsProfileFileType = (DocumentType)this.getLookupService().getByCode(DocumentType.class, DocumentType.CODE_BENEFITS_PROFILE_BY_CMS.getCode());
        List documentReiptList = this.findDocumentReceipts(healthBenefitPlanData.getVpid());
        String receiptNumber = healthBenefitPlanData.getHandbookRequestId();
        Directory currentDirectory = this.findActiveVBRDirectory();
        String vbrFolderName = this.getVBRFileLocation(currentDirectory);
        File vbrFolder = new File(vbrFolderName);
        if (!vbrFolder.exists() && !vbrFolder.mkdirs()) {
            throw new ServiceException("Unable to Create VBR Folder :" + vbrFolderName);
        }
        DocumentReceipt currentReceipt = null;
        int maxVersion = 0;
        ArrayList<DocumentReceipt> deleteReceipts = new ArrayList<DocumentReceipt>();
        for (int i = 0; i < documentReiptList.size(); ++i) {
            DocumentReceipt receipt = (DocumentReceipt)((Object)documentReiptList.get(i));
            if (receiptNumber.equals(receipt.getReceiptString())) {
                currentReceipt = receipt;
            }
            if (maxVersion < receipt.getVersionNumber()) {
                maxVersion = receipt.getVersionNumber();
            }
            if (i + 1 < handBookFileType.getVersionsKept()) continue;
            deleteReceipts.add(receipt);
        }
        int newVersionNumber = maxVersion + 1;
        boolean newDocumentReceipt = false;
        if (currentReceipt == null) {
            newDocumentReceipt = true;
            currentReceipt = new DocumentReceipt();
            currentReceipt.setReceiptDate(new Date());
            currentReceipt.setReleaseControlNumber(healthBenefitPlanData.getReleaseControlNumber());
            currentReceipt.setVPIDValue(healthBenefitPlanData.getVpid());
            currentReceipt.setReceiptString(healthBenefitPlanData.getHandbookRequestId());
            currentReceipt.setVersionNumber(newVersionNumber);
            currentReceipt.setVeteranIdentifierType((VeteranIdentifierType)this.getLookupService().getByName(VeteranIdentifierType.class, "VPID"));
            Document handBookDoc = new Document();
            handBookDoc.setDocumentType(handBookFileType);
            handBookDoc.setCreationDate(new Date());
            FileInfo handBookFile = new FileInfo();
            handBookFile.setName(healthBenefitPlanData.getVpid() + "_HANDBOOK_V" + newVersionNumber + ".pdf");
            handBookFile.setDirectory(currentDirectory);
            handBookDoc.setFileInfo(handBookFile);
            currentReceipt.addDocument(handBookDoc);
            Document benefitsDoc = new Document();
            benefitsDoc.setDocumentType(benefitsProfileFileType);
            FileInfo benefitsFile = new FileInfo();
            benefitsFile.setName(healthBenefitPlanData.getVpid() + "_BENEFITS_PROFILE_V" + newVersionNumber + ".pdf");
            benefitsFile.setDirectory(currentDirectory);
            benefitsDoc.setFileInfo(benefitsFile);
            benefitsDoc.setCreationDate(new Date());
            currentReceipt.addDocument(benefitsDoc);
        }
        HealthBenefitPlan hbPlan = new HealthBenefitPlan();
        hbPlan.setHealthBenefitCategory(healthBenefitPlanData.getCategoryCode());
        hbPlan.setCoveragePlanCode(healthBenefitPlanData.getCoveragePlanCode());
        hbPlan.setHealthBenefitCode(healthBenefitPlanData.getHealthBenefitCode());
        currentReceipt.addHealthBenefitPlan(hbPlan);
        this.saveDocumentReceipt(currentReceipt);
        if (newDocumentReceipt) {
            File handBookfile = new File(pdfFileLocation + "/" + healthBenefitPlanData.getIcn() + "_HB_" + healthBenefitPlanData.getHandbookRequestId() + ".pdf");
            File benefitsProfilefile = new File(pdfFileLocation + "/" + healthBenefitPlanData.getIcn() + "_BP_" + healthBenefitPlanData.getHandbookRequestId() + ".pdf");
            File handBookfileAtVBR = new File(this.getVBRFileLocation(currentDirectory) + healthBenefitPlanData.getVpid() + "_HANDBOOK_V" + newVersionNumber + ".pdf");
            File benProfilefileAtVBR = new File(this.getVBRFileLocation(currentDirectory) + healthBenefitPlanData.getVpid() + "_BENEFITS_PROFILE_V" + newVersionNumber + ".pdf");
            try {
                if (benefitsProfilefile.exists() && handBookfile.exists()) {
                    FileCopyUtils.copy((File)handBookfile, (File)handBookfileAtVBR);
                    stats.incrementNumHandbooksStored();
                    FileCopyUtils.copy((File)benefitsProfilefile, (File)benProfilefileAtVBR);
                    stats.incrementNumBenefitsProfilesStored();
                    if (!handBookfile.delete()) {
                        this.logger.error((Object)("Failed to delete file : " + handBookfile.getPath()));
                    }
                    if (!benefitsProfilefile.delete()) {
                        this.logger.error((Object)("Failed to delete file : " + benefitsProfilefile.getPath()));
                    }
                } else {
                    if (!benefitsProfilefile.exists()) {
                        FileCopyUtils.copy((File)benefitsProfilefile, (File)benProfilefileAtVBR);
                    }
                    if (!handBookfile.exists()) {
                        FileCopyUtils.copy((File)handBookfile, (File)handBookfileAtVBR);
                    }
                }
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
            for (int j = 0; deleteReceipts != null && j < deleteReceipts.size(); ++j) {
                DocumentReceipt receipt = (DocumentReceipt)((Object)deleteReceipts.get(j));
                Set delDocs = receipt.getDocuments();
                this.deleteDocumentReceipt(receipt);
                if (delDocs == null || delDocs.size() <= 0) continue;
                for (Document delDoc : delDocs) {
                    FileInfo file = delDoc.getFileInfo();
                    File phyFile = null;
                    try {
                        phyFile = new File(this.getVBRFileLocation(file.getDirectory()) + file.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (phyFile != null && phyFile.delete()) continue;
                }
            }
        }
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getLocalVBRLocation() {
        return this.localVBRLocation;
    }

    public void setLocalVBRLocation(String localVBRLocation) {
        this.localVBRLocation = localVBRLocation;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.mailQueueDAO, (String)"dao is required");
        Validate.notNull((Object)this.letterRequestService, (String)"letterRequestService is required");
        Validate.notNull((Object)this.personHelperService, (String)"personHelperService is required");
    }

    @Override
    public DocumentReceiptDAO getDocumentReceiptDao() {
        return this.documentReceiptDao;
    }

    @Override
    public void setDocumentReceiptDao(DocumentReceiptDAO documentReceiptDao) {
        this.documentReceiptDao = documentReceiptDao;
    }

    public CommsTemplateDAO getTemplDAO() {
        return this.templDAO;
    }

    public void setTemplDAO(CommsTemplateDAO templDAO) {
        this.templDAO = templDAO;
    }

    @Override
    public void recordDocumentAccess(BigDecimal fileId) throws Exception {
        DocumentAccessLog documentAccessLog = new DocumentAccessLog();
        documentAccessLog.setAccessDate(new Date());
        documentAccessLog.setFileId(fileId);
        UserPrincipal principal = this.getLoggedInUser();
        documentAccessLog.setAccessedBy(principal.getName());
        this.mailQueueDAO.recordDocumentAccess(documentAccessLog);
    }

    protected UserPrincipal getLoggedInUser() {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        return securityContext != null ? securityContext.getUserPrincipal() : null;
    }

    public HandBookMailQueueDAO getMailQueueDAO() {
        return this.mailQueueDAO;
    }

    public void setMailQueueDAO(HandBookMailQueueDAO mailQueueDAO) {
        this.mailQueueDAO = mailQueueDAO;
    }

    @Override
    public List findHandbookEntriesByPersonId(String personId) throws ServiceException {
        try {
            return this.mailQueueDAO.findHandbookListByPersonId(personId);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findAnyHandbookSentOrMailedForPersonId(String personId) throws ServiceException {
        try {
            return this.mailQueueDAO.findAnyHandbookSentOrMailedForPersonId(personId);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findDeliveryPreferenceEditableStatusByPersonId(String personId) throws ServiceException {
        try {
            return this.mailQueueDAO.findDeliveryPreferenceEditableStatusByPersonId(personId);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findHandbookEntriesInSendSatusByPersonId(BigDecimal personId, String releaseCtl) throws ServiceException {
        try {
            HandBookReleaseControl handBookRelaseCtl = this.getHandBookReleaseControl(releaseCtl);
            return this.mailQueueDAO.findHandbookSendStatusListByPersonId(personId, handBookRelaseCtl.getIdentifier());
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findHandbookEntriesInSendToCMSByPersonByTemp(Person person, ComLetterTemplateType template) throws ServiceException {
        try {
            if (person == null) {
                return null;
            }
            HandBookReleaseControl handBookRelaseCtl = this.getHandBookReleaseControl(null);
            HandBookMailStatusType sendToCmsType = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.SEND_TO_CMS);
            List handBookEntries = this.getMailQueueDAO().findHandBookEntryByPersonByTempOnSendStatus(new BigDecimal(person.getEntityKey().getKeyValueAsString()), template.getIdentifier(), sendToCmsType.getIdentifier(), handBookRelaseCtl.getIdentifier());
            return handBookEntries;
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook entries by Person Id: " + person.getEntityKey().getKeyValueAsString(), (Throwable)ex);
        }
    }

    @Override
    public List lastHandbookReturnPostOffice(String personId) throws ServiceException {
        try {
            return this.mailQueueDAO.lastHandbookReturnPostOffice(personId);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List getRawProfileData(String vpid, int receipt_id) throws ServiceException {
        try {
            return this.mailQueueDAO.getRawProfileData(vpid, receipt_id);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Raw Profile Data: ", (Throwable)ex);
        }
    }

    @Override
    public void triggerHandBookPFInsert(String personId) throws ServiceException {
        try {
            List handBookList = this.findHandbookEntriesInSendSatusByPersonId(new BigDecimal(personId), null);
            if (handBookList != null && handBookList.size() > 0) {
                ComLetterTemplateType type = this.getLookupService().getComLetterTemplateTypeByCode(ComLetterTemplateType.FORM_NUMBER_400F.getCode());
                this.requestHandBook(personId, new LetterTriggerIdentity(type, LetterTrigger.CategoryType.VETERAN_LETTER));
            } else {
                SystemParameterService systemParameterService = (SystemParameterService)this.getComponent("systemParameterService");
                if (systemParameterService.isHandBookRollOutOver()) {
                    ComLetterTemplateType type = this.getLookupService().getComLetterTemplateTypeByCode(ComLetterTemplateType.FORM_NUMBER_400H.getCode());
                    this.requestHandBook(personId, new LetterTriggerIdentity(type, LetterTrigger.CategoryType.VETERAN_LETTER));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)(" error in triggerHandBookPFInsert" + e.getStackTrace()));
        }
    }

    public CommsLetterRequestService getLetterRequestService() {
        return this.letterRequestService;
    }

    public void setLetterRequestService(CommsLetterRequestService letterRequestService) {
        this.letterRequestService = letterRequestService;
    }

    @Override
    public List findHandbookTemplate() throws ServiceException {
        try {
            return this.mailQueueDAO.findHandbookTemplate();
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find Handbook Template", (Throwable)ex);
        }
    }

    @Override
    public HandBookMailQueue getHandbookMailQueueEntry(EntityKey key) throws ServiceException {
        try {
            return (HandBookMailQueue)((Object)this.mailQueueDAO.getByKey(key));
        }
        catch (DAOException ex) {
            throw new ServiceException("Error getting HandbookMailQueue using key: " + key, (Throwable)ex);
        }
    }

    @Override
    public void updateRemarks(HandBookMailQueue handbookMailQueue) throws ServiceException {
        try {
            this.mailQueueDAO.saveObject((Object)handbookMailQueue);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error updating handbook remarks", (Throwable)ex);
        }
    }

    @Override
    public List findDocumentReceipts(String vpid) throws ServiceException {
        try {
            return this.documentReceiptDao.findDocumentReceipts(vpid);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public boolean verifyDocumentReceipt(String vpid, String uid) throws ServiceException {
        boolean verified = false;
        try {
            List documentReceiptList = this.findDocumentReceipts(vpid);
            for (int i = 0; i < documentReceiptList.size(); ++i) {
                Set docList;
                BigDecimal UID = new BigDecimal(uid);
                DocumentReceipt receipt = (DocumentReceipt)((Object)documentReceiptList.get(i));
                BigDecimal receiptString = new BigDecimal(receipt.getReceiptString());
                if (!UID.equals(receiptString) || (docList = receipt.getDocuments()) == null || docList.size() != 2) continue;
                this.logger.info((Object)("Found verified receipt uid=" + uid + " count=" + i + " receipt.getReceiptString()=" + receipt.getReceiptString()));
                verified = true;
                break;
            }
            return verified;
        }
        catch (NumberFormatException nex) {
            this.logger.error((Object)("fatal error in verifyDocumentReceipt : " + nex.getStackTrace()));
            throw new ServiceException("fatal error in verifyDocumentReceipt : ", (Throwable)nex);
        }
    }

    @Override
    public HandbookBatchRequestDAO getHandbookBatchRequestDAO() {
        return this.handbookBatchRequestDAO;
    }

    @Override
    public void setHandbookBatchRequestDAO(HandbookBatchRequestDAO handbookBatchRequestDAO) {
        this.handbookBatchRequestDAO = handbookBatchRequestDAO;
    }

    public HandbookBatchStatisticsDAO getHandbookBatchStatisticsDAO() {
        return this.handbookBatchStatisticsDAO;
    }

    public void setHandbookBatchStatisticsDAO(HandbookBatchStatisticsDAO handbookBatchStatisticsDAO) {
        this.handbookBatchStatisticsDAO = handbookBatchStatisticsDAO;
    }

    @Override
    public void addHandBookBatchRequest(HandBookBatchRequest handBookBatchRequest) throws ServiceException {
        try {
            String batchRequestId = this.getHandbookBatchRequestDAO().insertObject((Object)handBookBatchRequest).getKeyValueAsString();
            ArrayList<HandBookBatchRequest> acquiredData = new ArrayList<HandBookBatchRequest>();
            if (batchRequestId != null) {
                acquiredData.add(handBookBatchRequest);
                this.getProcessInvoker().processEntityData(null, acquiredData);
            }
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR to insert a new handbookbatch request entry ", (Throwable)dex);
            throw new ServiceException("Excption when inserting a batch request entry!" + dex.getMessage(), (Throwable)dex);
        }
    }

    @Override
    public void saveHandBookBatchRequest(HandBookBatchRequest handBookBatchRequest) throws ServiceException {
        try {
            this.getHandbookBatchRequestDAO().saveObject((Object)handBookBatchRequest);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR to insert a new handbookbatch request entry ", (Throwable)dex);
            throw new ServiceException("Excption when inserting a batch request entry!" + dex.getMessage(), (Throwable)dex);
        }
    }

    @Override
    public List getHandBookBatchRequests() throws ServiceException {
        List batchRequestList = null;
        try {
            batchRequestList = this.getHandbookBatchRequestDAO().getHandBookBatchRequests();
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return batchRequestList;
    }

    @Override
    public List<HandbookBatchRequestStatistics> getHandbookBatchRequestStatistics(Date releaseDate) throws ServiceException {
        List<HandbookBatchRequestStatistics> batchRequestList = null;
        try {
            batchRequestList = this.getHandbookBatchStatisticsDAO().getHandbookBatchRequestStatistics(releaseDate);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return batchRequestList;
    }

    @Override
    public List getHandbookBatchFileStatistics(Date startDate) throws ServiceException {
        return this.getHandbookBatchRequestStatistics(startDate);
    }

    @Override
    public List<Date> getHandbookBatchFileProcessDateList() throws ServiceException {
        List<Date> hbfDateList = null;
        try {
            hbfDateList = this.getHandbookBatchFileProcessStatisticsDAO().getHandbookBatchFileProcessDateList();
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return hbfDateList;
    }

    @Override
    public HandbookBatchFileProcessStatistics getHandbookBatchFileProcessStatistics(Date selectedDate, Date jobStartDate, Date jobEndDate) throws ServiceException {
        HandbookBatchFileProcessStatistics batchFileProcessStat = null;
        try {
            batchFileProcessStat = this.getHandbookBatchFileProcessStatisticsDAO().getHandbookBatchFileProcessStatistics(selectedDate, jobStartDate, jobEndDate);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return batchFileProcessStat;
    }

    @Override
    public Date getHandbookBatchFileProcessMinJobStartDate(Date selectedDate) throws ServiceException {
        Date minJobStartDate = null;
        try {
            minJobStartDate = this.getHandbookBatchFileProcessStatisticsDAO().getHandbookBatchFileProcessMinJobStartDate(selectedDate);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return minJobStartDate;
    }

    @Override
    public Date getHandbookBatchFileProcessMaxJobEndDate(Date selectedDate) throws ServiceException {
        Date maxJobEndDate = null;
        try {
            maxJobEndDate = this.getHandbookBatchFileProcessStatisticsDAO().getHandbookBatchFileProcessMaxJobEndDate(selectedDate);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return maxJobEndDate;
    }

    @Override
    public List getNewHandBookBatchRequestIds() throws ServiceException {
        List newRequestIds = null;
        try {
            newRequestIds = this.getHandbookBatchRequestDAO().getNewHandBookBatchRequestIds();
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException:", (Throwable)daoEx);
        }
        return newRequestIds;
    }

    private void pupulateEStRecordCount(List batchRequestList) {
        if (batchRequestList != null && batchRequestList.size() > 0) {
            for (int i = 0; i < batchRequestList.size(); ++i) {
                HandBookBatchRequest batchRequest = (HandBookBatchRequest)((Object)batchRequestList.get(i));
                if (!HandBookRequestStatusType.NEW.getCode().equals(batchRequest.getHandBookRequestStatus().getCode()) || batchRequest.getBatchReleaseSize() != null) continue;
                int estCount = this.getEstRecordCountForBatch(batchRequest.getEntityKey().getKeyValueAsString());
                batchRequest.setBatchReleaseSize(String.valueOf(estCount));
            }
        }
    }

    private void populateMailQueue(List batchRequestList) {
        if (batchRequestList != null && batchRequestList.size() > 0) {
            try {
                HandBookMailStatusType mailedCmsType = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.MAILED_BY_CMS);
                HandBookMailStatusType sentCmsType = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.SENT_TO_CMS);
                HandBookMailStatusType onlineType = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.ONLINE);
                for (int i = 0; i < batchRequestList.size(); ++i) {
                    try {
                        HandBookBatchRequest batchRequest = (HandBookBatchRequest)((Object)batchRequestList.get(i));
                        if (HandBookRequestStatusType.NEW.getCode().equals(batchRequest.getHandBookRequestStatus().getCode()) || HandBookRequestStatusType.CANCELLED.getCode().equals(batchRequest.getHandBookRequestStatus().getCode())) continue;
                        List mailedCms = this.getMailQueueDAO().getHandBookMailQueueCountByBatchIdByStatus(new BigDecimal(batchRequest.getEntityKey().getKeyValueAsString()), mailedCmsType.getIdentifier());
                        int mailedCmsCount = 0;
                        if (mailedCms != null) {
                            mailedCmsCount = (Integer)mailedCms.iterator().next();
                        }
                        batchRequest.setNumberOfRecordMailedByCMS(mailedCmsCount);
                        List sentCMS = this.getMailQueueDAO().getHandBookMailQueueCountByBatchIdByStatus(new BigDecimal(batchRequest.getEntityKey().getKeyValueAsString()), sentCmsType.getIdentifier());
                        int sentCms = 0;
                        if (sentCMS != null) {
                            sentCms = (Integer)sentCMS.iterator().next();
                        }
                        batchRequest.setNumberOfRecordSendToCMS(sentCms);
                        List online = this.getMailQueueDAO().getHandBookMailQueueCountByBatchIdByStatus(new BigDecimal(batchRequest.getEntityKey().getKeyValueAsString()), onlineType.getIdentifier());
                        int onlineCnt = 0;
                        if (online != null) {
                            onlineCnt = (Integer)online.iterator().next();
                        }
                        batchRequest.setNumberOfRecordOnline(onlineCnt);
                        continue;
                    }
                    catch (Exception dex) {
                        this.logger.error((Object)"ERROR to finding count of record in mail queue ", (Throwable)dex);
                    }
                }
            }
            catch (Exception dex) {
                this.logger.error((Object)"ERROR to finding count of record in mail queue", (Throwable)dex);
            }
        }
    }

    @Override
    public void updateBatchRequestEstCountRecord(HandBookBatchRequest batchrequest) {
        try {
            int noOfESTREcord = this.getEstRecordCountForBatch(batchrequest.getEntityKey().getKeyValueAsString());
            batchrequest.setBatchReleaseSize(String.valueOf(noOfESTREcord));
            this.getHandbookBatchRequestDAO().merge(batchrequest);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR to update a new handbookbatch request release size ", (Throwable)dex);
        }
    }

    @Override
    public int getEstRecordCountForBatch(String BatchId) {
        int noOfEstRecord = 0;
        try {
            noOfEstRecord = this.handbookBatchRequestDAO.getEstRecordCountForBatch(BatchId);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR to insert a new handbookbatch request entry ", (Throwable)dex);
        }
        return noOfEstRecord;
    }

    @Override
    public HandBookBatchRequest getHandbookBatchRequestEntry(EntityKey key) throws ServiceException {
        try {
            return (HandBookBatchRequest)((Object)this.getHandbookBatchRequestDAO().getByKey(key));
        }
        catch (DAOException ex) {
            throw new ServiceException("Error getting HandbookbatchRequest using key: " + key, (Throwable)ex);
        }
    }

    @Override
    public void updateHandBookBatchRequestStatus(HandBookBatchRequest handBookBatchRequest, HandBookRequestStatusType newStatus) throws ServiceException {
        try {
            handBookBatchRequest.setHandBookRequestStatus(newStatus);
            this.handbookBatchRequestDAO.saveObject((Object)handBookBatchRequest);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error updating handbookbatchrequest status " + (Object)((Object)ex));
        }
    }

    @Override
    public void saveHandBookMailQueue(HandBookMailQueue mailQueue) throws ServiceException {
        try {
            this.getMailQueueDAO().saveObject((Object)mailQueue);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR saving handbookMailQueue entry ", (Throwable)dex);
            throw new ServiceException("Excption saving a MailQueue entry!" + dex.getMessage(), (Throwable)dex);
        }
    }

    public HandBookHistoryDAO getMailQueueHistoryDAO() {
        return this.mailQueueHistoryDAO;
    }

    public void setMailQueueHistoryDAO(HandBookHistoryDAO mailQueueHistoryDAO) {
        this.mailQueueHistoryDAO = mailQueueHistoryDAO;
    }

    @Override
    public List getHandbookMailQueueHistory(BigDecimal key) throws ServiceException {
        try {
            return this.mailQueueHistoryDAO.getHandBookMailQueueHistory(key);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException in getHandbookMailQueueHistory:", (Throwable)daoEx);
        }
    }

    @Override
    public List getHandbookMailQueueCommentHistory(BigDecimal key) throws ServiceException {
        try {
            return this.mailQueueHistoryDAO.getHandBookMailQueueCommentHistory(key);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException in getHandbookMailQueueCommentHistory:", (Throwable)daoEx);
        }
    }

    @Override
    public List getHandBookMailStatusHistory(BigDecimal key) throws ServiceException {
        try {
            List statusList = this.mailQueueHistoryDAO.getHandBookMailStatusHistory(key);
            Iterator iter = statusList.iterator();
            String curStatusId = "";
            while (iter.hasNext()) {
                HandBookMailStatus hbms = (HandBookMailStatus)((Object)iter.next());
                if (hbms.getEntityKey().getKeyValueAsString().equals(curStatusId)) {
                    iter.remove();
                    continue;
                }
                curStatusId = hbms.getEntityKey().getKeyValueAsString();
                EntityKey ek = CommonEntityKeyFactory.createHandBookMailStatusTypeEntityKey(hbms.getStatusTypeId().toString());
                HandBookMailStatusType statusType = (HandBookMailStatusType)((Object)this.mailQueueDAO.getByKey(ek));
                hbms.setStatusType(statusType);
            }
            return this.mailQueueHistoryDAO.getHandBookMailStatusHistory(key);
        }
        catch (DAOException daoEx) {
            throw new ServiceException("DAOException in getHandBookMailStatusHistory:", (Throwable)daoEx);
        }
    }

    @Override
    public void changeHandbookMailingStatus(HandBookMailQueue handbookMailQueue, HandBookMailStatusType status) throws ServiceException {
        HandBookMailStatus hbms = handbookMailQueue.getHandBookMailStatus();
        hbms.setStatusType(status);
        try {
            this.mailQueueDAO.saveObject((Object)hbms);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error calling changeHandbookMailingStatus", (Throwable)ex);
        }
    }

    @Override
    public HandBookMailQueue findHandBookByIdentifier(String uid) throws ServiceException {
        HandBookMailQueue mailQueue = null;
        try {
            BigDecimal UID = new BigDecimal(uid);
            mailQueue = this.mailQueueDAO.findHandBookByIdentifier(UID);
            return mailQueue;
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public List requestHandBook(String personId, LetterTriggerIdentity letterType) throws ServiceException {
        HandBookReleaseControl handBookReleaseControl = this.getHandBookReleaseControl(null);
        ComLetterTemplateType formNum = letterType.getDataType();
        if (formNum == null || formNum.getName() == null) {
            ServiceException ex = new ServiceException("Can not send a handBook mail with an empty form number!!!");
            this.logger.error((Object)"Error empty form number while requesting an handBook mail ", (Throwable)ex);
            throw ex;
        }
        this.requestHandBookMail(new BigDecimal(personId), formNum, null, null, handBookReleaseControl.getIdentifier());
        return null;
    }

    private void requestHandBookMail(BigDecimal personId, CommsTemplate templ, String remark, String batchRequestId, BigDecimal releaseCtl) throws ServiceException {
        try {
            HandBookMailStatusType statusType = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.SEND_TO_CMS.getCode());
            List handBookEntry = this.getMailQueueDAO().findHandBookEntryByPersonByTempOnSendStatus(personId, new BigDecimal(templ.getEntityKey().getKeyValueAsString()), statusType.getIdentifier(), releaseCtl);
            if (handBookEntry != null && handBookEntry.size() > 0) {
                throw new DuplicatePrintRequestServiceException("Error there is a pending handbook of the same template for that person " + personId, null);
            }
        }
        catch (DAOException dex) {
            throw new ServiceException("ERROR in findHandBookEntryByPersonByTempOnSendStatus for peronsonId = " + personId + dex.getMessage(), (Throwable)dex);
        }
        HandBookMailQueue mailEntry = null;
        try {
            mailEntry = this.createMailQueue(personId, templ, batchRequestId, releaseCtl, remark);
            this.mailQueueDAO.insert(mailEntry);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR to insert a new mail queue entry with status \"Send to CMS\" while requesting an AAC letter", (Throwable)dex);
            throw new ServiceException("Excption when inserting a Mail queue entry!" + dex.getMessage(), (Throwable)dex);
        }
    }

    @Override
    public void requestHandBookMail(BigDecimal personId, ComLetterTemplateType formNum, String remark, String batchRequestId, BigDecimal releaseCtl) throws ServiceException {
        String formNumberStr = formNum.getCode();
        CommsTemplate templ = null;
        try {
            templ = (CommsTemplate)this.templDAO.findTemplateListByFormNumber(formNumberStr).get(0);
            this.requestHandBookMail(personId, templ, remark, batchRequestId, releaseCtl);
        }
        catch (DAOException dex) {
            this.logger.error((Object)("ERROR to find a Comms Template with form number = " + formNumberStr), (Throwable)dex);
            throw new ServiceException("Exception when find a Comms Template with form number=" + formNumberStr + ". Error Message: " + dex.getMessage(), (Throwable)dex);
        }
    }

    @Override
    public void request400HHandBookMail(BigDecimal personId, String remark, String batchRequestId, BigDecimal releaseCtl) throws ServiceException {
        this.requestHandBookMail(personId, this.getCommsTemplate400H(), remark, batchRequestId, releaseCtl);
    }

    private CommsTemplate getCommsTemplate400H() throws ServiceException {
        if (this.commsTemplate400H == null) {
            String formNumberStr = ComLetterTemplateType.FORM_NUMBER_400H.getCode();
            try {
                this.commsTemplate400H = (CommsTemplate)this.templDAO.findTemplateListByFormNumber(formNumberStr).get(0);
            }
            catch (DAOException dex) {
                this.logger.error((Object)("ERROR to find a Comms Template with form number = " + formNumberStr), (Throwable)dex);
                throw new ServiceException("Excption when find a Comms Template with form number=" + formNumberStr + ". Error Message: " + dex.getMessage(), (Throwable)dex);
            }
        }
        return this.commsTemplate400H;
    }

    public HandBookMailQueue createMailQueue(BigDecimal personId, CommsTemplate templ, String batchRequestId, BigDecimal releaseCtl, String remark) throws ServiceException {
        HandBookMailQueue mailQueue = new HandBookMailQueue();
        if (batchRequestId != null) {
            mailQueue.setBatchRequestId(new BigDecimal(batchRequestId));
        }
        mailQueue.setPersonId(personId);
        mailQueue.setTemplate(templ);
        HandBookMailStatus handBookMailStatus = new HandBookMailStatus();
        handBookMailStatus.setHandBookMailQueue(mailQueue);
        try {
            HandBookMailStatusType statusType = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.SEND_TO_CMS.getCode());
            handBookMailStatus.setStatusType(statusType);
            handBookMailStatus.setHandBookMailQueue(mailQueue);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR lookup  HandBookMailStatusType \"Send to CMS\" ", (Throwable)dex);
            throw new ServiceException("Excption when lookup class HandBookMailStatusType !" + dex.getMessage(), (Throwable)dex);
        }
        mailQueue.setHandBookMailStatus(handBookMailStatus);
        mailQueue.setReleaseControlId(releaseCtl);
        mailQueue.setActionComment(remark);
        return mailQueue;
    }

    public HistoryDAO getAddressHistoryDAO() {
        return this.addressHistoryDAO;
    }

    public void setAddressHistoryDAO(HistoryDAO addressHistoryDAO) {
        this.addressHistoryDAO = addressHistoryDAO;
    }

    @Override
    public Address getHandBookMailingAddress(HandBookMailQueue handBookMailQueue) throws ServiceException {
        Address address = null;
        Address hdbkAddress = null;
        BigDecimal hdbkAddressId = handBookMailQueue.getAddressId();
        if (hdbkAddressId != null) {
            address = hdbkAddress = this.getHandbookAddress(handBookMailQueue.getAddressId());
            if (handBookMailQueue.getHandBookMailStatus().getCmsFileGeneratedDate() != null) {
                try {
                    PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(handBookMailQueue.getPersonId()));
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Timestamp ts = Timestamp.valueOf(df.format(handBookMailQueue.getHandBookMailStatus().getCmsFileGeneratedDate()));
                    ChangeEvent ce = new ChangeEvent(ts, (EntityKey)personKey);
                    Person p = (Person)this.addressHistoryDAO.getHistoryByChangeTime(ce).getCurrentVersion();
                    Iterator iter = p.getAddresses().iterator();
                    Address nextAddr = null;
                    while (iter.hasNext()) {
                        nextAddr = (Address)iter.next();
                        if (!hdbkAddressId.toString().equals(nextAddr.getEntityKey().getKeyValueAsString())) continue;
                        address = nextAddr;
                        break;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return address;
    }

    @Override
    public void saveHandbookMailStatus(HandBookMailQueue mailQueue, HandBookMailStatusType statusType) throws ServiceException {
        HandBookMailStatus status = mailQueue.getHandBookMailStatus();
        status.setStatusType(statusType);
        try {
            this.mailQueueDAO.saveObject((Object)mailQueue);
        }
        catch (DAOException ex) {
            throw new ServiceException("DAOException in updateHandbookMailStatus", (Throwable)ex);
        }
    }

    @Override
    public List checkHandbookMailValidation(Person person) throws ServiceException {
        ArrayList<String> errorList = new ArrayList<String>(0);
        DeathRecord deathRecord = person.getDeathRecord();
        if (deathRecord != null && deathRecord.getDeathDate() != null) {
            errorList.add("This individual is deceased");
        }
        if (errorList.isEmpty()) {
            boolean enrolled = false;
            try {
                if (person.getEnrollmentDetermination().getEnrollmentStatus().getCode().equals(EnrollmentStatus.CODE_VERIFIED.getName())) {
                    enrolled = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!enrolled) {
                errorList.add("This individual is not currently enrolled");
            }
        }
        if (errorList.isEmpty()) {
            if (!this.hasPreferredFacility(person)) {
                errorList.add("This individual does not have a preferred facility");
            }
            if (!this.hasPriority(person)) {
                errorList.add("This individual does not have a enrollment priority");
            }
        }
        if (errorList.isEmpty()) {
            SystemParameterService systemParameterService = (SystemParameterService)this.getComponent("systemParameterService");
            String releaseCtl = systemParameterService.getHandBookReleaseCtl();
            List handbookEntries = this.findHandbookEntriesByPersonId(person.getPersonEntityKey().getKeyValueAsString());
            for (HandBookMailQueue hbmq : handbookEntries) {
                if (!hbmq.isSendToCMS() || !hbmq.getHandBookReleaseControl().getCode().equals(releaseCtl)) continue;
                errorList.add("This individual is already scheduled to received the current handbook");
                break;
            }
        }
        if (errorList.isEmpty()) {
            Address mailingAddress = this.demographicService.getLetterAddress(person);
            if (mailingAddress == null) {
                errorList.add("No mailing address for this individual");
            } else {
                if (mailingAddress.getLine1() == null || mailingAddress.getLine1().equals("")) {
                    errorList.add("Bad mailing address: No information for Line 1");
                }
                if (mailingAddress.getCity() == null || mailingAddress.getCity().equals("")) {
                    errorList.add("Bad mailing address: No City specified");
                }
                if (mailingAddress.isUSAddress()) {
                    if (mailingAddress.getState() == null || mailingAddress.getState().equals("")) {
                        errorList.add("Bad mailing address: No State specified");
                    }
                    if (mailingAddress.getZipCode() == null || mailingAddress.getZipCode().equals("")) {
                        errorList.add("Bad mailing address: No Zip Code specified");
                    }
                } else if (mailingAddress.getCountry() == null || mailingAddress.getCountry().equals("")) {
                    errorList.add("Bad mailing address: No Country Code specified");
                }
            }
            Name name = person.getLegalName();
            if (name == null) {
                errorList.add("No Legal Name for this individual");
            } else if (name.getFamilyName() == null || name.getFamilyName().equals("")) {
                errorList.add("No Last Name specified for this individual");
            }
            BirthRecord birthRecord = person.getBirthRecord();
            if (birthRecord == null || birthRecord.getBirthDate() == null) {
                errorList.add("No Date of Birth specified for this individual");
            }
            if (person.getGender() == null) {
                errorList.add("No Gender specified for this individual");
            }
            if (person.getVPIDValue() == null || person.getVPIDValue().equals("")) {
                errorList.add("No VPID specified for this individual");
            }
        }
        return errorList;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    private boolean hasPriority(Person person) {
        boolean validPriority = false;
        if (person.getEnrollmentDetermination() != null && person.getEnrollmentDetermination().getPriorityGroup() != null) {
            if (person.getEnrollmentDetermination().getPriorityGroup().equals((Object)EnrollmentPriorityGroup.GROUP_7) || person.getEnrollmentDetermination().getPriorityGroup().equals((Object)EnrollmentPriorityGroup.GROUP_8)) {
                if (person.getEnrollmentDetermination().getPrioritySubGroup() != null) {
                    validPriority = true;
                }
            } else {
                validPriority = true;
            }
        }
        return validPriority;
    }

    private boolean hasPreferredFacility(Person person) {
        boolean hasFacility = false;
        Date currentDate = DateUtils.getCurrentDateTime();
        Set pfList = person.getPreferredFacilities();
        if (pfList != null) {
            for (PreferredFacility pf : pfList) {
                if (pf.getUnassignmentDate() != null && !pf.getUnassignmentDate().after(currentDate)) continue;
                hasFacility = true;
                break;
            }
        }
        return hasFacility;
    }

    @Override
    public HandBookReleaseControl getHandBookReleaseControl(String releaseCtl) throws ServiceException {
        HandBookReleaseControl handBookReleaseControl = null;
        try {
            if (releaseCtl == null) {
                SystemParameterService systemParameterService = (SystemParameterService)this.getComponent("systemParameterService");
                releaseCtl = systemParameterService.getHandBookReleaseCtl();
            }
            if (releaseCtl != null) {
                handBookReleaseControl = (HandBookReleaseControl)this.getLookupService().getByCode(HandBookReleaseControl.class, releaseCtl);
            }
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR lookup HandBookReleaseControl ", (Throwable)dex);
            throw new ServiceException("Excption in lookup HandBookReleaseControl !" + dex.getMessage(), (Throwable)dex);
        }
        return handBookReleaseControl;
    }

    public AddressDAO getAddressDAO() {
        return this.addressDAO;
    }

    public void setAddressDAO(AddressDAO addressDAO) {
        this.addressDAO = addressDAO;
    }

    @Override
    public Address getHandbookAddress(BigDecimal addressId) throws ServiceException {
        Address address = null;
        try {
            address = this.addressDAO.getAddressById(addressId);
        }
        catch (Exception ex) {
            this.logger.error((Object)"ERROR getHandbookAddress ", (Throwable)ex);
            throw new ServiceException("Exception in getHandbookAddress: " + ex.getMessage(), (Throwable)ex);
        }
        return address;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    @Override
    public String getICNChecksumForVpid(String vpid) {
        return this.personHelperService.getICNChecksum(vpid);
    }

    @Override
    public void processUndeliverableHandbook(HandBookMailQueue handbookMailQueue) throws ServiceException {
        this.getCommunicationRuleService().handleUndeliverableHandbook(handbookMailQueue);
    }

    @Override
    public void handleMailingResponse(HandBookMailQueue handbookMailQueue) throws ServiceException {
        this.getCommunicationRuleService().handleHandbookMailingResponse(handbookMailQueue);
    }

    public HandBookBatchRequestConsumerProcess getProcessInvoker() {
        return this.processInvoker;
    }

    public void setProcessInvoker(HandBookBatchRequestConsumerProcess processInvoker) {
        this.processInvoker = processInvoker;
    }

    @Override
    public DeliveryPreference findDeliveryPreferenceByPersonId(String personId) throws ServiceException {
        try {
            return this.deliveryPreferenceDAO.findDeliveryPreferenceByPersonId(personId);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to find delivery preference by Person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public void saveDeliveryPreference(DeliveryPreference deliveryPreference) throws ServiceException {
        try {
            this.deliveryPreferenceDAO.saveObject((Object)deliveryPreference);
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to update delivery preference.", (Throwable)ex);
        }
    }

    public DeliveryPreferenceDAO getDeliveryPreferenceDAO() {
        return this.deliveryPreferenceDAO;
    }

    public void setDeliveryPreferenceDAO(DeliveryPreferenceDAO deliveryPreferenceDAO) {
        this.deliveryPreferenceDAO = deliveryPreferenceDAO;
    }

    public HistoryDAO getDeliveryPreferenceHistoryDAO() {
        return this.deliveryPreferenceHistoryDAO;
    }

    public void setDeliveryPreferenceHistoryDAO(HistoryDAO deliveryPreferenceHistoryDAO) {
        this.deliveryPreferenceHistoryDAO = deliveryPreferenceHistoryDAO;
    }

    @Override
    public HistoricalInfo getDeliveryPreferencesHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.deliveryPreferenceHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getDeliveryPreferencesChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.deliveryPreferenceHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void buildDeliveryPreference(DeliveryPreferenceInfo info, DeliveryPreference dp) throws ServiceException {
        if (info != null) {
            DeliveryPreferenceType dtp = dp.getDeliveryPreferenceType();
            dtp = (DeliveryPreferenceType)this.getLookupService().getByCode(DeliveryPreferenceType.class, DeliveryPreferenceType.CODE_MAIL.getCode());
            if (info.getDeliveryPreference().equalsIgnoreCase("MAIL")) {
                dtp = (DeliveryPreferenceType)this.getLookupService().getByCode(DeliveryPreferenceType.class, DeliveryPreferenceType.CODE_MAIL.getCode());
                dp.setDeliveryPreferenceType(dtp);
            }
            if (info.getDeliveryPreference().equalsIgnoreCase("ONLINE")) {
                dtp = (DeliveryPreferenceType)this.getLookupService().getByCode(DeliveryPreferenceType.class, DeliveryPreferenceType.CODE_ONLINE.getCode());
                dp.setDeliveryPreferenceType(dtp);
            }
            DeliveryPreferenceSourceOfChange dsc = dp.getSourceOfChange();
            dsc = (DeliveryPreferenceSourceOfChange)this.getLookupService().getByCode(DeliveryPreferenceSourceOfChange.class, DeliveryPreferenceSourceOfChange.CODE_VSS.getCode());
            dp.setSourceOfChange(dsc);
            dp.setModifiedBy(USER_SERVICE_DP);
            dp.setChangeDate(new Date());
            if (info.getEmailAddress() != null) {
                DeliveryPreferenceEmail email = dp.getEmail();
                if (email == null) {
                    email = new DeliveryPreferenceEmail();
                }
                email.setAddress(info.getEmailAddress());
                EmailType etp = email.getType();
                if (info.getEmailType().equalsIgnoreCase("BUSINESS")) {
                    etp = (EmailType)this.getLookupService().getByCode(EmailType.class, EmailType.CODE_BUSINESS.getCode());
                    email.setType(etp);
                }
                if (info.getEmailType().equalsIgnoreCase("PRIVATE")) {
                    etp = (EmailType)this.getLookupService().getByCode(EmailType.class, EmailType.CODE_PRIVATE.getCode());
                    email.setType(etp);
                }
                dp.setEmail(email);
            }
        }
    }

    @Override
    public FileInfo getFileInfoById(BigDecimal id) throws ServiceException {
        try {
            return this.getFileInfoDAO().getFileInfoById(id);
        }
        catch (DAOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public ByteArrayInputStream convertXmlHandBookToPDF(File file) throws ServiceException {
        if (file == null) {
            throw new ServiceException("Illegal Parameter.  Expected to receive an XML file; but no file received.");
        }
        if (!file.getName().endsWith("xml")) {
            throw new ServiceException("Illegal Parameter.  Expected to receive an XML file.");
        }
        try {
            URL url = new URL(this.getVcgWsdlLocation());
            QName qname = new QName(this.getVcgWsdlServiceNamespace(), this.getVcgWsdlServiceName());
            Service service = Service.create((URL)url, (QName)qname);
            HandbookServicePortType proxy = (HandbookServicePortType)service.getPort(HandbookServicePortType.class);
            GetHandbookRequest request = new GetHandbookRequest();
            byte[] requestPayload = FileUtils.readFileToByteArray((File)file);
            request.setXmlData(Base64.encodeBase64((byte[])requestPayload));
            GetHandbookResponse response = proxy.getHandbook(request);
            byte[] responsePayload = response.getPdfData();
            byte[] decodedResponsePayload = Base64.decodeBase64((byte[])responsePayload);
            ByteArrayInputStream bais = new ByteArrayInputStream(decodedResponsePayload);
            return bais;
        }
        catch (Exception e) {
            this.logger.error((Object)"PDF version of the Handbook / Benefits At a Glance could not be retrieved from Virtual Content Generator", (Throwable)e);
            throw new ServiceException("PDF version of the Handbook / Benefits At a Glance could not be retrieved from Virtual Content Generator");
        }
    }

    @Override
    public void saveOnlineDocumentReceipt(DocumentReceipt documentReceipt) throws ServiceException {
        try {
            documentReceipt.setReceiptDate(new Date());
            Set doc = documentReceipt.getDocuments();
            if (doc != null) {
                for (Document dt : doc) {
                    dt.setCreationDate(new Date());
                }
            }
            this.saveDocumentReceipt(documentReceipt);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String getVcgWsdlServiceName() {
        return this.vcgWsdlServiceName;
    }

    public void setVcgWsdlServiceName(String vcgWsdlServiceName) {
        this.vcgWsdlServiceName = vcgWsdlServiceName;
    }

    public String getVcgWsdlServiceNamespace() {
        return this.vcgWsdlServiceNamespace;
    }

    public void setVcgWsdlServiceNamespace(String vcgWsdlServiceNamespace) {
        this.vcgWsdlServiceNamespace = vcgWsdlServiceNamespace;
    }

    public String getVcgWsdlLocation() {
        return this.vcgWsdlLocation;
    }

    public void setVcgWsdlLocation(String vcgWsdlLocation) {
        this.vcgWsdlLocation = vcgWsdlLocation;
    }

    public HandbookBatchFileProcessStatisticsDAO getHandbookBatchFileProcessStatisticsDAO() {
        return this.handbookBatchFileProcessStatisticsDAO;
    }

    public void setHandbookBatchFileProcessStatisticsDAO(HandbookBatchFileProcessStatisticsDAO handbookBatchFileProcessStatisticsDAO) {
        this.handbookBatchFileProcessStatisticsDAO = handbookBatchFileProcessStatisticsDAO;
    }
}

