/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.batchprocess.CampLejeuneImportData;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.CampLejeuneService;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.service.ServiceException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class CampLejeuneServiceImpl
extends AbstractRuleAwareServiceImpl
implements CampLejeuneService {
    private static final long serialVersionUID = 7087682947713664526L;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private TriggerEventCacheManager triggerEventCacheManager;
    private EntityCacheManager entityCacheManager;
    private static final String CL_ERROR_REASON_NOT_SUPPORT = "ES data on file does not support CL eligibility.";
    private static final String CL_ERROR_REASON_UPDATE_INELIGIBLE = "ES CL eligibility updated with CLEAR ineligibility.";

    @Override
    public Person findPersonWithCLEARData(CampLejeuneImportData data) throws ServiceException {
        Validate.notNull((Object)((Object)data), (String)"Missing required CampLejeuneImportData");
        PersonIdentityTraits traits = data.getPersonTraits(this.getLookupService());
        Person onFile = this.getPersonService().find(traits);
        data.setIcn(onFile.getVPIDEntityKey().getShortVPID());
        Person clearPerson = (Person)((Object)onFile.clone());
        CampLejeuneVerification clv = data.getCampLejeuneVerification(this.getLookupService());
        clearPerson.setCampLejeuneVerification(clv);
        return clearPerson;
    }

    @Override
    public String[] processCLEARData(Person incoming) throws ServiceException {
        String[] oldNewErrString = new String[]{"", "", ""};
        Person onFile = this.getPersonService().getPerson(incoming.getPersonEntityKey());
        oldNewErrString[0] = this.getEnrollmentPriority(onFile.getEnrollmentDetermination());
        VAFacility sendingFacility = this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode());
        EEResultInfo clvInfo = new EEResultInfo();
        this.getEligibilityFactorRuleService().processSpecialFactors(incoming, sendingFacility, onFile, false, clvInfo);
        String errReason = clvInfo.getCLVErrorReason();
        if (errReason != null) {
            if (CL_ERROR_REASON_NOT_SUPPORT.equals(errReason)) {
                oldNewErrString[2] = CL_ERROR_REASON_NOT_SUPPORT;
                this.logger.error((Object)"#### ES data on file does not support CL eligibility.");
            } else if (CL_ERROR_REASON_UPDATE_INELIGIBLE.equals(errReason)) {
                if (onFile.getEnrollmentDetermination() != null) {
                    onFile.getEnrollmentDetermination().removeCLFromOtherEligibilities();
                }
                oldNewErrString[2] = CL_ERROR_REASON_UPDATE_INELIGIBLE;
                this.logger.error((Object)"#### ES CL eligibility updated with CLEAR ineligibility.");
            }
        }
        Person calculatedPerson = this.getEligibilityEnrollmentService().assessEEImpact(onFile, false, false, sendingFacility);
        oldNewErrString[1] = this.getEnrollmentPriority(calculatedPerson.getEnrollmentDetermination());
        Person pristinePerson = (Person)this.entityCacheManager.getItem(calculatedPerson.getEntityKey());
        if (this.isSendingZ11(oldNewErrString, calculatedPerson.getCampLejeuneVerification(), pristinePerson.getCampLejeuneVerification())) {
            PersonTriggerEvent z11TriggerEvt = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY);
            z11TriggerEvt.setPersonId((PersonEntityKey)pristinePerson.getEntityKey());
            z11TriggerEvt.setIdentityTraits(pristinePerson.getIdentityTraits());
            Set evts = this.triggerEventCacheManager.getTriggerEvents();
            if (evts == null) {
                HashSet<PersonTriggerEvent> evtSet = new HashSet<PersonTriggerEvent>();
                evtSet.add(z11TriggerEvt);
                this.triggerEventCacheManager.storeTriggerEvents(evtSet);
            } else {
                evts.add(z11TriggerEvt);
            }
        }
        if (AbstractEntity.matchesDomainValues((AbstractEntity)pristinePerson, (AbstractEntity)calculatedPerson)) {
            this.triggerEventCacheManager.removeTriggerEvents();
        } else {
            this.getPersonService().save(calculatedPerson);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("CampLejeuneServiceImpl.processCLEARData(): END processing CLEAR DATA rules for person VPID= " + calculatedPerson.getVPIDValue()));
        }
        return oldNewErrString;
    }

    private boolean isSendingZ11(String[] oldNewErrString, CampLejeuneVerification result, CampLejeuneVerification pristine) {
        Indicator pri;
        if (!oldNewErrString[0].equals(oldNewErrString[1])) {
            return true;
        }
        Indicator res = result == null ? null : result.getSpecialFactorIndicator();
        Indicator indicator = pri = pristine == null ? null : pristine.getSpecialFactorIndicator();
        if (res == null && pri == null) {
            return false;
        }
        if (res == null && pri != null || res != null && pri == null) {
            return true;
        }
        return !res.getCode().equals(pri.getCode());
    }

    private String getEnrollmentPriority(EnrollmentDetermination enroll) {
        if (enroll != null && enroll.getPriorityGroup() != null) {
            String priority = enroll.getPriorityGroup().getDescription();
            if (enroll.getPrioritySubGroup() != null) {
                priority = priority + enroll.getPrioritySubGroup().getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group", "");
            return priority.replaceAll("'", "");
        }
        return "";
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager entityCacheManager) {
        this.entityCacheManager = entityCacheManager;
    }
}

