/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external.person.ejb;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.service.ClinicalDeterminationService;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.HistoricalInfoService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonSearchQueryInfo;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.ExternalHandBookFactory;
import gov.va.med.esr.service.external.ExternalServiceBean;
import gov.va.med.esr.service.external.ExternalSummaryFactory;
import gov.va.med.esr.service.external.HandBookRequestInfo;
import gov.va.med.esr.service.external.person.AbstractEntityFinder;
import gov.va.med.esr.service.external.person.CategoryInfo;
import gov.va.med.esr.service.external.person.DeliveryPreferenceInfo;
import gov.va.med.esr.service.external.person.EDIPIEntityFinder;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilitySummary;
import gov.va.med.esr.service.external.person.EnrollmentDeterminationInfo;
import gov.va.med.esr.service.external.person.EntityKeyFactory;
import gov.va.med.esr.service.external.person.IVMLastPolledEntityFinder;
import gov.va.med.esr.service.external.person.IVMRecordStatusEntityFinder;
import gov.va.med.esr.service.external.person.IVMSummary;
import gov.va.med.esr.service.external.person.LNSEntityFinder;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.PersonLinkInfo;
import gov.va.med.esr.service.external.person.PersonMoveInfo;
import gov.va.med.esr.service.external.person.PersonPrimaryViewInfo;
import gov.va.med.esr.service.external.person.PersonService;
import gov.va.med.esr.service.external.person.PersonServiceUtil;
import gov.va.med.esr.service.external.person.SSNEntityFinder;
import gov.va.med.esr.service.external.person.SimpleEligibilitySummary;
import gov.va.med.esr.service.external.person.VPIDEntityFinder;
import gov.va.med.esr.service.external.person.VPIDEntityKey;
import gov.va.med.esr.service.external.person.collections.CategoryCollection;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.IdmWebServiceDelegate;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.ps.model.PatientIdentifier;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.hibernate.exception.ExceptionUtils;

public class PersonServiceBean
extends ExternalServiceBean
implements PersonService {
    private static final long serialVersionUID = 7424028798090596846L;
    private static final String ELIGIBILITY = "ELIGIBILITY";
    private static final String ENROLLMENT = "ENROLLMENT";
    private static final String DISABILITY = "DISABILITY";
    private static final String INSURANCE = "INSURANCE";
    private static final String ALL = "ALL";
    private EligibilityEnrollmentService eeService;
    private gov.va.med.esr.service.PersonService personService;
    private ExternalSummaryFactory externalSummaryFactory;
    private ExternalHandBookFactory externalHandBookFactory;
    private ClinicalDeterminationService clinicalDeterminationService;
    private DemographicService demographicService;
    private PreferredFacilityService preferredFacilityService;
    private HistoricalInfoService historicalInfoService;
    private HandBookService handBookService;
    private CommsEmailBulletinService commsEmailBulletinService;
    private IdmWebServiceDelegate idmServiceDelegate = null;
    private LookupService lookupService = null;

    @Override
    public void link(VPIDEntityKey deprecatedVPID, VPIDEntityKey survivingVPID) throws ESRException {
        try {
            this.processAuthenticate("PSIM link event");
            PersonLinkInfo data = PersonServiceUtil.createLinkInfo(deprecatedVPID, survivingVPID);
            this.publishExternalEventForInternalProcessing("crossApplication.notification.personLink", data);
        }
        catch (Exception e) {
            throw new ESRException("Unable to trigger event for: crossApplication.notification.personLink", e);
        }
    }

    @Override
    public void move(String dfn, String stationNumber, VPIDEntityKey fromVpid, VPIDEntityKey toVpid) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            PersonMoveInfo data = PersonServiceUtil.createMoveInfo(dfn, stationNumber, fromVpid, toVpid);
            this.publishExternalEventForInternalProcessing("crossApplication.notification.personMove", data);
        }
        catch (Exception e) {
            throw new ESRException("Unable to trigger event for: crossApplication.notification.personMove", e);
        }
    }

    public void primaryviewUpdate(VPIDEntityKey vpid) throws ESRException {
        try {
            this.processAuthenticate("PSIM primaryview event");
            PersonPrimaryViewInfo data = PersonServiceUtil.createPrimaryViewInfo(vpid);
            this.publishExternalEventForInternalProcessing("crossApplication.notification.personPrimaryview", data);
        }
        catch (Exception e) {
            throw new ESRException("Unable to trigger event for: crossApplication.notification.personPrimaryview", e);
        }
    }

    @Override
    public EligibilitySummary getEligibilitySummary(VPIDEntityKey vpid) throws ESRException {
        try {
            return this.getEligibilityEnrollmentService().getEligibilitySummary(vpid);
        }
        catch (Exception e) {
            throw new ESRException("Unable to get Eligibility Summary for VPID: " + vpid.getVPID(), e);
        }
    }

    private EligibilityEnrollmentService getEligibilityEnrollmentService() {
        if (this.eeService == null) {
            this.eeService = (EligibilityEnrollmentService)this.getBeanFactory().getBean(EligibilityEnrollmentService.class.getName(), EligibilityEnrollmentService.class);
        }
        return this.eeService;
    }

    private DemographicService getDemographicService() {
        if (this.demographicService == null) {
            this.demographicService = (DemographicService)this.getBeanFactory().getBean("demographicService");
        }
        return this.demographicService;
    }

    private PreferredFacilityService getPreferredFacilityService() {
        if (this.preferredFacilityService == null) {
            this.preferredFacilityService = (PreferredFacilityService)this.getBeanFactory().getBean("preferredFacilityService");
        }
        return this.preferredFacilityService;
    }

    private ClinicalDeterminationService getClinicalDeterminationService() {
        if (this.clinicalDeterminationService == null) {
            this.clinicalDeterminationService = (ClinicalDeterminationService)this.getBeanFactory().getBean("clinicalDeterminationService");
        }
        return this.clinicalDeterminationService;
    }

    @Override
    public SimpleEligibilitySummary getSimpleEligibilitySummary(String ssn) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
        }
        catch (LoginException le) {
            throw new ESRException("Unable to Search getSimpleEligibilitySummary", le);
        }
        PersonSearchQueryInfo searchQueryInfo = new PersonSearchQueryInfo();
        searchQueryInfo.setUnformattedSsn(ssn);
        List persons = null;
        try {
            persons = this.getPersonService().search(searchQueryInfo, true, false, false, -1);
        }
        catch (ServiceException se) {
            throw new ESRException("Unable to Search getSimpleEligibilitySummary", se);
        }
        if (persons == null || persons.size() <= 0) {
            return null;
        }
        if (persons.size() > 1) {
            throw new ESRException("More Than one person found with this SSN");
        }
        SimpleEligibilitySummary summary = new SimpleEligibilitySummary();
        Person person = (Person)((Object)persons.get(0));
        Boolean veteranInd = person.isVeteran();
        if (veteranInd == null) {
            veteranInd = new Boolean(false);
        }
        summary.setVeteranIndicator(veteranInd);
        Name legalName = person.getIdentityTraits().getLegalName();
        summary.setFirstName(legalName.getGivenName());
        summary.setLastName(legalName.getFamilyName());
        summary.setMiddleName(legalName.getMiddleName());
        return summary;
    }

    @Override
    public EESummary getEESummary(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            AbstractEntityFinder personFinder = (AbstractEntityFinder)((Object)finder);
            this.processAuthorize(personFinder.getAccountName(), personFinder.getRequestName());
            EESummary eeSummary = this.getExternalSummaryFactory().buildEESummary(this.getPersonFromFinder(finder, "eeSummary"), personFinder.getIncomeYear(), personFinder.getRequestName());
            if (eeSummary != null) {
                this.getEEAdminService().applyRequest(eeSummary, personFinder.getAccountName(), personFinder.getRequestName());
            }
            return eeSummary;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in getEESummary for finder :" + finder.getFinderData()), (Throwable)e);
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public EESummary getEESummaryHistory(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            AbstractEntityFinder personFinder = (AbstractEntityFinder)((Object)finder);
            this.processAuthorize(personFinder.getAccountName(), personFinder.getRequestName());
            PersonIdEntityKey personEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.getPersonFromFinder(finder).getEntityKey().getKeyValueAsString());
            EESummary eeSummary = new EESummary();
            EnrollmentDeterminationInfo edInfo = new EnrollmentDeterminationInfo();
            eeSummary.setEnrollmentDeterminationInfo(edInfo);
            CategoryCollection categorys = personFinder.getCategories();
            ChangeEvent ce = new ChangeEvent((EntityKey)personEntityKey);
            if (categorys != null) {
                CategoryInfo[] catinfo = categorys.getCategory();
                for (int i = 0; i < catinfo.length; ++i) {
                    ce.getTimeStamp().setTime(catinfo[i].getDateOfService().getTime());
                    if (catinfo[i].getCategoryName().equalsIgnoreCase(ELIGIBILITY) || catinfo[i].getCategoryName().equalsIgnoreCase(ALL)) {
                        this.getExternalSummaryFactory().buildEESummaryHistory((Person)this.getEligibilityEnrollmentService().getEligibilityHistoryByChangeTime(ce).getCurrentVersion(), eeSummary, ELIGIBILITY);
                    }
                    if (catinfo[i].getCategoryName().equalsIgnoreCase(ENROLLMENT) || catinfo[i].getCategoryName().equalsIgnoreCase(ALL)) {
                        this.getExternalSummaryFactory().buildEESummaryHistory((Person)this.getEligibilityEnrollmentService().getEnrollmentHistoryByChangeTime(ce).getCurrentVersion(), eeSummary, ENROLLMENT);
                        this.getExternalSummaryFactory().buildEESummaryHistory((Person)this.getEligibilityEnrollmentService().getEligibilityHistoryByChangeTime(ce).getCurrentVersion(), eeSummary, "PRIMARYELIGIBILITY");
                    }
                    if ((catinfo[i].getCategoryName().equalsIgnoreCase(INSURANCE) || catinfo[i].getCategoryName().equalsIgnoreCase(ALL)) && this.getDemographicService() != null) {
                        this.getExternalSummaryFactory().buildEESummaryHistory((Person)this.getDemographicService().getInsuranceHistoryByChangeTime(ce).getCurrentVersion(), eeSummary, INSURANCE);
                    }
                    if (!catinfo[i].getCategoryName().equalsIgnoreCase(DISABILITY) && !catinfo[i].getCategoryName().equalsIgnoreCase(ALL)) continue;
                    this.getExternalSummaryFactory().buildEESummaryHistory((Person)this.getEligibilityEnrollmentService().getEligibilityHistoryByChangeTime(ce).getCurrentVersion(), eeSummary, DISABILITY);
                }
            }
            if (eeSummary != null) {
                this.getEEAdminService().applyRequest(eeSummary, personFinder.getAccountName(), personFinder.getRequestName());
            }
            return eeSummary;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in getEESummary for finder :" + finder.getFinderData()), (Throwable)e);
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public EESummary getEDStatus(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            EESummary eeSummary = this.getExternalSummaryFactory().buildEDStatus(this.getPersonFromFinder(finder));
            return eeSummary;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in getEESummary for finder :" + finder.getFinderData()), (Throwable)e);
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public EESummary getPersonNotificationStatus(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            EESummary eeSummary = new EESummary();
            VPIDEntityFinder personFinder = (VPIDEntityFinder)finder;
            if (personFinder.getNotificationType() != null) {
                if (personFinder.getNotificationType().equalsIgnoreCase("PrimaryViewUpdate") && this.isValidforPrimaryviewUpdate(this.getPersonFromFinder(finder))) {
                    this.primaryviewUpdate(EntityKeyFactory.createVPIDEntityKey(personFinder.getVpid()));
                }
                if (personFinder.getNotificationType().equalsIgnoreCase("Link")) {
                    this.link(EntityKeyFactory.createVPIDEntityKey(personFinder.getSurvivingVpid()), EntityKeyFactory.createDeprecatedVPIDEntityKey(personFinder.getDeprecatedVpid()));
                }
                if (personFinder.getNotificationType().equalsIgnoreCase("Move")) {
                    this.move(personFinder.getDfn(), personFinder.getStationName(), EntityKeyFactory.createVPIDEntityKey(personFinder.getFromVpid()), EntityKeyFactory.createVPIDEntityKey(personFinder.getToVpid()));
                }
            }
            return eeSummary;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in getEESummary for finder :" + finder.getFinderData()), (Throwable)e);
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public EESummary getDeliveryPreference(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            String personId = this.getPersonFromFinder(finder).getPersonEntityKey().getKeyValueAsString();
            EESummary eeSummary = this.getExternalHandBookFactory().buildDeliveryPreferenceInfo(this.getHandBookService().findDeliveryPreferenceByPersonId(personId));
            if (this.getHandBookService().findDeliveryPreferenceEditableStatusByPersonId(personId).size() == 0 || this.getHandBookService().findDeliveryPreferenceEditableStatusByPersonId(personId) == null) {
                eeSummary.getDeliveryPreferenceInfo().setEditableFlag(Boolean.FALSE);
            } else {
                eeSummary.getDeliveryPreferenceInfo().setEditableFlag(Boolean.TRUE);
            }
            return eeSummary;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in getEESummary for finder :" + finder.getFinderData()), (Throwable)e);
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public EESummary updateDeliveryPreference(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            AbstractEntityFinder personFinder = (AbstractEntityFinder)((Object)finder);
            Person person = this.getPersonFromFinder(finder);
            String personId = person.getPersonEntityKey().getKeyValueAsString();
            EESummary eeSummary = new EESummary();
            if (this.getHandBookService().findDeliveryPreferenceEditableStatusByPersonId(personId).size() == 0 || this.getHandBookService().findDeliveryPreferenceEditableStatusByPersonId(personId) == null) {
                eeSummary = null;
            } else {
                DeliveryPreferenceInfo info = personFinder.getDeliveryPreferenceInfo();
                DeliveryPreference deliveryPreference = this.getHandBookService().findDeliveryPreferenceByPersonId(personId);
                DeliveryPreference dp = null;
                if (deliveryPreference == null) {
                    deliveryPreference = new DeliveryPreference();
                    person.addDeliveryPreference(deliveryPreference);
                    deliveryPreference.setPersonId(new BigDecimal(personId));
                    deliveryPreference.setDeliveryPreferenceType((DeliveryPreferenceType)this.getLookupService().getByCode(DeliveryPreferenceType.class, DeliveryPreferenceType.CODE_MAIL.getCode()));
                }
                deliveryPreference.setPersonId(new BigDecimal(personId));
                dp = (DeliveryPreference)((Object)deliveryPreference.clone());
                this.getHandBookService().buildDeliveryPreference(info, dp);
                this.getHandBookService().saveDeliveryPreference(dp);
                this.sendEmail(info, deliveryPreference);
            }
            return eeSummary;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in getEESummary for finder :" + finder.getFinderData()), (Throwable)e);
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public MSSummary getMSSummary(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            return this.getExternalSummaryFactory().buildMSSummary(this.getPersonFromFinder(finder));
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    public List getHandBook(EntityFinder finder, HandBookRequestInfo hbReqInfo) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            return this.getExternalHandBookFactory().buildHandBookInfo(this.getPersonFromFinder(finder), hbReqInfo);
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    public List getHBDataString(EntityFinder finder, HandBookRequestInfo hbReqInfo) throws ESRException {
        try {
            this.processAuthenticate("PSIM move event");
            return this.getExternalHandBookFactory().buildHBDataString(this.getPersonFromFinder(finder), hbReqInfo);
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service with EntityFinder arg: " + finder.getFinderData() + " due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public IVMSummary retrieveIVMCandidates(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("IVM move event");
            IVMLastPolledEntityFinder candidateFinder = (IVMLastPolledEntityFinder)finder;
            Date date = candidateFinder.getLastPolledDateTimeStamp();
            return this.getExternalSummaryFactory().buildIVMCandidates(date);
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service  due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public IVMSummary retrieveIVMLetterCandidates() throws ESRException {
        try {
            this.processAuthenticate("IVM move event");
            return this.getExternalSummaryFactory().buildIvmLetterCandidates();
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service  due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public IVMSummary updateIVMStatus(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("IVM move event");
            IVMRecordStatusEntityFinder updateRecordFinder = (IVMRecordStatusEntityFinder)finder;
            String status = updateRecordFinder.getErrorText();
            BigDecimal transactionId = new BigDecimal(updateRecordFinder.getTransactionId());
            return this.getExternalSummaryFactory().updateIvmStatus(transactionId, status);
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service  due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    @Override
    public IVMSummary processIVMIncomeTest(EntityFinder finder) throws ESRException {
        try {
            this.processAuthenticate("IVM move event");
            AbstractEntityFinder personFinder = (AbstractEntityFinder)((Object)finder);
            return this.getExternalSummaryFactory().processIVMIncomeTest(this.getPersonFromFinder(finder), personFinder.getIncomeYear(), personFinder.getSendIVMInfo(), personFinder.getIVMLetterInfo());
        }
        catch (Exception e) {
            String[] rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)e);
            throw new ESRException("Unable to invoke service  due to exception message: " + e.getMessage() + " and root cause stack trace: " + rootCauseStackTrace[0]);
        }
    }

    protected Person getPersonFromFinder(EntityFinder finder) throws ServiceException, ESRException {
        Person person = null;
        if (finder instanceof VPIDEntityFinder) {
            gov.va.med.esr.common.model.person.id.VPIDEntityKey internalVpid = CommonEntityKeyFactory.createVPIDEntityKey(finder.getFinderData());
            person = this.getPersonService().getPersonWithoutIdentityTraits(internalVpid);
        } else {
            PersonSearchQueryInfo searchQueryInfo = new PersonSearchQueryInfo();
            if (finder instanceof SSNEntityFinder) {
                searchQueryInfo.setUnformattedSsn(finder.getFinderData());
            } else if (finder instanceof LNSEntityFinder) {
                throw new ESRException("LNS person finder not yet implemented");
            }
            List persons = this.getPersonService().search(searchQueryInfo, true, false, false, -1);
            if (persons == null || persons.size() <= 0) {
                return null;
            }
            if (persons.size() > 1) {
                throw new ESRException("More than one person found with provided input");
            }
            person = (Person)((Object)persons.get(0));
        }
        return person;
    }

    protected Person getPersonFromFinder(EntityFinder finder, String operationName) throws ServiceException, ESRException {
        Person person = null;
        if (finder instanceof EDIPIEntityFinder) {
            if (StringUtils.isEmpty((String)finder.getFinderData())) {
                throw new ServiceException("EDIPI Exception :  " + finder.getFinderData());
            }
            List correlations = this.getIdmServiceDelegate().getCorrelationsByFullyQualifiedIdentifier(finder.getFinderData());
            if (correlations == null || correlations.size() == 0) {
                throw new ServiceException("No Record Found from MVI with EDIPI: " + finder.getFinderData());
            }
            String vpid = VPIDEntityKeyImpl.getLongVPID(this.getICN(correlations));
            gov.va.med.esr.common.model.person.id.VPIDEntityKey internalVpid = CommonEntityKeyFactory.createVPIDEntityKey(vpid);
            person = this.getPersonService().getPersonWithoutIdentityTraits(internalVpid);
        } else if (finder instanceof VPIDEntityFinder) {
            gov.va.med.esr.common.model.person.id.VPIDEntityKey internalVpid = CommonEntityKeyFactory.createVPIDEntityKey(finder.getFinderData());
            AbstractEntityFinder personFinder = (AbstractEntityFinder)((Object)finder);
            person = operationName != null && !"".equals(operationName) && operationName.equalsIgnoreCase("eeSummary") && personFinder.getRequestName().equalsIgnoreCase("IVMDATA") ? this.getPersonService().getPersonWithCompositeCall(internalVpid) : this.getPersonService().getPersonWithoutIdentityTraits(internalVpid);
        } else {
            PersonSearchQueryInfo searchQueryInfo = new PersonSearchQueryInfo();
            if (finder instanceof SSNEntityFinder) {
                searchQueryInfo.setUnformattedSsn(finder.getFinderData());
            } else if (finder instanceof LNSEntityFinder) {
                throw new ESRException("LNS person finder not yet implemented");
            }
            List persons = this.getPersonService().search(searchQueryInfo, true, false, false, -1);
            if (persons == null || persons.size() <= 0) {
                return null;
            }
            if (persons.size() > 1) {
                throw new ESRException("More than one person found with provided input");
            }
            person = (Person)((Object)persons.get(0));
        }
        return person;
    }

    public gov.va.med.esr.service.PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (gov.va.med.esr.service.PersonService)this.getBeanFactory().getBean("personService");
        }
        return this.personService;
    }

    public void setPersonService(gov.va.med.esr.service.PersonService personService) {
        this.personService = personService;
    }

    public ExternalSummaryFactory getExternalSummaryFactory() {
        if (this.externalSummaryFactory == null) {
            this.externalSummaryFactory = (ExternalSummaryFactory)this.getBeanFactory().getBean("externalSummaryFactory");
        }
        return this.externalSummaryFactory;
    }

    public void setExternalSummaryFactory(ExternalSummaryFactory externalSummaryFactory) {
        this.externalSummaryFactory = externalSummaryFactory;
    }

    public ExternalHandBookFactory getExternalHandBookFactory() {
        if (this.externalHandBookFactory == null) {
            this.externalHandBookFactory = (ExternalHandBookFactory)this.getBeanFactory().getBean("externalHandBookFactory");
        }
        return this.externalHandBookFactory;
    }

    public void setExternalHandBookFactory(ExternalHandBookFactory externalHandBookFactory) {
        this.externalHandBookFactory = externalHandBookFactory;
    }

    public void setClinicalDeterminationService(ClinicalDeterminationService clinicalDeterminationService) {
        this.clinicalDeterminationService = clinicalDeterminationService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    private boolean isValidforPrimaryviewUpdate(Person person) {
        boolean valid = false;
        if (person != null && (person.getDeathRecord() == null || person.getDeathRecord().getDeathDate() == null || person.getDeathRecord().getDeathDate().getDate() == null) && person.getEnrollmentDetermination() != null) {
            valid = true;
        }
        return valid;
    }

    public HandBookService getHandBookService() {
        if (this.handBookService == null) {
            this.handBookService = (HandBookService)this.getBeanFactory().getBean("handBookService");
        }
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    public CommsEmailBulletinService getCommsEmailBulletinService() {
        if (this.commsEmailBulletinService == null) {
            this.commsEmailBulletinService = (CommsEmailBulletinService)this.getBeanFactory().getBean("commsEmailBulletinService");
        }
        return this.commsEmailBulletinService;
    }

    public void setCommsEmailBulletinService(CommsEmailBulletinService commsEmailBulletinService) {
        this.commsEmailBulletinService = commsEmailBulletinService;
    }

    private void sendEmail(DeliveryPreferenceInfo info, DeliveryPreference dp) throws ServiceException {
        if (info.getDeliveryPreference() != null && dp.getDeliveryPreferenceType() != null && !info.getDeliveryPreference().equalsIgnoreCase(dp.getDeliveryPreferenceType().getName())) {
            if (dp.getDeliveryPreferenceType().getCode().equals("2") && info.getDeliveryPreference().equalsIgnoreCase("MAIL")) {
                if (info.getEmailAddress() != null) {
                    this.getCommsEmailBulletinService().sendEmailBulletin(BulletinTrigger.DataType.DELIVERY_PREFERENCE_CHANGE_MAIL_TO_ONLINE, info.getEmailAddress());
                }
            } else if (dp.getDeliveryPreferenceType().getCode().equals("1") && info.getDeliveryPreference().equalsIgnoreCase("ONLINE") && info.getEmailAddress() != null) {
                this.getCommsEmailBulletinService().sendEmailBulletin(BulletinTrigger.DataType.DELIVERY_PREFERENCE_CHANGE_ONLINE_TO_MAIL, info.getEmailAddress());
            }
        }
    }

    private String getICN(List correlations) {
        if (correlations == null || correlations.size() == 0) {
            return null;
        }
        PatientIdentifier pid2 = null;
        for (PatientIdentifier pid2 : correlations) {
            if (!"200M".equals(pid2.getStationNumber())) continue;
            return pid2.getIdentity();
        }
        return null;
    }

    public IdmWebServiceDelegate getIdmServiceDelegate() {
        if (this.idmServiceDelegate == null) {
            this.idmServiceDelegate = (IdmWebServiceDelegate)this.getBeanFactory().getBean("idmServiceDelegate");
        }
        return this.idmServiceDelegate;
    }

    public void setIdmServiceDelegate(IdmWebServiceDelegate idmServiceDelegate) {
        this.idmServiceDelegate = idmServiceDelegate;
    }

    public LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = (LookupService)this.getBeanFactory().getBean("lookupService");
        }
        return this.lookupService;
    }
}

