/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external.demographics;

import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.external.person.EntityKey;
import gov.va.med.esr.service.external.person.VPIDEntityKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DemographicsChangeSummary
extends ExternalComponent {
    public static final String DEFAULT_MESSAGE_INITIATER = "PSD demographics change";
    public static final String DEFAULT_MESSAGE_TYPE = "crossApplication.notification.demographicsChange";
    private static final long serialVersionUID = 493174924918166719L;
    private VPIDEntityKey vpid;
    private Set changeEvents;

    public VPIDEntityKey getVpid() {
        return this.vpid;
    }

    public DemographicsChangeSummary(VPIDEntityKey vpid) {
        this.vpid = vpid;
    }

    public DemographicsChangeSummary(VPIDEntityKey vpid, Set changeEvents) {
        this(vpid);
        this.changeEvents = changeEvents;
    }

    public Set getChangeEvents() {
        return this.changeEvents;
    }

    public Iterator getChangeEventsIterator() {
        return this.changeEvents != null ? this.changeEvents.iterator() : Collections.EMPTY_SET.iterator();
    }

    public synchronized void addChangeEvent(DemographicsChangeEvent changeEvent) {
        if (changeEvent != null) {
            this.changeEvents = this.changeEvents != null ? this.changeEvents : new HashSet();
            this.changeEvents.add(changeEvent);
        }
    }

    public boolean containsChangeEventsByType(DemographicsChangeType changeType) {
        return this.getChangeEventsByType(changeType).size() != 0;
    }

    public Set getEntityKeysByType(DemographicsChangeType changeType) {
        Set matches = this.getChangeEventsByType(changeType);
        HashSet<EntityKey> keys = new HashSet<EntityKey>();
        EntityKey key = null;
        Iterator itr = matches.iterator();
        while (itr.hasNext()) {
            key = ((DemographicsChangeEvent)itr.next()).getEntityKey();
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set getChangeEventsByType(DemographicsChangeType changeType) {
        HashSet<DemographicsChangeEvent> matches = new HashSet<DemographicsChangeEvent>();
        Iterator itr = this.getChangeEventsIterator();
        DemographicsChangeEvent current = null;
        while (itr.hasNext()) {
            current = (DemographicsChangeEvent)itr.next();
            if (!current.getChangeType().equals(changeType)) continue;
            matches.add(current);
        }
        return matches;
    }
}

