/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AuditInfo;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.person.idmgmt.types.MultipleBirthIndicator;
import gov.va.med.ps.model.PatientIdentifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonIdentityTraits
extends AbstractEntity {
    public static final String UPDATE_STATUS_ACCEPTED = "ACCEPTED";
    public static final String UPDATE_STATUS_PENDING = "PENDING";
    public static final String UPDATE_STATUS_REJECTED = "REJECTED";
    public static final int POTENTIAL_MATCH = 1;
    public static final int EXACT_MATCH = 2;
    private static final long serialVersionUID = -781467991435230932L;
    private Set names = new HashSet();
    private Set siteIdentities = new HashSet();
    private BirthRecord birthRecord;
    private Gender gender;
    private SSN ssn;
    private VPIDEntityKey vpid;
    private boolean hasPendingUpdates;
    private boolean isDeprecated;
    private boolean retrievedWithDeprecatedVPID;
    private String mothersMaidenName;
    private AuditInfo auditInfo;
    private String IDState = null;
    Set addresses = null;
    private VAFacility preferredFacilty;
    private MultipleBirthIndicator multiBirth;
    private String placeOfBirthCity;
    private String placeOfBirthState;
    private boolean addAPerson;
    private String patientType;
    private boolean isVeteran;
    private boolean isServiceConnected;
    private int idmMatchType;
    private String dateOfDeathText = null;
    private String has200ESRCorrelation = null;
    private transient List<PatientIdentifier> allCorrelations = null;

    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    public void setAuditInfo(AuditInfo auditInfo) {
        this.auditInfo = auditInfo;
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("names", (Object)this.names);
        builder.append("birthRecord", (Object)this.birthRecord);
        builder.append("gender", (Object)this.gender);
        builder.append("ssn", (Object)this.ssn);
        builder.append("vpid", (Object)this.vpid);
        builder.append("hasPendingUpdates", this.hasPendingUpdates);
        builder.append("isDeprecated", this.isDeprecated);
        builder.append("auditInfo", (Object)this.auditInfo);
        builder.append("preferredFacility", (Object)this.preferredFacilty);
        builder.append("multipleBirth", (Object)this.multiBirth);
        builder.append("placeOfBirthCity", (Object)this.placeOfBirthCity);
        builder.append("placeOfBirthState", (Object)this.placeOfBirthState);
        builder.append("addresses", (Object)this.addresses);
        builder.append("patientType", (Object)this.patientType);
        builder.append("isVeteran", this.isVeteran);
        builder.append("isServiceConnected", this.isServiceConnected);
        builder.append("idmMatchType", this.idmMatchType);
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Set getNames() {
        return this.names;
    }

    public Name getLegalName() {
        return this.names != null ? Name.getNameOfType(this.names, NameType.LEGAL_NAME.getName()) : null;
    }

    public void addName(Name name) {
        this.names.add(name);
    }

    public void setNames(Set names) {
        this.names = names;
    }

    public Set getSiteIdentities() {
        return this.siteIdentities;
    }

    public void setSiteIdentities(Set siteIdentities) {
        this.siteIdentities = siteIdentities;
    }

    public SSN getSsn() {
        return this.ssn;
    }

    public String getSsnText() {
        return this.ssn != null ? this.ssn.getFormattedSsnText() : null;
    }

    public void setSsn(SSN ssn) {
        this.ssn = ssn;
    }

    public BirthRecord getBirthRecord() {
        return this.birthRecord;
    }

    public void setBirthRecord(BirthRecord birthRecord) {
        this.birthRecord = birthRecord;
    }

    public VPIDEntityKey getVpid() {
        return this.vpid;
    }

    public void setVpid(VPIDEntityKey vpid) {
        this.vpid = vpid;
    }

    public boolean isHasPendingUpdates() {
        return this.hasPendingUpdates;
    }

    public void setHasPendingUpdates(boolean hasPendingUpdates) {
        this.hasPendingUpdates = hasPendingUpdates;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public boolean isServiceConnected() {
        return this.isServiceConnected;
    }

    public void setServiceConnected(boolean isServiceConnected) {
        this.isServiceConnected = isServiceConnected;
    }

    public boolean isVeteran() {
        return this.isVeteran;
    }

    public void setVeteran(boolean isVeteran) {
        this.isVeteran = isVeteran;
    }

    public String getPatientType() {
        return this.patientType;
    }

    public void setPatientType(String patientType) {
        this.patientType = patientType;
    }

    public Set getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set addresses) {
        this.addresses = addresses;
    }

    public void addAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        if (this.addresses == null) {
            this.addresses = new HashSet();
        }
        this.addresses.add(address);
    }

    public Address getAddressByType(String addressTypeName) {
        if (this.addresses != null && this.addresses.size() > 0) {
            return Address.getAddressOfType(this.addresses, addressTypeName);
        }
        return null;
    }

    public boolean containsOnlySSN() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isNotBlank((String)ssn) && StringUtils.isBlank((String)firstName) && StringUtils.isBlank((String)lastName) && dob == null && gender == null) {
            result = true;
        }
        return result;
    }

    public boolean hasOfficialSSN() {
        SSNType myType = this.getSsn() != null ? this.getSsn().getType() : null;
        return myType != null && SSNType.CODE_ACTIVE.getCode().equals(myType.getCode());
    }

    public boolean containsOnlyFullName() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isBlank((String)ssn) && StringUtils.isNotBlank((String)firstName) && StringUtils.isNotBlank((String)lastName) && dob == null && gender == null) {
            result = true;
        }
        return result;
    }

    public boolean containsAtLeastFullName() {
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        boolean result = false;
        if (StringUtils.isNotBlank((String)firstName) && StringUtils.isNotBlank((String)lastName)) {
            result = true;
        }
        return result;
    }

    public boolean containsOnlyLastNameAndDOB() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isBlank((String)ssn) && StringUtils.isBlank((String)firstName) && StringUtils.isNotBlank((String)lastName) && dob != null && gender == null) {
            result = true;
        }
        return result;
    }

    public boolean containsAtLeastLastNameAndDOB() {
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        boolean result = false;
        if (StringUtils.isNotBlank((String)lastName) && dob != null) {
            result = true;
        }
        return result;
    }

    public boolean containsSsnDOBGender() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isBlank((String)lastName) && StringUtils.isNotBlank((String)ssn) && dob != null && gender != null) {
            result = true;
        }
        return result;
    }

    public boolean isRetrievedWithDeprecatedVPID() {
        return this.retrievedWithDeprecatedVPID;
    }

    public void setRetrievedWithDeprecatedVPID(boolean retrievedWithDeprecatedVPID) {
        this.retrievedWithDeprecatedVPID = retrievedWithDeprecatedVPID;
    }

    public boolean isAcceptedStatus() {
        return "A".equalsIgnoreCase(this.auditInfo != null ? this.auditInfo.getStatus() : "");
    }

    public boolean isPendingStatus() {
        return "P".equalsIgnoreCase(this.auditInfo != null ? this.auditInfo.getStatus() : "");
    }

    public boolean isRejectedStatus() {
        return !this.isAcceptedStatus() && !this.isPendingStatus();
    }

    public String getMothersMaidenName() {
        return this.mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public boolean equals(Object o) {
        super.getLogger();
        return super.equals(o);
    }

    public String getIDState() {
        return this.IDState;
    }

    public void setIDState(String state) {
        this.IDState = state;
    }

    public MultipleBirthIndicator getMultiBirth() {
        return this.multiBirth;
    }

    public void setMultiBirth(MultipleBirthIndicator multiBirth) {
        this.multiBirth = multiBirth;
    }

    public String getPlaceOfBirthCity() {
        return this.placeOfBirthCity;
    }

    public void setPlaceOfBirthCity(String placeOfBirthCity) {
        this.placeOfBirthCity = placeOfBirthCity;
    }

    public String getPlaceOfBirthState() {
        return this.placeOfBirthState;
    }

    public void setPlaceOfBirthState(String placeOfBirthState) {
        this.placeOfBirthState = placeOfBirthState;
    }

    public VAFacility getPreferredFacilty() {
        return this.preferredFacilty;
    }

    public void setPreferredFacilty(VAFacility preferredFacilty) {
        this.preferredFacilty = preferredFacilty;
    }

    public boolean isAddAPerson() {
        return this.addAPerson;
    }

    public void setAddAPerson(boolean addAPerson) {
        this.addAPerson = addAPerson;
    }

    public int getIdmMatchType() {
        return this.idmMatchType;
    }

    public void setIdmMatchType(int idmMatchType) {
        this.idmMatchType = idmMatchType;
    }

    public String getDateOfDeathText() {
        return this.dateOfDeathText;
    }

    public void setDateOfDeathText(String dateOfDeathText) {
        this.dateOfDeathText = dateOfDeathText;
    }

    public String has200ESRCorrelation() {
        return this.has200ESRCorrelation != null ? this.has200ESRCorrelation : "N";
    }

    public void set200ESRCorrelation(String has200ESRCorrelation) {
        this.has200ESRCorrelation = has200ESRCorrelation;
    }

    public List<PatientIdentifier> getAllCorrelations() {
        return this.allCorrelations;
    }

    public void setAllCorrelations(List<PatientIdentifier> allCorrelations) {
        this.allCorrelations = allCorrelations;
    }
}

