/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.validator.person;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.validator.AbstractDQValidator;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;

public class PersonDQValidator
extends AbstractDQValidator {
    private static final long serialVersionUID = -6137838653506200625L;
    private Validator birthRecordValidator;
    private Validator deathRecordValidator;
    private Validator nameValidator;
    private LookupService lookupService;

    public Validator getBirthRecordValidator() {
        return this.birthRecordValidator;
    }

    public void setBirthRecordValidator(Validator birthRecordValidator) {
        this.birthRecordValidator = birthRecordValidator;
    }

    public Validator getDeathRecordValidator() {
        return this.deathRecordValidator;
    }

    public void setDeathRecordValidator(Validator deathRecordValidator) {
        this.deathRecordValidator = deathRecordValidator;
    }

    public Validator getNameValidator() {
        return this.nameValidator;
    }

    public void setNameValidator(Validator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    private boolean containsNameType(Person input, NameType type) throws ValidatorException {
        for (Name name : input.getNames()) {
            if (!type.equals((Object)name.getType())) continue;
            return true;
        }
        return false;
    }

    private NameType getLegalNameType() {
        try {
            return this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName());
        }
        catch (UnknownLookupCodeException e) {
            throw new RuntimeException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (UnknownLookupTypeException e) {
            throw new RuntimeException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected void processValidate(Object input) throws ValidatorException {
        this.validateMinimumDataProvided((Person)((Object)input));
        this.validateDependencies((Person)((Object)input));
        this.validateBirthAndDeathDates((Person)((Object)input));
    }

    private void validateMinimumDataProvided(Person input) throws ValidatorException {
        if (input.getBirthRecord() == null || input.getBirthRecord().getBirthDate() == null) {
            throw new ValidatorException("Date of Birth must be entered");
        }
        if (!this.containsNameType(input, this.getLegalNameType())) {
            throw new ValidatorException("Person must have a legal name");
        }
    }

    private void validateDependencies(Person input) throws ValidatorException {
        if (input.getBirthRecord() != null) {
            this.birthRecordValidator.validate((Object)input.getBirthRecord());
        }
        if (input.getDeathRecord() != null) {
            this.deathRecordValidator.validate((Object)input.getDeathRecord());
        }
        super.validateSet(this.nameValidator, input.getNames());
    }

    private void validateBirthAndDeathDates(Person input) throws ValidatorException {
        ImpreciseDate birthDate = input.getBirthRecord() == null ? null : input.getBirthRecord().getBirthDate();
        ImpreciseDate deathDate = input.getDeathRecord() == null ? null : input.getDeathRecord().getDeathDate();
    }
}

