/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.util;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.common.util.CommonNameHelper;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.model.lookup.NamedLookup;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CommonJspUtils {
    public static final String NULL_NA_TEXT = "not applicable";
    public static final String NULL_DEFAULT_TEXT = "";
    public static final String STANDARD_DATE_FORMAT = "MM/dd/yyyy";
    public static final String NEW_LINE = "\n";
    public static final String LINE_BREAK = "<br>";

    public static String displayValue(Object value, String nullText, String format) {
        if (value == null) {
            return nullText;
        }
        String result = null;
        if (value instanceof ImpreciseDate) {
            result = CommonJspUtils.displayDate((ImpreciseDate)value, format);
        } else if (value instanceof Date) {
            result = CommonJspUtils.displayDate((Date)value, format);
        } else if (value instanceof Boolean) {
            result = CommonJspUtils.displayBoolean((Boolean)value, format);
        } else if (value instanceof Name) {
            result = CommonJspUtils.displayName((Name)value);
        } else if (value instanceof Phone) {
            result = CommonJspUtils.displayPhone((Phone)((Object)value));
        } else if (value instanceof Email) {
            result = CommonJspUtils.displayEAddr((Email)((Object)value));
        } else if (value instanceof Address) {
            result = CommonJspUtils.displayAddress((Address)value);
        } else if (value instanceof SimpleAddress) {
            result = CommonJspUtils.displayAddress((SimpleAddress)value);
        } else if (value instanceof NamedLookup) {
            result = CommonJspUtils.displayNamedLookup((NamedLookup)value);
        } else if (value instanceof Lookup) {
            result = CommonJspUtils.displayCodedDescriptionLookup((Lookup)value);
        } else if (value instanceof SSN) {
            result = CommonJspUtils.displaySSN((SSN)((Object)value));
        } else if (value != null) {
            result = value.toString();
        }
        if (result == null) {
            result = nullText;
        }
        return result;
    }

    public static String displayValue(Object value, String nullText) {
        return CommonJspUtils.displayValue(value, nullText, null);
    }

    public static String displayValues(List values, String defText, String format) {
        StringBuffer result = new StringBuffer();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            result.append(CommonJspUtils.displayValue(i.next(), defText, format));
            result.append(i.hasNext() ? LINE_BREAK : NULL_DEFAULT_TEXT);
        }
        return result.toString();
    }

    public static String displayValues(Set values, String defText, String format) {
        return CommonJspUtils.displayValues(new ArrayList(values), defText, format);
    }

    private static String displayBoolean(Boolean value, String format) {
        String[] formats;
        String trueValue = "Yes";
        String falseValue = "No";
        if (!StringUtils.isEmpty((String)format) && (formats = format.split("/")).length == 2) {
            trueValue = formats[0];
            falseValue = formats[1];
        }
        String result = null;
        if (value != null) {
            result = value != false ? trueValue : falseValue;
        }
        return result;
    }

    public static String displayDate(ImpreciseDate value, String format) {
        return CommonJspUtils.displayDate(value, format, false);
    }

    public static String displayDate(ImpreciseDate value, String format, boolean displayTime) {
        if (displayTime) {
            return CommonDateUtils.formatForDisplayWithTime(value, format);
        }
        return CommonDateUtils.format(value, format);
    }

    public static String displayDate(Date value, String format) {
        return CommonJspUtils.displayDate(value, format, false);
    }

    public static String displayDate(Date value, String format, boolean displayTime) {
        if (displayTime) {
            return CommonDateUtils.formatWithTime(value, format);
        }
        return CommonDateUtils.format(value, format);
    }

    public static String displayName(Set value, String nameType) {
        String result = null;
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        for (Name nameTemp : value) {
            if (!nameTemp.getType().getCode().equals(nameType)) continue;
            result = CommonJspUtils.displayValue(nameTemp, NULL_DEFAULT_TEXT);
            break;
        }
        if (result == null) {
            result = CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        return result;
    }

    private static String displayName(Name value) {
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        String result = CommonNameHelper.formatNameLastNameFirst(value);
        if (StringUtils.isBlank((String)result)) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        return result;
    }

    public static String displayPhone(Set value, String phoneType) {
        String result = null;
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        for (Object contactObj : value) {
            Phone phoneTemp;
            if (!(contactObj instanceof Phone) || (phoneTemp = (Phone)((Object)contactObj)).getType() == null || !phoneTemp.getType().getCode().equals(phoneType)) continue;
            result = CommonJspUtils.displayValue((Object)phoneTemp, NULL_DEFAULT_TEXT);
            break;
        }
        if (result == null) {
            result = CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        return result;
    }

    public static String displayPhone(Phone value) {
        String result = null;
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        result = value.getPhoneNumber();
        return result;
    }

    public static String displayEAddr(Set value, String eAddrType) {
        String result = null;
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        for (Object contactObj : value) {
            Email eAddrTemp;
            if (!(contactObj instanceof Email) || (eAddrTemp = (Email)((Object)contactObj)).getType() == null || !eAddrTemp.getType().getCode().equals(eAddrType)) continue;
            result = CommonJspUtils.displayValue((Object)eAddrTemp, NULL_DEFAULT_TEXT);
            break;
        }
        if (result == null) {
            result = CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        return result;
    }

    public static String displayEAddr(Email value) {
        String result = null;
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        result = value.getAddress();
        return result;
    }

    public static String displayAddress(Set value, String addrType) {
        String result = null;
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        for (Object contactObj : value) {
            Address addrTemp;
            if (!(contactObj instanceof Address) || (addrTemp = (Address)contactObj).getType() == null || !addrTemp.getType().getCode().equals(addrType)) continue;
            result = CommonJspUtils.displayValue(addrTemp, NULL_DEFAULT_TEXT);
            break;
        }
        if (result == null) {
            result = CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        return result;
    }

    public static String displayAddress(Address value) {
        return CommonJspUtils.displayAddress((SimpleAddress)value);
    }

    public static String displayAddress(SimpleAddress value) {
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        String returnValue = value.getFormattedAddress().replaceAll(NEW_LINE, LINE_BREAK);
        if (StringUtils.isEmpty((String)returnValue)) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        return returnValue;
    }

    public static Integer parseInt(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isValidSSN(String value) {
        if (value == null || value.length() != 9) {
            return false;
        }
        try {
            Integer.parseInt(value);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String displaySSN(SSN ssn) {
        return ssn == null ? NULL_DEFAULT_TEXT : CommonJspUtils.displaySSN(ssn.getSsnText());
    }

    public static String displaySSN(String value) {
        StringBuffer result = new StringBuffer();
        if (value == null) {
            return CommonJspUtils.displayValue(null, NULL_DEFAULT_TEXT);
        }
        if (!CommonJspUtils.isValidSSN(value)) {
            return value;
        }
        int idx = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (idx >= 9 || value.charAt(i) == '-') continue;
            result.append(value.charAt(i));
            if (++idx != 3 && idx != 5) continue;
            result.append("-");
        }
        return result.toString();
    }

    private static String displayNamedLookup(NamedLookup value) {
        String result = null;
        if (value == null) {
            return null;
        }
        result = value.getDescription();
        return result;
    }

    private static String displayCodedDescriptionLookup(Lookup value) {
        String result = null;
        if (value == null) {
            return null;
        }
        result = value.getDescription();
        return result;
    }
}

