/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.Document;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.rule.data.RegistryInputData;
import gov.va.med.esr.common.rule.service.RegistryRuleService;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.LoadRegistryResult;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class RegistryRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements RegistryRuleService {
    private static final long serialVersionUID = 3584313719227829932L;
    private String manageRegistryRuleParameters = null;
    private String loadRegistryFilesRuleParameters = null;
    private String linkPersonRegistryRuleParameters = null;

    @Override
    public Registry manageRegistry(Registry incoming, Registry onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A registry must not be null for validation");
        this.doValidation(incoming);
        Registry pristineRegistry = (Registry)((Object)onFile.clone());
        RegistryType regTYpe = incoming.getRegistryTrait() != null ? incoming.getRegistryTrait().getRegistryType() : null;
        this.invokeRuleFlow(this.getRuleParameters(this.getManageRegistryRuleParameters()), (RuleDataAware)new RegistryInputData(incoming, onFile, pristineRegistry, true, regTYpe));
        return onFile;
    }

    @Override
    public Registry processRegistry(Registry incoming, Registry onFile, LoadRegistryResult result) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A registry must not be null for validation");
        Registry pristineRegistry = (Registry)((Object)onFile.clone());
        RegistryType regTYpe = incoming.getRegistryTrait() != null ? incoming.getRegistryTrait().getRegistryType() : null;
        RegistryInputData data = new RegistryInputData(incoming, onFile, pristineRegistry, false, regTYpe);
        data.setAmbiguousMatch(result.isAmbiguousMatch());
        data.setExactMatchDifferentEpisode(result.isExactMatchDifferentEpisode());
        data.setExactMatchSameEpisode(result.isExactMatchSameEpisode());
        data.setLoadRegistryResult(result);
        data.setExactMatch(result.isExactMatch());
        this.invokeRuleFlow(this.getRuleParameters(this.getLoadRegistryFilesRuleParameters()), (RuleDataAware)data);
        return onFile;
    }

    @Override
    public void linkPersonRegistry(Registry incoming, Registry onFile, Person incomingPerson, Person onFilePerson, RegistryType registryType, boolean isFromUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFilePerson), (String)"A person must not be null for validation");
        Registry pristine = onFile != null ? (Registry)((Object)onFile.clone()) : null;
        RegistryInputData inputData = new RegistryInputData(incoming, onFile, pristine, incomingPerson, onFilePerson, registryType, isFromUI);
        this.invokeRuleFlow(this.getRuleParameters(this.getLinkPersonRegistryRuleParameters()), (RuleDataAware)inputData);
    }

    private void doValidation(Registry registry) throws ServiceException {
        Set docs;
        ValidationMessages messages = new ValidationMessages();
        RuleValidationService ruleService = this.getRuleValidationService();
        ValidationMessages errors = ruleService.validateRegistry(registry, true);
        if (errors != null && !errors.isEmpty()) {
            messages.add(errors);
        }
        if ((docs = this.getDocuments(registry)) != null) {
            for (Document doc : docs) {
                errors = ruleService.validateRegistryDocument(registry, doc, true);
                if (errors == null || errors.isEmpty()) continue;
                messages.add(errors, String.valueOf(doc.hashCode()));
            }
        }
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
    }

    private Set getDocuments(Registry registry) {
        RegistryType registryType = registry.getRegistryTrait().getRegistryType();
        Set docs = null;
        if (registryType.isPurpleHeart()) {
            docs = ((PurpleHeart)registry).getDocuments();
        } else if (registryType.isPrisonerOfWar()) {
            docs = ((PrisonerOfWar)registry).getEpisodes();
        } else if (registryType.isSHAD()) {
            docs = ((SHAD)registry).getDocuments();
        }
        return docs;
    }

    public String getManageRegistryRuleParameters() {
        return this.manageRegistryRuleParameters;
    }

    public void setManageRegistryRuleParameters(String manageRegistryRuleParameters) {
        this.manageRegistryRuleParameters = manageRegistryRuleParameters;
    }

    public String getLoadRegistryFilesRuleParameters() {
        return this.loadRegistryFilesRuleParameters;
    }

    public void setLoadRegistryFilesRuleParameters(String loadRegistryFilesRuleParameters) {
        this.loadRegistryFilesRuleParameters = loadRegistryFilesRuleParameters;
    }

    public String getLinkPersonRegistryRuleParameters() {
        return this.linkPersonRegistryRuleParameters;
    }

    public void setLinkPersonRegistryRuleParameters(String linkPersonRegistryRuleParameters) {
        this.linkPersonRegistryRuleParameters = linkPersonRegistryRuleParameters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.manageRegistryRuleParameters, (String)"Manage registry parameters must not be null");
        Validate.notNull((Object)this.loadRegistryFilesRuleParameters, (String)"Load registry files parameters must not be null");
    }
}

