/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.PurpleHeartRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PurpleHeartRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements PurpleHeartRuleService {
    private static final long serialVersionUID = -8424238104146792581L;
    private String purpleHeartRuleParameters = null;
    private String managePurpleHeartRuleParameters = null;

    @Override
    public Person managePurpleHeart(Person incoming, Person onFile) throws ServiceException {
        return this.doProcessPurpleHeart(incoming, onFile, null, "UI", null);
    }

    @Override
    public Person managePurpleHeart(Person incoming, Person onFile, Clock.Type clockType) throws ServiceException {
        return this.doProcessPurpleHeart(incoming, onFile, null, "UI", clockType);
    }

    @Override
    public Person processPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo) throws ServiceException {
        return this.doProcessPurpleHeart(incoming, onFile, verificationInfo, null, null, null);
    }

    @Override
    public Person processPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo, VAFacility sendingFacility) throws ServiceException {
        return this.doProcessPurpleHeart(incoming, onFile, verificationInfo, null, null, sendingFacility);
    }

    @Override
    public Person processPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo, VAFacility sendingFacility, String caller) throws ServiceException {
        return this.doProcessPurpleHeart(incoming, onFile, verificationInfo, caller, null, sendingFacility);
    }

    public void processWorkflowPurpleHeart(PurpleHeart incoming, Person onFile) throws ServiceException {
    }

    private Person doProcessPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo, String caller, Clock.Type clockType) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if ("UI".equals(caller)) {
            this.validatePurpleHeart(incoming, true);
            PersonInputData data = new PersonInputData(incoming, onFile, pristine, true);
            data.setFiredClockType(clockType);
            this.invokeRuleFlow(this.getRuleParameters(this.getManagePurpleHeartRuleParameters()), (RuleDataAware)data);
        } else {
            this.invokeRuleFlow(this.getRuleParameters(this.getPurpleHeartRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, false, verificationInfo));
        }
        return onFile;
    }

    private Person doProcessPurpleHeart(Person incoming, Person onFile, VerificationInfo verificationInfo, String caller, Clock.Type clockType, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if ("UI".equals(caller)) {
            this.validatePurpleHeart(incoming, true);
            PersonInputData data = new PersonInputData(incoming, onFile, pristine, true);
            data.setFiredClockType(clockType);
            this.invokeRuleFlow(this.getRuleParameters(this.getManagePurpleHeartRuleParameters()), (RuleDataAware)data);
        } else {
            this.invokeRuleFlow(this.getRuleParameters(this.getPurpleHeartRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, sendingFacility, verificationInfo));
        }
        return onFile;
    }

    public String getPurpleHeartRuleParameters() {
        return this.purpleHeartRuleParameters;
    }

    public void setPurpleHeartRuleParameters(String purpleHeartRuleParameters) {
        this.purpleHeartRuleParameters = purpleHeartRuleParameters;
    }

    public String getManagePurpleHeartRuleParameters() {
        return this.managePurpleHeartRuleParameters;
    }

    public void setManagePurpleHeartRuleParameters(String managePurpleHeartRuleParameters) {
        this.managePurpleHeartRuleParameters = managePurpleHeartRuleParameters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.purpleHeartRuleParameters, (String)"purpleHeartRuleParameters property is required");
        Validate.notNull((Object)this.managePurpleHeartRuleParameters, (String)"managePurpleHeartRuleParameters property is required");
    }

    private void validatePurpleHeart(Person incoming, boolean isDataFromGUI) throws ServiceException {
        Set docs;
        PurpleHeart ph = incoming.getPurpleHeart();
        Set set = docs = ph != null ? ph.getDocuments() : null;
        if (docs != null && docs.size() > 0) {
            for (PurpleHeartDocument purpleHeartDocument : docs) {
                ValidationMessages messages = this.getRuleValidationService().validatePurpleHeartDocument(purpleHeartDocument, incoming, isDataFromGUI);
                if (messages == null || messages.isEmpty()) continue;
                throw new ValidationServiceException(messages);
            }
        }
    }
}

