/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.MilitaryServiceComponent;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.MilitaryServiceInputData;
import gov.va.med.esr.common.rule.service.MilitaryRuleService;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.MsdsResponseInfo;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MilitaryRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements MilitaryRuleService {
    private static final long serialVersionUID = -6650504748136518364L;
    private String periodOfServiceRuleParameters = null;
    private String processMilitaryRuleParameters = null;
    private String processMSDSDataRuleParameters = null;

    @Override
    public Person processMilitaryService(VAFacility sendingFacility, String dfn, MilitaryService ms, Person onFile, String caller) throws ServiceException {
        return this.doProcessMilitaryService(sendingFacility, dfn, ms, onFile, caller);
    }

    @Override
    public Person manageMilitaryService(MilitaryService ms, Person onFile) throws ServiceException {
        return this.manageMilitaryService(ms, onFile, false);
    }

    @Override
    public Person manageMilitaryService(MilitaryService ms, Person onFile, boolean isFromEE) throws ServiceException {
        return this.doManageMilitaryService(ms, onFile, isFromEE);
    }

    @Override
    public Person processVSSCData(MilitaryService ms, Person onFile, LoadVSSCDataResult loadVSSCDataResult) throws ServiceException {
        return this.doProcessVSSCData(ms, onFile, loadVSSCDataResult);
    }

    @Override
    public boolean processMSDSData(Person incoming, Person onFile, MsdsResponseInfo info) throws ServiceException {
        return this.doProcessMSDSData(incoming, onFile, "MSDSPROC", info);
    }

    @Override
    public boolean hasQualifyingMse(Person person, VerificationInfo info) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null ");
        Person pristine = this.getPristinePerson(person);
        if (person.getMilitaryService() != null) {
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(person.getMilitaryService(), person, pristine, false);
            militaryData.setUseCaseName("VBAQMSE");
            militaryData.setMilitaryService(person.getMilitaryService());
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMSDSDataRuleParameters()), (RuleDataAware)militaryData);
            info.setMsdsMessageDate(militaryData.getMsdsMessageDate());
            return militaryData.hasQmse();
        }
        return false;
    }

    @Override
    public boolean evaluateMSDSImprovement(Person incoming, Person onFile, MsdsResponseInfo info) throws ServiceException {
        return this.doProcessMSDSData(incoming, onFile, "MSDSEVAL", info);
    }

    private boolean doProcessMSDSData(Person incoming, Person onFile, String useCase, MsdsResponseInfo info) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        Validate.notNull((Object)((Object)incoming), (String)"An incoming veteran must not be null ");
        Validate.notNull((Object)useCase, (String)"Use case must be specified");
        Person pristine = this.getPristinePerson(onFile);
        if ("MSDSEVAL".equals(useCase) && onFile.getMilitaryService() != null) {
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(onFile.getMilitaryService(), onFile, pristine, true);
            militaryData.setUseCaseName(useCase);
            militaryData.setMilitaryService(onFile.getMilitaryService());
            militaryData.setImpreciseDateDetected(info.isConvertedImpreciseData());
            militaryData.setImprovedByMSDS(info.isSatisfiesUpgradeCriteria());
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMSDSDataRuleParameters()), (RuleDataAware)militaryData);
            return militaryData.isImprovedByMSDS();
        }
        if ("MSDSPROC".equals(useCase) && info != null) {
            this.applyCollisionRules(info);
            if (info.getEsrPerson() == null || info.getVadirMilitaryService() != null) {
                incoming.setMilitaryService(info.getVadirMilitaryService());
            }
            if (info.getMsdsReceivedStatus() != null && "02".equals(info.getMsdsReceivedStatus())) {
                incoming.setMilitaryService(new MilitaryService());
                MilitaryServiceInputData terminateEarly = new MilitaryServiceInputData(incoming.getMilitaryService(), onFile, pristine, true);
                terminateEarly.setUseCaseName(useCase);
                terminateEarly.setMsdsReceiveStatus(info.getMsdsReceivedStatus());
                this.invokeRuleFlow(this.getRuleParameters(this.getProcessMSDSDataRuleParameters()), (RuleDataAware)terminateEarly);
                return true;
            }
            if (this.checkIfNoData(info)) {
                incoming.setMilitaryService(new MilitaryService());
                MilitaryServiceInputData terminateEarly = new MilitaryServiceInputData(incoming.getMilitaryService(), onFile, pristine, true);
                terminateEarly.setUseCaseName(useCase);
                terminateEarly.setMsdsReceiveStatus(info.getMsdsReceivedStatus());
                terminateEarly.setNoMSDSdata(true);
                this.invokeRuleFlow(this.getRuleParameters(this.getProcessMSDSDataRuleParameters()), (RuleDataAware)terminateEarly);
                return true;
            }
            if (incoming.getMilitaryService() != null) {
                MilitaryServiceInputData militaryDataVadir = new MilitaryServiceInputData(incoming.getMilitaryService(), onFile, pristine, true);
                militaryDataVadir.setProcessQMSEflow(info.isProcessQMSEflow());
                militaryDataVadir.setHasQmse(info.isHasQmse());
                militaryDataVadir.setMsdsWorkItem(info.getMsdsWorkItem());
                militaryDataVadir.setMsdsDataSource("VADIR");
                militaryDataVadir.setMsdsReceiveStatus(info.getMsdsReceivedStatus());
                militaryDataVadir.setMsdsVadirStatus(info.getVadirError());
                militaryDataVadir.setMsdsOefOifIndicator(info.getOefoifInd());
                militaryDataVadir.setUseCaseName(useCase);
                militaryDataVadir.setMilitaryService(incoming.getMilitaryService());
                this.invokeRuleFlow(this.getRuleParameters(this.getProcessMSDSDataRuleParameters()), (RuleDataAware)militaryDataVadir);
                if (militaryDataVadir.isTerminateRuleFlow()) {
                    info.setMsdsWorkItem(militaryDataVadir.getMsdsWorkItem());
                    return militaryDataVadir.isTerminateRuleFlow();
                }
                if (militaryDataVadir.isImprovedByMSDS() || militaryDataVadir.hasQmse()) {
                    info.setSatisfiesUpgradeCriteria(true);
                }
                if (!info.isHasQmse()) {
                    info.setHasQmse(militaryDataVadir.hasQmse());
                }
                if (info.isProcessQMSEflow() && info.isHasQmse()) {
                    info.setProcessQMSEflow(false);
                }
                info.setConvertedImpreciseData(militaryDataVadir.isImpreciseData());
            }
            if (info.getEsrPerson() == null || info.getBirlsMilitaryService() != null) {
                incoming.setMilitaryService(info.getBirlsMilitaryService());
            }
            if (incoming.getMilitaryService() != null) {
                incoming.setPurpleHeart(info.getPurpleHeart());
                incoming.setMedalOfHonor(info.getMedalOfHonor());
                MilitaryServiceInputData militaryDataBirls = new MilitaryServiceInputData(incoming.getMilitaryService(), onFile, pristine, true);
                militaryDataBirls.setProcessQMSEflow(info.isProcessQMSEflow());
                militaryDataBirls.setHasQmse(info.isHasQmse());
                militaryDataBirls.setMsdsWorkItem(info.getMsdsWorkItem());
                militaryDataBirls.setMsdsDataSource("VBA");
                militaryDataBirls.setMsdsReceiveStatus(info.getMsdsReceivedStatus());
                militaryDataBirls.setMsdsBirlsStatus(info.getBirlsError());
                militaryDataBirls.setUseCaseName(useCase);
                militaryDataBirls.setMilitaryService(incoming.getMilitaryService());
                this.invokeRuleFlow(this.getRuleParameters(this.getProcessMSDSDataRuleParameters()), (RuleDataAware)militaryDataBirls);
                info.setMsdsWorkItem(militaryDataBirls.getMsdsWorkItem());
                if (militaryDataBirls.isImpreciseData()) {
                    info.setConvertedImpreciseData(militaryDataBirls.isImpreciseData());
                }
                if (militaryDataBirls.isImprovedByMSDS() || militaryDataBirls.hasQmse()) {
                    info.setSatisfiesUpgradeCriteria(true);
                }
                if (!info.isHasQmse()) {
                    info.setHasQmse(militaryDataBirls.hasQmse());
                }
                if (info.isProcessQMSEflow() && info.isHasQmse()) {
                    info.setProcessQMSEflow(false);
                }
                return militaryDataBirls.isTerminateRuleFlow();
            }
        }
        return false;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.periodOfServiceRuleParameters, (String)"periodOfServiceRuleParameters property is required");
        Validate.notNull((Object)this.processMilitaryRuleParameters, (String)"processMilitaryRuleParameters property is required");
    }

    @Override
    public Person calculatePeriodOfServiceForUI(Person incoming, Person onFile, String useCaseName) throws ServiceException {
        return this.calculatePeriodOfService(incoming, onFile, "UI", useCaseName, null);
    }

    @Override
    public Person calculatePeriodOfService(Person incoming, Person onFile, String useCaseName, VAFacility sendingFacility) throws ServiceException {
        return this.calculatePeriodOfService(incoming, onFile, null, useCaseName, sendingFacility);
    }

    private Person calculatePeriodOfService(Person incoming, Person onFile, String caller, String useCaseName, VAFacility sendingFacility) throws ServiceException {
        boolean isUpdateFromUI;
        Validate.notNull((Object)((Object)incoming), (String)"An incoming veteran must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        MilitaryService militaryService = incoming.getMilitaryService();
        Person pristine = this.getPristinePerson(onFile);
        boolean bl = isUpdateFromUI = StringUtils.equals((String)caller, (String)"UI");
        if (isUpdateFromUI) {
            this.doValidation(militaryService, onFile, pristine, "UI");
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getPeriodOfServiceRuleParameters()), (RuleDataAware)new MilitaryServiceInputData(militaryService, onFile, pristine, isUpdateFromUI, useCaseName, sendingFacility));
        return onFile;
    }

    private Person doManageMilitaryService(MilitaryService militaryService, Person onFile, boolean isFromEE) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        if (militaryService != null) {
            Person pristine = this.getPristinePerson(onFile);
            if (!isFromEE) {
                this.doValidation(militaryService, onFile, pristine, "UI");
            }
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(militaryService, onFile, pristine, true);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMilitaryRuleParameters()), (RuleDataAware)militaryData);
        } else {
            onFile.setMilitaryService(militaryService);
        }
        return onFile;
    }

    private Person doProcessMilitaryService(VAFacility sendingFacility, String dfn, MilitaryService militaryInfo, Person onFile, String caller) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        if (militaryInfo != null) {
            Person pristine = this.getPristinePerson(onFile);
            if ("UI".equals(caller)) {
                this.doValidation(militaryInfo, onFile, pristine, "UI");
            }
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(militaryInfo, onFile, pristine, false);
            militaryData.setSendingFacility(sendingFacility);
            militaryData.setDfn(dfn);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMilitaryRuleParameters()), (RuleDataAware)militaryData);
        } else {
            onFile.setMilitaryService(militaryInfo);
        }
        return onFile;
    }

    public Person doProcessVSSCData(MilitaryService ms, Person onFile, LoadVSSCDataResult loadVSSCDataResult) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        if (ms != null) {
            Person pristine = this.getPristinePerson(onFile);
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(ms, onFile, pristine, false);
            militaryData.setDataFromVSSC(true);
            militaryData.setLoadVSSCDataResult(loadVSSCDataResult);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMilitaryRuleParameters()), (RuleDataAware)militaryData);
        } else {
            onFile.setMilitaryService(ms);
        }
        return onFile;
    }

    @Override
    public void validateMilitaryService(Person incoming, Person onFile) throws ServiceException {
        ValidationMessages errors;
        Validate.notNull((Object)((Object)incoming), (String)"A veteran incoming must not be null for validation");
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null for validation");
        Person pristine = this.getPristinePerson(onFile);
        RuleValidationService ruleService = this.getRuleValidationService();
        ValidationMessages messages = new ValidationMessages();
        MilitaryService militaryService = incoming.getMilitaryService();
        if (militaryService != null && (errors = ruleService.validateMS(militaryService, onFile, pristine, true, "EE")) != null && !errors.isEmpty()) {
            messages.add(errors);
            throw new ValidationServiceException(messages);
        }
    }

    private void doValidation(MilitaryService militaryService, Person onFile, Person pristine, String caller) throws ServiceException {
        Set conflicts;
        MilitaryServiceSiteRecord record;
        Set episodes;
        Set combatEpisodes;
        Validate.notNull((Object)((Object)militaryService), (String)"Military Service for an incoming must not be null for validation.");
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null for validation.");
        RuleValidationService ruleService = this.getRuleValidationService();
        ValidationMessages messages = new ValidationMessages();
        ValidationMessages msErrors = ruleService.validateMS(militaryService, onFile, pristine, "UI".equals(caller), "MS");
        if (msErrors != null && !msErrors.isEmpty()) {
            messages.add(msErrors);
        }
        if ((combatEpisodes = militaryService.getCombatEpisodes()) != null) {
            for (CombatEpisode ce : combatEpisodes) {
                ValidationMessages errors = ruleService.validateCombatEpisode(ce, onFile, pristine, "UI".equals(caller));
                if (errors == null || errors.isEmpty()) continue;
                messages.add(errors, String.valueOf(ce.hashCode()));
            }
        }
        Set set = episodes = (record = militaryService.getHECMilitaryServiceSiteRecord()) != null ? record.getMilitaryServiceEpisodes() : null;
        if (episodes != null) {
            for (MilitaryServiceEpisode mse : episodes) {
                ValidationMessages errors = ruleService.validateMSE(mse, onFile, pristine, "UI".equals(caller));
                if (errors == null || errors.isEmpty()) continue;
                messages.add(errors, String.valueOf(mse.hashCode()));
            }
        }
        Set set2 = conflicts = record != null ? record.getConflictExperiences() : null;
        if (conflicts != null) {
            for (ConflictExperience ce : conflicts) {
                ValidationMessages errors = ruleService.validateConflictExperience(ce, onFile, pristine, "UI".equals(caller));
                if (errors == null || errors.isEmpty()) continue;
                messages.add(errors, String.valueOf(ce.hashCode()));
            }
        }
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
    }

    public String getPeriodOfServiceRuleParameters() {
        return this.periodOfServiceRuleParameters;
    }

    public void setPeriodOfServiceRuleParameters(String periodOfServiceRuleParameters) {
        this.periodOfServiceRuleParameters = periodOfServiceRuleParameters;
    }

    public String getProcessMilitaryRuleParameters() {
        return this.processMilitaryRuleParameters;
    }

    public void setProcessMilitaryRuleParameters(String processMilitaryRuleParameters) {
        this.processMilitaryRuleParameters = processMilitaryRuleParameters;
    }

    public String getProcessMSDSDataRuleParameters() {
        return this.processMSDSDataRuleParameters;
    }

    public void setProcessMSDSDataRuleParameters(String processMSDSDataRuleParameters) {
        this.processMSDSDataRuleParameters = processMSDSDataRuleParameters;
    }

    @Override
    public Person processSeedingMilitaryService(MilitaryService ms, Person onFile) throws ServiceException {
        return this.doProcessSeedingMilitaryService(ms, onFile);
    }

    private Person doProcessSeedingMilitaryService(MilitaryService militaryInfo, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        if (militaryInfo != null) {
            Person pristine = this.getPristinePerson(onFile);
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(militaryInfo, onFile, pristine, false);
            militaryData.setIsSeeding(true);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMilitaryRuleParameters()), (RuleDataAware)militaryData);
        }
        return onFile;
    }

    private void applyCollisionRules(MsdsResponseInfo info) {
        Set episodes;
        MilitaryService ms;
        MilitaryServiceSiteRecord hec;
        if (info == null) {
            return;
        }
        HashSet<MilitaryServiceEpisode> birls = new HashSet<MilitaryServiceEpisode>();
        HashSet<MilitaryServiceEpisode> vadir = new HashSet<MilitaryServiceEpisode>();
        HashSet<MilitaryServiceEpisode> vadirToRemove = new HashSet<MilitaryServiceEpisode>();
        HashSet<MilitaryServiceEpisode> birlsToRemove = new HashSet<MilitaryServiceEpisode>();
        if (info.getBirlsMilitaryService() != null && (hec = (ms = info.getBirlsMilitaryService()).getHECMilitaryServiceSiteRecord()) != null) {
            episodes = hec.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode episode : episodes) {
                birls.add(episode);
            }
        }
        if (info.getVadirMilitaryService() != null && (hec = (ms = info.getVadirMilitaryService()).getHECMilitaryServiceSiteRecord()) != null) {
            episodes = hec.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode episode : episodes) {
                vadir.add(episode);
            }
        }
        if (!vadir.isEmpty() && !birls.isEmpty()) {
            HashSet<MilitaryServiceEpisode> toAddBack;
            HashSet original;
            MilitaryService ms2;
            MilitaryServiceSiteRecord hec2;
            HashSet<MilitaryServiceEpisode> episodes2 = vadir;
            for (MilitaryServiceEpisode episode : episodes2) {
                HashSet<MilitaryServiceEpisode> birlEpisodes = birls;
                for (MilitaryServiceEpisode birlsEpisode : birlEpisodes) {
                    if (episode.getServiceBranch() == null || birlsEpisode.getServiceBranch() == null || episode.getStartDate() == null || birlsEpisode.getStartDate() == null) continue;
                    ServiceBranch vadirSb = episode.getServiceBranch();
                    ServiceBranch birlsSb = birlsEpisode.getServiceBranch();
                    ImpreciseDate vadirStart = episode.getStartDate();
                    ImpreciseDate birlsStart = birlsEpisode.getStartDate();
                    if (!vadirSb.getCode().equals(birlsSb.getCode()) || !vadirStart.equals((Object)birlsStart)) continue;
                    DischargeType vadirChar = episode.getDischargeType();
                    DischargeType birlsChar = birlsEpisode.getDischargeType();
                    Date vadirEnd = ImpreciseDateUtils.getDateWithDefault(episode.getEndDate());
                    Date birlsEnd = ImpreciseDateUtils.getDateWithDefault(birlsEpisode.getEndDate());
                    if (vadirChar == null && birlsChar == null) {
                        if (DateUtils.isEqualOrAfter((Date)vadirEnd, (Date)birlsEnd)) {
                            birlsToRemove.add(birlsEpisode);
                            continue;
                        }
                        if (!DateUtils.isEqualOrAfter((Date)birlsEnd, (Date)vadirEnd)) continue;
                        vadirToRemove.add(episode);
                        continue;
                    }
                    if (birlsChar == null && vadirChar != null) {
                        birlsToRemove.add(birlsEpisode);
                        continue;
                    }
                    if (birlsChar != null && vadirChar == null) {
                        vadirToRemove.add(episode);
                        continue;
                    }
                    if (vadirChar.getCode().equals(birlsChar.getCode()) && DateUtils.isEqualOrAfter((Date)vadirEnd, (Date)birlsEnd)) {
                        birlsToRemove.add(birlsEpisode);
                        continue;
                    }
                    if (vadirChar.getCode().equals(birlsChar.getCode()) && DateUtils.isEqualOrAfter((Date)birlsEnd, (Date)vadirEnd)) {
                        vadirToRemove.add(episode);
                        continue;
                    }
                    if (vadirChar.getCode().equals(birlsChar.getCode()) || !DateUtils.isEqualOrAfter((Date)birlsEnd, (Date)vadirEnd) || "03".equals(info.getMsdsReceivedStatus()) || "02".equals(info.getMsdsReceivedStatus())) continue;
                    info.setMsdsReceivedStatus("07");
                }
            }
            if (vadirToRemove.size() > 0 && (hec2 = (ms2 = info.getVadirMilitaryService()).getHECMilitaryServiceSiteRecord()) != null) {
                original = new HashSet(hec2.getMilitaryServiceEpisodes());
                toAddBack = new HashSet<MilitaryServiceEpisode>();
                hec2.removeAllMilitaryServiceEpisodes();
                for (MilitaryServiceEpisode episode : original) {
                    if (vadirToRemove.contains((Object)episode)) continue;
                    toAddBack.add(episode);
                }
                if (toAddBack.size() > 0) {
                    hec2.addAllMilitaryServiceEpisodes(toAddBack);
                }
            }
            if (birlsToRemove.size() > 0 && (hec2 = (ms2 = info.getBirlsMilitaryService()).getHECMilitaryServiceSiteRecord()) != null) {
                original = new HashSet(hec2.getMilitaryServiceEpisodes());
                toAddBack = new HashSet();
                hec2.removeAllMilitaryServiceEpisodes();
                for (MilitaryServiceEpisode episode : original) {
                    if (birlsToRemove.contains((Object)episode)) continue;
                    toAddBack.add(episode);
                }
                if (toAddBack.size() > 0) {
                    hec2.addAllMilitaryServiceEpisodes(toAddBack);
                }
            }
        }
    }

    @Override
    public Person processCreateHECRecord(MilitaryService ms, Person onFile) throws ServiceException {
        return this.doProcessCreateHECRecord(ms, onFile);
    }

    private Person doProcessCreateHECRecord(MilitaryService militaryInfo, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        if (militaryInfo != null) {
            Person pristine = this.getPristinePerson(onFile);
            MilitaryServiceInputData militaryData = new MilitaryServiceInputData(militaryInfo, onFile, pristine, false);
            militaryData.setIsSeeding(true);
            militaryData.setTransferToHec(true);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMilitaryRuleParameters()), (RuleDataAware)militaryData);
        }
        return onFile;
    }

    private boolean checkIfNoData(MsdsResponseInfo info) {
        Set episodes;
        MilitaryServiceSiteRecord hec;
        MilitaryService ms;
        if (info == null) {
            return true;
        }
        if (info.getBirlsMilitaryService() != null && (ms = info.getBirlsMilitaryService()) != null && (hec = ms.getHECMilitaryServiceSiteRecord()) != null && (episodes = hec.getMilitaryServiceEpisodes()) != null && episodes.size() > 0) {
            return false;
        }
        if (info.getVadirMilitaryService() != null && (ms = info.getVadirMilitaryService()) != null) {
            hec = ms.getHECMilitaryServiceSiteRecord();
            if (hec != null && (episodes = hec.getMilitaryServiceEpisodes()) != null && episodes.size() > 0) {
                return false;
            }
            Set hecActivations = ms.getActivations();
            if (hecActivations != null && hecActivations.size() > 0) {
                return false;
            }
            Set hecCombatPays = ms.getCombatServices();
            if (hecCombatPays != null && hecCombatPays.size() > 0) {
                return false;
            }
        }
        if (info.getPurpleHeart() != null && info.getPurpleHeart().getPhIndicator() != null) {
            return false;
        }
        if (info.getMedalOfHonor() != null && info.getMedalOfHonor().getMhIndicator() != null) {
            return false;
        }
        return info.getOefoifInd() == null;
    }

    @Override
    public Person processMilitaryServiceNumbers(Person onFile) throws ServiceException {
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService == null) {
            return onFile;
        }
        MilitaryServiceSiteRecord currentHECSiteRecord = currentMilitaryService.getHECMilitaryServiceSiteRecord();
        if (currentHECSiteRecord == null) {
            return onFile;
        }
        Set episodes = currentHECSiteRecord.getMilitaryServiceEpisodes();
        if (episodes == null) {
            return onFile;
        }
        for (MilitaryServiceEpisode hecMilitaryServiceEpisode : episodes) {
            if (StringUtils.isNotEmpty((String)hecMilitaryServiceEpisode.getServiceNumber())) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("MilitaryRuleServiceImpl processMilitaryServiceNumbers : ServiceNumber: " + hecMilitaryServiceEpisode.getServiceNumber()));
                continue;
            }
            MilitaryServiceEpisode matchSiteMilitaryServiceEpisode = this.findMatchingSiteEpisode(hecMilitaryServiceEpisode, onFile);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MilitaryRuleServiceImpl processMilitaryServiceNumbers : matchSiteMilitaryServiceEpisode: " + (Object)((Object)matchSiteMilitaryServiceEpisode)));
            }
            if (matchSiteMilitaryServiceEpisode == null || !StringUtils.isNotBlank((String)matchSiteMilitaryServiceEpisode.getServiceNumber())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MilitaryRuleServiceImpl processMilitaryServiceNumbers : site ServiceNumber: " + matchSiteMilitaryServiceEpisode.getServiceNumber()));
            }
            hecMilitaryServiceEpisode.setServiceNumber(matchSiteMilitaryServiceEpisode.getServiceNumber());
        }
        return onFile;
    }

    private MilitaryServiceEpisode findMatchingSiteEpisode(MilitaryServiceEpisode hecMilitaryServiceEpisode, Person onFile) {
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService == null) {
            return null;
        }
        Set siteRecords = currentMilitaryService.getMilitaryServiceSiteRecords();
        if (siteRecords == null) {
            return null;
        }
        for (MilitaryServiceSiteRecord siteRecord : siteRecords) {
            Set episodes;
            if (siteRecord.getSite() != null && siteRecord.getSite().getCode() != null && siteRecord.getSite().getCode().equals(VAFacility.CODE_HEC.getCode())) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("MilitaryRuleServiceImpl findMatchingSiteEpisode : HEC site: " + siteRecord.getSite().getCode()));
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MilitaryRuleServiceImpl findMatchingSiteEpisode : Not HEC site: " + ToStringBuilder.reflectionToString((Object)((Object)siteRecord), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
            }
            if ((episodes = siteRecord.getMilitaryServiceEpisodes()) == null) {
                return null;
            }
            for (MilitaryServiceEpisode siteMilitaryServiceEpisode : episodes) {
                if (hecMilitaryServiceEpisode == null || siteMilitaryServiceEpisode == null || !this.isMatchServiceBranch(hecMilitaryServiceEpisode.getServiceBranch(), siteMilitaryServiceEpisode.getServiceBranch()) || !this.isMatchDischargeType(hecMilitaryServiceEpisode.getDischargeType(), siteMilitaryServiceEpisode.getDischargeType()) || !this.isMatchMilitaryServiceComponent(hecMilitaryServiceEpisode.getMilitaryServiceComponent(), siteMilitaryServiceEpisode.getMilitaryServiceComponent()) || !ImpreciseDateUtils.impreciseDatesEqualWithoutTime(hecMilitaryServiceEpisode.getStartDate(), siteMilitaryServiceEpisode.getStartDate()) || !ImpreciseDateUtils.impreciseDatesEqualWithoutTime(hecMilitaryServiceEpisode.getEndDate(), siteMilitaryServiceEpisode.getEndDate())) continue;
                return siteMilitaryServiceEpisode;
            }
        }
        return null;
    }

    private boolean isMatchServiceBranch(ServiceBranch br1, ServiceBranch br2) {
        if (br1 == null && br2 == null) {
            return true;
        }
        if (br1 != null && br2 != null) {
            return br1.getCode().equals(br2.getCode());
        }
        return false;
    }

    private boolean isMatchDischargeType(DischargeType br1, DischargeType br2) {
        if (br1 == null && br2 == null) {
            return true;
        }
        if (br1 != null && br2 != null) {
            return br1.getCode().equals(br2.getCode());
        }
        return false;
    }

    private boolean isMatchMilitaryServiceComponent(MilitaryServiceComponent br1, MilitaryServiceComponent br2) {
        if (br1 == null && br2 == null) {
            return true;
        }
        if (br1 != null && br2 != null) {
            return br1.getCode().equals(br2.getCode());
        }
        return false;
    }
}

