/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.AddressInputData;
import gov.va.med.esr.common.rule.service.ContactInfoRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.FilterSitesPersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class ContactInfoRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements ContactInfoRuleService {
    private static final long serialVersionUID = 7538907746205849651L;
    private String addressRuleParameters = null;
    private String contactInfoRuleParameters = null;
    private EntityCacheManager cacheManager;
    private TriggerRouter triggerRouter = null;
    private TriggerEventCacheManager triggerEventCacheManager;
    private String handBookEventRuleParameters = null;
    private LookupService lookupService = null;

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    @Override
    public void processAddresses(Set incoming, Person onFile, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming set of addresses must not be null");
        for (Object obj : incoming) {
            if (!(obj instanceof Address)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ContactInfoRuleService processAddresses : incoming" + incoming + " onfile: " + (Object)((Object)onFile)));
            }
            this.doProcessAddress((Address)obj, onFile, this.getRuleParameters(this.getAddressRuleParameters()), sendingFacility, false, null);
        }
    }

    @Override
    public void processAddresses(Set incoming, Person onFile, VAFacility sendingFacility, VerificationInfo veriInfo) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming set of addresses must not be null");
        for (Object obj : incoming) {
            if (!(obj instanceof Address)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ContactInfoRuleService processAddresses : incoming" + incoming + " onfile: " + (Object)((Object)onFile)));
            }
            this.doProcessAddress((Address)obj, onFile, this.getRuleParameters(this.getAddressRuleParameters()), sendingFacility, false, veriInfo);
        }
    }

    @Override
    public void manageElectronicAddresses(Set emails, Person onFile) throws ServiceException {
        this.processElectronicAddresses(emails, onFile, null, "UI");
    }

    @Override
    public void processElectronicAddresses(Set emails, Person onFile, VAFacility sendingFacility) throws ServiceException {
        this.processElectronicAddresses(emails, onFile, sendingFacility, null);
    }

    private void processElectronicAddresses(Set emails, Person onFile, VAFacility sendingFacility, String caller) throws ServiceException {
        HashMap<AbstractKeyedEntity, VAFacility> updatedKeysAndSitesMap;
        boolean shouldNotifyVista;
        block12: {
            Iterator iter;
            block11: {
                Validate.notNull((Object)emails, (String)"An incoming set of electronic addresses is null");
                shouldNotifyVista = false;
                updatedKeysAndSitesMap = new HashMap<AbstractKeyedEntity, VAFacility>();
                Person pristinePerson = this.getPristinePerson(onFile);
                iter = emails.iterator();
                if (!emails.isEmpty()) break block11;
                onFile.removeAllEmails();
                if (pristinePerson.getEmails() == null || pristinePerson.getEmails().isEmpty()) break block12;
                shouldNotifyVista = true;
                if (!updatedKeysAndSitesMap.isEmpty()) break block12;
                updatedKeysAndSitesMap.put(pristinePerson, sendingFacility);
                break block12;
            }
            HashSet<Email> working = new HashSet<Email>();
            while (iter.hasNext()) {
                Email incoming = (Email)((Object)iter.next());
                Email found = (Email)this.findMatchingElement((AbstractEntity)incoming, onFile.getEmails());
                if (found != null) {
                    onFile.removeEmail(found);
                } else {
                    found = new Email();
                }
                if (!StringUtils.equals((String)incoming.getAddress(), (String)found.getAddress())) {
                    if (StringUtils.equals((String)"UI", (String)caller)) {
                        incoming.setChangeDate(this.getTransactionDate());
                        shouldNotifyVista = true;
                        if (updatedKeysAndSitesMap.isEmpty()) {
                            updatedKeysAndSitesMap.put(found, null);
                        }
                    } else if (incoming.getChangeDate() != null && (found.getChangeDate() == null || incoming.getChangeDate().after(found.getChangeDate()))) {
                        shouldNotifyVista = true;
                        if (updatedKeysAndSitesMap.isEmpty()) {
                            updatedKeysAndSitesMap.put(found, sendingFacility);
                        }
                    }
                }
                this.getMergeRuleService().mergeEmail(incoming, found);
                working.add(found);
            }
            onFile.removeAllEmails();
            for (Email updated : working) {
                onFile.addEmail(updated);
            }
        }
        if (shouldNotifyVista) {
            this.notifyVistaForContactInfo(onFile, updatedKeysAndSitesMap);
        }
    }

    private FilterSitesPersonTriggerEvent notifyVistaForContactInfo(Person person, Map updatedKeysAndSitesMap) {
        FilterSitesPersonTriggerEvent triggerEvent = new FilterSitesPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ADDRESS, updatedKeysAndSitesMap);
        triggerEvent.setPersonId(person.getPersonEntityKey());
        triggerEvent.setIdentityTraits(person.getIdentityTraits());
        triggerEvent.setEntityKeysAndSites(updatedKeysAndSitesMap);
        boolean hasAddressTriggerEvent = false;
        if (this.triggerEventCacheManager.getTriggerEvents() != null) {
            for (TriggerEvent currentEvent : this.triggerEventCacheManager.getTriggerEvents()) {
                TriggerIdentity identity = currentEvent.getTriggerIdentity();
                if (!(identity instanceof PersonTriggerIdentity) || !((PersonTriggerIdentity)identity).matchTriggerCriteria((PersonTriggerIdentity)triggerEvent.getTriggerIdentity())) continue;
                hasAddressTriggerEvent = true;
                break;
            }
        }
        if (!hasAddressTriggerEvent) {
            HashSet<FilterSitesPersonTriggerEvent> triggerEvents = new HashSet<FilterSitesPersonTriggerEvent>();
            triggerEvents.add(triggerEvent);
            this.triggerEventCacheManager.storeTriggerEvents(triggerEvents);
            return triggerEvent;
        }
        return null;
    }

    @Override
    public void managePhones(Set phones, Person onFile, boolean fromAddNewPerson) throws ServiceException {
        this.processPhones(phones, onFile, null, "UI", fromAddNewPerson, null);
    }

    @Override
    public void managePhones(Set phones, Person onFile) throws ServiceException {
        this.processPhones(phones, onFile, null, "UI", false, null);
    }

    @Override
    public void processPhones(Person incoming, Person onFile, VAFacility sendingFacility) throws ServiceException {
        this.processPhones(incoming.getPhones(), onFile, sendingFacility, null, false, incoming);
    }

    private void processPhones(Set phones, Person onFile, VAFacility sendingFacility, String caller, boolean fromAddNewPerson, Person incomingPerson) throws ServiceException {
        Person pristinePerson;
        HashMap<AbstractKeyedEntity, VAFacility> updatedKeysAndSitesMap;
        Phone oldHomePhone;
        boolean triggerZ05;
        block17: {
            Iterator iter;
            block16: {
                Validate.notNull((Object)phones, (String)"An incoming set of phones is null");
                triggerZ05 = false;
                oldHomePhone = onFile.getHomePhone();
                updatedKeysAndSitesMap = new HashMap<AbstractKeyedEntity, VAFacility>();
                pristinePerson = this.getPristinePerson(onFile);
                iter = phones.iterator();
                if (!phones.isEmpty()) break block16;
                onFile.removeAllPhones();
                if (pristinePerson.getPhones() == null || pristinePerson.getPhones().isEmpty()) break block17;
                triggerZ05 = true;
                if (!updatedKeysAndSitesMap.isEmpty()) break block17;
                updatedKeysAndSitesMap.put(pristinePerson, sendingFacility);
                break block17;
            }
            Set<Phone> working = new HashSet();
            String homePhoneCd = PhoneType.CODE_HOME.getCode();
            while (iter.hasNext()) {
                Phone incoming = (Phone)((Object)iter.next());
                Phone found = (Phone)this.findMatchingElement((AbstractEntity)incoming, onFile.getPhones());
                if (found != null) {
                    onFile.removePhone(found);
                } else {
                    found = new Phone();
                }
                if (!StringUtils.equals((String)incoming.getPhoneNumber(), (String)found.getPhoneNumber()) || !incoming.getType().equals((Object)found.getType())) {
                    if (StringUtils.equals((String)"UI", (String)caller)) {
                        incoming.setChangeDate(this.getTransactionDate());
                        triggerZ05 = true;
                        this.getMergeRuleService().mergePhone(incoming, found);
                        working.add(found);
                        if (!updatedKeysAndSitesMap.isEmpty()) continue;
                        updatedKeysAndSitesMap.put(found, sendingFacility);
                        continue;
                    }
                    String phoneCode = incoming.getType().getCode();
                    Phone pristinePhone = null;
                    pristinePhone = this.getMostRecentPhone(pristinePerson, phoneCode);
                    found = (Phone)this.findMatchingElement((AbstractEntity)pristinePhone, onFile.getPhones());
                    if (found != null) {
                        onFile.removePhone(found);
                    } else {
                        found = new Phone();
                    }
                    if (incoming.getChangeDate() != null && (found.getChangeDate() == null || incoming.getChangeDate().after(found.getChangeDate()))) {
                        triggerZ05 = true;
                        this.getMergeRuleService().mergePhone(incoming, found);
                        if (!incoming.getPhoneNumber().equals("")) {
                            working.add(found);
                        }
                        if (!updatedKeysAndSitesMap.isEmpty()) continue;
                        updatedKeysAndSitesMap.put(found, sendingFacility);
                        continue;
                    }
                    if (found.getPhoneNumber() == null) continue;
                    working.add(found);
                    continue;
                }
                working.add(found);
            }
            if (!StringUtils.equals((String)"UI", (String)caller)) {
                working = this.processRemainingPhones(pristinePerson.getPhones(), onFile, working);
            }
            onFile.removeAllPhones();
            for (Phone updated : working) {
                if (updated.getPhoneNumber() == null) continue;
                onFile.addPhone(updated);
            }
        }
        Phone newHomePhone = onFile.getHomePhone();
        if (triggerZ05) {
            FilterSitesPersonTriggerEvent evt = this.notifyVistaForContactInfo(onFile, updatedKeysAndSitesMap);
            if (!fromAddNewPerson && evt != null && (oldHomePhone == null && newHomePhone != null || oldHomePhone != null && newHomePhone == null || oldHomePhone != null && newHomePhone != null && StringUtils.equals((String)oldHomePhone.getPhoneNumber(), (String)newHomePhone.getPhoneNumber()))) {
                if (sendingFacility == null || !VAFacility.CODE_MHV.getCode().equals(sendingFacility.getCode())) {
                    ((PersonTriggerIdentity)evt.getTriggerIdentity()).setIdMAddressPhoneUpdate(true);
                }
                if (incomingPerson != null && incomingPerson.isEsrCorrelationAdded()) {
                    ((PersonTriggerIdentity)evt.getTriggerIdentity()).setIdMAddressPhoneUpdate(false);
                }
                if (!StringUtils.equals((String)"UI", (String)caller) && pristinePerson != null) {
                    evt.setOnFileIdentityTraits(pristinePerson.getIdentityTraits());
                }
            }
        }
    }

    @Override
    public void manageAddress(Address incoming, Person onFile) throws ServiceException {
        this.doProcessAddress(incoming, onFile, this.getRuleParameters(this.getContactInfoRuleParameters()), null, false, null);
    }

    @Override
    public void manageHandBookForBadAddressText(Set incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming set of addresses must not be null");
        for (Object obj : incoming) {
            if (!(obj instanceof Address)) continue;
            this.manageHandBookForBadAddressText((Address)obj, onFile);
        }
    }

    @Override
    public void manageHandBookForBadAddressText(Address incoming, Person onFile) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ContactInfoRuleService manageHandbookBadAddress : incoming" + incoming + " onfile: " + (Object)((Object)onFile)));
        }
        this.doProcessHandBookForBadAddressTxt(incoming, onFile, this.getRuleParameters(this.getHandBookEventRuleParameters()), null);
    }

    @Override
    public void manageAddresses(Set incoming, Person onFile, boolean fromAddNewPerson) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming set of addresses must not be null");
        RuleParameters parameters = this.getRuleParameters(this.getContactInfoRuleParameters());
        for (Object obj : incoming) {
            if (!(obj instanceof Address)) continue;
            this.doProcessAddress((Address)obj, onFile, parameters, null, fromAddNewPerson, null);
        }
    }

    @Override
    public void manageAddresses(Set incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming set of addresses must not be null");
        for (Object obj : incoming) {
            if (!(obj instanceof Address)) continue;
            this.manageAddress((Address)obj, onFile);
        }
    }

    @Override
    public void manageAssociationAddress(Association incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Validate.notNull((Object)incoming, (String)"An incoming association must not be null");
        Address incomingAddress = incoming.getAddress();
        Association onFileAssociation = (Association)this.findMatchingElement((AbstractEntity)incoming, onFile.getAssociations());
        this.doProcessAddress(incomingAddress, onFileAssociation, this.getRuleParameters(this.getContactInfoRuleParameters()));
    }

    @Override
    public void manageAssociationAddresses(Set associations, Person onFile) throws ServiceException {
        Validate.notNull((Object)associations, (String)"The incoming associations must not be null");
        for (Object association : associations) {
            Validate.isTrue((boolean)(association instanceof Association), (String)"An invalid association type");
            this.manageAssociationAddress((Association)association, onFile);
        }
    }

    @Override
    public void manageInsuranceAddresses(Set policies, Person onFile) throws ServiceException {
        Validate.notNull((Object)policies, (String)"The incoming insurance policies must not be null");
        for (Object policy : policies) {
            Validate.isTrue((boolean)(policy instanceof InsurancePolicy), (String)"An invalid insurance type");
            this.manageInsuranceAddress((InsurancePolicy)policy, onFile);
        }
    }

    @Override
    public void manageInsuranceAddress(InsurancePolicy incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Validate.notNull((Object)incoming, (String)"An incoming insurance policy must not be null");
        InsurancePolicy onFilePolicy = (InsurancePolicy)this.findMatchingElement((AbstractEntity)incoming, onFile.getInsurances());
        this.getMergeRuleService().mergeInsuranceAddress(incoming.getAddress(), onFilePolicy);
    }

    private void doProcessAddress(Address incoming, Person onFile, RuleParameters parameters, VAFacility sendingFacility, boolean fromAddNewPerson, VerificationInfo veriInfo) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming address must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if (incoming != null && incoming.getType() != null && !incoming.isActive()) {
            Address onFileTempAddress;
            AddressType type = incoming.getType();
            if (AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getCode().equals(type.getCode()) && (onFileTempAddress = pristine.getTemporaryCorrespondenceAddress()) == null) {
                this.logger.debug((Object)"Inactive temporary address without onfile address, so not uploading ");
                return;
            }
        }
        if (incoming != null && incoming.getCounty() == null) {
            ZipCode zipCodeObject = null;
            String incomingZipCode = incoming.getZipCode();
            if (incomingZipCode != null) {
                County countyObject;
                try {
                    zipCodeObject = this.lookupService.getPartialZipCodeByCode(incomingZipCode);
                }
                catch (Exception e) {
                    throw new RuntimeException(incomingZipCode, e);
                }
                if (zipCodeObject != null && (countyObject = zipCodeObject.getCounty()) != null) {
                    incoming.setCounty(countyObject.getName());
                }
            }
        }
        if (incoming != null && (incoming.getCountry() == null || incoming.getCountry().isEmpty())) {
            if (this.lookupService.getZipCodeByCode(incoming.getZipCode()) != null) {
                incoming.setCountry(Country.CODE_USA.getName());
            } else if (incoming.getType().getCode().equals((Object)AddressType.CODE_PERMANENT_ADDRESS)) {
                this.logger.warn((Object)("Zip Code: " + incoming.getZipCode() + " is invalid and Country Code is Empty for person address: " + onFile.getPersonEntityKey().getKeyValueAsString()));
            }
        }
        AddressInputData addressData = new AddressInputData(incoming, onFile, pristine, sendingFacility, veriInfo);
        addressData.setFromAddNewPerson(fromAddNewPerson);
        this.invokeRuleFlow(parameters, (RuleDataAware)addressData);
    }

    private void doProcessHandBookForBadAddressTxt(Address incoming, Person onFile, RuleParameters parameters, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming address must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Person pristine = this.getPristinePerson(onFile);
        AddressInputData addressData = new AddressInputData(incoming, onFile, pristine, sendingFacility);
        this.invokeRuleFlow(parameters, (RuleDataAware)addressData);
    }

    private void doProcessAddress(Address incoming, Association onFileAssociation, RuleParameters parameters) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming address must not be null ");
        Validate.notNull((Object)onFileAssociation, (String)"An association on file must not be null");
        AddressInputData addressData = new AddressInputData(incoming, onFileAssociation);
        this.invokeRuleFlow(parameters, (RuleDataAware)addressData);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    public String getAddressRuleParameters() {
        return this.addressRuleParameters;
    }

    public void setAddressRuleParameters(String addressRuleParameters) {
        this.addressRuleParameters = addressRuleParameters;
    }

    public String getContactInfoRuleParameters() {
        return this.contactInfoRuleParameters;
    }

    public void setContactInfoRuleParameters(String contactInfoRuleParameters) {
        this.contactInfoRuleParameters = contactInfoRuleParameters;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public EntityCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(EntityCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public String getHandBookEventRuleParameters() {
        return this.handBookEventRuleParameters;
    }

    public void setHandBookEventRuleParameters(String handBookEventRuleParameters) {
        this.handBookEventRuleParameters = handBookEventRuleParameters;
    }

    private Set processRemainingPhones(Set pristinePhones, Person onFile, Set working) {
        Validate.notNull((Object)pristinePhones, (String)"set of phones stored in pristinePhones is null");
        for (Phone pristinePhone : pristinePhones) {
            Phone found = (Phone)this.findMatchingElement((AbstractEntity)pristinePhone, onFile.getPhones());
            if (found == null) continue;
            onFile.removePhone(found);
            working.add(found);
        }
        return working;
    }

    private Phone getMostRecentPhone(Person pristinePerson, String phoneCode) {
        Set pristinePhones = pristinePerson.getPhones();
        Iterator iter = pristinePhones.iterator();
        Phone mostRecentPhone = new Phone();
        while (iter.hasNext()) {
            Phone pristinePhone = (Phone)((Object)iter.next());
            if (!pristinePhone.getType().getCode().equals(phoneCode) || pristinePhone.getChangeDate() == null || mostRecentPhone.getChangeDate() != null && !pristinePhone.getChangeDate().after(mostRecentPhone.getChangeDate())) continue;
            mostRecentPhone = pristinePhone;
        }
        return mostRecentPhone;
    }
}

