/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.AssociationInputData;
import gov.va.med.esr.common.rule.service.AssociationRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class AssociationRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements AssociationRuleService {
    private static final long serialVersionUID = 1879678699757403682L;
    private String associationRuleParameters = null;
    public static final String DELETE_FLAG = "DELETEFLAG";

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.associationRuleParameters, (String)"Association parameters must not be null");
    }

    @Override
    public Person manageAssociation(Association association, Person onFile) throws ServiceException {
        Validate.notNull((Object)association, (String)"Incoming association must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        this.doProcessAssociation(association, onFile, "UI", null);
        return onFile;
    }

    @Override
    public void processAssociations(Set incoming, Person onFile, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Association incomingVAGuardian = Association.getAssociationOfType(incoming, AssociationType.CODE_GUARDIAN_VA.getCode());
        if (incomingVAGuardian == null) {
            Association onFileVAGuardian = onFile.getVAGuardian();
            if (onFileVAGuardian != null) {
                onFile.removeAssociation(onFileVAGuardian);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("AssociationRuleServiceImpl processAssociations : Removed Assoication: incoming" + incoming + " onfile: " + (Object)((Object)onFile)));
            }
        }
        Association incomingNok1 = Association.getAssociationOfType(incoming, AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode());
        Association incomingNok2 = Association.getAssociationOfType(incoming, AssociationType.CODE_OTHER_NEXT_OF_KIN.getCode());
        Association incomingDesig = Association.getAssociationOfType(incoming, AssociationType.CODE_DESIGNEE.getCode());
        Association incomingEmer1 = Association.getAssociationOfType(incoming, AssociationType.CODE_EMERGENCY_CONTACT.getCode());
        Association incomingEmer2 = Association.getAssociationOfType(incoming, AssociationType.CODE_OTHER_EMERGENCY_CONTACT.getCode());
        Association onFileNok1 = Association.getAssociationOfType(onFile.getAllAssociations(), AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode());
        Association onFileNok2 = Association.getAssociationOfType(onFile.getAllAssociations(), AssociationType.CODE_OTHER_NEXT_OF_KIN.getCode());
        Association onFileDesig = Association.getAssociationOfType(onFile.getAllAssociations(), AssociationType.CODE_DESIGNEE.getCode());
        Association onFileEmer1 = Association.getAssociationOfType(onFile.getAllAssociations(), AssociationType.CODE_EMERGENCY_CONTACT.getCode());
        Association onFileEmer2 = Association.getAssociationOfType(onFile.getAllAssociations(), AssociationType.CODE_OTHER_EMERGENCY_CONTACT.getCode());
        if (incomingNok1 != null && incomingNok1.getRepresentativeName() != null && incomingNok1.getRepresentativeName().getFamilyName() != null && incomingNok1.getRepresentativeName().getFamilyName().equals(DELETE_FLAG) && onFileNok1 != null && onFileNok1.getLastUpdateDate() != null && incomingNok1.getLastUpdateDate() != null && onFileNok1.getLastUpdateDate().getTime() < incomingNok1.getLastUpdateDate().getTime()) {
            onFile.removeAssociation(onFileNok1);
        }
        if (incomingNok2 != null && incomingNok2.getRepresentativeName() != null && incomingNok2.getRepresentativeName().getFamilyName() != null && incomingNok2.getRepresentativeName().getFamilyName().equals(DELETE_FLAG) && onFileNok2 != null && onFileNok2.getLastUpdateDate() != null && incomingNok2.getLastUpdateDate() != null && onFileNok2.getLastUpdateDate().getTime() < incomingNok2.getLastUpdateDate().getTime()) {
            onFile.removeAssociation(onFileNok2);
        }
        if (incomingEmer1 != null && incomingEmer1.getRepresentativeName() != null && incomingEmer1.getRepresentativeName().getFamilyName() != null && incomingEmer1.getRepresentativeName().getFamilyName().equals(DELETE_FLAG) && onFileEmer1 != null && onFileEmer1.getLastUpdateDate() != null && incomingEmer1.getLastUpdateDate() != null && onFileEmer1.getLastUpdateDate().getTime() < incomingEmer1.getLastUpdateDate().getTime()) {
            onFile.removeAssociation(onFileEmer1);
        }
        if (incomingEmer2 != null && incomingEmer2.getRepresentativeName() != null && incomingEmer2.getRepresentativeName().getFamilyName() != null && incomingEmer2.getRepresentativeName().getFamilyName().equals(DELETE_FLAG) && onFileEmer2 != null && onFileEmer2.getLastUpdateDate() != null && incomingEmer2.getLastUpdateDate() != null && onFileEmer2.getLastUpdateDate().getTime() < incomingEmer2.getLastUpdateDate().getTime()) {
            onFile.removeAssociation(onFileEmer2);
        }
        if (incomingDesig != null && incomingDesig.getRepresentativeName() != null && incomingDesig.getRepresentativeName().getFamilyName() != null && incomingDesig.getRepresentativeName().getFamilyName().equals(DELETE_FLAG) && onFileDesig != null && onFileDesig.getLastUpdateDate() != null && incomingDesig.getLastUpdateDate() != null && onFileDesig.getLastUpdateDate().getTime() < incomingDesig.getLastUpdateDate().getTime()) {
            onFile.removeAssociation(onFileDesig);
        }
        this.doProcessAssociations(incoming, onFile, null, sendingFacility);
    }

    public String getAssociationRuleParameters() {
        return this.associationRuleParameters;
    }

    public void setAssociationRuleParameters(String associationRuleParameters) {
        this.associationRuleParameters = associationRuleParameters;
    }

    private void doProcessAssociation(Association incoming, Person onFile, String caller, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An association must not be null");
        if (incoming.getRepresentativeName() != null && incoming.getRepresentativeName().getFamilyName() != null && incoming.getRepresentativeName().getFamilyName().equals(DELETE_FLAG)) {
            return;
        }
        Person pristine = this.getPristinePerson(onFile);
        ValidationMessages messages = this.getRuleValidationService().validateAssociation(incoming, onFile, pristine, "UI".equals(caller));
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("AssociationRuleServiceImpl processAssociationRuleFlow : incoming" + incoming + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getAssociationRuleParameters()), (RuleDataAware)new AssociationInputData(incoming, onFile, pristine, "UI".equals(caller), sendingFacility));
    }

    private void doProcessAssociations(Set incoming, Person onFile, String caller, VAFacility sendingFacility) throws ServiceException {
        Iterator iter = incoming.iterator();
        while (iter.hasNext()) {
            this.doProcessAssociation((Association)iter.next(), onFile, caller, sendingFacility);
        }
    }
}

