/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.rule.UpdateMessageEventInput;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.trigger.TriggerAware;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.AfterReturningAdvice;

public class TriggerAwareParameterAdvice
extends AbstractComponent
implements AfterReturningAdvice {
    private TriggerEventCacheManager cacheManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterReturning(Object returnVal, Method method, Object[] args, Object target) throws Throwable {
        TriggerAware triggerAware = null;
        if (args != null) {
            for (int index = 0; index < args.length; ++index) {
                if (!(args[index] instanceof RuleParameters)) continue;
                RuleParameters ruleParams = (RuleParameters)args[index];
                Collection params = ruleParams.getRuleParameters().values();
                for (Object trigger : params) {
                    if (!(trigger instanceof TriggerAware)) continue;
                    TriggerAware triggerAware2 = triggerAware = (TriggerAware)trigger;
                    synchronized (triggerAware2) {
                        if (triggerAware instanceof UpdateMessageEventInput) {
                            ((UpdateMessageEventInput)triggerAware).updateMessageEvents();
                        }
                        this.cacheTriggerEvents(triggerAware.getTriggerEvents());
                        triggerAware.clearTriggerEvents();
                    }
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.cacheManager == null) {
            throw new ServiceConfigurationException("Missing required components");
        }
    }

    public TriggerEventCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(TriggerEventCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private void cacheTriggerEvents(Set triggerEvents) {
        HashSet<TriggerIdentity> triggerIdentities = new HashSet<TriggerIdentity>();
        HashSet<TriggerEvent> cacheableTriggerEvents = new HashSet<TriggerEvent>();
        if (triggerEvents == null || triggerEvents.isEmpty()) {
            return;
        }
        if (this.cacheManager.getTriggerEvents() != null) {
            for (TriggerEvent triggerEvent : this.cacheManager.getTriggerEvents()) {
                triggerIdentities.add(triggerEvent.getTriggerIdentity());
            }
        }
        if (triggerEvents != null) {
            for (TriggerEvent triggerEvent : triggerEvents) {
                if (triggerIdentities.contains(triggerEvent.getTriggerIdentity())) {
                    if (triggerEvent.getTriggerIdentity() instanceof PersonTriggerIdentity) {
                        PersonTriggerIdentity triggerIdentity = (PersonTriggerIdentity)triggerEvent.getTriggerIdentity();
                        if (!triggerIdentity.getApplicableDataTypes().contains((Object)PersonTrigger.DataType.INSURANCE)) continue;
                        cacheableTriggerEvents.add(triggerEvent);
                        continue;
                    }
                    if (!"triggerEvent.createHecRecord".equals(triggerEvent.getName())) continue;
                    cacheableTriggerEvents.add(triggerEvent);
                    continue;
                }
                triggerIdentities.add(triggerEvent.getTriggerIdentity());
                cacheableTriggerEvents.add(triggerEvent);
            }
        }
        if (!cacheableTriggerEvents.isEmpty()) {
            this.cacheManager.storeTriggerEvents(cacheableTriggerEvents);
        }
    }
}

