/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.ServiceConnectionInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ServiceConnectionInputParameter
extends BaseParameter
implements ServiceConnectionInput {
    private static final long serialVersionUID = -8383695576970070293L;
    private Integer serviceConnectedPercentage = null;
    private Date combinedSCEffectiveDate = null;
    private Boolean unemploymentIdicator = null;
    private Boolean areAACRatedDisabilitiesLessThan = null;
    private Integer combinedSCPercentageWithNoRDs = null;
    private Integer scPercentageWithNoRDs = null;
    private Boolean permanentAndTotalIndicator = null;
    private Boolean ratedIncompetentIndicator = null;

    @Override
    public ServiceConnectionAward getServiceConnectionAward() throws RuleException {
        return this.getServiceConnectionAward(this.getIncomingPerson());
    }

    @Override
    public Integer getServiceConnectedPercentage() throws RuleException {
        if (this.serviceConnectedPercentage == null) {
            this.serviceConnectedPercentage = this.getServiceConnectedPercentage(this.getIncomingPerson());
        }
        return this.serviceConnectedPercentage;
    }

    @Override
    public boolean isServiceConnectedPercentageChanged() throws RuleException {
        Integer incoming = this.getServiceConnectedPercentage();
        Integer prior = this.getServiceConnectedPercentage(this.getPristinePerson());
        if (prior == null && incoming == null) {
            return false;
        }
        return prior == null || incoming == null || prior.intValue() != incoming.intValue();
    }

    @Override
    public Boolean isUnemployable() throws RuleException {
        if (this.unemploymentIdicator == null) {
            this.unemploymentIdicator = this.getUnemploymentIndicator(this.getIncomingPerson());
        }
        return this.unemploymentIdicator;
    }

    @Override
    public boolean hasRatedDisabilityCodeBeenAdded() throws RuleException {
        Set incomingRDs = this.getRatedDisabilities(this.getIncomingPerson());
        Set currentRDs = this.getRatedDisabilities(this.getPristinePerson());
        return this.checkRatedDisabilityMembership(incomingRDs, currentRDs);
    }

    @Override
    public boolean hasRatedDisabilityCodeBeenRemoved() throws RuleException {
        Set incomingRDs = this.getRatedDisabilities(this.getIncomingPerson());
        Set currentRDs = this.getRatedDisabilities(this.getPristinePerson());
        return this.checkRatedDisabilityMembership(currentRDs, incomingRDs);
    }

    @Override
    public boolean areAACRatedDisabilitiesLessThan() throws RuleException {
        if (this.areAACRatedDisabilitiesLessThan == null) {
            Person onSitePerson = this.getIncomingPerson();
            Person onFilePerson = this.getPristinePerson();
            Set siteRatedDisabilities = this.getHelperService().getRatedDisabilities(onSitePerson);
            Set onFileRatedDisabilities = this.getHelperService().getRatedDisabilities(onFilePerson);
            boolean lessThan = (siteRatedDisabilities != null ? siteRatedDisabilities.size() : 0) < (onFileRatedDisabilities != null ? onFileRatedDisabilities.size() : 0);
            this.areAACRatedDisabilitiesLessThan = lessThan;
        }
        return this.areAACRatedDisabilitiesLessThan;
    }

    @Override
    public Integer getCombinedSCPercentageWithNoRDs() {
        if (this.combinedSCPercentageWithNoRDs == null) {
            this.combinedSCPercentageWithNoRDs = this.getServiceConnnectedPercentageWithNoRDs();
        }
        return this.combinedSCPercentageWithNoRDs;
    }

    @Override
    public Boolean getServiceConnectedIndicator() throws RuleException {
        return this.getServiceConnectedIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getPermanentAndTotalIndicator() {
        if (this.permanentAndTotalIndicator == null) {
            Boolean value = this.getPermanentAndTotalIndicator(this.getIncomingPerson());
            this.permanentAndTotalIndicator = Boolean.TRUE.equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.permanentAndTotalIndicator;
    }

    @Override
    public Boolean getPermanentAndTotalIndicator(Person person) {
        ServiceConnectionAward award = person != null ? person.getServiceConnectionAward() : null;
        Boolean ind = award != null ? award.isPermanentAndTotal() : null;
        return Boolean.TRUE.equals(ind) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean getRatedIncompetentIndicator() throws RuleException {
        if (this.ratedIncompetentIndicator == null) {
            Boolean value = this.getRatedIncompetentIndicator(this.getIncomingPerson());
            this.ratedIncompetentIndicator = Boolean.TRUE.equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.ratedIncompetentIndicator;
    }

    @Override
    public boolean hasAtleastOneInvalidDisabilityCode() {
        boolean invalid = false;
        if (this.getAacInfo() != null && this.getAacInfo().getExceptions() != null && !this.getAacInfo().getExceptions().isEmpty()) {
            for (Exception e : this.getAacInfo().getExceptions()) {
                UnknownLookupCodeException unknownCode;
                Throwable[] causes = ExceptionUtils.getThrowables((Throwable)e);
                int index = ExceptionUtils.indexOfThrowable((Throwable)e, UnknownLookupCodeException.class);
                if (causes == null || index == -1 || causes.length < index + 1 || !ClassUtils.isAssignable((Class)(unknownCode = (UnknownLookupCodeException)((Object)causes[index])).getType(), Disability.class)) continue;
                invalid = true;
                break;
            }
        }
        return invalid;
    }

    @Override
    public void setRateIncompetentIndicator(Boolean parameter) {
        IncompetenceRuling ruling = this.getResultPerson().getIncompetenceRuling();
        if (ruling == null) {
            ruling = new IncompetenceRuling();
            this.getResultPerson().setIncompetenceRuling(ruling);
        }
        ruling.setIncompetent(parameter);
    }

    @Override
    public void setServiceConnectedPercentage(Integer parm) {
        ServiceConnectionAward sca = this.getResultPerson().getServiceConnectionAward();
        if (sca != null) {
            sca.setServiceConnectedPercentage(parm);
        }
    }

    @Override
    public void setUnemploymentIndicator(Boolean parameter) {
        ServiceConnectionAward sca = this.getResultPerson().getServiceConnectionAward();
        if (sca != null) {
            sca.setUnemployable(parameter);
        }
    }

    @Override
    public Boolean getUnemploymentIndicator(Person person) throws RuleException {
        Boolean unemployment = Boolean.FALSE;
        ServiceConnectionAward award = this.getServiceConnectionAward(person);
        if (award != null && award.isUnemployable() != null) {
            unemployment = award.isUnemployable();
        }
        return unemployment;
    }

    @Override
    public void setPermanentAndTotal(Boolean parameter) {
        ServiceConnectionAward serviceConnectionAward = this.getResultPerson().getServiceConnectionAward();
        if (serviceConnectionAward != null) {
            serviceConnectionAward.setPermanentAndTotal(parameter);
        }
    }

    @Override
    public void addServiceConnectionAward() {
        ServiceConnectionAward award = this.getServiceConnectionAward(this.getResultPerson());
        if (award == null) {
            this.getResultPerson().setServiceConnectionAward(this.createServiceConnectionAward());
        }
    }

    @Override
    public void removeServiceConnectionAward() {
        ServiceConnectionAward award = this.getServiceConnectionAward(this.getResultPerson());
        if (award != null) {
            this.getResultPerson().setServiceConnectionAward(null);
        }
    }

    @Override
    public void setPermanentAndTotalEffectiveDate(Date effectiveDate) {
        ServiceConnectionAward award = this.getServiceConnectionAward(this.getResultPerson());
        if (award != null) {
            award.setPermanentAndTotalEffectiveDate(effectiveDate);
        }
    }

    @Override
    public Date getPermanentAndTotalEffectiveDate() {
        return this.getPermanentAndTotalEffectiveDate(this.getIncomingPerson());
    }

    @Override
    public Date getPermanentAndTotalEffectiveDate(Person person) {
        ServiceConnectionAward award = this.getServiceConnectionAward(person);
        return award != null ? award.getPermanentAndTotalEffectiveDate() : null;
    }

    @Override
    public Boolean getServiceConnectedIndicator(Person person) throws RuleException {
        ServiceConnectionAward award = this.getServiceConnectionAward(person);
        return award != null ? award.getServiceConnectedIndicator() : null;
    }

    @Override
    public Date getCombinedSCPercentageEffectiveDate() throws RuleException {
        if (this.combinedSCEffectiveDate == null) {
            this.combinedSCEffectiveDate = this.getCombinedSCPercentageEffectiveDate(this.getIncomingPerson());
        }
        return this.combinedSCEffectiveDate;
    }

    @Override
    public Date getCombinedSCPercentageEffectiveDate(Person person) throws RuleException {
        ServiceConnectionAward sca = this.getServiceConnectionAward(person);
        ImpreciseDate date = sca != null ? sca.getCombinedServiceConnectedPercentageEffectiveDate() : null;
        return date != null ? date.getDate() : null;
    }

    @Override
    public void setCombinedSCPercentageEffectiveDate(Date date) throws RuleException {
        ServiceConnectionAward sca = this.getServiceConnectionAward(this.getResultPerson());
        if (sca == null) {
            sca = this.createServiceConnectionAward();
            Person result = this.getResultPerson();
            result.setServiceConnectionAward(sca);
        }
        ImpreciseDate effDate = date != null ? new ImpreciseDate(date) : null;
        sca.setCombinedServiceConnectedPercentageEffectiveDate(effDate);
    }

    @Override
    public Set getRatedDisabilities(Person person) throws RuleException {
        ServiceConnectionAward sca = this.getServiceConnectionAward(person);
        return sca != null ? sca.getRatedDisabilities() : null;
    }

    @Override
    public Set getRatedDisabilities() throws RuleException {
        return this.getRatedDisabilities(this.getIncomingPerson());
    }

    private ServiceConnectionAward createServiceConnectionAward() {
        return this.createServiceConnectionAward(null);
    }

    private ServiceConnectionAward createServiceConnectionAward(Boolean serviceConnectedIndicator) {
        ServiceConnectionAward sca = new ServiceConnectionAward();
        if (serviceConnectedIndicator != null) {
            sca.setServiceConnectedIndicator(serviceConnectedIndicator);
        } else {
            sca.initDefaults();
        }
        return sca;
    }

    @Override
    public boolean hasRatedDisabilityMissingPercentageOrCode() throws RuleException {
        Set rds = this.getRatedDisabilities();
        Iterator itr = rds != null ? rds.iterator() : null;
        RatedDisability rd = null;
        while (itr != null && itr.hasNext()) {
            rd = (RatedDisability)((Object)itr.next());
            if (rd.getPercentage() != null && rd.getDisability() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRatedDisabilities(Set disabilities) throws RuleException {
        ServiceConnectionAward sca = this.getServiceConnectionAward(this.getResultPerson());
        if (sca == null) {
            sca = this.createServiceConnectionAward();
            Person result = this.getResultPerson();
            result.setServiceConnectionAward(sca);
        }
        try {
            Set updated = this.getMergeRuleService().mergeRatedDisabilitiesFromHL7(disabilities, sca.getRatedDisabilities());
            sca.removeAllRatedDisability();
            sca.addAllRatedDisability(updated);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to merge a set of rated disabilities", (Throwable)e);
        }
    }

    @Override
    public Boolean getRatedIncompetentIndicator(Person person) throws RuleException {
        return person != null && person.getIncompetenceRuling() != null ? person.getIncompetenceRuling().isIncompetent() : null;
    }

    @Override
    public Integer getServiceConnectedPercentage(Person person) throws RuleException {
        ServiceConnectionAward award = this.getServiceConnectionAward(person);
        Integer result = award != null ? award.getServiceConnectedPercentage() : null;
        this.logger.debug((Object)result);
        return result;
    }

    @Override
    public ServiceConnectionAward getServiceConnectionAward(Person person) {
        return person != null ? person.getServiceConnectionAward() : null;
    }

    private boolean checkRatedDisabilityMembership(Set a, Set b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return !a.isEmpty();
        }
        if (a.size() > b.size()) {
            return true;
        }
        for (RatedDisability ra : a) {
            Iterator iterB = b.iterator();
            boolean found = false;
            while (iterB.hasNext()) {
                RatedDisability rb = (RatedDisability)((Object)iterB.next());
                if (!this.compareRatedDisability(ra, rb)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private boolean compareRatedDisability(RatedDisability a, RatedDisability b) {
        return a == null && b == null || a != null && b != null && new EqualsBuilder().append((Object)a.getDisability(), (Object)b.getDisability()).isEquals();
    }

    private Integer getServiceConnnectedPercentageWithNoRDs() {
        if (this.scPercentageWithNoRDs == null && this.getAacInfo() != null) {
            this.scPercentageWithNoRDs = this.getAacInfo().getCombinedSCPercentage();
        }
        return this.scPercentageWithNoRDs;
    }

    @Override
    public boolean doesRatedDisabilitiesHaveReceivedCode(String code) throws RuleException {
        Set rds = this.getRatedDisabilities();
        Iterator itr = rds != null ? rds.iterator() : null;
        RatedDisability rd = null;
        while (itr != null && itr.hasNext()) {
            rd = (RatedDisability)((Object)itr.next());
            if (!rd.getDisability().getCode().equalsIgnoreCase(code)) continue;
            return true;
        }
        return false;
    }
}

