/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.rule.PersonInput;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.data.PersonSignatureInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.util.MilitaryServiceEpisodeComparator;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PersonInputParameter
extends BaseParameter
implements PersonInput {
    private static final long serialVersionUID = 1618615529888953259L;

    @Override
    public String getClaimFolderLocation() {
        return this.getClaimFolderLocation(this.getIncomingPerson());
    }

    @Override
    public String getClaimFolderNumber() {
        return this.getClaimFolderNumber(this.getIncomingPerson());
    }

    @Override
    public boolean isVeteran() {
        return this.isVeteran(this.getIncomingPerson());
    }

    @Override
    public void setClaimFolderLocation(String code) {
        block3: {
            Person result = this.getResultPerson();
            if (result != null) {
                try {
                    result.setClaimFolderLocation(this.getLookupService().getVaFacilityByCode(code));
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn((Object)("Failed to set a va facility location for a code " + code));
                }
            }
        }
    }

    @Override
    public void setClaimFolderNumber(String number) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setClaimFolderNumber(number);
        }
    }

    @Override
    public void setVeteranIndicator(Boolean setting) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setVeteran(setting);
        }
    }

    @Override
    public boolean isExistingPerson() {
        boolean enrolled = false;
        Person pristine = this.getPristinePerson();
        if (pristine != null) {
            enrolled = pristine.getEnrollmentDetermination() != null;
        }
        return enrolled;
    }

    @Override
    public Integer getUserEnrolleeValidThrough() {
        Person incoming = this.getIncomingPerson();
        return incoming != null ? incoming.getUserEnrolleeValidThrough() : null;
    }

    @Override
    public Boolean getSensitiveRecordIndicator() {
        return this.getSensitiveRecordIndicator(this.getIncomingPerson());
    }

    @Override
    public void setSensitiveRecordIndicator(Boolean flag) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setSensitiveRecord(flag);
        }
    }

    @Override
    public void setSensitiveChangeSource(String source) throws RuleException {
        Person result = this.getResultPerson();
        if (result != null) {
            try {
                result.setSensitivityChangeSource(this.getLookupService().getSensitivityChangeSourceByCode(source));
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to set a sensitivity change source ", (Throwable)e);
            }
        }
    }

    @Override
    public void setSensitiveChangeDate(Date date) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setSensitivityChangeDate(date);
        }
    }

    @Override
    public void setSensitiveChangeSite(VAFacility site) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setSensitivityChangeSite(site);
        }
    }

    @Override
    public Date getSensitiveChangeDate() {
        return this.getResultPerson().getSensitivityChangeDate();
    }

    @Override
    public VAFacility getSensitiveChangeSite() {
        return this.getResultPerson().getSensitivityChangeSite();
    }

    @Override
    public String getPristineSignatureIndicator() {
        String result;
        SignatureImage pristine = this.getMatchingSignatureImage(this.getIncomingSignatureImage(), this.getPristinePerson());
        String string = result = pristine != null && pristine.getSignatureIndicator() != null ? pristine.getSignatureIndicator().getCode() : SignatureIndicator.CODE_NO.getName();
        if (this.logger.isDebugEnabled()) {
            if (result != null) {
                this.logger.debug((Object)("Pristine signature indicator =" + result));
            } else {
                this.logger.debug((Object)"Pristine signature indicator is null");
            }
        }
        return result;
    }

    @Override
    public ArrayList getPristineSignatureList() {
        Set signatures = this.getPristinePerson().getSignatureImages();
        return new ArrayList(signatures);
    }

    @Override
    public String getSignatureIndicator() {
        String result;
        SignatureImage si = this.getIncomingSignatureImage();
        String string = result = si != null && si.getSignatureIndicator() != null ? si.getSignatureIndicator().getCode() : SignatureIndicator.CODE_NO.getName();
        if (this.logger.isDebugEnabled()) {
            if (result != null) {
                this.logger.debug((Object)("Incoming Signature indicator: " + result));
            } else {
                this.logger.debug((Object)"Incoming Signature indicator is null");
            }
        }
        return result;
    }

    @Override
    public IncomeTest getPrimaryIncomeTestForSignatureImageIncomeYear() {
        SignatureImage si = this.getIncomingSignatureImage();
        IncomeTest forYear = this.getPristinePerson().getIncomeTest(si.getIncomeYear());
        IncomeTest primaryForYear = null;
        if (forYear != null && Boolean.TRUE.equals(forYear.isPrimaryIncomeTest())) {
            primaryForYear = forYear;
        }
        return primaryForYear;
    }

    @Override
    public boolean hasPrimaryIncomeTest() {
        return this.getPrimaryTest() != null;
    }

    @Override
    public boolean hasSignatureIndicatorOfNo() {
        return this.hasSignatureIndicator(SignatureIndicator.CODE_NO.getName());
    }

    @Override
    public boolean hasSignatureIndicatorOfYes() {
        return this.hasSignatureIndicator(SignatureIndicator.CODE_YES.getName());
    }

    private boolean hasSignatureIndicator(String code) {
        Set images = this.getIncomingPerson().getSignatureImages();
        if (images != null && images.size() > 0) {
            for (SignatureImage si : images) {
                if (si.getSignatureIndicator() == null || !si.getSignatureIndicator().getCode().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPristineSignatureIndicatorCountOfYes() {
        return this.getPristineSignatureIndicatorCount(SignatureIndicator.CODE_YES.getName());
    }

    private int getPristineSignatureIndicatorCount(String code) {
        int count = 0;
        Set images = this.getPristinePerson().getSignatureImages();
        if (images != null && images.size() > 0) {
            for (SignatureImage si : images) {
                if (si.getSignatureIndicator() == null || !si.getSignatureIndicator().getCode().equals(code)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void updateSignatureInformation() throws RuleException {
        try {
            this.getMergeRuleService().mergeSignatureImage(this.getIncomingSignatureImage(), this.getResultPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to merge prisoner of war record", (Throwable)e);
        }
    }

    @Override
    public Integer getPriorUserEnrolleeValidThrough() {
        Person pristine = this.getPristinePerson();
        return pristine != null ? pristine.getUserEnrolleeValidThrough() : null;
    }

    @Override
    public Boolean getSensitiveRecordIndicator(Person person) {
        return person != null ? person.getSensitiveRecord() : Boolean.FALSE;
    }

    @Override
    public String getClaimFolderLocation(Person person) {
        VAFacility facility = person != null ? person.getClaimFolderLocation() : null;
        return facility != null ? facility.getCode() : null;
    }

    @Override
    public String getClaimFolderNumber(Person person) {
        return person != null ? person.getClaimFolderNumber() : null;
    }

    @Override
    public boolean isVeteran(Person person) {
        Boolean isVeteran = person != null ? person.isVeteran() : null;
        return isVeteran != null ? isVeteran : false;
    }

    @Override
    public void setAppointmentRequestDate(Date requestDate) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setAppointmentRequestDate(requestDate);
        }
    }

    @Override
    public void setAppointmentRequestResponse(Boolean response) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setAppointmentRequestResponse(response);
        }
    }

    private PersonSignatureInputData getPersonSignatureInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof PersonSignatureInputData) {
            return (PersonSignatureInputData)ruleDataAware;
        }
        return null;
    }

    private SignatureImage getIncomingSignatureImage() {
        return this.getPersonSignatureInputData() != null ? this.getPersonSignatureInputData().getSignatureImage() : null;
    }

    private SignatureImage getMatchingSignatureImage(SignatureImage signature, Person person) {
        SignatureImage match = null;
        if (signature != null && person != null) {
            match = (SignatureImage)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)signature, person.getSignatureImages());
        }
        return match;
    }

    @Override
    public boolean isVOAOnly() {
        return this.getPristinePerson().isVOAOnly();
    }

    @Override
    public void updateVOAIndicator() {
        String messageType = null;
        if (this.getAacInfo() != null && (messageType = this.getAacInfo().getMessageType()) != null && messageType.equals(MessageType.CODE_ORUZ07_TO_ESR.getCode())) {
            if (this.isMessageFromVista()) {
                this.getResultPerson().setVOAIndicator(null);
            } else if (this.isMessageFromVOA() && this.getPristinePerson().getVOAIndicator() == null) {
                this.getResultPerson().setVOAIndicator(null);
            }
        }
    }

    @Override
    public Boolean getDentalIndicator() {
        Person person = this.getIncomingPerson();
        return person != null ? person.getEligibleForClassIIDental() : Boolean.FALSE;
    }

    @Override
    public void setDentalIndicator(Boolean dentalIndicator) {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setEligibleForClassIIDental(dentalIndicator);
        }
    }

    @Override
    public void deleteDentalApplicationDueBeforeDate() {
        Person result = this.getResultPerson();
        if (result != null) {
            result.setClassIIDentalApplicationDueBefore(null);
        }
    }

    @Override
    public void calculateDentalApplicationDueBeforeDate() {
        Date mostRecentServiceSD = this.getMostRecentReceivedSSD();
        Person result = this.getResultPerson();
        if (mostRecentServiceSD != null) {
            mostRecentServiceSD = this.getDatePlus180Days(mostRecentServiceSD);
        }
        if (result != null) {
            result.setClassIIDentalApplicationDueBefore(mostRecentServiceSD);
        }
    }

    @Override
    public boolean isHandBookTrigger() {
        return this.getPersonInputData().getHandBookTrigger();
    }

    private Date getDatePlus180Days(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            calendar.add(5, 180);
            return calendar.getTime();
        }
        return null;
    }

    public Date getMostRecentReceivedSSD() {
        Date mostRecentSSD = null;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms != null) {
            Iterator i;
            HashSet episodes = new HashSet();
            Set records = ms.getMilitaryServiceSiteRecords();
            Iterator iterator = i = records != null ? records.iterator() : null;
            while (i != null && i.hasNext()) {
                MilitaryServiceSiteRecord site_record = (MilitaryServiceSiteRecord)((Object)i.next());
                Set site_episodes = site_record != null ? site_record.getMilitaryServiceEpisodes() : null;
                if (site_episodes == null || site_episodes.isEmpty()) continue;
                episodes.addAll(site_episodes);
            }
            MilitaryServiceEpisodeComparator comparator = new MilitaryServiceEpisodeComparator();
            if (!episodes.isEmpty()) {
                MilitaryServiceEpisode episode = (MilitaryServiceEpisode)((Object)Collections.max(episodes, comparator));
                mostRecentSSD = episode != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
            }
        }
        return mostRecentSSD;
    }

    private PersonInputData getPersonInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof PersonInputData) {
            return (PersonInputData)ruleDataAware;
        }
        return null;
    }

    @Override
    public void setVoaFormProcessPendingTrue() {
        this.getIncomingPerson().setVoaFormProcessPendingStatusTrue();
    }
}

