/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.PensionReasonCode;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.MonetaryAwardInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class MonetaryAwardInputParameter
extends BaseParameter
implements MonetaryAwardInput {
    private static final long serialVersionUID = 7206910358099240141L;
    private static final String Original_Award_Reason_Code = "0";

    @Override
    public BigDecimal getTotalCheckAmount() throws RuleException {
        return this.getTotalCheckAmount(this.getIncomingPerson());
    }

    @Override
    public void setTotalCheckAmount(BigDecimal param) {
        this.setTotalCheckAmount(param, this.getResultPerson());
    }

    @Override
    public IncompetenceRuling getVeteranRatedIncompetent() {
        return this.getPristinePerson().getIncompetenceRuling();
    }

    @Override
    public MonetaryBenefit getHouseBound() throws RuleException {
        return this.getHouseBound(this.getIncomingPerson());
    }

    @Override
    public MonetaryBenefit getHouseBound(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        return mba != null ? mba.getHouseBound() : null;
    }

    @Override
    public void addMonetaryBenefit(MonetaryBenefit benefit) throws RuleException {
        MonetaryBenefitAward mba;
        Person person = this.getResultPerson();
        MonetaryBenefitAward monetaryBenefitAward = mba = benefit != null ? person.getMonetaryBenefitAward() : null;
        if (mba != null) {
            try {
                mba.removeMonetaryBenefitByType(benefit.getType());
                MonetaryBenefit mb = new MonetaryBenefit();
                this.getMergeRuleService().mergeMonetaryBenefit(benefit, mb);
                mb.setType(benefit.getType());
                mb.setMonetaryBenefitIndicator(benefit.getMonetaryBenefitIndicator());
                mba.addMonetaryBenefit(mb);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to add a monetary benefit of type " + benefit.getType().getCode());
            }
        }
    }

    @Override
    public boolean containsMonetaryBenefits() throws RuleException {
        Person person = this.getIncomingPerson();
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        return mba != null ? mba.containsMonetaryBenefits() : false;
    }

    @Override
    public MonetaryBenefit getVADisability() throws RuleException {
        return this.getVADisability(this.getIncomingPerson());
    }

    @Override
    public MonetaryBenefit getVADisability(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        return mba != null ? mba.getDisabilityCompensation() : null;
    }

    @Override
    public MonetaryBenefit getVAPension() throws RuleException {
        return this.getVAPension(this.getIncomingPerson());
    }

    @Override
    public MonetaryBenefit getVAPension(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        return mba != null ? mba.getVAPension() : null;
    }

    @Override
    public Boolean getVAPensionIndicator() throws RuleException {
        return this.getVAPensionIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getVAPensionIndicator(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        MonetaryBenefit mb = mba != null ? mba.getVAPension() : null;
        return this.convertMBIndicatorToBoolean(mb);
    }

    @Override
    public void setVAPensionIndicator(Boolean flag) throws RuleException {
        try {
            Person updated = this.getResultPerson();
            MonetaryBenefit mb = this.getVAPension(updated);
            if (mb == null) {
                mb = this.getHelperService().addVAPension(updated);
            }
            this.setMonetaryBenefitIndicator(mb, flag);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set a VA pension indicator", (Throwable)e);
        }
    }

    @Override
    public IncompetenceRuling getRatedIncompetentOfVerifiedSite() throws RuleException {
        Person verified = this.getVerifiedSiteData();
        return verified != null ? verified.getIncompetenceRuling() : null;
    }

    @Override
    public MonetaryBenefit getAidAttendance() throws RuleException {
        return this.getAidAttendance(this.getIncomingPerson());
    }

    @Override
    public MonetaryBenefit getAidAttendance(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        return mba != null ? mba.getAidAndAttendance() : null;
    }

    @Override
    public Boolean getAidAttendanceIndicator() throws RuleException {
        return this.getAidAttendanceIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getAidAttendanceIndicator(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        MonetaryBenefit mb = mba != null ? mba.getAidAndAttendance() : null;
        return this.convertMBIndicatorToBoolean(mb);
    }

    @Override
    public void setAidAttendanceIndicator(Boolean flag) throws RuleException {
        try {
            Person updated = this.getResultPerson();
            MonetaryBenefit mb = this.getAidAttendance(updated);
            if (mb == null) {
                mb = this.getHelperService().addAABenefit(updated);
            }
            this.setMonetaryBenefitIndicator(mb, flag);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set a House bound indicator", (Throwable)e);
        }
    }

    @Override
    public Boolean getHouseBoundIndicator() throws RuleException {
        return this.getHouseBoundIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getHouseBoundIndicator(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        MonetaryBenefit mb = mba != null ? mba.getHouseBound() : null;
        return this.convertMBIndicatorToBoolean(mb);
    }

    @Override
    public void setHouseBoundIndicator(Boolean flag) throws RuleException {
        try {
            Person updated = this.getResultPerson();
            MonetaryBenefit mb = this.getHouseBound(updated);
            if (mb == null) {
                mb = this.getHelperService().addHouseboundBenefit(updated);
            }
            this.setMonetaryBenefitIndicator(mb, flag);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set a House bound indicator", (Throwable)e);
        }
    }

    @Override
    public Boolean getVADisabilityIndicator() throws RuleException {
        return this.getVADisabilityIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getVADisabilityIndicator(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        MonetaryBenefit mb = mba != null ? mba.getDisabilityCompensation() : null;
        return this.convertMBIndicatorToBoolean(mb);
    }

    @Override
    public void setVADisabilityIndicator(Boolean flag) throws RuleException {
        try {
            Person updated = this.getResultPerson();
            MonetaryBenefit mb = this.getVADisability(updated);
            if (mb == null) {
                mb = this.getHelperService().addVADisability(updated);
            }
            this.setMonetaryBenefitIndicator(mb, flag);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set a VA pension indicator", (Throwable)e);
        }
    }

    @Override
    public BigDecimal getTotalCheckAmount(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        BigDecimal result = mba != null ? mba.getCheckAmount() : BigDecimal.valueOf(0L);
        this.logger.debug((Object)result);
        return result;
    }

    private void setTotalCheckAmount(BigDecimal amount, Person person) {
        MonetaryBenefitAward monetaryBenefitAward;
        MonetaryBenefitAward monetaryBenefitAward2 = monetaryBenefitAward = person != null ? person.getMonetaryBenefitAward() : null;
        if (monetaryBenefitAward != null) {
            monetaryBenefitAward.setCheckAmount(amount);
        } else {
            monetaryBenefitAward = new MonetaryBenefitAward();
            monetaryBenefitAward.setCheckAmount(amount);
            person.setMonetaryBenefitAward(monetaryBenefitAward);
        }
    }

    private Boolean convertMBIndicatorToBoolean(MonetaryBenefit mb) {
        return mb != null && mb.getMonetaryBenefitIndicator() != null ? mb.getMonetaryBenefitIndicator().toBoolean() : null;
    }

    private void setMonetaryBenefitIndicator(MonetaryBenefit benefit, Boolean flag) throws RuleException {
        if (benefit != null) {
            try {
                Indicator.Code code = Boolean.TRUE.equals(flag) ? Indicator.YES : Indicator.NO;
                benefit.setMonetaryBenefitIndicator(this.getLookupService().getIndicatorByCode(code));
            }
            catch (Exception e) {
                throw new RuleException("Failed to set a monetary benefit indicator", (Throwable)e);
            }
        }
    }

    @Override
    public Pension getPension() throws RuleException {
        return this.getPension(this.getIncomingPerson());
    }

    private Pension getPension(Person person) throws RuleException {
        MonetaryBenefit mb = this.getVAPension(person);
        return mb != null ? mb.getPension() : null;
    }

    @Override
    public boolean getPensionStatus(Person person) throws RuleException {
        MonetaryBenefit pension;
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        MonetaryBenefit monetaryBenefit = pension = mba != null ? mba.getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION) : null;
        if (pension != null && pension.getMonetaryBenefitIndicator() != null && pension.getMonetaryBenefitIndicator().toBoolean() != null) {
            return pension.getMonetaryBenefitIndicator().toBoolean();
        }
        return false;
    }

    @Override
    public boolean isPensionStatusChanged() throws RuleException {
        boolean result = this.getPensionStatus(this.getResultPerson());
        boolean prior = this.getPensionStatus(this.getPristinePerson());
        return prior != result;
    }

    @Override
    public Date getPristinePensionAwardEffectiveDate() throws RuleException {
        return this.getPensionAwardEffectiveDate(this.getPristinePerson());
    }

    @Override
    public Date getPensionAwardEffectiveDate() throws RuleException {
        return this.getPensionAwardEffectiveDate(this.getIncomingPerson());
    }

    private Date getPensionAwardEffectiveDate(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        return pension != null ? pension.getEffectiveDate() : null;
    }

    @Override
    public Date getPensionAwardTerminationDate() throws RuleException {
        return this.getPensionAwardTerminationDate(this.getIncomingPerson());
    }

    private Date getPensionAwardTerminationDate(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        return pension != null ? pension.getTerminationDate() : null;
    }

    @Override
    public String getPensionAwardReasonCode() throws RuleException {
        return this.getPensionAwardReasonCode(this.getIncomingPerson());
    }

    private String getPensionAwardReasonCode(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        PensionReasonCode prcode = pension != null ? pension.getAwardReasonCode() : null;
        return prcode != null ? prcode.getCode() : null;
    }

    @Override
    public String getPensionAwardTerminationReasonCode1() throws RuleException {
        return this.getPensionAwardTerminationReasonCode1(this.getIncomingPerson());
    }

    private String getPensionAwardTerminationReasonCode1(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        PensionReasonCode prcode = pension != null ? pension.getTerminationReasonCode1() : null;
        return prcode != null ? prcode.getCode() : null;
    }

    @Override
    public String getPensionAwardTerminationReasonCode2() throws RuleException {
        return this.getPensionAwardTerminationReasonCode2(this.getIncomingPerson());
    }

    private String getPensionAwardTerminationReasonCode2(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        PensionReasonCode prcode = pension != null ? pension.getTerminationReasonCode2() : null;
        return prcode != null ? prcode.getCode() : null;
    }

    @Override
    public String getPensionAwardTerminationReasonCode3() throws RuleException {
        return this.getPensionAwardTerminationReasonCode3(this.getIncomingPerson());
    }

    private String getPensionAwardTerminationReasonCode3(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        PensionReasonCode prcode = pension != null ? pension.getTerminationReasonCode3() : null;
        return prcode != null ? prcode.getCode() : null;
    }

    @Override
    public String getPensionAwardTerminationReasonCode4() throws RuleException {
        return this.getPensionAwardTerminationReasonCode4(this.getIncomingPerson());
    }

    private String getPensionAwardTerminationReasonCode4(Person person) throws RuleException {
        Pension pension = this.getPension(person);
        PensionReasonCode prcode = pension != null ? pension.getTerminationReasonCode4() : null;
        return prcode != null ? prcode.getCode() : null;
    }

    @Override
    public Pension getResultPension() throws RuleException {
        try {
            Person updated = this.getResultPerson();
            MonetaryBenefit mb = this.getVAPension(updated);
            Pension pension = this.getPension(updated);
            if (mb == null) {
                mb = this.getHelperService().addVAPension(updated);
            }
            if (pension == null) {
                pension = new Pension();
                mb.setPension(pension);
            }
            return pension;
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get a pension", (Throwable)e);
        }
    }

    @Override
    public void setPensionAwardEffectiveDate(Date effDate) throws RuleException {
        this.getResultPension().setEffectiveDate(effDate);
    }

    @Override
    public void setPensionAwardTerminationDate(Date termDate) throws RuleException {
        this.getResultPension().setTerminationDate(termDate);
    }

    @Override
    public void setPensionAwardReasonCode(String awaCode) throws RuleException {
        try {
            PensionReasonCode reasonCode = null;
            if (awaCode != null) {
                reasonCode = this.getLookupService().getPensionReasonByCode(awaCode);
            }
            this.getResultPension().setAwardReasonCode(reasonCode);
        }
        catch (Exception e) {
            throw new RuleException("Failed to set a pension reason code", (Throwable)e);
        }
    }

    @Override
    public void setPensionAwardTerminationReasonCode1(String termCode) throws RuleException {
        try {
            PensionReasonCode reasonCode = null;
            if (termCode != null) {
                reasonCode = this.getLookupService().getPensionReasonByCode(termCode);
            }
            this.getResultPension().setTerminationReasonCode1(reasonCode);
        }
        catch (Exception e) {
            throw new RuleException("Failed to set a pension reason code", (Throwable)e);
        }
    }

    @Override
    public void setPensionAwardTerminationReasonCode2(String termCode) throws RuleException {
        try {
            PensionReasonCode reasonCode = null;
            if (termCode != null) {
                reasonCode = this.getLookupService().getPensionReasonByCode(termCode);
            }
            this.getResultPension().setTerminationReasonCode2(reasonCode);
        }
        catch (Exception e) {
            throw new RuleException("Failed to set a pension reason code", (Throwable)e);
        }
    }

    @Override
    public void setPensionAwardTerminationReasonCode3(String termCode) throws RuleException {
        try {
            PensionReasonCode reasonCode = null;
            if (termCode != null) {
                reasonCode = this.getLookupService().getPensionReasonByCode(termCode);
            }
            this.getResultPension().setTerminationReasonCode3(reasonCode);
        }
        catch (Exception e) {
            throw new RuleException("Failed to set a pension reason code", (Throwable)e);
        }
    }

    @Override
    public void setPensionAwardTerminationReasonCode4(String termCode) throws RuleException {
        try {
            PensionReasonCode reasonCode = null;
            if (termCode != null) {
                reasonCode = this.getLookupService().getPensionReasonByCode(termCode);
            }
            this.getResultPension().setTerminationReasonCode4(reasonCode);
        }
        catch (Exception e) {
            throw new RuleException("Failed to set a pension reason code", (Throwable)e);
        }
    }

    @Override
    public void setPensionAwardTerminationReasonCodes() throws RuleException {
        this.setPensionAwardTerminationReasonCode1(this.getPensionAwardTerminationReasonCode1());
        this.setPensionAwardTerminationReasonCode2(this.getPensionAwardTerminationReasonCode2());
        this.setPensionAwardTerminationReasonCode3(this.getPensionAwardTerminationReasonCode3());
        this.setPensionAwardTerminationReasonCode4(this.getPensionAwardTerminationReasonCode4());
    }

    @Override
    public void setPensionAwardTerminationReasonCodesToNull() throws RuleException {
        this.setPensionAwardTerminationReasonCode1(null);
        this.setPensionAwardTerminationReasonCode2(null);
        this.setPensionAwardTerminationReasonCode3(null);
        this.setPensionAwardTerminationReasonCode4(null);
    }

    @Override
    public boolean isIncomingPensionAwardEffectiveDateGreaterThanToday() throws RuleException {
        Date effDate = this.getPensionAwardEffectiveDate();
        Date today = DateUtils.getCurrentDate();
        return effDate != null && effDate.after(today);
    }

    @Override
    public boolean isIncomingPensionAwardTerminationDateGreaterThanToday() throws RuleException {
        Date termDate = this.getPensionAwardTerminationDate();
        Date today = DateUtils.getCurrentDate();
        return termDate != null && termDate.after(today);
    }

    @Override
    public boolean isPensionAwardReasonCodeEqualToZero() throws RuleException {
        String pawdCode = this.getPensionAwardReasonCode(this.getIncomingPerson());
        return pawdCode != null && Original_Award_Reason_Code.equalsIgnoreCase(pawdCode);
    }

    public boolean isDateInFuture(Date adate) {
        Date today = Calendar.getInstance().getTime();
        return this.isAfter(adate, today);
    }

    @Override
    public boolean isPensionAwardReasonCodesDiff() throws RuleException {
        String resultPenAwardCode;
        boolean diff = false;
        String incomingPenAwardCode = this.getPensionAwardReasonCode(this.getIncomingPerson());
        if (incomingPenAwardCode != (resultPenAwardCode = this.getPensionAwardReasonCode(this.getResultPerson()))) {
            diff = true;
        }
        return diff;
    }

    @Override
    public boolean isPensionAwardEffDateDiff() throws RuleException {
        boolean diff = false;
        Date incomingPenAwardCode = this.getPensionAwardEffectiveDate(this.getIncomingPerson());
        Date resultPenAwardCode = this.getPensionAwardEffectiveDate(this.getResultPerson());
        if (resultPenAwardCode.compareTo(incomingPenAwardCode) > 0 || resultPenAwardCode.compareTo(incomingPenAwardCode) == 0) {
            diff = true;
        }
        return diff;
    }

    @Override
    public Boolean isPensionAwardReasonCodeNull(Person person) throws RuleException {
        boolean isNull = false;
        String penAwardCode = this.getPensionAwardReasonCode(person);
        if (penAwardCode == null) {
            isNull = true;
        }
        return new Boolean(isNull);
    }

    @Override
    public Boolean isPensionAwardEffDateNull(Person person) throws RuleException {
        boolean isNull = false;
        Date penAwardEffDate = this.getPensionAwardEffectiveDate(person);
        if (penAwardEffDate == null) {
            isNull = true;
        }
        return new Boolean(isNull);
    }

    @Override
    public boolean getServiceIndicator() throws ServiceException {
        return super.getSystemParameterService().getVBADataSharingIndicator();
    }

    @Override
    public void pensionIndicatorReset() throws RuleException, ServiceException {
        MonetaryBenefit pensionMB = this.getVAPension(this.getIncomingPerson());
        if (this.getServiceIndicator() && pensionMB != null && this.getVAPensionIndicator() != null && Boolean.TRUE.equals(this.getVAPensionIndicator())) {
            this.setMonetaryBenefitIndicator(pensionMB, Boolean.FALSE);
            if (this.isCheckSumDueToPension()) {
                this.getIncomingPerson().getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));
            }
        }
    }

    private boolean isCheckSumDueToPension() throws RuleException {
        return !(this.getVADisabilityIndicator() != null && Boolean.TRUE.equals(this.getVADisabilityIndicator()) || this.getHouseBoundIndicator() != null && Boolean.TRUE.equals(this.getHouseBoundIndicator())) && (this.getAidAttendanceIndicator() == null || !Boolean.TRUE.equals(this.getAidAttendanceIndicator()));
    }
}

