/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.UpdateMessageEventInput;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.rule.data.FinancialInputData;
import gov.va.med.esr.common.rule.data.PersonSignatureInputData;
import gov.va.med.esr.common.rule.parameter.AbstractTriggerAwareInputParameter;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.FilterSitesPersonTriggerEvent;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PartialPersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.esr.service.trigger.TargetedPersonTriggerEvent;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MessageEventInputParameter
extends AbstractTriggerAwareInputParameter
implements UpdateMessageEventInput {
    private static final long serialVersionUID = 792324279259355480L;
    private Set updatedInsuranceEntityKeys = new HashSet();
    private Map updatedAssociationEntityKeysAndSites = new HashMap();
    private Map updatedAddressEntityKeysAndSites = new HashMap();
    private boolean sendingZ11 = false;
    private boolean z11Sent = false;
    private boolean z10Sent = false;
    private boolean fromAddNewPerson = false;
    private PersonService personService = null;
    private TriggerEventCacheManager triggerEventCacheManager;

    @Override
    public void notifyVistaForSpouseDependentsSSNValidationInfo() {
        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.FINANCIAL);
        Person person = this.getResultPerson();
        IncomeTest incomeTest = this.getHelperService().getCurrentIncomeTest(person);
        if (incomeTest != null) {
            incomeYearTriggerEvent.setIncomeYear(incomeTest.getIncomeYear());
            this.addTriggerEvent(incomeYearTriggerEvent);
        }
    }

    @Override
    public void queryMSDSforMSdata() {
        this.logger.info((Object)"Adding the msds trigger event to the queue");
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.ELIGIBILITY));
        this.logger.info((Object)"Added the msds trigger event to the queue");
    }

    @Override
    public void queryVBAForEligibility() {
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VBA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.ELIGIBILITY));
    }

    @Override
    public void respondVistaForEligibility() {
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.RESPOND, PersonTrigger.DataType.ELIGIBILITY));
    }

    @Override
    public void notifyVistaForEligibility() {
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY));
    }

    @Override
    public void queryVistaForFullData() {
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.FULL_DATA));
    }

    @Override
    public void notifyVistaForInsurance(Set updatedKeys) {
        this.addTriggerEvent(new PartialPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.INSURANCE, updatedKeys));
    }

    @Override
    public void notifyVistaForAssociation(Map updatedKeys) {
        this.addTriggerEvent(new FilterSitesPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.GUARDIAN_INFO, updatedKeys));
    }

    @Override
    public void notifyVistaForAddress(Map updatedKeys) {
        FilterSitesPersonTriggerEvent evt = new FilterSitesPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ADDRESS, updatedKeys);
        boolean updateAddrToMVI = this.isUpdateAddressToMVI();
        ((PersonTriggerIdentity)evt.getTriggerIdentity()).setIdMAddressPhoneUpdate(updateAddrToMVI);
        if (updateAddrToMVI && !this.isFromUI()) {
            evt.setOnFileIdentityTraits(this.getPristinePerson().getIdentityTraits());
        }
        boolean hasPersonTriggerEvent = false;
        evt.setPersonId(this.getPersonId());
        evt.setIdentityTraits(this.getPersonIdentityTraits());
        evt.setEntityKeysAndSites(updatedKeys);
        if (this.triggerEventCacheManager.getTriggerEvents() != null) {
            for (TriggerEvent currentEvent : this.triggerEventCacheManager.getTriggerEvents()) {
                TriggerIdentity identity = currentEvent.getTriggerIdentity();
                if (!(identity instanceof PersonTriggerIdentity) || !((PersonTriggerIdentity)identity).matchTriggerCriteria((PersonTriggerIdentity)evt.getTriggerIdentity())) continue;
                hasPersonTriggerEvent = true;
                if (((PersonTriggerIdentity)identity).isIdMAddressPhoneUpdate() || !((PersonTriggerIdentity)evt.getTriggerIdentity()).isIdMAddressPhoneUpdate()) continue;
                ((PersonTriggerIdentity)identity).setIdMAddressPhoneUpdate(true);
            }
        }
        if (!hasPersonTriggerEvent) {
            this.addTriggerEvent(evt);
        }
    }

    @Override
    public void notifyVistaForAddress() {
        PartialPersonTriggerEvent evt = new PartialPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ADDRESS);
        boolean updateAddrToMVI = this.isUpdateAddressToMVI();
        ((PersonTriggerIdentity)evt.getTriggerIdentity()).setIdMAddressPhoneUpdate(updateAddrToMVI);
        if (updateAddrToMVI && !this.isFromUI()) {
            evt.setOnFileIdentityTraits(this.getPristinePerson().getIdentityTraits());
        }
        this.addTriggerEvent(evt);
    }

    @Override
    public void notifyVistaForFinancial() {
        Integer incomeYear = this.getIncomingIncomeYear();
        if (incomeYear != null) {
            IncomeYearTriggerEvent triggerEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(incomeYear);
            this.notifyVistaForFinancial(triggerEvent);
        }
    }

    @Override
    public void notifyVistaForIVMFinancial() {
        FinancialInputData data = this.getFinancialInputData();
        if (data != null && data.getIvmFinancialInfo() != null) {
            IVMFinancialInfo info = data.getIvmFinancialInfo();
            Integer incomeYear = info.getIncomeYear();
            if (info.getIvmActionCode().equalsIgnoreCase("C")) {
                IncomeYearTriggerEvent incomeYearTriggerEvent;
                if (data.isMTConversion()) {
                    incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.MEANS_TEST);
                    incomeYearTriggerEvent.setIncomeYear(incomeYear);
                    incomeYearTriggerEvent.setActionCode(info.getIvmActionCode());
                    incomeYearTriggerEvent.setType("MT");
                    this.addTriggerEvent(incomeYearTriggerEvent);
                }
                if (data.isRXConversion()) {
                    incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.RX_TEST);
                    incomeYearTriggerEvent.setIncomeYear(incomeYear);
                    incomeYearTriggerEvent.setActionCode(info.getIvmActionCode());
                    incomeYearTriggerEvent.setType("RX");
                    this.addTriggerEvent(incomeYearTriggerEvent);
                }
            } else if (info.getIvmActionCode().equalsIgnoreCase("R")) {
                IncomeYearTriggerEvent incomeYearTriggerEvent;
                IncomeTest deletedIncomeTestCopy;
                IncomeTest deletedIncomeTest = this.getDeletedIncomeTest(incomeYear);
                IncomeTest incomeTest = deletedIncomeTestCopy = deletedIncomeTest != null ? (IncomeTest)((Object)deletedIncomeTest.clone()) : null;
                if (deletedIncomeTestCopy != null) {
                    deletedIncomeTestCopy.setPerson(null);
                    deletedIncomeTestCopy.setGmtAddress(null);
                }
                if (data.isMTReversal()) {
                    incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.MEANS_TEST);
                    incomeYearTriggerEvent.setIncomeYear(incomeYear);
                    incomeYearTriggerEvent.setDeletedIncomeTest(deletedIncomeTestCopy);
                    incomeYearTriggerEvent.setActionCode(info.getIvmActionCode());
                    incomeYearTriggerEvent.setType("MT");
                    this.addTriggerEvent(incomeYearTriggerEvent);
                }
                if (data.isRXReversal()) {
                    incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.RX_TEST);
                    incomeYearTriggerEvent.setIncomeYear(incomeYear);
                    incomeYearTriggerEvent.setDeletedIncomeTest(deletedIncomeTestCopy);
                    incomeYearTriggerEvent.setActionCode(info.getIvmActionCode());
                    incomeYearTriggerEvent.setType("RX");
                    this.addTriggerEvent(incomeYearTriggerEvent);
                }
                Integer conversionIY = info.getIncomeYear();
                Integer currentIYCloneScenarioReversal = info.getCurrentIncomeYear();
                if (conversionIY != null && currentIYCloneScenarioReversal != null) {
                    boolean send;
                    boolean bl = send = currentIYCloneScenarioReversal.compareTo(conversionIY) < 0;
                    if (send) {
                        IncomeYearTriggerEvent triggerEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(currentIYCloneScenarioReversal);
                        this.notifyVistaForFinancial(triggerEvent);
                    }
                }
            }
        }
    }

    @Override
    public void notifyVistaForFinancialByIncomeYear(Integer incomeYear) {
        if (incomeYear != null) {
            IncomeYearTriggerEvent triggerEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(incomeYear);
            this.notifyVistaForFinancial(triggerEvent);
        }
    }

    @Override
    public void notifyVistaForIncomeTestDelete() {
        IncomeTest deletedIncomeTest;
        IncomeTest deletedIncomeTestCopy;
        Integer incomeYear = null;
        FinancialInputData financialInputData = this.getFinancialInputData();
        if (financialInputData != null) {
            incomeYear = financialInputData.getIncomingIncomeYear();
        }
        IncomeTest incomeTest = deletedIncomeTestCopy = (deletedIncomeTest = this.getDeletedIncomeTest(incomeYear)) != null ? (IncomeTest)((Object)deletedIncomeTest.clone()) : null;
        if (deletedIncomeTestCopy != null) {
            deletedIncomeTestCopy.setPerson(null);
            deletedIncomeTestCopy.setGmtAddress(null);
        }
        IncomeYearTriggerEvent triggerEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(incomeYear, deletedIncomeTestCopy);
        this.notifyVistaForFinancial(triggerEvent);
    }

    private void notifyVistaForFinancial(IncomeYearTriggerEvent triggerEvent) {
        IncomeTestSource incomeTestSource = this.getIncomeTestSource(triggerEvent.getIncomeYear());
        if (incomeTestSource == null || !StringUtils.equals((String)IncomeTestSource.CODE_IVM.getCode(), (String)incomeTestSource.getCode())) {
            this.addTriggerEvent(triggerEvent);
            BaseData bd = this.getBaseData();
            if (bd != null) {
                bd.setZ10Sent(true);
            }
        }
    }

    @Override
    public void notifySendingVistaForFutureDatedTest(VAFacility facility, String dfn) {
        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.FINANCIAL);
        Person person = this.getResultPerson();
        IncomeTest futureTest = this.getHelperService().getLatestIncomeTest(person);
        if (futureTest != null) {
            incomeYearTriggerEvent.setIncomeYear(futureTest.getIncomeYear());
            incomeYearTriggerEvent.setTargetSites(this.createTargetSites(facility, dfn));
            this.addTriggerEvent(incomeYearTriggerEvent);
        }
    }

    @Override
    public void respondVistaForFinancial() {
    }

    private void notifyMVIforDateOfDeath() {
        try {
            this.getPersonService().updateProfileForDeathEvent(this.getResultPerson());
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Death Notification to MVI failed for person: " + this.getPersonId().getKeyValueAsString()), (Throwable)ex);
        }
    }

    @Override
    public void notifyVistaForDateOfDeath() {
        this.notifyMVIforDateOfDeath();
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.DATE_OF_DEATH));
    }

    @Override
    public void notifyVistaForDateOfDeath(VAFacility sendingFacility) {
        this.notifyMVIforDateOfDeath();
        TargetedPersonTriggerEvent triggerEvent = new TargetedPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.DATE_OF_DEATH);
        HashSet<VAFacility> sites = new HashSet<VAFacility>();
        sites.add(sendingFacility);
        triggerEvent.setFilterSites(sites);
        this.addTriggerEvent(triggerEvent);
    }

    @Override
    public void addUpdatedInsuranceEntityKeys(EntityKey key) {
        if (key != null) {
            this.updatedInsuranceEntityKeys.add(key);
        }
    }

    @Override
    public void addUpdatedInsuranceEntityKeys(AbstractEntity entity) {
        this.updatedInsuranceEntityKeys.add(entity);
    }

    @Override
    public void addUpdatedAssociationEntityKeys(EntityKey key) {
        if (key != null) {
            this.updatedAssociationEntityKeysAndSites.put(key, null);
        }
    }

    @Override
    public void addUpdatedAssociationEntityKeys(AbstractEntity entity) {
        if (entity != null) {
            this.updatedAssociationEntityKeysAndSites.put(entity, null);
        }
    }

    @Override
    public void addUpdatedAssociationEntityKeys(AbstractEntity entity, VAFacility sendingFacility) {
        if (entity != null) {
            this.updatedAssociationEntityKeysAndSites.put(entity, sendingFacility);
        }
    }

    @Override
    public void addDeferredAddressEntityKeys() {
        Set addresses = this.getResultPerson().getAddresses();
        for (Address adr : addresses) {
            this.addUpdatedAddressEntityKeys(adr.getEntityKey());
        }
    }

    @Override
    public void addDeferredAddressEntityKeysForMessaging() {
        Set addresses = this.getResultPerson().getAddresses();
        for (Address adr : addresses) {
            if (!this.updatedAddressEntityKeysAndSites.isEmpty()) continue;
            this.addUpdatedAddressEntityKeys(adr.getEntityKey());
        }
    }

    @Override
    public void addUpdatedAddressEntityKeys(EntityKey key) {
        if (key != null) {
            this.updatedAddressEntityKeysAndSites.put(key, null);
        }
    }

    @Override
    public void addUpdatedAddressEntityKeys(EntityKey key, VAFacility sendingFacility) {
        if (key != null) {
            this.updatedAddressEntityKeysAndSites.put(key, sendingFacility);
        }
    }

    private boolean isUpdateAddressToMVI() {
        if (this.getBaseData().isFromAddNewPerson() || this.getSendingFacility() != null && VAFacility.CODE_MHV.getCode().equals(this.getSendingFacility().getCode()) || this.getIncomingPerson().isEsrCorrelationAdded()) {
            return false;
        }
        Address newAddr = this.getResultPerson().getPermanentAddress();
        Address oldAddr = this.getPristinePerson().getPermanentAddress();
        if (newAddr == null && oldAddr == null) {
            return false;
        }
        return newAddr == null || oldAddr == null || !this.isEqual(newAddr.getLine1(), oldAddr.getLine1()) || !this.isEqual(newAddr.getLine2(), oldAddr.getLine2()) || !this.isEqual(newAddr.getLine3(), oldAddr.getLine3()) || !this.isEqual(newAddr.getCity(), oldAddr.getCity()) || !this.isEqual(newAddr.getState(), oldAddr.getState()) || !this.isEqual(newAddr.getZipCode(), oldAddr.getZipCode()) || !this.isEqual(newAddr.getCountry(), oldAddr.getCountry()) || !this.isEqual((Object)newAddr.getBadAddressReason(), (Object)oldAddr.getBadAddressReason());
    }

    @Override
    public void notifyVistaForAddress(VAFacility facility, String dfn) {
        HashSet<VAFacility> sites = new HashSet<VAFacility>();
        TargetedPersonTriggerEvent targetedPersonTriggerEvent = new TargetedPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ADDRESS);
        sites.add(facility);
        targetedPersonTriggerEvent.setTargetSites(this.createTargetSites(facility, dfn));
        boolean updateAddrToMVI = this.isUpdateAddressToMVI();
        ((PersonTriggerIdentity)targetedPersonTriggerEvent.getTriggerIdentity()).setIdMAddressPhoneUpdate(updateAddrToMVI);
        if (updateAddrToMVI && !this.isFromUI()) {
            targetedPersonTriggerEvent.setOnFileIdentityTraits(this.getPristinePerson().getIdentityTraits());
        }
        this.addTriggerEvent(targetedPersonTriggerEvent);
    }

    @Override
    public void updateMessageEvents() {
        if (!this.updatedAddressEntityKeysAndSites.isEmpty()) {
            HashMap updatedAddressKeysAndSites = new HashMap();
            updatedAddressKeysAndSites.putAll(this.updatedAddressEntityKeysAndSites);
            this.notifyVistaForAddress(updatedAddressKeysAndSites);
            this.updatedAddressEntityKeysAndSites.clear();
        }
        if (!this.updatedInsuranceEntityKeys.isEmpty()) {
            if (this.isFromUI()) {
                HashSet updatedInsuranceKeys = new HashSet();
                updatedInsuranceKeys.addAll(this.updatedInsuranceEntityKeys);
                this.notifyVistaForInsurance(updatedInsuranceKeys);
            }
            this.updatedInsuranceEntityKeys.clear();
        }
        if (!this.updatedAssociationEntityKeysAndSites.isEmpty()) {
            RuleDataAware data = this.getRuleDataAware();
            if (data instanceof BaseData) {
                HashMap updatedAssociationKeysWithSites = new HashMap();
                updatedAssociationKeysWithSites.putAll(this.updatedAssociationEntityKeysAndSites);
                this.notifyVistaForAssociation(updatedAssociationKeysWithSites);
            }
            this.updatedAssociationEntityKeysAndSites.clear();
        }
    }

    @Override
    public void notifyVistaForSignatureInformation() {
        HashSet<VAFacility> sites = new HashSet<VAFacility>();
        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.MEANS_TEST);
        sites.add(this.getPrimaryFinancialAssessmentSite());
        incomeYearTriggerEvent.setIncomeYear(this.getIncomingIncomeYear());
        incomeYearTriggerEvent.setTargetSites(sites);
        this.addTriggerEvent(incomeYearTriggerEvent);
    }

    @Override
    public void notifyVistaForFinancialExceptPrimary() {
        HashSet<VAFacility> sites = new HashSet<VAFacility>();
        IncomeYearTriggerEvent triggerEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(this.getIncomingIncomeYear());
        sites.add(this.getPrimaryFinancialAssessmentSite());
        triggerEvent.setFilterSites(sites);
        this.addTriggerEvent(triggerEvent);
        BaseData bd = this.getBaseData();
        if (bd != null) {
            bd.setZ10Sent(true);
        }
    }

    @Override
    public void generateORFZ10(VAFacility facility, String dfn, Integer incomeYear) {
        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.RESPOND, PersonTrigger.DataType.FINANCIAL);
        incomeYearTriggerEvent.setIncomeYear(incomeYear);
        incomeYearTriggerEvent.setIncomingMessageInfo(this.getIncomingMessageInfo());
        incomeYearTriggerEvent.setTargetSites(this.createTargetSites(facility, dfn));
        this.addTriggerEvent(incomeYearTriggerEvent);
    }

    @Override
    public void generateORFZ11(VAFacility facility, String dfn) {
        TargetedPersonTriggerEvent targetedPersonTriggerEvent = new TargetedPersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.RESPOND, PersonTrigger.DataType.ELIGIBILITY);
        targetedPersonTriggerEvent.setTargetSites(this.createTargetSites(facility, dfn));
        targetedPersonTriggerEvent.setIncomingMessageInfo(this.getIncomingMessageInfo());
        this.addTriggerEvent(targetedPersonTriggerEvent);
    }

    private Set createTargetSites(VAFacility facility, String dfn) {
        HashSet<Object> sites = new HashSet<Object>();
        if (dfn != null) {
            SiteIdentity siteIdentity = new SiteIdentity();
            siteIdentity.setVaFacility(facility);
            siteIdentity.setDfn(dfn);
            sites.add((Object)siteIdentity);
        } else {
            sites.add((Object)facility);
        }
        return sites;
    }

    @Override
    public void triggerMFNZEGMessage() {
    }

    private IncomingMessageInfo getIncomingMessageInfo() {
        if (this.getRuleDataAware() instanceof EventInputData) {
            return ((EventInputData)this.getRuleDataAware()).getIncomingMessageInfo();
        }
        return null;
    }

    private FinancialInputData getFinancialInputData() {
        if (this.getRuleDataAware() instanceof FinancialInputData) {
            return (FinancialInputData)this.getRuleDataAware();
        }
        return null;
    }

    private Integer getIncomingIncomeYear() {
        IncomeTest primary;
        if (this.getPersonSignatureInputData() != null) {
            Integer year;
            Integer n = year = this.getPersonSignatureInputData().getSignatureImage() != null ? this.getPersonSignatureInputData().getSignatureImage().getIncomeYear() : null;
            if (year != null) {
                return year;
            }
        }
        return (primary = this.getOnFilePrimaryTest()) != null ? primary.getIncomeYear() : null;
    }

    public IncomeTest getOnFilePrimaryTest() {
        return this.getHelperService().getCurrentIncomeTest(this.getResultPerson());
    }

    private IncomeTest getDeletedIncomeTest(Integer incomeYear) {
        FinancialInputData financialInputData = this.getFinancialInputData();
        if (financialInputData != null && incomeYear != null) {
            Person person = (Person)financialInputData.getPristineData();
            return person.getIncomeTest(incomeYear);
        }
        return null;
    }

    private IncomeTestSource getIncomeTestSource(Integer incomeYesr) {
        Person person = this.getIncomingPerson();
        IncomeTest incomeTest = person.getIncomeTest(incomeYesr);
        return incomeTest == null ? null : incomeTest.getSource();
    }

    private VAFacility getPrimaryFinancialAssessmentSite() {
        IncomeTest primary = this.getPrimaryTest();
        return primary != null ? primary.getSiteConductingTest() : null;
    }

    private PersonSignatureInputData getPersonSignatureInputData() {
        if (this.getRuleDataAware() instanceof PersonSignatureInputData) {
            return (PersonSignatureInputData)this.getRuleDataAware();
        }
        return null;
    }

    @Override
    public boolean isMFKZEGRecievedForCurrentEGT() {
        return false;
    }

    @Override
    public boolean isZ10Sent() {
        BaseData bd = this.getBaseData();
        return bd != null ? bd.isZ10Sent() : false;
    }

    @Override
    public boolean isSendingZ11() {
        return this.sendingZ11;
    }

    @Override
    public void setSendingZ11(boolean sendingZ11) {
        this.sendingZ11 = sendingZ11;
    }

    @Override
    public boolean isZ11Sent() {
        return this.z11Sent;
    }

    @Override
    public void setZ11Sent(boolean z11Sent) {
        this.z11Sent = z11Sent;
    }

    @Override
    public void sendVOAFinalStatusToMHV() {
        this.addTriggerEvent(new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.MHV, CommonTrigger.DispatchType.RESPOND, PersonTrigger.DataType.VOA));
    }

    @Override
    public boolean getQueryMSDSIndicator() {
        return this.getEventInputData().isTriggerMSDSBroker();
    }

    @Override
    public boolean isValidQueryInfo() {
        if (this.passedNullValidation()) {
            return !this.invalidQuery();
        }
        return false;
    }

    private boolean invalidQuery() {
        return this.getIncomingPerson().getIdentityTraits().getLegalName().getGivenName() == null || this.getIncomingPerson().getIdentityTraits().getLegalName().getGivenName().length() == 0 || this.getIncomingPerson().getIdentityTraits().getLegalName().getGivenName().trim().length() == 0 || this.getIncomingPerson().getIdentityTraits().getSsnText() == null || this.getIncomingPerson().getIdentityTraits().getSsnText().length() == 0 || this.getIncomingPerson().getIdentityTraits().getSsnText().trim().length() == 0 || this.getIncomingPerson().getIdentityTraits().getLegalName().getFamilyName() == null || this.getIncomingPerson().getIdentityTraits().getLegalName().getFamilyName().length() == 0 || this.getIncomingPerson().getIdentityTraits().getLegalName().getFamilyName().trim().length() == 0 || this.getIncomingPerson().getIdentityTraits().getBirthRecord().getBirthDate() == null;
    }

    public boolean passedNullValidation() {
        return this.getIncomingPerson().getIdentityTraits() != null && this.getIncomingPerson().getIdentityTraits().getLegalName() != null && this.getIncomingPerson().getBirthRecord() != null;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    private boolean isFromUI() {
        RuleDataAware data = this.getRuleDataAware();
        return data instanceof BaseData && ((BaseData)data).isDataFromGUI();
    }

    @Override
    public boolean isTempAddressUpdateRecent() {
        return this.getEventInputData().getVerificationInfo().isTempAddressUpdateMoreRecent();
    }
}

