/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.rule.DependentFinancialInput;
import gov.va.med.esr.common.rule.data.DependentFinancialsInputData;
import gov.va.med.esr.common.rule.parameter.AbstractFinancialInputParameter;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;

public class DependentFinancialInputParameter
extends AbstractFinancialInputParameter
implements DependentFinancialInput {
    private static final long serialVersionUID = 4164075105209388639L;

    @Override
    public boolean isDemographicUpdate() {
        return this.getDependentFinancialsInputData() != null ? this.getDependentFinancialsInputData().isDemographicUpdate() : false;
    }

    @Override
    public BigDecimal getAssetAmount(AssetType.Code expenseType) {
        BigDecimal amount = this.getAssetAmount(this.getDependentFinancials(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getIncomeAmount(IncomeType.Code expenseType) {
        BigDecimal amount = this.getIncomeAmount(this.getDependentFinancials(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getExpenseAmount(ExpenseType.Code expenseType) {
        BigDecimal amount = this.getExpenseAmount(this.getDependentFinancials(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public String getDependentGivenName() {
        String givenName = this.getRelationGivenName(this.getDependent());
        return StringUtils.isNotEmpty((String)givenName) ? givenName : null;
    }

    @Override
    public String getDependentFamilyName() {
        String familyName = this.getRelationFamilyName(this.getDependent());
        return StringUtils.isNotEmpty((String)familyName) ? familyName : null;
    }

    @Override
    public Date getChildDependentEffective() {
        return this.getDependentEffectiveDate();
    }

    @Override
    public String getDependentSSN() {
        return this.getRelationSSN(this.getDependent());
    }

    @Override
    public boolean isDependentSSNUsed() {
        return this.isRelationSSNUsed(this.getDependentFinancials());
    }

    @Override
    public Date getDependentEffectiveDate() {
        return this.getRelationEffectiveDate(this.getDependent());
    }

    @Override
    public Date getDependentInactiveDate() {
        return this.getRelationInActiveDate(this.getDependent());
    }

    @Override
    public String getDependentRelationship() {
        Relationship relationship = this.getDependent() != null ? this.getDependent().getRelationship() : null;
        return relationship != null ? relationship.getCode() : null;
    }

    @Override
    public BigDecimal getChildSupportContributionAmount() {
        DependentFinancials depFin = this.getDependentFinancials();
        return depFin != null && depFin.getAmountContributedToSupport() != null ? depFin.getAmountContributedToSupport() : new BigDecimal(0.0);
    }

    @Override
    public Boolean getHasIncomeIndicator() {
        DependentFinancials depFin = this.getDependentFinancials();
        return depFin != null ? depFin.getHasIncome() : null;
    }

    @Override
    public Boolean getIncomeAvailableToVeteranIndicator() {
        DependentFinancials depFin = this.getDependentFinancials();
        return depFin != null ? depFin.getIncomeAvailableToPatient() : null;
    }

    @Override
    public boolean isDependentHasAnyIncomeAmount() {
        Collection incomes;
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        Collection collection = incomes = dependentFinancials != null && dependentFinancials.getIncome() != null ? dependentFinancials.getIncome().values() : null;
        if (incomes != null && !incomes.isEmpty()) {
            for (Income income : incomes) {
                double d = income != null && income.getAmount() != null ? income.getAmount().doubleValue() : 0.0;
                double amount = d;
                if (!(amount > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDependentHasAnyExpenseAmount() {
        Collection expenses;
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        Collection collection = expenses = dependentFinancials != null && dependentFinancials.getExpenses() != null ? dependentFinancials.getExpenses().values() : null;
        if (expenses != null && !expenses.isEmpty()) {
            for (Expense expense : expenses) {
                double d = expense != null && expense.getAmount() != null ? expense.getAmount().doubleValue() : 0.0;
                double amount = d;
                if (!(amount > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDependentHasAnyAssetAmount() {
        Collection assets;
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        Collection collection = assets = dependentFinancials != null && dependentFinancials.getAssets() != null ? dependentFinancials.getAssets().values() : null;
        if (assets != null && !assets.isEmpty()) {
            for (Asset asset : assets) {
                double d = asset != null && asset.getAmount() != null ? asset.getAmount().doubleValue() : 0.0;
                double amount = d;
                if (!(amount > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isContributionInRange(double lower, double upper) {
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        if (dependentFinancials != null && dependentFinancials.getAmountContributedToSupport() != null) {
            return this.isInRange(dependentFinancials.getAmountContributedToSupport(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isIncomeInRange(double lower, double upper) {
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        if (dependentFinancials != null && dependentFinancials.getIncome() != null) {
            return this.isIncomeInRange(dependentFinancials.getIncome().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isExpenseInRange(double lower, double upper) {
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        if (dependentFinancials != null && dependentFinancials.getExpenses() != null) {
            return this.isExpenseInRange(dependentFinancials.getExpenses().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isAssetInRange(double lower, double upper) {
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        if (dependentFinancials != null && dependentFinancials.getAssets() != null) {
            return this.isAssetInRange(dependentFinancials.getAssets().values(), lower, upper);
        }
        return true;
    }

    @Override
    public Date getDependentBirthDate() {
        return this.getRelationBirthDate(this.getDependent());
    }

    @Override
    public boolean isDependentLivesWithVeteran() {
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        return dependentFinancials != null && dependentFinancials.getLivedWithPatient() != null ? dependentFinancials.getLivedWithPatient() : false;
    }

    @Override
    public boolean isChildSupportContributionIndicator() {
        DependentFinancials dependentFinancials = this.getDependentFinancials();
        return dependentFinancials != null && dependentFinancials.getContributedToSupport() != null ? dependentFinancials.getContributedToSupport() : false;
    }

    @Override
    public int getTotalNumberOfDependents() {
        FinancialStatement stmt = this.getDependentFinancials() != null ? this.getDependentFinancials().getFinancialStatement() : null;
        return stmt != null ? stmt.getDependentFinancials().size() : 0;
    }

    private Dependent getDependent() {
        return this.getDependentFinancials() != null ? this.getDependentFinancials().getReportedOn() : null;
    }

    private DependentFinancials getDependentFinancials() {
        DependentFinancialsInputData inputData = this.getDependentFinancialsInputData();
        return inputData != null ? inputData.getIncomingDependentFinancials() : null;
    }

    protected DependentFinancialsInputData getDependentFinancialsInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        return ruleDataAware instanceof DependentFinancialsInputData ? (DependentFinancialsInputData)ruleDataAware : null;
    }
}

