/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.infra.PreciseDateUtils;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HandBookMailStatus;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.common.persistent.system.SystemParameterDAO;
import gov.va.med.esr.common.rule.CommunicationsInput;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.data.PersonSignatureInputData;
import gov.va.med.esr.common.rule.parameter.AbstractTriggerAwareInputParameter;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.ProcessTriggerEvent;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;

public class CommunicationsInputParameter
extends AbstractTriggerAwareInputParameter
implements CommunicationsInput,
LetterTrigger,
BulletinTrigger {
    private static final long serialVersionUID = 6278256148059152581L;
    public static final String EMPTY_LINE = "                                        ";
    public static final String TAB = "\t";
    public static final String NEW_LINE = "\n";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String NO_DATA = "No Data";
    public static final String SPACE = " ";
    private static final String RX_COPAY_TEXT = "RX COPAY = NOT EXEMPT";
    private static final String MT_COPAY_TEXT = "MT COPAY = NOT EXEMPT";
    private static final String GMT_COPAY_TEXT = "GMT COPAY = NOT EXEMPT";
    public static final String COLON = ":";
    private static final String POW_REGISTRY_FROM_DATE = "POW Registry From Date";
    private static final String POW_REGISTRY_TO_DATE = "POW Registry To Date";
    private static final String POW_REGISTRY_CONFINEMENT_LOCATION = "POW Registry Confinement Location";
    private SystemParameterDAO systemParameterDAO = null;
    private HandBookService handBookService = null;
    private static final String[] ivmEligibilityCodeList = new String[]{EligibilityType.AID_AND_ATTENDANCE.getName(), EligibilityType.HOUSEBOUND.getName(), EligibilityType.NSC_VA_PENSION.getName(), EligibilityType.PRISONER_OF_WAR.getName(), EligibilityType.PURPLE_HEART_RECIPIENT.getName(), EligibilityType.SC_LESS_THAN_50_PERCENT.getName(), EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getName()};

    @Override
    public SystemParameterDAO getSystemParameterDAO() {
        return this.systemParameterDAO;
    }

    @Override
    public void setSystemParameterDAO(SystemParameterDAO systemParameterDAO) {
        this.systemParameterDAO = systemParameterDAO;
    }

    @Override
    public boolean isHandbookBenefitActive() throws RuleException {
        try {
            SystemParameter sysParameter = this.getSystemParameterDAO().getByName("Handbook Active");
            if (sysParameter != null && sysParameter.getValue() != null) {
                return sysParameter.getValue().equalsIgnoreCase("Y");
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error getting SystemParameter (HANDBOOK_ACTIVE) value", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean isIVMFinalLetterActive() throws RuleException {
        try {
            SystemParameter sysParameter = this.getSystemParameterDAO().getByName("IVM Final Letter Indicator");
            if (sysParameter != null && sysParameter.getValue() != null) {
                return sysParameter.getValue().equalsIgnoreCase("Y");
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error getting SystemParameter (IVM_FINAL_LETTER_INDICATOR) value", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean isHandbookRollOutOver() throws RuleException {
        try {
            SystemParameter sysParameter = this.getSystemParameterDAO().getByName("HANDBOOK ROLL OUT OVER");
            if (sysParameter != null && sysParameter.getValue() != null) {
                return sysParameter.getValue().equalsIgnoreCase("Y");
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error getting SystemParameter (HANDBOOK_ROLL_OUT_OVER) value", (Throwable)ex);
        }
        return false;
    }

    @Override
    public void trigger623RLetter() throws RuleException {
        this.triggerAutoLetter(this.getComLetterTemplateType(ComLetterTemplateType.FORM_NUMBER_623R.getName()));
    }

    @Override
    public void triggerLetterMailing(int letter) {
    }

    @Override
    public void triggerHECReviewBulletin() {
        this.triggerSendIneligibleInfoBulletin();
    }

    @Override
    public void triggerDODDeletionBulletin() {
        VAFacility facilitySendingMessage = this.getSendingFacility();
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_SITE_VERIFY_DOD_DELETION);
        bte.addField("SITE", facilitySendingMessage == null ? SPACE : facilitySendingMessage.getStationNumber());
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerBadAddressNotificationBulletin(BadAddressReason reason) {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.BAD_ADDRESS_NOTIFY);
        bte.addField("BadAddressRsn", reason != null ? reason.getDescription() : SPACE);
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerPurpleHeartIsNoBulletin() {
        PurpleHeart ph = this.getHelperService().getPurpleHeart(this.getResultPerson());
        String remark = ph != null && ph.getRejectionRemark() != null ? ph.getRejectionRemark().getDescription() : SPACE;
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_PURPLE_HEART_NO_DECISION);
        bte.addField("EffectiveDate", new Date());
        bte.addField("RejectedRemark", remark);
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerPOWYesToNoBulletin() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"+triggerPOWYesToNoBulletin");
        }
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_POW_NO);
        this.addTriggerEvent(bte);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"-triggerPOWYesToNoBulletin");
        }
    }

    @Override
    public void triggerHecRecord() throws RuleException {
        ProcessTriggerEvent pte = new ProcessTriggerEvent("triggerEvent.createHecRecord", this.getPersonId());
        this.addTriggerEvent(pte);
    }

    @Override
    public void triggerPOWNoToYesBulletin() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"+triggerPOWNoToYesBulletin");
        }
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_POW_DISCREPANCY_NOT_POW);
        this.addTriggerEvent(bte);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"-triggerPOWNoToYesBulletin");
        }
    }

    @Override
    public void triggerPOWDiscrepantBulletin() {
        Person pristinePderson;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"+triggerPOWDiscrepantBulletin");
        }
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_POW_DISCREPANCY_NOT_MATCH);
        this.addTriggerEvent(bte);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Added BulletinTrigger.DataType.HEC_NOTIFY_POW_DISCREPANCY_NOT_MATCH");
        }
        PrisonerOfWar pow = (pristinePderson = this.getPristinePerson()) != null ? pristinePderson.getPrisonerOfWar() : null;
        Set powEpisodes = pow != null ? pow.getEpisodes() : new HashSet();
        StringBuffer messageBody = new StringBuffer();
        for (POWEpisode powEpisode : powEpisodes) {
            String captureDate = powEpisode != null && powEpisode.getCaptureDate() != null ? powEpisode.getCaptureDate().toString() : SPACE;
            String releaseDate = powEpisode != null && powEpisode.getReleaseDate() != null ? powEpisode.getReleaseDate().toString() : SPACE;
            String confinementLocation = powEpisode != null && powEpisode.getConfinementLocation() != null ? powEpisode.getConfinementLocation().getDescription() : SPACE;
            messageBody.append(POW_REGISTRY_FROM_DATE).append(COLON).append(captureDate);
            messageBody.append(NEW_LINE);
            messageBody.append(POW_REGISTRY_TO_DATE).append(COLON).append(releaseDate);
            messageBody.append(NEW_LINE);
            messageBody.append(POW_REGISTRY_CONFINEMENT_LOCATION).append(COLON).append(confinementLocation);
            messageBody.append(NEW_LINE);
            messageBody.append(NEW_LINE);
        }
        bte.addField("POWEpisodes", messageBody.toString());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("POW Episodes Info: " + messageBody));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"-triggerPOWDiscrepantBulletin");
        }
    }

    @Override
    public void triggerSendIneligibleInfoBulletin() {
        VAFacility facilitySendingMessage = this.getSendingFacility();
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_SITE_SEND_INELIGIBLE_INFO);
        bte.addField("SITE", facilitySendingMessage == null ? SPACE : facilitySendingMessage.getStationNumber());
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerVeteranNeedsVerificationBulletin() {
        VAFacility preferred = this.getResultPerson().getMostRecentPreferredFacility();
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_SITE_VETERAN_VERIFICATION);
        if (preferred != null) {
            bte.addField("PreferredFacility", preferred.getDescription());
        } else {
            bte.addField("PreferredFacility", SPACE);
        }
        this.addTriggerEvent(bte);
    }

    @Override
    public void trigger600CLetter() throws RuleException {
        this.triggerAutoLetter(this.getComLetterTemplateType(ComLetterTemplateType.FORM_NUMBER_600C.getName()));
    }

    @Override
    public void trigger601BLetter() throws RuleException {
        this.triggerAutoLetter(this.getComLetterTemplateType(ComLetterTemplateType.FORM_NUMBER_601B.getName()));
    }

    @Override
    public void trigger620ALetter() throws RuleException {
        this.triggerAutoLetter(this.getComLetterTemplateType(ComLetterTemplateType.FORM_NUMBER_620A.getName()));
    }

    @Override
    public void triggerORFZ11NotMatchPersonBulletin() throws RuleException {
    }

    @Override
    public void triggerPersonEligibilityNotVerifiedBulletin() throws RuleException {
        this.triggerPersonEligibilityNotVerifiedBulletin(this.getSendingFacility());
    }

    @Override
    public void triggerPersonEligibilityNotVerifiedBulletin(VAFacility facilitySendingMessage) throws RuleException {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.ELIG_NOT_VERIFIED_CALL_HEC);
        bte.addField("SITE", facilitySendingMessage == null ? SPACE : facilitySendingMessage.getStationNumber());
        this.addTriggerEvent(bte);
    }

    @Override
    public boolean hasReceivedNotificationOfIneligibleStatus() throws RuleException {
        try {
            List logs = this.getCommsLogService().findLogEntriesByPersonId(this.getIncomingPerson().getEntityKey().getKeyValueAsString());
            if (logs != null) {
                for (CommsLogEntry log : logs) {
                    MailingStatusLink msl;
                    String mslCode;
                    if (!ComLetterTemplateType.FORM_NUMBER_601B.equals(log.getFormNumber()) && !ComLetterTemplateType.FORM_NUMBER_601C.equals(log.getFormNumber()) || (mslCode = (msl = log.getLatestMailingStatus()) != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null) == null || !ComMailingStatusType.SEND_TO_AAC.getName().equals(mslCode) && !ComMailingStatusType.SENT_TO_AAC.getName().equals(mslCode) && !ComMailingStatusType.SEND_TO_CMS.getName().equals(mslCode) && !ComMailingStatusType.SENT_TO_CMS.getName().equals(mslCode) && !ComMailingStatusType.MAILED_BY_HEC.getName().equals(mslCode) && !ComMailingStatusType.REJECT_AT_HEC.getName().equals(mslCode) && !ComMailingStatusType.REJECT_BY_AAC.getName().equals(mslCode) && !ComMailingStatusType.ERROR_BY_AAC.getName().equals(mslCode) && !ComMailingStatusType.RETURN_BY_POST_OFFICE.getName().equals(mslCode) && !ComMailingStatusType.SENT_TO_HEC_PRINTER.getName().equals(mslCode) && !ComMailingStatusType.ADDRESS_CHANGED_AND_MAILED_BY_AAC.getName().equals(mslCode) && !ComMailingStatusType.MAILED_BY_AAC.getName().equals(mslCode)) continue;
                    return true;
                }
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to trigger VA Pension bulletin", (Throwable)e);
        }
        return false;
    }

    @Override
    public Date getLetterMailingDate() {
        return this.getCommsLogEntry() != null ? this.getCommsLogEntry().getMailingDate() : null;
    }

    @Override
    public boolean isLetterSentToConfidentialAddress() {
        return this.isAddressType(AddressType.CODE_CONFIDENTIAL_ADDRESS, this.getMailingAddress());
    }

    @Override
    public boolean isLetterSentToPermanentAddress() {
        return this.isAddressType(AddressType.CODE_PERMANENT_ADDRESS, this.getMailingAddress());
    }

    @Override
    public boolean isLetterSentToTemporaryAddress() {
        return this.isAddressType(AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS, this.getMailingAddress());
    }

    @Override
    public void setLetterAddressEndDate(ImpreciseDate endDate) {
        if (this.getMailingAddress() != null && endDate != null) {
            if (this.getMailingAddress().getStartDate() != null && this.getMailingAddress().getStartDate().compareTo(endDate) > 0) {
                this.getMailingAddress().setStartDate(endDate);
            }
            this.getMailingAddress().setEndDate(endDate);
            this.getCommsInputData().setAddressChanged(true);
        }
    }

    @Override
    public void expireLetterAddress() {
        this.setLetterAddressEndDate(ImpreciseDateUtils.createImpreciseDateWithoutTime(DateUtils.getYesterdayDate()));
    }

    @Override
    public void triggerRemailingOfLetter() throws RuleException {
        String form;
        CommsLogEntry commsLogEntry = this.getCommsLogEntry();
        if (commsLogEntry != null && (form = commsLogEntry.getFormNumber()) != null) {
            ComLetterTemplateType comLetterTemplateType = this.getComLetterTemplateType(form);
            this.triggerRemailLetter(comLetterTemplateType);
        }
    }

    @Override
    public Address getLetterMailedToAddress() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getMailingAddress() : null;
    }

    @Override
    public void addCommsErrorMessage(String errorMessage) {
    }

    public String getTextForGMTCopayRequired() {
        return GMT_COPAY_TEXT;
    }

    public String getTextForMTCopayRequired() {
        return MT_COPAY_TEXT;
    }

    public String getTextForRXCopay() {
        return RX_COPAY_TEXT;
    }

    @Override
    public String getLetterFileType() {
        return this.getCommsLogEntry() != null && this.getCommsLogEntry().getLetterType() != null ? this.getCommsLogEntry().getLetterType().getCode() : null;
    }

    @Override
    public String getPristineRemailStatus() {
        return null;
    }

    @Override
    public void setCommunicationStatus(String status) throws RuleException {
        this.setCommsStatus(status);
    }

    @Override
    public void setLetterFileType(String fileType) throws RuleException {
        try {
            if (this.getCommsLogEntry() != null && fileType != null) {
                this.getCommsLogEntry().setLetterType(this.getLookupService().getComLetterTypeByCode(fileType));
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set comms letter type", (Throwable)e);
        }
    }

    @Override
    public void setRemailStatus(String status) {
    }

    @Override
    public void updateCommunicationInformation() {
    }

    @Override
    public BigDecimal getBarcodeId() {
        return this.getCommsLogEntry() != null && this.getCommsLogEntry().getEntityKey() != null ? new BigDecimal(this.getCommsLogEntry().getEntityKey().getKeyValueAsString()) : null;
    }

    @Override
    public Long getVersion() {
        return this.getCommsLogEntry() != null && this.getCommsLogEntry().getVersion() != null ? new Long(this.getCommsLogEntry().getVersion().longValue()) : null;
    }

    @Override
    public BigDecimal getVeteranBarcodeId() {
        CommsLogEntry cle = this.getCommsLogEntry();
        EntityKey key = cle != null ? cle.getEntityKey() : null;
        return key != null ? new BigDecimal(key.getKeyValueAsString()) : null;
    }

    @Override
    public String getVeteranFormNumber() {
        return this.getCommsLogEntry() != null ? this.getCommsLogEntry().getFormNumber() : null;
    }

    @Override
    public Long getVeteranVersion() {
        return this.getCommsLogEntry() != null && this.getCommsLogEntry().getVersion() != null ? new Long(this.getCommsLogEntry().getVersion().longValue()) : null;
    }

    @Override
    public String getFinalLetterCode() {
        IVMFinancialInfo info = this.getCommsInputData() != null ? this.getCommsInputData().getIvmFinancialInfo() : null;
        return info != null ? info.getIvmLetterCode() : null;
    }

    @Override
    public Date getIvmCaseClosureDate() {
        return this.getCommsLogEntry() != null ? this.getCommsLogEntry().getIvmCaseClosureDate() : null;
    }

    @Override
    public String getIvmCaseNumber() {
        return this.getCommsLogEntry() != null ? this.getCommsLogEntry().getIvmCaseNumber() : null;
    }

    @Override
    public boolean meetsIvmEligibilityCriteria(Person person) throws RuleException {
        if (person != null) {
            IncomeTest current;
            Hardship hardShip;
            Set secondaries;
            EnrollmentDetermination ed = person.getEnrollmentDetermination();
            String code = ed != null && ed.getPrimaryEligibility() != null ? ed.getPrimaryEligibility().getType().getCode() : null;
            Set set = secondaries = ed != null ? ed.getSecondaryEligibilities() : null;
            if (code != null && StringUtils.contains((String[])ivmEligibilityCodeList, (String)code)) {
                if (code.equals(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode())) {
                    int scPercentage = this.getPercentage(person);
                    BigDecimal total = this.getTotalCheckAmount(person);
                    if (scPercentage == 0 && total != null && total.compareTo(new BigDecimal(0)) > 0) {
                        return false;
                    }
                    if (scPercentage > 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (secondaries != null) {
                for (Eligibility eligibility : secondaries) {
                    if (!StringUtils.contains((String[])ivmEligibilityCodeList, (String)eligibility.getType().getCode())) continue;
                    return false;
                }
            }
            Hardship hardship = hardShip = (current = this.getHelperService().getCurrentIncomeTest(person)) != null ? current.getHardship() : null;
            if (hardShip != null && hardShip.getHardshipGranted() != null && hardShip.getHardshipGranted().booleanValue()) {
                return false;
            }
            if (this.isEligibleForMedicaid(person).booleanValue()) {
                return false;
            }
            DeathRecord dr = person.getDeathRecord();
            if (dr != null && dr.getDeathDate() != null) {
                return false;
            }
            CatastrophicDisability cd = this.getCatastrophicDisability(person);
            return cd == null || cd.getCatastrophicallyDisabled() == null || cd.getCatastrophicallyDisabled() == false;
        }
        return false;
    }

    private CatastrophicDisability getCatastrophicDisability(Person person) {
        return (CatastrophicDisability)this.getHelperService().getClinicalDetermination(CatastrophicDisability.class, person);
    }

    private Boolean isEligibleForMedicaid(Person person) {
        MedicaidFactor ma = person.getMedicaidFactor();
        return ma != null ? this.getNotNull(ma.isEligibleForMedicaid()) : Boolean.FALSE;
    }

    private Boolean getNotNull(Boolean value) {
        return value == null ? Boolean.FALSE : value;
    }

    private BigDecimal getTotalCheckAmount(Person person) throws RuleException {
        MonetaryBenefitAward mba = person != null ? person.getMonetaryBenefitAward() : null;
        BigDecimal result = mba != null ? mba.getCheckAmount() : BigDecimal.valueOf(0L);
        this.logger.debug((Object)result);
        return result;
    }

    @Override
    public boolean isLetterSentToPOA() {
        CommsLogEntry cle = this.getCommsLogEntry();
        return cle != null ? "Power of Attorney".equals(cle.getRecipient()) : false;
    }

    @Override
    public String getCommsLetterFormType() {
        if (this.getCommsLogEntry() != null) {
            return this.getCommsLogEntry().getFormNumber();
        }
        return this.getCommsInputData() != null && this.getCommsInputData().getFormNumber() != null ? this.getCommsInputData().getFormNumber().getCode() : null;
    }

    @Override
    public String getCommsComment() {
        return this.getCommsLogEntry() != null ? this.getCommsLogEntry().getActionComment() : null;
    }

    @Override
    public String getCurrentLetterForm() {
        CommsLogEntry commsLogEntry = this.getCommsLogEntry();
        if (commsLogEntry != null) {
            return this.getCommsLogEntry().getFormNumber();
        }
        CommsInputData cid = this.getCommsInputData();
        return cid != null && cid.getFormNumber() != null ? cid.getFormNumber().getCode() : null;
    }

    @Override
    public String getLetterType() {
        if (this.getCommsInputData() != null && this.getCommsInputData().getMailType() != null) {
            return this.getCommsInputData().getMailType().getName();
        }
        return null;
    }

    @Override
    public boolean hasLetterBeenMailedForSameIncomeYear(String letterFormType) throws RuleException {
        CommsInputData cid = this.getCommsInputData();
        String context = null;
        if (cid != null) {
            context = cid.getRuleContext();
        }
        if (letterFormType == null || "AAC_EXPORT".equals(context)) {
            return false;
        }
        List logs = this.getCommsLogs(this.getIncomingPerson());
        if (logs != null) {
            for (CommsLogEntry log : logs) {
                Date incomeTestEffectiveDate;
                MailingStatusLink msl;
                String code;
                if (log == null || !log.getFormNumber().equals(letterFormType) || (code = (msl = log.getLatestMailingStatus()) != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null) == null || !ComMailingStatusType.SEND_TO_AAC.getName().equals(code) && !ComMailingStatusType.SENT_TO_AAC.getName().equals(code) && !ComMailingStatusType.SEND_TO_CMS.getName().equals(code) && !ComMailingStatusType.SENT_TO_CMS.getName().equals(code) && !ComMailingStatusType.MAILED_BY_HEC.getName().equals(code) && !ComMailingStatusType.MAILED_BY_AAC.getName().equals(code)) continue;
                Date mailingDate = log.getMailingDate();
                Date createdDate = log.getCreatedOn();
                Date compareDate = null;
                compareDate = mailingDate != null ? mailingDate : createdDate;
                IncomeTest test = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
                if (test == null || compareDate == null || (incomeTestEffectiveDate = test.getEffectiveDate()) == null) continue;
                GregorianCalendar daysAfter = new GregorianCalendar();
                daysAfter.setTime(incomeTestEffectiveDate);
                daysAfter.add(5, 365);
                if (compareDate.getTime() < incomeTestEffectiveDate.getTime() || compareDate.getTime() >= daysAfter.getTime().getTime()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDuplicateMailRequest() {
        return false;
    }

    @Override
    public boolean isLetterFormPreviouslyMailed(String letterFormType) throws RuleException {
        if (letterFormType != null) {
            ComLetterTemplateType comLetterTemplateType = this.getComLetterTemplateType(letterFormType);
            return this.hasLetterFormBeenPreviouslyMailed(comLetterTemplateType);
        }
        return false;
    }

    @Override
    public boolean isLetterFormPreviouslyMailedExcludeMailedStatus(String type) throws RuleException {
        if (type == null) {
            return false;
        }
        List logs = this.getCommsLogs(this.getIncomingPerson());
        if (logs != null) {
            for (CommsLogEntry log : logs) {
                MailingStatusLink msl;
                String mslCode;
                if (!type.equals(log.getFormNumber()) || (mslCode = (msl = log.getLatestMailingStatus()) != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null) == null || ComMailingStatusType.SEND_TO_AAC.getName().equals(mslCode) || ComMailingStatusType.SENT_TO_AAC.getName().equals(mslCode) || ComMailingStatusType.SEND_TO_CMS.getName().equals(mslCode) || ComMailingStatusType.SENT_TO_CMS.getName().equals(mslCode) || ComMailingStatusType.MAILED_BY_HEC.getName().equals(mslCode) || ComMailingStatusType.MAILED_BY_AAC.getName().equals(mslCode) || ComMailingStatusType.MAILED_BY_CMS.getName().equals(mslCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isiMostRecent680NReturnByPostOffice() throws RuleException {
        List logs = this.getCommsLogs(this.getIncomingPerson());
        if (logs != null) {
            for (CommsLogEntry log : logs) {
                MailingStatusLink msl;
                String mslCode;
                if (!ComLetterTemplateType.FORM_NUMBER_680N.equals(log.getFormNumber()) || (mslCode = (msl = log.getLatestMailingStatus()) != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null) == null) continue;
                return ComMailingStatusType.RETURN_BY_POST_OFFICE.getName().equals(mslCode);
            }
        }
        return false;
    }

    @Override
    public boolean hasLetterBeenMailedIncludingMailedStatus(String letterFormType) throws RuleException {
        if (letterFormType == null) {
            return false;
        }
        if (ComLetterTemplateType.FORM_NUMBER_683A.getCode().equals(letterFormType)) {
            return this.hasCompassionLetterBeenPreviouslyMailed(letterFormType);
        }
        List logs = this.getCommsLogs(this.getIncomingPerson());
        if (logs != null) {
            for (CommsLogEntry log : logs) {
                MailingStatusLink msl;
                String mslCode;
                if (!letterFormType.equals(log.getFormNumber()) || (mslCode = (msl = log.getLatestMailingStatus()) != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null) == null || !ComMailingStatusType.SEND_TO_AAC.getName().equals(mslCode) && !ComMailingStatusType.SENT_TO_AAC.getName().equals(mslCode) && !ComMailingStatusType.SEND_TO_CMS.getName().equals(mslCode) && !ComMailingStatusType.SENT_TO_CMS.getName().equals(mslCode) && !ComMailingStatusType.MAILED_BY_HEC.getName().equals(mslCode) && !ComMailingStatusType.MAILED_BY_AAC.getName().equals(mslCode) && !ComMailingStatusType.MAILED_BY_CMS.getName().equals(mslCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUserOverridingMailRequest() {
        return this.getCommsInputData() != null ? this.getCommsInputData().isOverrideRequest() : false;
    }

    @Override
    public void setCommsComment(String comment) {
        if (this.getResultCommsLogEntry() != null) {
            this.getResultCommsLogEntry().setActionComment(comment);
        }
    }

    @Override
    public void setCommsStatusUpdateDate(Date updateDate) {
    }

    @Override
    public String getCommsStatus() {
        return this.getCommsStatus(this.getCommsLogEntry());
    }

    @Override
    public void setCommsStatus(String communicationStatus) throws RuleException {
        if (communicationStatus == null) {
            return;
        }
        if (this.getResultCommsLogEntry() != null) {
            try {
                ComMailingStatusType status = this.getLookupService().getComMailingStatusTypeByCode(communicationStatus);
                this.getResultCommsLogEntry().addMailingStatus(status);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to set comms status", (Throwable)e);
            }
        }
        if (this.getResultHandbookMailQueue() != null) {
            HandBookMailStatus status = this.getResultHandbookMailQueue().getHandBookMailStatus();
            if (status == null) {
                throw new RuleException("Handbook status is null. HandBookMailQueue id = " + this.getResultHandbookMailQueue().getId());
            }
            try {
                HandBookMailStatusType statusType = this.getLookupService().getHandBookMailingStatusTypeByCode(communicationStatus);
                status.setStatusType(statusType);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to set comms status for handbook mail queue", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isLetterFormPreviouslyMailedDaysAgo(String letterFormType, int daysAgo) throws RuleException {
        boolean result = false;
        if (letterFormType == null) {
            return false;
        }
        ComLetterTemplateType comLetterTemplateType = this.getComLetterTemplateType(letterFormType);
        if (comLetterTemplateType != null) {
            List logs = null;
            try {
                logs = this.getCommsLogService().findLogEntriesByPersonId(this.getIncomingPerson().getEntityKey().getKeyValueAsString());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get CommsLog", (Throwable)e);
            }
            if (logs != null && logs.size() > 0) {
                for (CommsLogEntry log : logs) {
                    if (comLetterTemplateType.getCode().equals(log.getFormNumber()) && this.recipientMatches(log)) {
                        Date mailDate;
                        String code;
                        MailingStatusLink msl = log.getLatestMailingStatus();
                        String string = code = msl != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null;
                        if (!(ComMailingStatusType.SEND_TO_AAC.getName().equals(code) || ComMailingStatusType.SENT_TO_AAC.getName().equals(code) || ComMailingStatusType.SEND_TO_CMS.getName().equals(code) || ComMailingStatusType.SENT_TO_CMS.getName().equals(code) || (mailDate = log.getMailingDate()) == null)) {
                            Calendar to = Calendar.getInstance();
                            to.setTime(new Date());
                            Calendar from = Calendar.getInstance();
                            from.setTime(mailDate);
                            boolean bl = result = PreciseDateUtils.getDays(from, to).compareTo(new Long(daysAgo)) >= 0;
                        }
                    }
                    if (!result) continue;
                    break;
                }
            }
        }
        return result;
    }

    private boolean recipientMatches(CommsLogEntry log) {
        String recipient = log.getRecipient();
        String subject = this.getSubject();
        return recipient != null && ("Veteran".equals(recipient) && "V".equals(subject) || "Spouse".equals(recipient) && "S".equals(subject) || "Dependent".equals(recipient) && "D".equals(subject) || "Power of Attorney".equals(recipient));
    }

    @Override
    public void triggerLetterMailing(String letterFormType) throws RuleException {
        if (letterFormType != null) {
            if (this.getSubject() != null && (ComLetterTemplateType.FORM_NUMBER_290.getCode().equals(letterFormType) || ComLetterTemplateType.FORM_NUMBER_291.getCode().equals(letterFormType) || ComLetterTemplateType.FORM_NUMBER_292.getCode().equals(letterFormType) || ComLetterTemplateType.FORM_NUMBER_293.getCode().equals(letterFormType))) {
                this.triggerAutoLetter(this.getComLetterTemplateType(letterFormType), this.getSubject());
            } else {
                this.triggerAutoLetter(this.getComLetterTemplateType(letterFormType));
            }
        }
    }

    public void triggerLetterMailing(ComLetterTemplateType type) {
        this.triggerAutoLetter(type);
    }

    @Override
    public boolean has30DaySSNClockExpired() {
        Clock.Type fired = this.getFiredClockType();
        return fired != null ? Clock.Type.SSN_30_DAY_VALIDATION_CLOCK.getName().equals(fired.getName()) : false;
    }

    @Override
    public void start30DaySSNClock() throws RuleException {
        try {
            this.getScheduledTaskService().startSSNInvalidLetterClock(this.getResultPerson(), this.getSubject());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start SSN 30 day clock", (Throwable)e);
        }
    }

    @Override
    public void start30DaySSNClock(String subject) throws RuleException {
        try {
            this.getScheduledTaskService().startSSNInvalidLetterClock(this.getResultPerson(), subject);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start SSN 30 day clock", (Throwable)e);
        }
    }

    @Override
    public void triggerEGTProcessingEndBulletin() {
    }

    @Override
    public void triggerEGTProcessingStartBulletin() {
    }

    @Override
    public void triggerEGTProcessingStoppedBulletin() {
    }

    @Override
    public boolean has30DayPseudoSSNReasonClockExpired() {
        Clock.Type fired = this.getFiredClockType();
        return fired != null ? Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK.getName().equals(fired.getName()) : false;
    }

    @Override
    public boolean has30DayPseudoSSNVerificationClockExpired() {
        Clock.Type fired = this.getFiredClockType();
        return fired != null ? Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK.getName().equals(fired.getName()) : false;
    }

    @Override
    public void start30DayPseudoSSNReasonClock(String subject) throws RuleException {
        try {
            this.getScheduledTaskService().startPseudoSSNReasonClock(this.getResultPerson(), subject);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start Pseudo SSN 30 day clock", (Throwable)e);
        }
    }

    @Override
    public void start30DayPseudoSSNVerificationClock(String subject) throws RuleException {
        try {
            this.getScheduledTaskService().startPseudoSSNVerificationClock(this.getResultPerson(), subject);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start Pseudo SSN 30 day clock", (Throwable)e);
        }
    }

    @Override
    public void start30DayPseudoSSNReasonClock() throws RuleException {
        try {
            this.getScheduledTaskService().startPseudoSSNReasonClock(this.getResultPerson(), this.getSubject());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start Pseudo SSN 30 day clock", (Throwable)e);
        }
    }

    @Override
    public void start30DayPseudoSSNVerificationClock() throws RuleException {
        try {
            this.getScheduledTaskService().startPseudoSSNVerificationClock(this.getResultPerson(), this.getSubject());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start Pseudo SSN 30 day clock", (Throwable)e);
        }
    }

    @Override
    public void triggerSSARecordNotMatchBulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_SSA_RECORD_NOT_MATCH_HEC_INTERNAL_ID);
        this.addTriggerEvent(bte);
    }

    @Override
    public void cancel30DayPseudoSSNReasonClock() throws RuleException {
        try {
            this.getScheduledTaskService().cancelClock(this.getIncomingPerson(), Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK, Clock.Group.SSN_CLOCK_GROUP, this.getSubject());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to cancel SSN letter clock", (Throwable)e);
        }
    }

    @Override
    public void cancel72HourMilServQueryClock() throws RuleException {
        try {
            this.getScheduledTaskService().cancelClock(this.getIncomingPerson(), Clock.Type.WF_72_HOUR_CLOCK, Clock.Group.WF_CLOCK_GROUP);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to cancel Mil Serv Query clock", (Throwable)e);
        }
    }

    @Override
    public void start72HourMilServQueryClock() throws RuleException {
        try {
            this.getScheduledTaskService().startMilServiceQueryClock(this.getIncomingPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start Mil Service Query Pending clock", (Throwable)e);
        }
    }

    @Override
    public void cancel30DayPseudoSSNVerificationClock() throws RuleException {
        try {
            this.getScheduledTaskService().cancelClock(this.getIncomingPerson(), Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK, Clock.Group.SSN_CLOCK_GROUP, this.getSubject());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to cancel SSN letter clock", (Throwable)e);
        }
    }

    @Override
    public String getPristineCommsStatus() {
        return this.getCommsStatus(this.getPristineCommsLogEntry());
    }

    @Override
    public void setHECRejectReasons() {
    }

    private String getAddedRatedDisabilityCodeList() {
        Set a = this.getRatedDisabilities(this.getIncomingPerson());
        Set b = this.getRatedDisabilities(this.getPristinePerson());
        boolean aIsEmpty = a == null || a.size() <= 0;
        boolean bIsEmpty = b == null || b.size() <= 0;
        String added = SPACE;
        HashSet<String> addedSet = new HashSet<String>();
        if (aIsEmpty && bIsEmpty) {
            return added;
        }
        if (aIsEmpty && !bIsEmpty) {
            return added;
        }
        if (!aIsEmpty && bIsEmpty) {
            for (RatedDisability ra : a) {
                addedSet.add(this.getRDCodeAndDescription(ra));
            }
            if (addedSet.size() > 0) {
                added = StringUtils.join((Object[])addedSet.toArray(), (String)", ");
            }
            return added;
        }
        for (RatedDisability ra : a) {
            Iterator iterB = b.iterator();
            boolean found = false;
            while (iterB.hasNext()) {
                RatedDisability rb = (RatedDisability)((Object)iterB.next());
                if (!this.compareRatedDisability(ra, rb)) continue;
                found = true;
                break;
            }
            if (found) continue;
            addedSet.add(this.getRDCodeAndDescription(ra));
        }
        if (addedSet != null && addedSet.size() > 0) {
            added = StringUtils.join((Object[])addedSet.toArray(), (String)", ");
        }
        return added;
    }

    private String getRemovedRatedDisabilityCodeList() {
        Set a = this.getRatedDisabilities(this.getIncomingPerson());
        Set b = this.getRatedDisabilities(this.getPristinePerson());
        boolean aIsEmpty = a == null || a.size() <= 0;
        boolean bIsEmpty = b == null || b.size() <= 0;
        String removed = SPACE;
        HashSet<String> removedSet = new HashSet<String>();
        if (aIsEmpty && bIsEmpty) {
            return removed;
        }
        if (aIsEmpty && !bIsEmpty) {
            for (RatedDisability rb : b) {
                removedSet.add(this.getRDCodeAndDescription(rb));
            }
            if (removedSet.size() > 0) {
                removed = StringUtils.join((Object[])removedSet.toArray(), (String)", ");
            }
            return removed;
        }
        if (!aIsEmpty && bIsEmpty) {
            return removed;
        }
        for (RatedDisability rb : b) {
            Iterator iterA = a.iterator();
            boolean found = false;
            while (iterA.hasNext()) {
                RatedDisability ra = (RatedDisability)((Object)iterA.next());
                if (!this.compareRatedDisability(ra, rb)) continue;
                found = true;
                break;
            }
            if (found) continue;
            removedSet.add(this.getRDCodeAndDescription(rb));
        }
        if (removedSet.size() > 0) {
            removed = StringUtils.join((Object[])removedSet.toArray(), (String)", ");
        }
        return removed;
    }

    private boolean compareRatedDisability(RatedDisability a, RatedDisability b) {
        return a == null && b == null || a != null && b != null && new EqualsBuilder().append((Object)a.getDisability(), (Object)b.getDisability()).isEquals();
    }

    private Set getRatedDisabilities(Person person) {
        if (person != null && person.getServiceConnectionAward() != null) {
            return person.getServiceConnectionAward().getRatedDisabilities();
        }
        return null;
    }

    private String getRDCodeAndDescription(RatedDisability rd) {
        if (rd == null) {
            return SPACE;
        }
        String code = rd.getDisability() != null ? rd.getDisability().getCode() : SPACE;
        String desc = rd.getDisability() != null ? rd.getDisability().getName() : SPACE;
        return code + SPACE + desc;
    }

    @Override
    public void triggerAutoLetter(ComLetterTemplateType type) {
        this.triggerLetter(type, LetterTriggerEvent.AUTO_MAIL, null);
    }

    public void triggerAutoLetter(ComLetterTemplateType type, String subject) {
        this.triggerLetter(type, LetterTriggerEvent.AUTO_MAIL, subject);
    }

    @Override
    public void triggerRemailLetter(ComLetterTemplateType type) {
        this.triggerLetter(type, LetterTriggerEvent.REMAIL_MAIL, null);
    }

    private void triggerLetter(ComLetterTemplateType type, LetterTriggerEvent.MailType mailType, String subject) {
        if (this.getBaseData() != null && this.getBaseData().isReviewOnly()) {
            return;
        }
        LetterTriggerEvent lte = null;
        if (subject != null) {
            if ("D".equals(subject)) {
                lte = new LetterTriggerEvent(type, LetterTrigger.CategoryType.DEPENDENT_LETTER);
            } else if ("S".equals(subject)) {
                lte = new LetterTriggerEvent(type, LetterTrigger.CategoryType.SPOUSE_LETTER);
            } else if ("V".equals(subject)) {
                lte = new LetterTriggerEvent(type, LetterTrigger.CategoryType.VETERAN_LETTER);
            }
        }
        if (lte == null) {
            lte = new LetterTriggerEvent(type);
        }
        if (this.isCompassionLetter(type.getCode()) || this.isIVMFinalLetter(type.getCode())) {
            this.updateLetterTriggerEventForCms(lte);
        }
        lte.setMailType(mailType);
        this.addTriggerEvent(lte);
    }

    private Address getMailingAddress() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getMailingAddress() : null;
    }

    private boolean isAddressType(AddressType.Code addressType, Address address) {
        return address != null ? address.getType().getCode().equals(addressType.getName()) : false;
    }

    private CommsLogEntry getCommsLogEntry() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getCommsLogEntry() : null;
    }

    private CommsLogEntry getResultCommsLogEntry() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getResultCommsLogEntry() : null;
    }

    private HandBookMailQueue getHandbookMailQueue() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getHandbookMailQueue() : null;
    }

    private HandBookMailQueue getResultHandbookMailQueue() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getResultHandbookMailQueue() : null;
    }

    private CommsLogEntry getPristineCommsLogEntry() {
        return this.getCommsInputData() != null ? this.getCommsInputData().getPristineCommsLogEntry() : null;
    }

    private PersonSignatureInputData getPersonSignatureInputData() {
        if (this.getRuleDataAware() instanceof PersonSignatureInputData) {
            return (PersonSignatureInputData)this.getRuleDataAware();
        }
        return null;
    }

    private String getCommsStatus(CommsLogEntry entry) {
        MailingStatusLink mailStatusLink = entry.getLatestMailingStatus();
        ComMailingStatusType latestStatus = mailStatusLink != null ? mailStatusLink.getMailingStatus() : null;
        return latestStatus != null ? latestStatus.getCode() : null;
    }

    private boolean hasLetterFormBeenPreviouslyMailed(ComLetterTemplateType type) throws RuleException {
        if (type == null) {
            return false;
        }
        List logs = null;
        if (this.getCommsInputData() != null && this.getCommsInputData().getCommsLogEntries() != null) {
            logs = this.getCommsInputData().getCommsLogEntries();
        } else {
            try {
                logs = this.getCommsLogService().findLogEntriesByPersonId(this.getIncomingPerson().getEntityKey().getKeyValueAsString());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get CommsLog", (Throwable)e);
            }
        }
        if (logs != null && logs.size() > 0) {
            for (CommsLogEntry log : logs) {
                String code;
                if (!type.getCode().equals(log.getFormNumber())) continue;
                MailingStatusLink msl = log.getLatestMailingStatus();
                String string = code = msl != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null;
                if (ComMailingStatusType.SEND_TO_AAC.getName().equals(code) || ComMailingStatusType.SENT_TO_AAC.getName().equals(code) || ComMailingStatusType.SEND_TO_CMS.getName().equals(code) || ComMailingStatusType.SENT_TO_CMS.getName().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasCompassionLetterBeenPreviouslyMailed(String letter) throws RuleException {
        ComLetterTemplateType type = this.getComLetterTemplateType(letter);
        if (type == null || !ComLetterTemplateType.FORM_NUMBER_683A.getCode().equals(letter)) {
            return false;
        }
        List logs = null;
        if (this.getCommsInputData() != null && this.getCommsInputData().getCommsLogEntries() != null) {
            logs = this.getCommsInputData().getCommsLogEntries();
        } else {
            try {
                logs = this.getCommsLogService().findLogEntriesByPersonId(this.getIncomingPerson().getEntityKey().getKeyValueAsString());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get CommsLog", (Throwable)e);
            }
        }
        if (logs != null && logs.size() > 0) {
            for (CommsLogEntry log : logs) {
                String code;
                if (!type.getCode().equals(log.getFormNumber())) continue;
                MailingStatusLink msl = log.getLatestMailingStatus();
                String string = code = msl != null && msl.getMailingStatus() != null ? msl.getMailingStatus().getCode() : null;
                if (!ComMailingStatusType.MAILED_BY_CMS.getName().equals(code) && !ComMailingStatusType.SENT_TO_CMS.getName().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    private ComLetterTemplateType getComLetterTemplateType(String type) throws RuleException {
        if (type != null) {
            try {
                return this.getLookupService().getComLetterTemplateTypeByCode(type);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get com letter template type", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void trigger290SSNValidationLetter() throws RuleException {
        this.triggerAutoLetter(this.getComLetterTemplateType(ComLetterTemplateType.FORM_NUMBER_290.getName()), this.getSubject());
    }

    @Override
    public void triggerInconsistantOEFOIFCombatEpisodeData(VAFacility facilitySendingMessage) throws RuleException {
        this.triggerInconsistantOEFOIFCombatEpisodeData("", facilitySendingMessage);
    }

    @Override
    public void triggerInconsistantOEFOIFCombatEpisodeData(String dfn, VAFacility facilitySendingMessage) throws RuleException {
        Person pristine = this.getResultPerson();
        MilitaryService ms = pristine.getMilitaryService();
        Set combatEpisodes = ms.getCombatEpisodes();
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.INCONS_CONFLICT_DATA_FROM_SITE);
        bte.addField("SITE", facilitySendingMessage == null ? SPACE : facilitySendingMessage.getStationNumber());
        StringBuffer messageBody = new StringBuffer();
        if (combatEpisodes != null && combatEpisodes.size() > 0) {
            for (CombatEpisode episode : combatEpisodes) {
                String location = episode.getConflictLocation() == null ? "" : episode.getConflictLocation().getName();
                String startDate = this.formatImpreciseDate(episode.getStartDate());
                String endDate = this.formatImpreciseDate(episode.getEndDate());
                String source = episode.getOEFOIFSource() == null ? SPACE : episode.getOEFOIFSource().getName();
                messageBody.append(this.formatString(location, 30));
                messageBody.append(this.formatString(startDate, 20));
                messageBody.append(this.formatString(endDate, 20));
                messageBody.append(this.formatString(source, 30));
                messageBody.append(NEW_LINE);
            }
        } else {
            messageBody.append("None");
            messageBody.append(NEW_LINE);
        }
        bte.addField("OEIFEpisodes", messageBody.toString());
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerAppointmentConversionCompleteBulletin() throws RuleException {
    }

    @Override
    public String getMailingAddressTypeCode() {
        Address address = this.getMailingAddress();
        return address != null && address.getType() != null ? address.getType().getCode() : null;
    }

    private String formatString(String str, int length) {
        if (str == null || str.length() == 0) {
            return EMPTY_LINE.substring(0, length);
        }
        if (str.length() >= length) {
            return str;
        }
        return str + EMPTY_LINE.substring(0, length - str.length());
    }

    private String formatImpreciseDate(ImpreciseDate date) {
        if (date == null) {
            return SPACE;
        }
        if (date.isPrecise()) {
            return DateUtils.format((Date)date.getDate(), (String)"MM/dd/yyyy");
        }
        return date.toStandardFormat();
    }

    private List getCommsLogs(Person person) throws RuleException {
        List logs = null;
        if (this.getCommsInputData() != null && this.getCommsInputData().getCommsLogEntries() != null) {
            logs = this.getCommsInputData().getCommsLogEntries();
        } else if (person != null) {
            try {
                logs = this.getCommsLogService().findLogEntriesByPersonId(person.getEntityKey().getKeyValueAsString());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get CommsLog", (Throwable)e);
            }
        }
        return logs;
    }

    @Override
    public void triggerVOASpinalCordBulletin() throws RuleException {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.VOA_SPINAL_CORD_INJURY);
        bte.addField("VPID", this.getIncomingPerson().getVPIDEntityKey().getKeyValueAsString());
        if (this.getDfn() != null) {
            bte.addField("DFN", this.getDfn());
        }
        bte.addField("StationNumber", VAFacility.CODE_MHV.getCode());
        bte.addField("PreferredFacility", this.getIncomingPerson().getMostRecentPreferredFacility().getCode());
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerHandBookMail(String type) throws RuleException {
        if (this.getBaseData() != null && this.getBaseData().isReviewOnly()) {
            return;
        }
        ComLetterTemplateType tmeplate = this.getComLetterTemplateType(type);
        LetterTriggerEvent lte = null;
        if (lte == null) {
            lte = new LetterTriggerEvent(tmeplate);
        }
        lte.setMailType(LetterTriggerEvent.AUTO_MAIL);
        this.addTriggerEvent(lte);
    }

    @Override
    public boolean has400HSendBefore(Person person) throws RuleException {
        try {
            List logs = this.getHandBookService().findHandbookEntriesInSendSatusByPersonId(new BigDecimal(person.getEntityKey().getKeyValueAsString()), null);
            if (logs.size() > 0) {
                return true;
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("error in finding if 400Hsend before:" + e.getStackTrace()));
            throw new RuleException("error in finding if 400Hsend before:", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean hasAny400HTriggerdBefore(Person person) throws RuleException {
        try {
            List logs = this.getHandBookService().findAnyHandbookSentOrMailedForPersonId(person.getEntityKey().getKeyValueAsString());
            if (logs.size() > 0) {
                return true;
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("error in finding if any 400H triggered before:" + e.getStackTrace()));
            throw new RuleException("error in finding if any 400H triggered before:", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isLastHandBookReturnPost(Person person) throws RuleException {
        try {
            List logs = this.getHandBookService().lastHandbookReturnPostOffice(person.getPersonEntityKey().getKeyValueAsString());
            if (logs.size() > 0) {
                return true;
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to find last handbook return by post office", (Throwable)e);
        }
        return false;
    }

    @Override
    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    @Override
    public boolean isPristinePensionInd() {
        return this.getPensionInd(this.getPristinePerson());
    }

    @Override
    public boolean isUpdatedPensionInd() {
        return this.getPensionInd(this.getResultPerson());
    }

    @Override
    public boolean isUpdatedAAInd() {
        return this.getAAInd(this.getResultPerson());
    }

    @Override
    public boolean isUpdatedHBInd() {
        return this.getHBInd(this.getResultPerson());
    }

    private boolean getPensionInd(Person person) {
        MonetaryBenefit mb;
        boolean pensionInd = false;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        MonetaryBenefit monetaryBenefit = mb = mba != null ? person.getMonetaryBenefitAward().getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION) : null;
        if (mb != null && mb.getMonetaryBenefitIndicator() != null && mb.getMonetaryBenefitIndicator().getCode().equals(Indicator.YES.getCode())) {
            pensionInd = true;
        }
        return pensionInd;
    }

    private boolean getAAInd(Person person) {
        MonetaryBenefit mb;
        boolean aaInd = false;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        MonetaryBenefit monetaryBenefit = mb = mba != null ? person.getMonetaryBenefitAward().getMonetaryBenefitByType(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE) : null;
        if (mb != null && mb.getMonetaryBenefitIndicator() != null && mb.getMonetaryBenefitIndicator().getCode().equals(Indicator.YES.getCode())) {
            aaInd = true;
        }
        return aaInd;
    }

    private boolean getHBInd(Person person) {
        MonetaryBenefit mb;
        boolean hbInd = false;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        MonetaryBenefit monetaryBenefit = mb = mba != null ? person.getMonetaryBenefitAward().getMonetaryBenefitByType(MonetaryBenefitType.CODE_HOUSEBOUND) : null;
        if (mb != null && mb.getMonetaryBenefitIndicator() != null && mb.getMonetaryBenefitIndicator().getCode().equals(Indicator.YES.getCode())) {
            hbInd = true;
        }
        return hbInd;
    }

    private boolean isPristinePrimEligCodeEqualsType(String eligType) {
        String code;
        boolean eligCodeIsEqual = false;
        EligibilityType type = this.getPristinePerson().getEnrollmentDetermination().getPrimaryEligibility().getType();
        String string = code = type == null ? null : type.getCode();
        if (code != null && code.equals(eligType)) {
            eligCodeIsEqual = true;
        }
        return eligCodeIsEqual;
    }

    @Override
    public boolean isPristinePrimEligCodeNSC() {
        if (this.getPristinePerson().getEnrollmentDetermination() != null && this.getPristinePerson().getEnrollmentDetermination().getPrimaryEligibility() != null) {
            return this.isPristinePrimEligCodeEqualsType(EligibilityType.NSC.getCode());
        }
        return false;
    }

    @Override
    public boolean isPristinePrimEligCodeNSCVAPension() {
        if (this.getPristinePerson().getEnrollmentDetermination() != null && this.getPristinePerson().getEnrollmentDetermination().getPrimaryEligibility() != null) {
            return this.isPristinePrimEligCodeEqualsType(EligibilityType.NSC_VA_PENSION.getCode());
        }
        return false;
    }

    @Override
    public boolean isPristinePrimEligCodeLess100() {
        return this.getPristinePerson().getEnrollmentDetermination() != null && this.getPristinePerson().getEnrollmentDetermination().getPrimaryEligibility() != null && (this.isPristinePrimEligCodeEqualsType(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode()) || this.isPristinePrimEligCodeEqualsType(EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getCode()));
    }

    @Override
    public boolean isPristinePrimEligCodeHB() {
        if (this.getPristinePerson().getEnrollmentDetermination() != null && this.getPristinePerson().getEnrollmentDetermination().getPrimaryEligibility() != null) {
            return this.isPristinePrimEligCodeEqualsType(EligibilityType.HOUSEBOUND.getCode());
        }
        return false;
    }

    @Override
    public boolean isPristinePrimEligCodeAA() {
        if (this.getPristinePerson().getEnrollmentDetermination() != null && this.getPristinePerson().getEnrollmentDetermination().getPrimaryEligibility() != null) {
            return this.isPristinePrimEligCodeEqualsType(EligibilityType.AID_AND_ATTENDANCE.getCode());
        }
        return false;
    }

    @Override
    public void triggerVAPensionToAABulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_VA_PENSION_TO_AA);
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerSCVAPensionTerminateBulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_SC_VA_PENSION_TERMINATE);
        this.addTriggerEvent(bte);
        bte.addField("XX", this.getPercentage(this.getResultPerson()));
    }

    @Override
    public void triggerNSCVAPensionTerminateBulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_NSC_VA_PENSION_TERMINATE);
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerVAPensionToHBBulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_VA_PENSION_TO_HB);
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerSCToVAPensionBulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_SC_TO_VA_PENSION);
        this.addTriggerEvent(bte);
    }

    @Override
    public void triggerNSCToVAPensionBulletin() {
        BulletinTriggerEvent bte = new BulletinTriggerEvent(BulletinTrigger.DataType.HEC_NOTIFY_NSC_TO_VA_PENSION);
        this.addTriggerEvent(bte);
    }

    private int getPercentage(Person person) {
        int percent = 0;
        if (person.getServiceConnectionAward() != null && person.getServiceConnectionAward().getServiceConnectedPercentage() != null) {
            percent = person.getServiceConnectionAward().getServiceConnectedPercentage();
        }
        return percent;
    }

    @Override
    public boolean isProcessingHandbook() {
        return this.getCommsInputData().isProcessingHandbook();
    }

    @Override
    public void retriggerHandbookForReturnedOrRejected() throws RuleException {
        try {
            if (this.hasHandBookInSendStatus(ComLetterTemplateType.FORM_NUMBER_400H.getCode())) {
                return;
            }
            CommsTemplate origRequestTemplate = this.getHandbookMailQueue().getTemplate();
            String origFormNumber = null;
            if (origRequestTemplate != null) {
                origFormNumber = origRequestTemplate.getCommsTemplateFormNumber();
            }
            if (ComLetterTemplateType.FORM_NUMBER_400H.getCode().equals(origFormNumber)) {
                this.retrigger400H();
            } else if (ComLetterTemplateType.FORM_NUMBER_400B.getCode().equals(origFormNumber)) {
                this.retrigger400B();
            } else if (ComLetterTemplateType.FORM_NUMBER_400F.getCode().equals(origFormNumber)) {
                this.retrigger400F();
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("Error in retriggerHandbookForReturnedOrRejected:" + e.getStackTrace()));
            throw new RuleException("Error in retriggerHandbookForReturnedOrRejected:", (Throwable)e);
        }
    }

    @Override
    public void updateMVIOfDODChanges() throws ServiceException, RuleException {
        this.sendDodUpdateToMVI();
    }

    @Override
    public void updateMVIOfVerifiedDODChanges() throws ServiceException, RuleException {
        if (this.getIncomingPerson().getDeathRecord().getDodVerifiedInd() != null && this.getIncomingPerson().getDeathRecord().getDodVerifiedInd().booleanValue()) {
            this.sendDodUpdateToMVI();
        }
    }

    private void sendDodUpdateToMVI() throws RuleException {
        ProcessTriggerEvent pte = new ProcessTriggerEvent("triggerEvent.updateMVIofDod", this.getPersonId());
        this.addTriggerEvent(pte);
    }

    private boolean hasHandBookInSendStatus(String formNumber) throws ServiceException {
        ComLetterTemplateType templateType = this.getLookupService().getComLetterTemplateTypeByCode(formNumber);
        List pastHandbookList = this.handBookService.findHandbookEntriesInSendToCMSByPersonByTemp(this.getIncomingPerson(), templateType);
        return pastHandbookList != null && !pastHandbookList.isEmpty();
    }

    private void retrigger400H() throws ServiceException, RuleException {
        this.cancelHandbookInSendStatus(ComLetterTemplateType.FORM_NUMBER_400B.getCode());
        this.cancelHandbookInSendStatus(ComLetterTemplateType.FORM_NUMBER_400F.getCode());
        this.triggerHandBookMail(ComLetterTemplateType.FORM_NUMBER_400H.getName());
    }

    private void cancelHandbookInSendStatus(String formNumber) throws ServiceException {
        ComLetterTemplateType templateType = this.getLookupService().getComLetterTemplateTypeByCode(formNumber);
        List pastHandBookList = this.handBookService.findHandbookEntriesInSendToCMSByPersonByTemp(this.getIncomingPerson(), templateType);
        if (pastHandBookList != null && !pastHandBookList.isEmpty()) {
            HandBookMailQueue mailQueue = (HandBookMailQueue)((Object)pastHandBookList.iterator().next());
            HandBookMailStatusType cancelByHEC = (HandBookMailStatusType)this.getLookupService().getByCode(HandBookMailStatusType.class, HandBookMailStatusType.CANCEL_BY_HEC);
            this.handBookService.saveHandbookMailStatus(mailQueue, cancelByHEC);
        }
    }

    private void retrigger400B() throws ServiceException, RuleException {
        if (this.hasHandBookInSendStatus(ComLetterTemplateType.FORM_NUMBER_400B.getCode())) {
            return;
        }
        this.triggerHandBookMail(ComLetterTemplateType.FORM_NUMBER_400B.getName());
    }

    private void retrigger400F() throws ServiceException, RuleException {
        if (this.hasHandBookInSendStatus(ComLetterTemplateType.FORM_NUMBER_400F.getCode())) {
            return;
        }
        this.triggerHandBookMail(ComLetterTemplateType.FORM_NUMBER_400F.getName());
    }

    private boolean isIVMFinalLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_400.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_450.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_451.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_452.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_453.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_454.getCode()) || form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_455.getCode());
    }

    private boolean isCompassionLetter(String form) {
        return form.equalsIgnoreCase(ComLetterTemplateType.FORM_NUMBER_683A.getCode());
    }

    private void updateLetterTriggerEventForCms(LetterTriggerEvent lte) {
        IVMFinancialInfo info;
        IVMFinancialInfo iVMFinancialInfo = info = this.getCommsInputData() != null ? this.getCommsInputData().getIvmFinancialInfo() : null;
        if (info != null) {
            lte.setIvmCaseClosureDate(info.getIvmCaseClosureDate());
            lte.setIvmCaseNumber(info.getIvmCaseNumber());
        }
    }
}

