/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.rule.FinancialInfoInput;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.rule.data.FinancialInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.rule.parameter.MTTotalIncomePresentAndFinancialStmtIncomeNullException;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public abstract class AbstractFinancialInputParameter
extends BaseParameter
implements FinancialInfoInput {
    private static final long serialVersionUID = -1370346746640850300L;
    protected static final BigDecimal ZERO_AMOUNT = new BigDecimal(0);
    private int spousalSupportLimit = 600;
    private Relationship.Code[] childRelationships = null;
    private ExpenseType.Code[] childExpenseTypes = null;
    private ExpenseType.Code[] veteranExpenseTypes = null;
    private Integer numberOfDependentChildren = null;
    private Integer numberOfDependents = null;
    private BigDecimal calculatedTotalIncome = null;
    private BigDecimal calculatedNetIncome = null;
    private BigDecimal calculatedNetIncomeForCE = null;
    private BigDecimal calculatedDeductibleExpense = null;
    private BigDecimal calculatedNetworth = null;
    private BigDecimal calculatedIncomeExclusionThreshold = null;
    private BigDecimal calculatedPensionThreshold = null;
    private BigDecimal calculatedMedicalExpense = null;
    private BigDecimal calculatedAdjustableMedicalExpense = null;
    private FinancialsHelperService financialsHelperService = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.financialsHelperService, (String)"FinancialHelperService is required.");
        Validate.notNull((Object)this.childRelationships, (String)"Child Relationship array (Relationship.Code[]) is required.");
        Validate.notNull((Object)this.childExpenseTypes, (String)"Child Expense types array is required.");
        Validate.notNull((Object)this.veteranExpenseTypes, (String)"Veteran Expense types array is required.");
    }

    public void throwMTTotalIncomePresentAndFinancialStmtIncomeNullException() throws MTTotalIncomePresentAndFinancialStmtIncomeNullException {
        throw new MTTotalIncomePresentAndFinancialStmtIncomeNullException("MT total income present and financial statement income is null.");
    }

    public BigDecimal getIncomingIncomeTestTotalIncome() {
        return this.getIncomingIncomeTest() != null ? this.getIncomingIncomeTest().getTotalIncome() : null;
    }

    public boolean isIncomingVeteranIncomeNull() {
        FinancialStatement incomingFS = this.getIncomingFinancialStatement();
        return incomingFS == null ? true : incomingFS.getIncome().isEmpty();
    }

    public boolean isIncomingVeteranSpouseIncomeNull() {
        FinancialStatement incomingFS = this.getIncomingFinancialStatement();
        if (incomingFS != null) {
            for (SpouseFinancials sf : incomingFS.getSpouseFinancials()) {
                if (sf == null || sf.getIncome().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isIncomingVeteranDependantsIncomeNull() {
        FinancialStatement incomingFS = this.getIncomingFinancialStatement();
        if (incomingFS != null) {
            for (DependentFinancials df : incomingFS.getDependentFinancials()) {
                if (df == null || df.getIncome().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public Boolean getDisclosure(IncomeTest test) {
        if (test != null) {
            return test.getDiscloseFinancialInformation();
        }
        return null;
    }

    public Boolean getAgreeToPayIndicator(IncomeTest test) {
        if (test == null) {
            return null;
        }
        return test.getAgreesToPayDeductible();
    }

    protected void setIncomeAmount(FinancialInformation finInfo, IncomeType.Code typeCode, BigDecimal amount) {
        IncomeType incomeType = this.getIncomeType(typeCode);
        this.setIncomeAmount(finInfo, incomeType, amount);
    }

    protected void setAssetAmount(FinancialInformation finInfo, AssetType.Code typeCode, BigDecimal amount) {
        AssetType assetType = this.getAssetType(typeCode);
        this.setAssetAmount(finInfo, assetType, amount);
    }

    protected void setExpenseAmount(FinancialInformation finInfo, ExpenseType.Code typeCode, BigDecimal amount) {
        ExpenseType expenseType = this.getExpenseType(typeCode);
        this.setExpenseAmount(finInfo, expenseType, amount);
    }

    protected void setIncomeAmount(FinancialInformation finInfo, IncomeType incomeType, BigDecimal amount) {
        Validate.notNull((Object)((Object)finInfo), (String)"Can not set amount on NULL FinancialInformation Object.");
        Income income = finInfo.getIncome(incomeType);
        if (income == null) {
            income = new Income();
            finInfo.setIncome(incomeType, income);
        }
        income.setAmount(amount);
    }

    protected void setAssetAmount(FinancialInformation finInfo, AssetType assetType, BigDecimal amount) {
        Validate.notNull((Object)((Object)finInfo), (String)"Can not set amount on NULL FinancialInformation Object.");
        Asset asset = finInfo.getAsset(assetType);
        if (asset == null) {
            asset = new Asset();
            finInfo.setAsset(assetType, asset);
        }
        asset.setAmount(amount);
    }

    protected void setExpenseAmount(FinancialInformation finInfo, ExpenseType expenseType, BigDecimal amount) {
        Validate.notNull((Object)((Object)finInfo), (String)"Can not set amount on NULL FinancialInformation Object.");
        Expense expense = finInfo.getExpense(expenseType);
        if (expense == null) {
            expense = new Expense();
            finInfo.setExpense(expenseType, expense);
        }
        expense.setAmount(amount);
    }

    protected BigDecimal getIncomeAmount(FinancialInformation finInfo, IncomeType.Code typeCode) {
        if (finInfo == null || typeCode == null) {
            return null;
        }
        Income income = finInfo.getIncome(typeCode);
        return income != null ? income.getAmount() : null;
    }

    protected BigDecimal getExpenseAmount(FinancialInformation finInfo, ExpenseType.Code typeCode) {
        if (finInfo == null || typeCode == null) {
            return null;
        }
        Expense expense = finInfo.getExpense(typeCode);
        return expense != null ? expense.getAmount() : null;
    }

    protected BigDecimal getAssetAmount(FinancialInformation finInfo, AssetType.Code typeCode) {
        if (finInfo == null || typeCode == null) {
            return null;
        }
        Asset asset = finInfo.getAsset(typeCode);
        return asset != null ? asset.getAmount() : null;
    }

    protected ExpenseType getExpenseType(ExpenseType.Code typeCode) {
        try {
            return this.getLookupService().getExpenseTypeByCode(typeCode.getName());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid Expense type code specified");
        }
    }

    protected IncomeType getIncomeType(IncomeType.Code typeCode) {
        try {
            return this.getLookupService().getIncomeTypeByCode(typeCode.getName());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid Income type code specified");
        }
    }

    protected AssetType getAssetType(AssetType.Code typeCode) {
        try {
            return this.getLookupService().getAssetTypeByCode(typeCode.getName());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid Asset type code specified");
        }
    }

    public String getMeansTestStatusCode(IncomeTest incomeTest, IncomeTestType.Code testType) {
        MeansTestStatus status = this.getMeansTestStatus(incomeTest, testType);
        return status == null ? null : status.getCode();
    }

    public String getDeterminedStatusCode(IncomeTest incomeTest, IncomeTestType.Code testType) {
        MeansTestStatus status = this.getDeterminedStatus(incomeTest, testType);
        return status == null ? null : status.getCode();
    }

    public MeansTestStatus getDeterminedStatus(IncomeTest incomeTest, IncomeTestType.Code testType) {
        IncomeTestStatus status = this.getIncomeTestStatus(incomeTest, testType);
        return status == null ? null : status.getDeterminedStatus();
    }

    public MeansTestStatus getMeansTestStatus(IncomeTest incomeTest, IncomeTestType.Code testType) {
        IncomeTestStatus status = this.getIncomeTestStatus(incomeTest, testType);
        return status == null ? null : status.getStatus();
    }

    protected IncomeTestStatus getIncomeTestStatus(IncomeTest incomeTest, IncomeTestType.Code testType) {
        IncomeTestStatus status = null;
        if (incomeTest != null && testType != null) {
            status = IncomeTest.getIncomeTestStatusOfType(incomeTest.getStatuses(), testType);
        }
        return status;
    }

    public Date getEffectiveTestDate(IncomeTest iTest) {
        return iTest != null ? iTest.getEffectiveDate() : null;
    }

    protected void setDebtInfo(FinancialInformation finInfo, Debt debt) {
        if (debt != null) {
            this.setDebtAmount(finInfo, debt.getAmount());
        }
    }

    protected void setDebtAmount(FinancialInformation finInfo, BigDecimal amount) {
        Validate.notNull((Object)((Object)finInfo), (String)"Can not set amount on NULL FinancialInformation Object.");
        Debt debt = finInfo.getDebt();
        if (debt == null) {
            debt = new Debt();
            finInfo.setDebt(debt);
        }
        debt.setAmount(amount);
    }

    protected void setAssetInfo(FinancialInformation finInfo, Collection assets) {
        if (assets != null) {
            for (Asset asset : assets) {
                this.setAssetAmount(finInfo, asset.getType(), asset.getAmount());
            }
        }
    }

    protected void setIncomeInfo(FinancialInformation finInfo, Collection incomes) {
        if (incomes != null) {
            for (Income income : incomes) {
                this.setIncomeAmount(finInfo, income.getType(), income.getAmount());
            }
        }
    }

    protected void setExpenseInfo(FinancialInformation finInfo, Collection expenses) {
        if (expenses != null) {
            for (Expense expense : expenses) {
                this.setExpenseAmount(finInfo, expense.getType(), expense.getAmount());
            }
        }
    }

    protected FinancialStatement getOrCreateFinancialStatement() {
        Integer incomeYear = this.getIncomingFinancialStatement().getIncomeYear();
        FinancialStatement rStmt = this.getResultPerson().getFinancialStatement(incomeYear);
        if (rStmt == null) {
            rStmt = new FinancialStatement();
            this.getResultPerson().setFinancialStatement(incomeYear, rStmt);
        }
        return rStmt;
    }

    protected IncomeTest getOrCreateIncomeTest() {
        Integer incomeYear = this.getIncomingIncomeYear();
        IncomeTest rIncomeTest = this.getResultPerson().getIncomeTest(incomeYear);
        if (rIncomeTest == null) {
            rIncomeTest = new IncomeTest();
            rIncomeTest.setIncomeYear(incomeYear);
            this.getResultPerson().setIncomeTest(incomeYear, rIncomeTest);
        }
        return rIncomeTest;
    }

    public FinancialStatement getPristineFinancialStatement() {
        return this.getFinancialStatement(this.getPristinePerson(), this.getIncomingIncomeYear());
    }

    public FinancialStatement getIncomingFinancialStatement() {
        return this.getFinancialStatement(this.getIncomingPerson(), this.getIncomingIncomeYear());
    }

    @Override
    public FinancialStatement getFinancialStatement(Person person, Integer incomeYear) {
        if (person != null && incomeYear != null) {
            return person.getFinancialStatement(incomeYear);
        }
        return null;
    }

    @Override
    public IncomeTest getIncomeTest(Person person, Integer incomeYear) {
        if (person != null && incomeYear != null) {
            return person.getIncomeTest(incomeYear);
        }
        return null;
    }

    public IncomeTest getPristineIncomeTest() {
        Integer year;
        RuleDataAware data = this.getRuleDataAware();
        if (data != null && data instanceof BaseData && (year = ((BaseData)data).getIncomeYearForCurrentTest()) != null) {
            return this.getPriorIncomeTest(this.getPristinePerson(), year);
        }
        return this.getIncomeTest(this.getPristinePerson(), this.getIncomingIncomeYear());
    }

    public IncomeTest getIncomingIncomeTest() {
        Integer incomeYear = this.getIncomingIncomeYear();
        if (incomeYear != null) {
            return this.getIncomeTest(this.getIncomingPerson(), this.getIncomingIncomeYear());
        }
        return this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
    }

    @Override
    public Integer getIncomingIncomeYear() {
        IncomeTest test;
        FinancialInputData data = this.getFinancialInputData();
        if (data != null) {
            return data.getIncomingIncomeYear();
        }
        RuleDataAware rda = this.getRuleDataAware();
        if (rda instanceof EventInputData) {
            Integer incomeYear = ((EventInputData)rda).getIncomeYear();
            IncomeTest current = null;
            if (incomeYear != null) {
                current = this.getIncomingPerson().getIncomeTest(incomeYear);
            }
            if (current != null) {
                return current.getIncomeYear();
            }
            current = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
            return current != null ? current.getIncomeYear() : null;
        }
        if ((rda instanceof EEInputData || rda instanceof CommsInputData) && (test = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson())) != null) {
            return test.getIncomeYear();
        }
        return null;
    }

    protected VAFacility getSourceFacility() {
        FinancialInputData data = this.getFinancialInputData();
        if (data != null) {
            return data.getSourceFacility();
        }
        return null;
    }

    protected FinancialInputData getFinancialInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof FinancialInputData) {
            return (FinancialInputData)ruleDataAware;
        }
        return null;
    }

    protected String getRelationGivenName(Relation relation) {
        return relation != null && relation.getName() != null ? relation.getName().getGivenName() : null;
    }

    protected String getRelationFamilyName(Relation relation) {
        return relation != null && relation.getName() != null ? relation.getName().getFamilyName() : null;
    }

    protected String getRelationSSN(Relation relation) {
        SSN ssn = relation != null ? relation.getOfficialSsn() : null;
        return ssn == null ? null : ssn.getFormattedSsnText();
    }

    protected boolean isRelationSSNUsed(RelationFinancials relFins) {
        String relSSN;
        if (relFins == null) {
            return false;
        }
        String string = relSSN = relFins instanceof SpouseFinancials ? this.getRelationSSN(((SpouseFinancials)relFins).getReportedOn()) : this.getRelationSSN(((DependentFinancials)relFins).getReportedOn());
        if (StringUtils.isEmpty((String)relSSN)) {
            return false;
        }
        FinancialStatement finStmt = relFins.getFinancialStatement();
        if (finStmt == null) {
            return false;
        }
        for (SpouseFinancials spouseFin : finStmt.getSpouseFinancials()) {
            if (spouseFin.equals((Object)relFins) || !StringUtils.equals((String)relSSN, (String)this.getRelationSSN(spouseFin.getReportedOn()))) continue;
            return true;
        }
        for (DependentFinancials depFin : finStmt.getDependentFinancials()) {
            if (relFins.equals((Object)depFin) || !StringUtils.equals((String)relSSN, (String)this.getRelationSSN(depFin.getReportedOn()))) continue;
            return true;
        }
        return false;
    }

    protected Date getRelationEffectiveDate(Relation relation) {
        ImpreciseDate startImpDate;
        ImpreciseDate impreciseDate = startImpDate = relation != null ? relation.getStartDate() : null;
        if (startImpDate != null) {
            return ImpreciseDateUtils.getDateWithDefault(startImpDate);
        }
        return null;
    }

    protected Date getRelationBirthDate(Relation relation) {
        if (relation != null) {
            return ImpreciseDateUtils.getDateWithDefault(relation.getDob());
        }
        return null;
    }

    protected Date getRelationInActiveDate(Relation relation) {
        return relation != null ? relation.getEndDate() : null;
    }

    public boolean isEquals(Date date1, Date date2) {
        return date1 != null && date2 != null && date1.equals(date2);
    }

    public boolean isEquals(Boolean obj1, Boolean obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    @Override
    public Date getLatest(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return date1.before(date2) ? date2 : date1;
        }
        return date1 != null ? date1 : date2;
    }

    @Override
    public Date getEarliest(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return date1.after(date2) ? date2 : date1;
        }
        return date1 != null ? date1 : date2;
    }

    @Override
    public boolean isEarlier(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return date1.before(date2);
        }
        return date1 != null;
    }

    protected String getLookupCode(Lookup lookup) {
        return lookup == null ? null : lookup.getCode();
    }

    protected boolean isIncomeInRange(Collection incomes, double lower, double upper) {
        boolean valid = true;
        if (incomes != null && !incomes.isEmpty()) {
            Iterator iter = incomes.iterator();
            while (valid && iter.hasNext()) {
                Income income = (Income)((Object)iter.next());
                valid = income == null ? true : this.isInRange(income.getAmount(), lower, upper);
            }
        }
        return valid;
    }

    protected boolean isExpenseInRange(Collection expenses, double lower, double upper) {
        boolean valid = true;
        if (expenses != null && !expenses.isEmpty()) {
            Iterator iter = expenses.iterator();
            while (valid && iter.hasNext()) {
                Expense expense = (Expense)((Object)iter.next());
                valid = expense == null ? true : this.isInRange(expense.getAmount(), lower, upper);
            }
        }
        return valid;
    }

    protected boolean isAssetInRange(Collection assets, double lower, double upper) {
        boolean valid = true;
        if (assets != null && !assets.isEmpty()) {
            Iterator iter = assets.iterator();
            while (valid && iter.hasNext()) {
                Asset asset = (Asset)((Object)iter.next());
                valid = asset == null ? true : this.isInRange(asset.getAmount(), lower, upper);
            }
        }
        return valid;
    }

    public BigDecimal getCalculatedIncomeExclusionThreshold() throws ServiceException {
        if (this.calculatedIncomeExclusionThreshold == null) {
            this.calculatedIncomeExclusionThreshold = this.determineIncomeExclusionThreshold(this.getIncomingIncomeYear());
        }
        return this.calculatedIncomeExclusionThreshold;
    }

    protected BigDecimal determineIncomeExclusionThreshold(Integer incomeYear) throws ServiceException {
        IncomeThreshold it = this.getLookupService().getIncomeThreshold(incomeYear);
        BigDecimal threshold = it == null ? ZERO_AMOUNT : it.getChildIncomeExclusion();
        return threshold == null ? ZERO_AMOUNT : threshold;
    }

    public BigDecimal getCalculatedPensionThreshold() throws ServiceException {
        if (this.calculatedPensionThreshold == null) {
            IncomeTest test = this.getIncomingIncomeTest();
            this.calculatedPensionThreshold = this.determinePensionThreshold(test.getIncomeYear(), this.getCalculatedNumberOfDependents());
        }
        return this.calculatedPensionThreshold;
    }

    private BigDecimal determinePensionThreshold(Integer incomeYear, Integer dependentCount) throws ServiceException {
        if (incomeYear == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal pensionThreshold = new BigDecimal(0);
        IncomeThreshold it = this.getLookupService().getIncomeThreshold(incomeYear);
        if (it != null && dependentCount != null) {
            int count = dependentCount;
            if (count == 0) {
                pensionThreshold = this.getNotNull(it.getPensionThreshold());
            } else if (count > 0) {
                pensionThreshold = this.getNotNull(it.getPension1Dependent());
            }
            for (int i = 1; i < count; ++i) {
                pensionThreshold = pensionThreshold.add(this.getNotNull(it.getAddDependentPension()));
            }
        }
        return pensionThreshold;
    }

    public BigDecimal getCalculatedNonReimbursedMedicalExpense() throws ServiceException {
        if (this.calculatedMedicalExpense == null) {
            IncomeTest test = this.getIncomingIncomeTest();
            FinancialStatement stmt = this.getIncomingFinancialStatement();
            this.calculatedMedicalExpense = this.determineNonReimbursedMedicalExpense(test, stmt);
        }
        return this.calculatedMedicalExpense;
    }

    public BigDecimal getCalculatedAdjustableMedicalExpense() throws ServiceException {
        if (this.calculatedAdjustableMedicalExpense == null) {
            FinancialStatement stmt = this.getIncomingFinancialStatement();
            this.calculatedAdjustableMedicalExpense = this.determineAdjustableMedicalExpense(stmt);
        }
        return this.calculatedAdjustableMedicalExpense;
    }

    private BigDecimal determineAdjustableMedicalExpense(FinancialStatement stmt) throws ServiceException {
        BigDecimal medExpClaimed;
        ExpenseType.Code expenseType = ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL;
        if (this.isMessageFromVOA()) {
            expenseType = ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL;
        }
        if ((medExpClaimed = this.getExpenseAmount(stmt, expenseType)) == null) {
            return ZERO_AMOUNT;
        }
        Integer prevYear = new Integer(stmt.getIncomeYear() - 1);
        BigDecimal pensionThreshold = this.determinePensionThreshold(prevYear, this.getCalculatedNumberOfDependents());
        BigDecimal deductibleAmount = pensionThreshold.multiply(this.getMedicalDeductionRate(prevYear));
        if (medExpClaimed.compareTo(deductibleAmount) > 0) {
            return medExpClaimed.subtract(deductibleAmount);
        }
        return ZERO_AMOUNT;
    }

    private BigDecimal determineNonReimbursedMedicalExpense(IncomeTest incomeTest, FinancialStatement stmt) throws ServiceException {
        BigDecimal adjustedMedExp = this.getExpenseAmount(stmt, ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL);
        if (adjustedMedExp == null || adjustedMedExp.intValue() == 0) {
            return ZERO_AMOUNT;
        }
        if (incomeTest == null) {
            return adjustedMedExp;
        }
        Integer prevYear = new Integer(stmt.getIncomeYear() - 1);
        Integer dependents = this.getNotNull(incomeTest.getTotalNumberOfDependents());
        BigDecimal pensionThreshold = this.determinePensionThreshold(prevYear, dependents);
        BigDecimal deductibleAmount = pensionThreshold.multiply(this.getMedicalDeductionRate(prevYear));
        return adjustedMedExp.add(deductibleAmount);
    }

    protected BigDecimal calculateTotalIncome(FinancialStatement stmt) throws ServiceException {
        BigDecimal totalIncome = this.getTotalIncome(stmt);
        for (SpouseFinancials sf : stmt.getSpouseFinancials()) {
            if (!this.isSpouseIncomeAllowed(sf)) continue;
            totalIncome = totalIncome.add(this.getTotalIncome(sf));
        }
        for (DependentFinancials df : stmt.getDependentFinancials()) {
            if (!this.isChildIncomeAllowed(df)) continue;
            totalIncome = totalIncome.add(this.getTotalIncome(df));
        }
        return totalIncome;
    }

    protected BigDecimal calculateNetIncome(FinancialStatement stmt) throws ServiceException {
        if (stmt == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal totalIncome = this.calculateVeteranNetIncome(stmt);
        for (SpouseFinancials sf : stmt.getSpouseFinancials()) {
            totalIncome = totalIncome.add(this.calculateSpouseNetIncome(sf));
        }
        for (DependentFinancials df : stmt.getDependentFinancials()) {
            if (!this.isChildIncomeAllowed(df)) continue;
            totalIncome = totalIncome.add(this.calculateChildNetIncome(df));
        }
        if (totalIncome.intValue() < 0) {
            totalIncome = ZERO_AMOUNT;
        }
        return totalIncome;
    }

    protected BigDecimal calculateNetIncomeForCE(IncomeTest test) throws ServiceException {
        BigDecimal result = new BigDecimal(0);
        if (test != null) {
            BigDecimal netIncome = test.getNetIncome();
            if (netIncome != null) {
                result = netIncome;
            } else {
                BigDecimal totalIncome = test.getTotalIncome();
                BigDecimal deductableExpenses = test.getDeductibleExpenses();
                if (totalIncome != null && deductableExpenses != null) {
                    result = this.isGreaterThan(totalIncome, deductableExpenses) ? totalIncome.subtract(deductableExpenses) : new BigDecimal(0);
                } else if (totalIncome != null) {
                    result = totalIncome;
                }
            }
        }
        return result;
    }

    protected BigDecimal getTotalIncome(FinancialStatement stmt, IncomeType.Code incomeType) throws ServiceException {
        BigDecimal totalIncome = new BigDecimal(0.0);
        BigDecimal veteranIncome = this.getIncomeAmount(stmt, incomeType);
        if (veteranIncome != null) {
            totalIncome = totalIncome.add(veteranIncome);
        }
        for (SpouseFinancials sf : stmt.getSpouseFinancials()) {
            BigDecimal spouseIncome;
            if (!this.isSpouseIncomeAllowed(sf) || (spouseIncome = this.getIncomeAmount(sf, incomeType)) == null) continue;
            totalIncome = totalIncome.add(spouseIncome);
        }
        for (DependentFinancials df : stmt.getDependentFinancials()) {
            BigDecimal depIncome;
            if (!this.isChildIncomeAllowed(df) || (depIncome = this.getIncomeAmount(df, incomeType)) == null) continue;
            totalIncome = totalIncome.add(depIncome);
        }
        if (totalIncome.intValue() < 0) {
            totalIncome = ZERO_AMOUNT;
        }
        return totalIncome;
    }

    private BigDecimal calculateDeductibleExpense(FinancialStatement stmt) throws ServiceException {
        BigDecimal totalExpenses = this.calculateVeteranExpenses(stmt);
        for (DependentFinancials df : stmt.getDependentFinancials()) {
            if (!this.isChildIncomeAllowed(df)) continue;
            totalExpenses = totalExpenses.add(this.calculateChildExpenses(df));
        }
        return totalExpenses;
    }

    private BigDecimal calculateChildExpenses(DependentFinancials df) throws ServiceException {
        BigDecimal childIncomeExcThreshold;
        BigDecimal childExpense = new BigDecimal(0.0);
        BigDecimal childEmpIncome = this.getTotalEmploymentIncome(df);
        if (childEmpIncome.compareTo(childIncomeExcThreshold = this.getCalculatedIncomeExclusionThreshold()) > 0) {
            BigDecimal childEducationExpense = this.getTotalExpenses(df, this.codeToStringArray(this.childExpenseTypes));
            BigDecimal adjustedIncome = childEmpIncome.subtract(childIncomeExcThreshold);
            childExpense = childExpense.add(childIncomeExcThreshold);
            childExpense = childExpense.add(childEducationExpense.compareTo(adjustedIncome) > 0 ? adjustedIncome : childEducationExpense);
        } else {
            childExpense = childExpense.add(childEmpIncome);
        }
        return childExpense;
    }

    private BigDecimal calculateVeteranNetIncome(FinancialStatement stmt) throws ServiceException {
        BigDecimal totalIncome = this.getTotalIncome(stmt);
        BigDecimal totalExpenses = this.calculateVeteranExpenses(stmt);
        return totalIncome.subtract(totalExpenses);
    }

    private BigDecimal calculateVeteranExpenses(FinancialStatement stmt) throws ServiceException {
        BigDecimal adjustedMedExpenses = this.determineAdjustableMedicalExpense(stmt);
        BigDecimal otherExpenses = this.getTotalExpenses(stmt, this.codeToStringArray(this.veteranExpenseTypes));
        return otherExpenses.add(adjustedMedExpenses);
    }

    private BigDecimal calculateSpouseNetIncome(SpouseFinancials sf) {
        if (this.isSpouseIncomeAllowed(sf)) {
            return this.getTotalIncome(sf);
        }
        return ZERO_AMOUNT;
    }

    private BigDecimal calculateChildNetIncome(DependentFinancials df) throws ServiceException {
        BigDecimal childIncome = this.getTotalIncome(df).subtract(this.getTotalEmploymentIncome(df));
        BigDecimal calculatedEmpIncome = this.calculateChildEmploymentIncome(df);
        childIncome = childIncome.add(calculatedEmpIncome);
        return childIncome;
    }

    private BigDecimal calculateChildEmploymentIncome(DependentFinancials df) throws ServiceException {
        BigDecimal childExpenses;
        BigDecimal adjustedIncome;
        BigDecimal childIncomeExcThreshold;
        BigDecimal childEmpIncome = this.getTotalEmploymentIncome(df);
        if (childEmpIncome.compareTo(childIncomeExcThreshold = this.getCalculatedIncomeExclusionThreshold()) > 0 && (adjustedIncome = childEmpIncome.subtract(childIncomeExcThreshold)).compareTo(childExpenses = this.getTotalExpenses(df, this.codeToStringArray(this.childExpenseTypes))) > 0) {
            return adjustedIncome.subtract(childExpenses);
        }
        return ZERO_AMOUNT;
    }

    private boolean isSpouseIncomeAllowed(SpouseFinancials sf) {
        return sf != null && this.isSpouseValidDependent(sf);
    }

    private boolean isChildIncomeAllowed(DependentFinancials df) {
        return df != null && this.isDependentValidDependent(df) && Boolean.TRUE.equals(df.getIncomeAvailableToPatient());
    }

    protected BigDecimal getNetworth(FinancialInformation finInfo) {
        if (finInfo == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal assetsAmount = this.getTotalAssets(finInfo);
        BigDecimal debtAmount = this.getTotalDebt(finInfo);
        return assetsAmount.subtract(debtAmount);
    }

    protected BigDecimal calculateNetworth(FinancialStatement stmt) {
        if (stmt == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal networth = this.getNetworth(stmt);
        for (SpouseFinancials sf : stmt.getSpouseFinancials()) {
            if (!this.isSpouseIncomeAllowed(sf)) continue;
            networth = networth.add(this.getNetworth(sf));
        }
        for (DependentFinancials df : stmt.getDependentFinancials()) {
            if (df == null || !this.isDependentValidDependent(df)) continue;
            networth = networth.add(this.getTotalAssets(df));
        }
        return networth;
    }

    protected BigDecimal getTotalExpenses(FinancialInformation finInfo, String[] expenseTypes) {
        if (finInfo == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal totalExpenses = new BigDecimal(0);
        for (Expense expense : finInfo.getExpenses().values()) {
            if (!StringUtils.contains((String[])expenseTypes, (String)expense.getType().getCode()) || expense.getAmount() == null) continue;
            totalExpenses = totalExpenses.add(expense.getAmount());
        }
        return totalExpenses;
    }

    protected BigDecimal getTotalIncome(FinancialInformation finInfo) {
        if (finInfo == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal totalIncome = new BigDecimal(0);
        for (Income income : finInfo.getIncome().values()) {
            if (income.getAmount() == null) continue;
            totalIncome = totalIncome.add(income.getAmount());
        }
        return totalIncome;
    }

    protected BigDecimal getTotalIncome(FinancialInformation finInfo, String[] incomeTypes) {
        if (finInfo == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal totalIncome = new BigDecimal(0);
        for (Income income : finInfo.getIncome().values()) {
            if (!StringUtils.contains((String[])incomeTypes, (String)income.getType().getCode()) || income.getAmount() == null) continue;
            totalIncome = totalIncome.add(income.getAmount());
        }
        return totalIncome;
    }

    protected BigDecimal getTotalAssets(FinancialInformation finInfo) {
        if (finInfo == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal totalAssets = new BigDecimal(0);
        for (Asset asset : finInfo.getAssets().values()) {
            if (asset.getAmount() == null) continue;
            totalAssets = totalAssets.add(asset.getAmount());
        }
        return totalAssets;
    }

    protected BigDecimal getTotalDebt(FinancialInformation finInfo) {
        if (finInfo == null) {
            return ZERO_AMOUNT;
        }
        Debt debt = finInfo.getDebt();
        return debt == null || debt.getAmount() == null ? ZERO_AMOUNT : debt.getAmount();
    }

    protected boolean isValidDependent(RelationFinancials rf) {
        if (rf instanceof DependentFinancials) {
            return this.isDependentValidDependent((DependentFinancials)rf);
        }
        if (rf instanceof SpouseFinancials) {
            return this.isSpouseValidDependent((SpouseFinancials)rf);
        }
        return false;
    }

    public boolean isDependentValidDependent(DependentFinancials df) {
        if (df == null) {
            return false;
        }
        Relationship relationship = df.getReportedOn().getRelationship();
        String rs = relationship == null ? null : relationship.getCode();
        boolean contributed = Boolean.TRUE.equals(df.getContributedToSupport());
        return this.isActiveRelation(df.getReportedOn()) && StringUtils.contains((String[])this.codeToStringArray(this.childRelationships), (String)rs) && (Boolean.TRUE.equals(df.getLivedWithPatient()) || contributed);
    }

    public boolean isSpouseValidDependent(SpouseFinancials sf) {
        if (sf == null) {
            return false;
        }
        FinancialStatement stmt = sf.getFinancialStatement();
        int sfCount = stmt.getSpouseFinancials().size();
        if (sfCount == 1 || sfCount > 1 && sf.getReportedOn().getEndDate() == null) {
            if (stmt.getContributedToSpouseInd() != null) {
                boolean contributed = stmt.getContributedToSpouseInd();
                boolean isActiveRelationFlag = this.isActiveRelation(sf.getReportedOn());
                Boolean livedWithPatient = sf.getLivedWithPatient();
                Boolean marriedLastCalendarYear = sf.getFinancialStatement().getMarriedLastCalendarYear();
                return isActiveRelationFlag && (contributed && Boolean.FALSE.equals(livedWithPatient) && Boolean.TRUE.equals(marriedLastCalendarYear) || Boolean.TRUE.equals(marriedLastCalendarYear) && Boolean.TRUE.equals(livedWithPatient));
            }
            boolean contributed = stmt.getContributionToSpouse() != null && stmt.getContributionToSpouse().intValue() >= this.spousalSupportLimit;
            return this.isActiveRelation(sf.getReportedOn()) && (contributed && Boolean.FALSE.equals(sf.getLivedWithPatient()) && Boolean.TRUE.equals(sf.getFinancialStatement().getMarriedLastCalendarYear()) || Boolean.TRUE.equals(sf.getFinancialStatement().getMarriedLastCalendarYear()) && Boolean.TRUE.equals(sf.getLivedWithPatient()));
        }
        return false;
    }

    public boolean isActiveRelation(Relation relation) {
        return this.getFinancialsHelperService().isActiveRelation(relation, this.getIncomingIncomeYear());
    }

    protected void countDependents(FinancialStatement stmt) {
        if (stmt == null) {
            return;
        }
        int dependentCount = 0;
        Set dfSet = stmt.getDependentFinancials();
        for (DependentFinancials df : dfSet) {
            if (!this.isDependentValidDependent(df)) continue;
            ++dependentCount;
        }
        this.numberOfDependentChildren = new Integer(dependentCount);
        Set spSet = stmt.getSpouseFinancials();
        for (SpouseFinancials sf : spSet) {
            if (!this.isSpouseValidDependent(sf)) continue;
            ++dependentCount;
        }
        this.numberOfDependents = new Integer(dependentCount);
    }

    public Integer getCalculatedNumberOfDependentChildren() {
        if (this.numberOfDependentChildren == null) {
            this.countDependents(this.getIncomingFinancialStatement());
        }
        return this.numberOfDependentChildren;
    }

    public Integer getCalculatedNumberOfDependents() {
        if (this.numberOfDependents == null) {
            this.countDependents(this.getIncomingFinancialStatement());
        }
        return this.numberOfDependents;
    }

    public BigDecimal getCalculatedTotalIncome() throws ServiceException {
        if (this.calculatedTotalIncome == null) {
            this.calculatedTotalIncome = this.calculateTotalIncome(this.getIncomingFinancialStatement());
            if (this.isMessageFromVOA() && this.getCalculatedDeductibleExpense() != null && this.getCalculatedDeductibleExpense().compareTo(this.calculatedTotalIncome) > 0) {
                this.calculatedTotalIncome = new BigDecimal("0");
            }
        }
        return this.calculatedTotalIncome;
    }

    public BigDecimal getCalculatedNetIncome() throws ServiceException {
        if (this.calculatedNetIncome == null) {
            this.calculatedNetIncome = this.calculateNetIncome(this.getIncomingFinancialStatement());
        }
        this.logger.debug((Object)("calculatedNetIncome: " + this.calculatedNetIncome));
        return this.calculatedNetIncome;
    }

    public BigDecimal getCalculatedNetIncomeForCE() throws ServiceException {
        if (this.calculatedNetIncomeForCE == null) {
            IncomeTest test = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
            this.calculatedNetIncomeForCE = this.calculateNetIncomeForCE(test);
        }
        this.logger.debug((Object)("calculatedNetIncomeForCE: " + this.calculatedNetIncomeForCE));
        return this.calculatedNetIncomeForCE;
    }

    public BigDecimal getCalculatedDeductibleExpense() throws ServiceException {
        if (this.calculatedDeductibleExpense == null) {
            FinancialStatement stmt = this.getIncomingFinancialStatement();
            this.calculatedDeductibleExpense = this.calculateDeductibleExpense(stmt);
        }
        return this.calculatedDeductibleExpense;
    }

    public BigDecimal getCalculatedNetworth() {
        if (this.calculatedNetworth == null) {
            this.calculatedNetworth = this.calculateNetworth(this.getIncomingFinancialStatement());
        }
        return this.calculatedNetworth;
    }

    private BigDecimal getTotalEmploymentIncome(FinancialInformation finInfo) {
        Income totalEmpIncome = finInfo == null ? null : finInfo.getTotalEmploymentIncome();
        BigDecimal totalEmpIncomeAmount = this.getNotNull(totalEmpIncome == null ? null : totalEmpIncome.getAmount());
        return totalEmpIncomeAmount;
    }

    protected BigDecimal getNotNull(BigDecimal bd) {
        return bd == null ? new BigDecimal(0) : bd;
    }

    protected Integer getNotNull(Integer bd) {
        return bd == null ? new Integer(0) : bd;
    }

    protected BigDecimal convert(Integer intValue) {
        return intValue == null ? new BigDecimal(0) : new BigDecimal(intValue);
    }

    protected Boolean getNotNull(Boolean value) {
        return value == null ? Boolean.FALSE : value;
    }

    private String[] codeToStringArray(AbstractCode[] codes) {
        if (codes == null || codes.length == 0) {
            return new String[0];
        }
        String[] strArray = new String[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            strArray[i] = codes[i].getName();
        }
        return strArray;
    }

    public int getSpousalSupportLimit() {
        return this.spousalSupportLimit;
    }

    public void setSpousalSupportLimit(int spousalSupportLimit) {
        this.spousalSupportLimit = spousalSupportLimit;
    }

    public Relationship.Code[] getChildRelationships() {
        return this.childRelationships;
    }

    public void setChildRelationships(Relationship.Code[] childRelationships) {
        this.childRelationships = childRelationships;
    }

    public ExpenseType.Code[] getChildExpenseTypes() {
        return this.childExpenseTypes;
    }

    public void setChildExpenseTypes(ExpenseType.Code[] childExpenseTypes) {
        this.childExpenseTypes = childExpenseTypes;
    }

    public ExpenseType.Code[] getVeteranExpenseTypes() {
        return this.veteranExpenseTypes;
    }

    public void setVeteranExpenseTypes(ExpenseType.Code[] veteranExpenseTypes) {
        this.veteranExpenseTypes = veteranExpenseTypes;
    }

    public BigDecimal getMedicalDeductionRate(Integer incomeYear) throws ServiceException {
        IncomeThreshold it = this.getLookupService().getIncomeThreshold(incomeYear);
        if (it == null) {
            return ZERO_AMOUNT;
        }
        BigDecimal medExpRate = this.getNotNull(it.getMedicalExpenseDeductible());
        if (medExpRate.doubleValue() > 0.0) {
            return new BigDecimal(Double.toString(medExpRate.doubleValue() / 100.0));
        }
        return medExpRate;
    }

    public FinancialsHelperService getFinancialsHelperService() {
        return this.financialsHelperService;
    }

    public void setFinancialsHelperService(FinancialsHelperService financialsHelperService) {
        this.financialsHelperService = financialsHelperService;
    }

    private IncomeTest getPriorIncomeTest(Person person, Integer currentIncomeYear) {
        if (currentIncomeYear == null) {
            return null;
        }
        Map incomeTests = person.getIncomeTests();
        ArrayList incomeYears = new ArrayList(incomeTests.keySet());
        if (incomeYears == null || incomeYears.isEmpty()) {
            return null;
        }
        Collections.sort(incomeYears);
        for (int i = incomeYears.size() - 1; i >= 0; --i) {
            Integer incomeYear = (Integer)incomeYears.get(i);
            if (incomeYear == null || incomeYear.compareTo(currentIncomeYear) >= 0) continue;
            return person.getIncomeTest(incomeYear);
        }
        return null;
    }

    public IncomeTest getIncomingIncludingFutureIncomeTest() {
        Integer incomeYear = this.getIncomingIncludingFutureIncomeYear();
        if (incomeYear != null) {
            return this.getIncomeTest(this.getIncomingPerson(), this.getIncomingIncludingFutureIncomeYear());
        }
        return this.getHelperService().getCurrentOrFutureIncomeTest(this.getIncomingPerson(), this.getPristinePerson());
    }

    public Integer getIncomingIncludingFutureIncomeYear() {
        IncomeTest test;
        FinancialInputData data = this.getFinancialInputData();
        if (data != null) {
            return data.getIncomingIncomeYear();
        }
        RuleDataAware rda = this.getRuleDataAware();
        if (rda instanceof EventInputData) {
            Integer incomeYear = ((EventInputData)rda).getIncomeYear();
            IncomeTest current = null;
            if (incomeYear != null) {
                current = this.getIncomingPerson().getIncomeTest(incomeYear);
            }
            if (current != null) {
                return current.getIncomeYear();
            }
            current = this.getHelperService().getCurrentOrFutureIncomeTest(this.getIncomingPerson(), this.getPristinePerson());
            return current != null ? current.getIncomeYear() : null;
        }
        if ((rda instanceof EEInputData || rda instanceof CommsInputData) && (test = this.getHelperService().getCurrentOrFutureIncomeTest(this.getIncomingPerson(), this.getPristinePerson())) != null) {
            return test.getIncomeYear();
        }
        return null;
    }
}

