/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportPeriod;
import gov.va.med.esr.common.model.report.ReportSchedule;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.ParamSubstitutionDAOImpl;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.Query;
import org.hibernate.Session;

public class MSTReportDataDAOImpl
extends ParamSubstitutionDAOImpl {
    private static final long serialVersionUID = -6627321528592452046L;
    public static final int VPID = 0;
    public static final int STATUS = 1;
    public static final int STATUS_DATE = 2;
    public static final int GENDER_CODE = 3;
    private static final MilitarySexualTraumaStatus.Code[] statusCodes = new MilitarySexualTraumaStatus.Code[]{MilitarySexualTraumaStatus.CODE_SCREENED_DECLINES_TO_ANSWER, MilitarySexualTraumaStatus.CODE_SCREENED_DOES_NOT_REPORT_MST, MilitarySexualTraumaStatus.CODE_SCREENED_REPORTS_MST, MilitarySexualTraumaStatus.CODE_UNKNOWN_NOT_SCREENED};

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup.getParameterSet();
            ReportPeriod period = parameters.getReportPeriod();
            ReportPeriodType reportPeriodType = period.getType();
            criteria.setStartDate(this.getDate(config, true));
            criteria.setEndDate(this.getDate(config, false));
            criteria.setReportPeriodType(reportPeriodType.getDescription().toUpperCase());
            criteria.setReportPeriodTypeCode(reportPeriodType.getCode());
            Integer year = period.getYear();
            if (year != null) {
                criteria.setReportPeriod("As of " + year);
            } else {
                DateFormat df = DateFormat.getDateInstance(2);
                criteria.setReportPeriod("As of " + df.format(this.getDate(config, false)));
            }
        }
    }

    public List postDataRetrieval(List results, ReportConfiguration config) throws ReportDataException {
        Collection<String> vpids = new HashSet();
        ArrayList reportData = new ArrayList();
        try {
            TreeMap data = new TreeMap();
            Map genders = null;
            Map statuses = null;
            vpids = null;
            for (Object[] objectArray : results) {
                String vpid = (String)objectArray[0];
                String status = (String)objectArray[1];
                String period = this.getPeriod((Date)objectArray[2], config);
                String genderCode = (String)objectArray[3];
                if (genderCode == null) {
                    genderCode = Gender.UNKNOWN.getCode();
                }
                if (!data.containsKey(period)) {
                    statuses = new TreeMap();
                    data.put(period, statuses);
                } else {
                    statuses = (Map)data.get(period);
                }
                if (!statuses.containsKey(status)) {
                    genders = new TreeMap();
                    statuses.put(status, genders);
                } else {
                    genders = (Map)statuses.get(status);
                }
                if (!genders.containsKey(genderCode)) {
                    vpids = new HashSet();
                    genders.put(genderCode, vpids);
                } else {
                    vpids = (Collection)genders.get(genderCode);
                }
                vpids.add(vpid);
            }
            for (Map.Entry entry : data.entrySet()) {
                String period = (String)entry.getKey();
                statuses = (TreeMap)entry.getValue();
                for (Map.Entry status_entry : statuses.entrySet()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("status", status_entry.getKey());
                    genders = (TreeMap)status_entry.getValue();
                    vpids = (Set)genders.get(Gender.MALE.getName());
                    int male = vpids != null ? vpids.size() : 0;
                    row.put("male", new Integer(male));
                    vpids = (Set)genders.get(Gender.FEMALE.getName());
                    int female = vpids != null ? vpids.size() : 0;
                    row.put("female", new Integer(female));
                    vpids = (Set)genders.get(Gender.OTHER.getName());
                    int other = vpids != null ? vpids.size() : 0;
                    row.put("other", new Integer(other));
                    vpids = (Set)genders.get(Gender.UNKNOWN.getName());
                    int unknown = vpids != null ? vpids.size() : 0;
                    row.put("unknown", new Integer(unknown));
                    int subtotal = male + female + other + unknown;
                    row.put("subtotal", new Integer(subtotal));
                    double percentage = (double)subtotal / (double)this.getTotalVetsByPeriod(statuses);
                    row.put("percentage", new Double(percentage));
                    row.put("period", period);
                    String desc = this.getLookupDescription(MilitarySexualTraumaStatus.CODE_SCREENED_REPORTS_MST);
                    row.putAll(this.getPercentageOfScreenedVetsByPeriod(statuses, desc, "positive"));
                    desc = this.getLookupDescription(MilitarySexualTraumaStatus.CODE_SCREENED_DOES_NOT_REPORT_MST);
                    row.putAll(this.getPercentageOfScreenedVetsByPeriod(statuses, desc, "negative"));
                    reportData.add(row);
                }
            }
            this.processGrandTotal(data, reportData, config);
        }
        catch (ServiceException e) {
            throw new ReportDataException("Failed to get report data", (Throwable)e);
        }
        return reportData;
    }

    protected String getLookupDescription(AbstractCode code) throws ServiceException {
        MilitarySexualTraumaStatus status = this.lookupService.getMilitarySexualTraumaStatusByCode(code.getName());
        return status != null ? status.getDescription() : null;
    }

    protected String getPeriod(Date statusDate, ReportConfiguration config) {
        String period = null;
        String code = (String)config.getResourceMapping().get("Type_Code");
        if (ReportPeriodType.CODE_ALL_FISCAL_YEARS.getCode().equals(code)) {
            period = String.valueOf(DateUtils.getFiscalYear((Date)statusDate));
        } else if (ReportPeriodType.CODE_FISCAL_YEAR.getCode().equals(code) || ReportPeriodType.CODE_QUARTERLY.getCode().equals(code)) {
            period = DateUtils.getQuarterAsString((Date)statusDate) + ": " + DateUtils.getQuarterDateRangeAsString((Date)statusDate);
        } else if (ReportPeriodType.CODE_DATE_RANGE.getCode().equals(code)) {
            DateFormat df = DateFormat.getDateInstance(2);
            Date startDate = (Date)config.getResourceMapping().get("startDate");
            Date endDate = (Date)config.getResourceMapping().get("endDate");
            period = df.format(startDate) + " - " + df.format(endDate);
        }
        return period;
    }

    protected Map getPercentageOfScreenedVetsByPeriod(Map data, String desc, String codeValue) {
        HashMap<String, Double> row = new HashMap<String, Double>();
        Map status = (Map)data.get(desc);
        Gender.Code gender = Gender.MALE;
        Set vets = status != null ? (Set)status.get(gender.getName()) : null;
        int subtotal = vets != null ? vets.size() : 0;
        double percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetByGenderAndPeriod(data, gender) : 0.0;
        row.put("male_" + codeValue, new Double(percentage));
        gender = Gender.FEMALE;
        vets = status != null ? (Set)status.get(gender.getName()) : null;
        subtotal = vets != null ? vets.size() : 0;
        percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetByGenderAndPeriod(data, gender) : 0.0;
        row.put("female_" + codeValue, new Double(percentage));
        gender = Gender.OTHER;
        vets = status != null ? (Set)status.get(gender.getName()) : null;
        subtotal = vets != null ? vets.size() : 0;
        percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetByGenderAndPeriod(data, gender) : 0.0;
        row.put("other_" + codeValue, new Double(percentage));
        gender = Gender.UNKNOWN;
        vets = status != null ? (Set)status.get(gender.getName()) : null;
        subtotal = vets != null ? vets.size() : 0;
        percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetByGenderAndPeriod(data, gender) : 0.0;
        row.put("unknown_" + codeValue, new Double(percentage));
        return row;
    }

    protected void processGrandTotal(Map data, Collection reportData, ReportConfiguration config) throws ServiceException {
        if (data.size() > 1) {
            String period = ((TreeMap)data).firstKey() + " - " + ((TreeMap)data).lastKey();
            String code = (String)config.getResourceMapping().get("Type_Code");
            if (ReportPeriodType.CODE_FISCAL_YEAR.getCode().equals(code)) {
                Date startDate = (Date)config.getResourceMapping().get("startDate");
                period = "Fiscal Year " + String.valueOf(DateUtils.getFiscalYear((Date)startDate));
            }
            int total = this.getTotalVets(data);
            for (int i = 0; i < statusCodes.length; ++i) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("status", this.getLookupDescription(statusCodes[i]));
                int male = this.getTotalVetsByGenderAndStatus(data, statusCodes[i], Gender.MALE);
                row.put("male", new Integer(male));
                int female = this.getTotalVetsByGenderAndStatus(data, statusCodes[i], Gender.FEMALE);
                row.put("female", new Integer(female));
                int other = this.getTotalVetsByGenderAndStatus(data, statusCodes[i], Gender.OTHER);
                row.put("other", new Integer(other));
                int unknown = this.getTotalVetsByGenderAndStatus(data, statusCodes[i], Gender.UNKNOWN);
                row.put("unknown", new Integer(unknown));
                int subtotal = male + female + other + unknown;
                row.put("subtotal", new Integer(subtotal));
                double percentage = (double)subtotal / (double)total;
                row.put("percentage", new Double(percentage));
                row.put("period", period);
                row.putAll(this.getPercentageOfScreenedVets(data, MilitarySexualTraumaStatus.CODE_SCREENED_REPORTS_MST, "positive"));
                row.putAll(this.getPercentageOfScreenedVets(data, MilitarySexualTraumaStatus.CODE_SCREENED_DOES_NOT_REPORT_MST, "negative"));
                reportData.add(row);
            }
        }
    }

    protected Map getPercentageOfScreenedVets(Map data, MilitarySexualTraumaStatus.Code code, String codeValue) throws ServiceException {
        HashMap<String, Double> row = new HashMap<String, Double>();
        int subtotal = this.getTotalVetsByGenderAndStatus(data, code, Gender.MALE);
        double percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetsByGender(data, Gender.MALE) : 0.0;
        row.put("male_" + codeValue, new Double(percentage));
        subtotal = this.getTotalVetsByGenderAndStatus(data, code, Gender.FEMALE);
        percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetsByGender(data, Gender.FEMALE) : 0.0;
        row.put("female_" + codeValue, new Double(percentage));
        subtotal = this.getTotalVetsByGenderAndStatus(data, code, Gender.OTHER);
        percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetsByGender(data, Gender.OTHER) : 0.0;
        row.put("other_" + codeValue, new Double(percentage));
        subtotal = this.getTotalVetsByGenderAndStatus(data, code, Gender.UNKNOWN);
        percentage = subtotal > 0 ? (double)subtotal / (double)this.getTotalVetsByGender(data, Gender.UNKNOWN) : 0.0;
        row.put("unknown_" + codeValue, new Double(percentage));
        return row;
    }

    protected int getTotalVetByGenderAndPeriod(Map data, AbstractCode code) {
        int total = 0;
        for (Map.Entry entry : data.entrySet()) {
            Object value = entry.getValue();
            Map genders = (Map)value;
            Collection vets = (Collection)genders.get(code.getName());
            total += vets != null ? vets.size() : 0;
        }
        return total;
    }

    protected int getTotalVetsByPeriod(Map data) {
        int total = 0;
        for (Map.Entry entry : data.entrySet()) {
            Map genders = (Map)entry.getValue();
            for (Map.Entry e : genders.entrySet()) {
                Object value = e.getValue();
                total += value instanceof Collection ? ((Collection)value).size() : 0;
            }
        }
        return total;
    }

    protected int getTotalVets(Map data) {
        int total = 0;
        for (Map.Entry entry : data.entrySet()) {
            total += this.getTotalVetsByPeriod((Map)entry.getValue());
        }
        return total;
    }

    protected int getTotalVetsByGenderAndStatus(Map data, MilitarySexualTraumaStatus.Code statusCode, Gender.Code genderCode) throws ServiceException {
        int total = 0;
        for (Map.Entry entry : data.entrySet()) {
            Map statuses = (Map)entry.getValue();
            Map genders = (Map)statuses.get(this.getLookupDescription(statusCode));
            if (genders == null) continue;
            Collection vets = (Collection)genders.get(genderCode.getName());
            total += vets != null ? vets.size() : 0;
        }
        return total;
    }

    protected int getTotalVetsByGender(Map data, Gender.Code genderCode) {
        int total = 0;
        for (Map.Entry entry : data.entrySet()) {
            Map statuses = (Map)entry.getValue();
            for (Map.Entry e : statuses.entrySet()) {
                Map genders = (Map)e.getValue();
                Collection vets = (Collection)genders.get(genderCode.getName());
                total += vets != null ? vets.size() : 0;
            }
        }
        return total;
    }

    @Override
    protected Date getDate(ReportConfiguration config, boolean isStartDate) {
        Date date = null;
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            String frequency;
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup.getParameterSet();
            ReportPeriod period = parameters.getReportPeriod();
            ReportPeriodType reportPeriodType = period.getType();
            String reportPeriod = reportPeriodType.getCode();
            ReportSchedule schedule = setup != null ? setup.getSchedule() : null;
            String string = frequency = schedule != null ? schedule.getRunFrequency().getCode() : null;
            if (frequency != null && !ReportRunFrequency.OTHER.getCode().equals(frequency)) {
                return super.getDate(config, isStartDate);
            }
            if (ReportPeriodType.CODE_ALL_FISCAL_YEARS.getCode().equals(reportPeriod)) {
                if (isStartDate) {
                    date = DateUtils.createCalendar((int)2002, (int)10, (int)1).getTime();
                } else {
                    int year = period.getYear();
                    date = DateUtils.getFiscalYearFourthQuarter((int)year, (boolean)false).getTime();
                }
            } else if (ReportPeriodType.CODE_FISCAL_YEAR.getCode().equals(reportPeriod)) {
                int year = period.getYear();
                date = isStartDate ? DateUtils.getFiscalYearFirstQuarter((int)year, (boolean)true).getTime() : DateUtils.getFiscalYearFourthQuarter((int)year, (boolean)false).getTime();
            } else if (ReportPeriodType.CODE_QUARTERLY.getCode().equals(reportPeriod)) {
                int year = period.getYear();
                String quarter = period.getQuarter().getCode();
                date = isStartDate ? DateUtils.getFiscalYearQuarter((int)year, (boolean)true, (String)quarter).getTime() : DateUtils.getFiscalYearQuarter((int)year, (boolean)false, (String)quarter).getTime();
            } else if (ReportPeriodType.CODE_DATE_RANGE.getCode().equals(reportPeriod)) {
                date = isStartDate ? period.getFromDate() : period.getToDate();
            }
        }
        return date;
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        Query query = super.buildQuery(config, session);
        query.setDate("startDate", this.getDate(config, true));
        query.setDate("endDate", this.getDate(config, false));
        return query;
    }
}

