/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class IV5ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -7314500493075026550L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        ReportParameterSet parameters;
        Query query = null;
        query = this.getNamedQuery(session);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
        if (parameters == null) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID());
        }
        query.setDate("startDate", parameters.getFromDate());
        query.setDate("endDate", parameters.getToDate());
        Set reportFacilities = parameters.getFacilities();
        if (reportFacilities == null || reportFacilities.isEmpty()) {
            ArrayList<String> facilities = new ArrayList<String>();
            facilities.add("FACILITY");
            query.setParameterList("facilityNameList", facilities);
            query.setString("ALL", "ALL");
        } else {
            query.setParameterList("facilityNameList", (Collection)this.getFacilitityNameList(reportFacilities));
            query.setString("ALL", "NO");
        }
        return query;
    }

    private List getFacilitityNameList(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<String> list = new ArrayList<String>();
        String HEC = VAFacility.CODE_HEC.getCode();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null) continue;
            VAFacility facility = (VAFacility)rFacility.getLookup();
            if (HEC.equals(facility.getStationNumber())) {
                list.add("HEC-" + facility.getStationNumber());
                continue;
            }
            list.add("VAMC-" + facility.getStationNumber());
        }
        return list;
    }
}

