/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.report.ReportMessageError;
import gov.va.med.esr.common.model.report.ReportMessageType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.ParamSubstitutionDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class HL7ErrorReportDataDAOImpl
extends ParamSubstitutionDAOImpl {
    private static final long serialVersionUID = -1986182813327815652L;
    private String title = "HL7 Error Report";
    private String direction = null;
    private String queryNameAE = "hl7AEErrorReport.Summary";
    private String queryNameAR = "hl7ARErrorReport.Summary";
    private String queryNameAEandAR = "hl7AEandARErrorReport.Summary";
    private boolean summary = true;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            if (this.isSummary()) {
                StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
                ReportSetup setup = criteria.getReportSetup();
                ReportParameterSet parameters = setup != null ? setup.getParameterSet() : null;
                Set messageErrors = parameters.getMessageErrors();
                if (messageErrors.size() == 1) {
                    ReportMessageError messageErrorType = (ReportMessageError)messageErrors.iterator().next();
                    if (messageErrorType.getMessageError().getCode().equalsIgnoreCase("AE")) {
                        super.setQueryName(this.queryNameAE);
                    } else if (messageErrorType.getMessageError().getCode().equalsIgnoreCase("AR")) {
                        super.setQueryName(this.queryNameAR);
                    }
                } else if (messageErrors.size() == 2) {
                    super.setQueryName(this.queryNameAEandAR);
                }
            }
            query = super.buildQuery(config, session);
            if (this.direction != null) {
                query.setString("direction", this.direction);
            }
        }
        return query;
    }

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        StandardReportCriteria criteria;
        ReportSetup setup;
        ReportParameterSet parameters;
        Set messageTypes;
        super.preDataRetrieval(config);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria != null) {
            reportCriteria.addCriterion((Object)"Title", (Object)this.title);
        }
        if (reportCriteria instanceof StandardReportCriteria && (messageTypes = (parameters = (setup = (criteria = (StandardReportCriteria)reportCriteria).getReportSetup()) != null ? setup.getParameterSet() : null).getMessageTypes()).size() > 0) {
            ReportMessageType msgType = (ReportMessageType)messageTypes.iterator().next();
            criteria.addCriterion("messageType", msgType.getLookup().getCode());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getQueryNameAE() {
        return this.queryNameAE;
    }

    public void setQueryNameAE(String queryNameAE) {
        this.queryNameAE = queryNameAE;
    }

    public String getQueryNameAR() {
        return this.queryNameAR;
    }

    public void setQueryNameAR(String queryNameAR) {
        this.queryNameAR = queryNameAR;
    }

    public String getQueryNameAEandAR() {
        return this.queryNameAEandAR;
    }

    public void setQueryNameAEandAR(String queryNameAEandAR) {
        this.queryNameAEandAR = queryNameAEandAR;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }
}

