/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportPersonMergeStatus;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportUser;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class EED12ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = 7521588029497083337L;

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet parameters = setup.getParameterSet();
        if (reportCriteria instanceof StandardReportCriteria) {
            criteria.setStartDate(this.getDate(config, true));
            criteria.setEndDate(this.getDate(config, false));
            if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())) {
                Set personMergeStatuses = parameters.getPersonMergeStatuses();
                for (ReportPersonMergeStatus comp : personMergeStatuses) {
                    String code = comp.getPersonMergeStatus().getCode();
                    criteria.addCriterion("personMergeStatuses" + code, "Y");
                }
            }
        }
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            ArrayList<String> userIds;
            Set reportUsers;
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            if (startDate == null) {
                throw new ReportDataException("Missing Start Date in report " + config.getReportID());
            }
            Date endDate = parameters.getToDate();
            if (endDate == null) {
                throw new ReportDataException("Missing End Date in report " + config.getReportID());
            }
            query.setDate("startDate", startDate);
            query.setDate("endDate", endDate);
            if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())) {
                Set personMergeStatuses = parameters.getPersonMergeStatuses();
                Iterator iter = personMergeStatuses.iterator();
                ArrayList<String> listComps = new ArrayList<String>();
                while (iter.hasNext()) {
                    ReportPersonMergeStatus comp = (ReportPersonMergeStatus)iter.next();
                    String code = comp.getPersonMergeStatus().getCode();
                    listComps.add(code);
                }
                if (listComps.isEmpty()) {
                    listComps.add("");
                }
                query.setParameterList("personMergeStatuses", listComps);
            }
            if ((reportUsers = parameters.getUsers()) != null && !reportUsers.isEmpty()) {
                userIds = new ArrayList();
                for (ReportUser reportuser : reportUsers) {
                    String userId = reportuser.getUser().getUserCredentials().getUserID();
                    userIds.add(userId);
                }
                if (userIds.isEmpty()) {
                    userIds.add("");
                }
                query.setParameterList("recordModifiedBy", userIds);
                query.setString("is_all", "notAll");
            } else {
                userIds = new ArrayList<String>();
                userIds.add("");
                query.setParameterList("recordModifiedBy", userIds);
                query.setString("is_all", "all");
            }
        }
        return query;
    }
}

