/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportBadAddressReason;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class AddressReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -5657439440961807171L;

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        super.preDataRetrieval(config);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            criteria.setStartDate(this.getDate(config, true));
            criteria.setEndDate(this.getDate(config, false));
            String visnNames = "";
            Set visns = parameters.getFacilities();
            if (visns != null && !visns.isEmpty()) {
                ArrayList visnVistaNameList = this.getVistaNameList(parameters.getFacilities());
                visnNames = this.getItemsAsString(visnVistaNameList);
                criteria.addCriterion("visns", visnNames);
            } else {
                criteria.addCriterion("visns", "NO VISN");
            }
            if (parameters.getFileType() != null) {
                criteria.setFileType(parameters.getFileType().getCode());
            }
        }
    }

    private ArrayList getVistaNameList(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<String> vistaNameList = new ArrayList<String>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null || rFacility.getLookup() == null) continue;
            vistaNameList.add(rFacility.getFacility().getDescription());
        }
        return vistaNameList;
    }

    private String getItemsAsString(ArrayList facilities) {
        String rFacility;
        Iterator i = facilities != null ? facilities.iterator() : null;
        StringBuffer sBuf = new StringBuffer();
        if (i.hasNext()) {
            rFacility = (String)i.next();
            sBuf.append(rFacility);
        }
        while (i.hasNext()) {
            sBuf.append(", ");
            rFacility = (String)i.next();
            sBuf.append(rFacility);
        }
        return sBuf.toString();
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            Set reasons;
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            ArrayList<BigDecimal> visns = new ArrayList<BigDecimal>();
            Set facilities = parameters.getFacilities();
            if (facilities != null && !facilities.isEmpty()) {
                Iterator i = facilities.iterator();
                while (i.hasNext()) {
                    VAFacility facility = ((ReportFacility)i.next()).getFacility();
                    visns.add(facility.getIdentifier());
                }
            }
            Iterator i = (reasons = parameters.getBadAddressReasons()) != null ? reasons.iterator() : null;
            ArrayList<String> list = new ArrayList<String>();
            while (i != null && i.hasNext()) {
                ReportBadAddressReason reason = (ReportBadAddressReason)i.next();
                list.add(reason.getLookup().getCode());
            }
            Object[] codes = list.toArray();
            if (codes == null || codes.length <= 0) {
                throw new ReportDataException("Missing address reason codes in report " + config.getReportID());
            }
            if (visns.isEmpty()) {
                visns.add(new BigDecimal(-1));
            }
            query.setParameterList("visns", visns);
            query.setDate("startDate", parameters.getFromDate());
            query.setDate("endDate", parameters.getToDate());
            query.setParameterList("reason", codes);
            if (parameters.isNoVISNPresent()) {
                query.setString("noVISN", "noVISN");
            } else {
                query.setString("noVISN", "VISN");
            }
        }
        return query;
    }
}

