/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.ivmdm.IVMMigration;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.AbstractKeyedEntitySubmittedAdvice;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PersonSubmittedAdvice
extends AbstractKeyedEntitySubmittedAdvice {
    public static final String SUBMITTER_ATTENDED = "UI";
    public static final String SUBMITTER_UNATTENDED = "Unattended_Process";
    public static final String SUBMITTER_IVM_DM = "IVM_DM";
    public static final String SUBMITTER_DATA_DESTINED_FOR_HECLEGACYDATASYNC = "UI";
    public static final String[] mtStatusCodesForIVMCriteria = new String[]{MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode(), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode(), MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()};
    public static final String[] enrollmentPriorityCodesForIVMCriteria = new String[]{EnrollmentPriorityGroup.GROUP_2.getCode(), EnrollmentPriorityGroup.GROUP_3.getCode(), EnrollmentPriorityGroup.GROUP_5.getCode(), EnrollmentPriorityGroup.GROUP_6.getCode(), EnrollmentPriorityGroup.GROUP_7.getCode(), EnrollmentPriorityGroup.GROUP_8.getCode()};
    private PersonService personService;
    private PersonHelperService personHelperService;
    private IVMDMService ivmDMService;
    private EntityCacheManager entityCacheManager;

    protected final void processEntitySubmitted(AbstractKeyedEntity entity, Object[] methodArguments) throws Exception {
        if (entity instanceof Person) {
            Integer latestMigratedYear;
            boolean awaitingTx;
            boolean markedForDeleteRecordExists;
            Integer deletedYear;
            Integer incomeYear;
            Person oldPerson;
            Person updatedPerson = (Person)entity;
            PersonEntityKey key = updatedPerson.getPersonEntityKey();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Person [" + key.getKeyValue() + "] submitted by " + this.getSubmitter()));
            }
            if ((oldPerson = (Person)this.entityCacheManager.getItem(updatedPerson.getEntityKey())) == null) {
                oldPerson = this.getPersonArgumentIfAny(methodArguments);
            }
            Integer currentActiveIVMIncomeYear = this.getIvmDMService().getCurrentActiveIVMIncomeYear();
            Integer nextIVMIncomeYear = this.getIvmDMService().getNextVMIncomeYear();
            HashSet<Integer> incomeYearsInserted = new HashSet<Integer>();
            HashSet changes = new HashSet();
            IncomeTest currentIncomeTest = this.getPersonHelperService().getCurrentIncomeTest(updatedPerson);
            Integer n = incomeYear = currentIncomeTest != null ? currentIncomeTest.getIncomeYear() : null;
            if (incomeYear == null && currentActiveIVMIncomeYear != null) {
                incomeYear = currentActiveIVMIncomeYear;
            }
            Set migrations = this.getIvmDMService().findIVMMigrationsWithCompleteOrPendingStatus(updatedPerson.getPersonEntityKey());
            boolean recordAwaitingTx = this.ivmMigrationsContainStatus(migrations, MessageStatus.AWAITING_TRANSMISSION, incomeYear);
            PersonIdentityTraits traits = this.getTraits(updatedPerson, oldPerson);
            if (oldPerson == null) {
                boolean flag;
                SSASSNVerificationData data = this.getSSASSNVerificationDataArgumentIfAny(methodArguments);
                if (data != null && !recordAwaitingTx && (flag = this.satisfiesIVMSelectionCriteria(updatedPerson, incomeYear, traits))) {
                    this.insertIVMMigrationEntry(updatedPerson, incomeYear, incomeYearsInserted, false);
                }
                return;
            }
            boolean recordPreviouslyCompleted = this.ivmMigrationsContainStatus(migrations, MessageStatus.COMPLETE, incomeYear);
            boolean veteranPreviouslyQualified = migrations != null ? migrations.size() > 0 : false;
            this.checkIvmSyncChanges(changes, updatedPerson, oldPerson);
            if ((recordPreviouslyCompleted || veteranPreviouslyQualified) && updatedPerson.getChangeEvents().containsKey("INCOMETEST_DELETED") && (deletedYear = new Integer((String)updatedPerson.getChangeEvents().get("INCOMETEST_DELETED"))) != null && !(markedForDeleteRecordExists = this.ivmMigrationsContainMarkedForDelete(migrations, incomeYear))) {
                boolean deleteTheIncomeTestForThisIncomeYear = true;
                this.insertIVMMigrationEntry(updatedPerson, deletedYear, incomeYearsInserted, deleteTheIncomeTestForThisIncomeYear);
            }
            if (!recordAwaitingTx && recordPreviouslyCompleted && changes.size() > 0 && !incomeYearsInserted.contains(incomeYear)) {
                this.insertIVMMigrationEntry(updatedPerson, incomeYear, incomeYearsInserted, false);
            }
            boolean meetsIVMSelectionCriteria = this.satisfiesIVMSelectionCriteria(updatedPerson, incomeYear, traits);
            if (!(recordAwaitingTx || recordPreviouslyCompleted || incomeYear.compareTo(currentActiveIVMIncomeYear) != 0 && incomeYear.compareTo(nextIVMIncomeYear) != 0 || !meetsIVMSelectionCriteria || changes.size() <= 0 || incomeYearsInserted.contains(incomeYear))) {
                this.insertIVMMigrationEntry(updatedPerson, incomeYear, incomeYearsInserted, false);
            }
            boolean meetsIVMSelectionForCurrentIVMActiveYear = this.satisfiesIVMSelectionCriteria(updatedPerson, currentActiveIVMIncomeYear, traits);
            boolean meetsIVMSelectionForNextVMIncomeYear = this.satisfiesIVMSelectionCriteria(updatedPerson, nextIVMIncomeYear, traits);
            boolean changeToNonIYSpecificData = this.checkNonIncomeYearSpecificChanges(updatedPerson, oldPerson);
            if (changeToNonIYSpecificData) {
                boolean awaitingTxForNextIY;
                boolean awaitingTxForCurrActIY;
                if (meetsIVMSelectionForCurrentIVMActiveYear && !incomeYearsInserted.contains(currentActiveIVMIncomeYear) && !(awaitingTxForCurrActIY = this.ivmMigrationsContainStatus(migrations, MessageStatus.AWAITING_TRANSMISSION, currentActiveIVMIncomeYear))) {
                    this.insertIVMMigrationEntry(updatedPerson, currentActiveIVMIncomeYear, incomeYearsInserted, false);
                }
                if (meetsIVMSelectionForNextVMIncomeYear && !incomeYearsInserted.contains(nextIVMIncomeYear) && !(awaitingTxForNextIY = this.ivmMigrationsContainStatus(migrations, MessageStatus.AWAITING_TRANSMISSION, nextIVMIncomeYear))) {
                    this.insertIVMMigrationEntry(updatedPerson, nextIVMIncomeYear, incomeYearsInserted, false);
                }
            }
            Integer mostRecentlyTransferredIY = this.getMostRecentIVMMigratedIY(migrations);
            if (!(meetsIVMSelectionForCurrentIVMActiveYear || meetsIVMSelectionForNextVMIncomeYear || changes.size() <= 0 || mostRecentlyTransferredIY == null || incomeYearsInserted.contains(mostRecentlyTransferredIY) || (awaitingTx = this.ivmMigrationsContainStatus(migrations, MessageStatus.AWAITING_TRANSMISSION, mostRecentlyTransferredIY)))) {
                this.insertIVMMigrationEntry(updatedPerson, mostRecentlyTransferredIY, incomeYearsInserted, false);
            }
            if (mostRecentlyTransferredIY == null && changes.size() > 0 && (latestMigratedYear = this.getLatestMigratedIYForLegacyRecord(migrations)) != null && !incomeYearsInserted.contains(latestMigratedYear)) {
                this.insertIVMMigrationEntry(updatedPerson, latestMigratedYear, incomeYearsInserted, false);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Returned value is not an instance of Person (type: " + entity.getClass().getName() + "), not applying any after advice"));
        }
    }

    private boolean ivmMigrationsContainMarkedForDelete(Set data, Integer incomeYear) {
        if (incomeYear == null) {
            return false;
        }
        for (IVMMigration migration : data) {
            if (!migration.isStampped() || !incomeYear.equals(migration.getIncomeYear())) continue;
            return true;
        }
        return false;
    }

    private boolean ivmMigrationsContainStatus(Set data, MessageStatus.Code code, Integer incomeYear) {
        if (incomeYear == null) {
            return false;
        }
        for (IVMMigration migration : data) {
            if (incomeYear.compareTo(migration.getIncomeYear()) == 0 && migration.getStatus() == null && code == null) {
                return true;
            }
            if (incomeYear.compareTo(migration.getIncomeYear()) != 0 || migration.getStatus() == null || code == null || !migration.getStatus().getCode().equals(code.getCode())) continue;
            return true;
        }
        return false;
    }

    public Integer getLatestMigratedIYForLegacyRecord(Set data) {
        List sorted = this.sortIVMMigrationsByIY(data);
        for (IVMMigration migration : sorted) {
            if (migration.getStatus() != null || migration.getLoadFailureReason() != null || migration.getMigrationDate() == null || migration.getIncomeYear() == null) continue;
            return migration.getIncomeYear();
        }
        return null;
    }

    public Integer getMostRecentIVMMigratedIY(Set data) {
        List sorted = this.sortIVMMigrationsByIY(data);
        for (IVMMigration migration : sorted) {
            if (migration.getStatus() == null || !MessageStatus.COMPLETE.getCode().equals(migration.getStatus().getCode()) || migration.getMigrationDate() == null || migration.getIncomeYear() == null) continue;
            return migration.getIncomeYear();
        }
        return null;
    }

    public List sortIVMMigrationsByIY(Set data) {
        if (data == null) {
            return new ArrayList();
        }
        ArrayList d = new ArrayList(data);
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Integer iy1 = obj1 instanceof IVMMigration ? ((IVMMigration)((Object)obj1)).getIncomeYear() : null;
                Integer iy2 = obj2 instanceof IVMMigration ? ((IVMMigration)((Object)obj2)).getIncomeYear() : null;
                return iy1 != null && iy2 != null ? -iy1.compareTo(iy2) : 0;
            }
        };
        Collections.sort(d, comparator);
        return d;
    }

    private PersonIdentityTraits getTraits(Person updatedPerson, Person oldPerson) {
        PersonIdentityTraits pit = updatedPerson.getIdentityTraits();
        if (pit != null && pit.getSsn() != null && pit.getSsn().getSsaVerificationStatus() == null && oldPerson != null && oldPerson.getIdentityTraits() != null && oldPerson.getIdentityTraits().getSsn() != null && oldPerson.getIdentityTraits().getSsn().getSsaVerificationStatus() != null) {
            pit = oldPerson.getIdentityTraits();
        }
        return pit;
    }

    protected final Person getPersonArgumentIfAny(Object[] methodArguments) throws ServiceException {
        Person incomingPerson = null;
        for (int i = 0; i < methodArguments.length; ++i) {
            Object arg = methodArguments[i];
            if (!(arg instanceof Person) && !(arg instanceof PersonEntityKey)) continue;
            if (arg instanceof Person && incomingPerson == null) {
                incomingPerson = (Person)((Object)arg);
                continue;
            }
            if (arg instanceof PersonEntityKey && incomingPerson == null) {
                incomingPerson = this.personService.getPerson((PersonEntityKey)arg);
                continue;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"More than one incoming Person object, no way to know which is intended incoming");
            }
            incomingPerson = null;
            break;
        }
        return incomingPerson;
    }

    private final SSASSNVerificationData getSSASSNVerificationDataArgumentIfAny(Object[] methodArguments) throws ServiceException {
        SSASSNVerificationData data = null;
        for (int i = 0; i < methodArguments.length; ++i) {
            Object arg = methodArguments[i];
            if (!(arg instanceof SSASSNVerificationData) || data != null) continue;
            data = (SSASSNVerificationData)((Object)arg);
        }
        return data;
    }

    private final void handleUpdate(Person person, Set logs) throws ServiceException {
        this.personService.logChanges(logs);
    }

    private void checkIvmSyncChanges(Set logs, Person updatedPerson, Person oldPerson) {
        if (oldPerson == null) {
            this.logger.error((Object)"There is no incoming person to compare IVM changes. Returning without adding any entry for IVM.");
            return;
        }
        if (this.checkNonIncomeYearSpecificChanges(updatedPerson, oldPerson)) {
            logs.add(this.createPersonChangeLogEntry(updatedPerson, null));
        }
        this.checkIncomeYearSpecificChanges(logs, updatedPerson, oldPerson);
    }

    private PersonChangeLogEntry createPersonChangeLogEntry(Person person, Integer year) {
        PersonChangeLogEntry logEntry = new PersonChangeLogEntry();
        logEntry.setPersonEntityKey(CommonEntityKeyFactory.createPersonIdEntityKey(person.getPersonEntityKey().getKeyValueAsString()));
        logEntry.setSubmitterDescription(SUBMITTER_IVM_DM);
        logEntry.setSubmittedDate(new Date());
        logEntry.setIncomeYear(year);
        return logEntry;
    }

    private boolean checkNonIncomeYearSpecificChanges(Person updatedPerson, Person oldPerson) {
        MonetaryBenefitAward oldAward;
        Eligibility oldElig;
        PersonIdentityTraits traitsOld;
        if (updatedPerson.getChangeEvents().containsKey("BT_IND_CHANGE")) {
            return true;
        }
        PersonIdentityTraits traitsUpdated = updatedPerson.getIdentityTraits() != null ? updatedPerson.getIdentityTraits() : null;
        PersonIdentityTraits personIdentityTraits = traitsOld = oldPerson.getIdentityTraits() != null ? oldPerson.getIdentityTraits() : null;
        if (traitsUpdated != null && traitsOld != null && !traitsUpdated.equals((Object)traitsOld)) {
            return true;
        }
        if (updatedPerson.getChangeEvents().containsKey("CLAIMNUM") || updatedPerson.getChangeEvents().containsKey("CLAIMLOC") || updatedPerson.getChangeEvents().containsKey("EMPLOYMENT") || updatedPerson.getChangeEvents().containsKey("INCOMETEST_DELETED") || updatedPerson.getChangeEvents().containsKey("IDENTITY_TRAITS") || updatedPerson.getChangeEvents().containsKey("INSURANCE")) {
            return true;
        }
        DeathRecord updatedDeathRecord = updatedPerson.getDeathRecord();
        DeathRecord oldDeathRecord = oldPerson.getDeathRecord();
        if (updatedDeathRecord != null && oldDeathRecord == null) {
            return true;
        }
        if (updatedDeathRecord == null && oldDeathRecord != null) {
            return true;
        }
        if (updatedDeathRecord != null && oldDeathRecord != null && !updatedDeathRecord.equals((Object)oldDeathRecord)) {
            return true;
        }
        IneligibilityFactor updatedIneligibilityFactor = updatedPerson.getIneligibilityFactor();
        IneligibilityFactor oldIneligibilityFactor = oldPerson.getIneligibilityFactor();
        if (updatedIneligibilityFactor != null && oldIneligibilityFactor == null) {
            return true;
        }
        if (updatedIneligibilityFactor == null && oldIneligibilityFactor != null) {
            return true;
        }
        if (updatedIneligibilityFactor != null && oldIneligibilityFactor != null && this.compareAbstractKeyedEntity(updatedIneligibilityFactor, oldIneligibilityFactor)) {
            return true;
        }
        Address permAddressUpdated = updatedPerson.getPermanentAddress();
        Address permAddressOld = oldPerson.getPermanentAddress();
        boolean confidential = false;
        if (permAddressUpdated != null) {
            confidential = permAddressUpdated.isConfidential();
        }
        if (!confidential) {
            if (permAddressUpdated != null && permAddressUpdated.getBadAddressReason() == null && permAddressOld == null) {
                return true;
            }
            if (permAddressUpdated == null && permAddressOld != null && permAddressOld.getBadAddressReason() == null) {
                return true;
            }
            if (permAddressUpdated != null && permAddressUpdated.getBadAddressReason() == null && permAddressOld != null && this.compareAbstractKeyedEntity(permAddressUpdated, permAddressOld)) {
                return true;
            }
            Address tempAddressUpdated = updatedPerson.getTemporaryCorrespondenceAddress();
            Address tempAddressOld = oldPerson.getTemporaryCorrespondenceAddress();
            if (tempAddressUpdated != null && tempAddressUpdated.getBadAddressReason() == null && tempAddressOld == null) {
                return true;
            }
            if (tempAddressUpdated == null && tempAddressOld != null && tempAddressOld.getBadAddressReason() == null) {
                return true;
            }
            if (tempAddressUpdated != null && tempAddressUpdated.getBadAddressReason() == null && tempAddressOld != null && this.compareAbstractKeyedEntity(tempAddressUpdated, tempAddressOld)) {
                return true;
            }
        }
        if (this.compareAbstractKeyedEntitySets(updatedPerson.getPhones(), oldPerson.getPhones())) {
            return true;
        }
        if (this.compareAbstractKeyedEntity(updatedPerson.getEligibilityVerification(), oldPerson.getEligibilityVerification()) || this.compareAbstractKeyedEntity(updatedPerson.getServiceConnectionAward(), oldPerson.getServiceConnectionAward()) || this.compareAbstractKeyedEntity(updatedPerson.getIncompetenceRuling(), oldPerson.getIncompetenceRuling())) {
            return true;
        }
        EnrollmentDetermination newEnroll = updatedPerson.getEnrollmentDetermination();
        Eligibility newElig = newEnroll != null ? newEnroll.getPrimaryEligibility() : null;
        EnrollmentDetermination oldEnroll = oldPerson.getEnrollmentDetermination();
        Eligibility eligibility = oldElig = oldEnroll != null ? oldEnroll.getPrimaryEligibility() : null;
        if (this.compareAbstractKeyedEntity(newElig, oldElig) || this.compareAbstractKeyedEntity(updatedPerson.getIneligibilityFactor(), oldPerson.getIneligibilityFactor())) {
            return true;
        }
        MonetaryBenefitAward newAward = updatedPerson.getMonetaryBenefitAward();
        if (this.compareAbstractKeyedEntity(newAward, oldAward = oldPerson.getMonetaryBenefitAward()) || newAward != null && oldAward != null && this.compareAbstractKeyedEntitySets(newAward.getMonetaryBenefits(), oldAward.getMonetaryBenefits())) {
            return true;
        }
        return this.compareAbstractKeyedEntity(updatedPerson.getMedicaidFactor(), oldPerson.getMedicaidFactor()) || this.compareAbstractKeyedEntitySets(updatedPerson.getInsurances(), oldPerson.getInsurances());
    }

    private IVMMigration insertIVMMigrationEntry(Person person, Integer incomeYear, Set<Integer> insertedIncomeYears, boolean deleteIncomeTest) throws ServiceException {
        IVMMigration ivmMigration = new IVMMigration();
        ivmMigration.setPersonEntityKey(CommonEntityKeyFactory.createPersonIdEntityKey(person.getPersonEntityKey().getKeyValueAsString()));
        ivmMigration.setIncomeYear(incomeYear);
        if (deleteIncomeTest) {
            ivmMigration.setStampped(true);
        }
        ivmMigration.setRemigrate(false);
        this.getIvmDMService().saveIVMMigration(ivmMigration, MessageStatus.AWAITING_TRANSMISSION);
        insertedIncomeYears.add(incomeYear);
        return ivmMigration;
    }

    public boolean satisfiesIVMSelectionCriteria(Person person, Integer incomeYear, PersonIdentityTraits traits) {
        boolean meetsPriorityGroupCriteria;
        SSN ssn = traits != null ? traits.getSsn() : null;
        SSAVerificationStatus status = ssn != null ? ssn.getSsaVerificationStatus() : null;
        boolean meetsSSNVerificationStatusCriteria = status != null ? SSAVerificationStatus.VERIFIED.getCode().equals(status.getCode()) : false;
        ImpreciseDate deathDate = person.getDeathRecord() != null ? person.getDeathRecord().getDeathDate() : null;
        IncomeTest incomeTest = person.getIncomeTest(incomeYear);
        boolean futureTest = incomeTest != null && incomeTest.isFutureTest() != null ? incomeTest.isFutureTest() : false;
        MeansTestStatus mtStatus = incomeTest != null && !futureTest ? incomeTest.getStatus() : null;
        boolean meetsIncomeTestCriteria = incomeTest != null && !futureTest && incomeTest.isPrimaryIncomeTest() != null && incomeTest.isPrimaryIncomeTest() != false && StringUtils.contains((String[])mtStatusCodesForIVMCriteria, (String)mtStatus.getCode());
        EnrollmentStatus enrollmentStatus = person.getEnrollmentDetermination() != null ? person.getEnrollmentDetermination().getEnrollmentStatus() : null;
        boolean meetsEnrollmentStatusCriteria = enrollmentStatus != null ? EnrollmentStatus.CODE_PENDING_MEANS_TEST_REQUIRED.getCode().equals(enrollmentStatus.getCode()) : false;
        EnrollmentPriorityGroup priority = person.getEnrollmentDetermination() != null ? person.getEnrollmentDetermination().getPriorityGroup() : null;
        boolean bl = meetsPriorityGroupCriteria = priority != null && StringUtils.contains((String[])enrollmentPriorityCodesForIVMCriteria, (String)priority.getCode());
        return meetsSSNVerificationStatusCriteria && deathDate == null && (meetsIncomeTestCriteria || meetsPriorityGroupCriteria || meetsEnrollmentStatusCriteria && this.hasSelfReportedTest(person));
    }

    private boolean hasSelfReportedTest(Person person) {
        if (person.getIncomeTests() != null && person.getIncomeTests().isEmpty()) {
            return false;
        }
        Map incomeTestMap = person.getIncomeTests();
        Collection incomeTests = incomeTestMap.values();
        for (IncomeTest incomeTest : incomeTests) {
            String code;
            String string = code = incomeTest.getSource() != null ? incomeTest.getSource().getCode() : null;
            if (IncomeTestSource.CODE_IVM.getCode().equals(code)) continue;
            return true;
        }
        return false;
    }

    private void checkIncomeYearSpecificChanges(Set logs, Person updatedPerson, Person oldPerson) {
        Map newFinancialStatements;
        Integer iy;
        Set newSignatures;
        Set keys;
        HashMap<Integer, PersonChangeLogEntry> map = new HashMap<Integer, PersonChangeLogEntry>();
        Map newSummariesMap = updatedPerson.getPatientVisitSummaries();
        Set set = keys = newSummariesMap != null ? newSummariesMap.keySet() : null;
        if (keys != null) {
            for (SiteYear siteYear : keys) {
                Integer year = siteYear.getYear();
                if (year == null || !this.compareAbstractKeyedEntitySets(updatedPerson.getPatientVisitSummaries(year), oldPerson.getPatientVisitSummaries(year))) continue;
                map.put(year, this.createPersonChangeLogEntry(updatedPerson, year));
            }
        }
        if ((newSignatures = updatedPerson.getSignatureImages()) != null) {
            for (SignatureImage newSignature : newSignatures) {
                Integer year = newSignature.getIncomeYear();
                if (year == null || !this.compareAbstractKeyedEntity(newSignature, oldPerson.getSignatureImage(year))) continue;
                map.put(year, this.createPersonChangeLogEntry(updatedPerson, year));
            }
        }
        if (updatedPerson.getChangeEvents().containsKey("FIN_INCOMETEST_CHANGE")) {
            iy = new Integer((String)updatedPerson.getChangeEvents().get("FIN_INCOMETEST_CHANGE"));
            map.put(iy, this.createPersonChangeLogEntry(updatedPerson, iy));
        }
        if (updatedPerson.getChangeEvents().containsKey("FIN_INCTSTSTATUS_CHANGE")) {
            iy = new Integer((String)updatedPerson.getChangeEvents().get("FIN_INCTSTSTATUS_CHANGE"));
            map.put(iy, this.createPersonChangeLogEntry(updatedPerson, iy));
        }
        Set set2 = keys = (newFinancialStatements = updatedPerson.getFinancialStatements()) != null ? newFinancialStatements.keySet() : null;
        if (keys != null) {
            for (Integer year : keys) {
                Set oldSpouseFinancial;
                Set newSpouseFinancial;
                FinancialStatement oldStatement;
                if (year == null) continue;
                FinancialStatement newStatement = updatedPerson.getFinancialStatement(year);
                if (this.compareAbstractKeyedEntity(newStatement, oldStatement = oldPerson.getFinancialStatement(year))) {
                    map.put(year, this.createPersonChangeLogEntry(updatedPerson, year));
                }
                if (newStatement != null && oldStatement != null && this.compareAbstractKeyedEntitySets(new HashSet(newStatement.getIncome().values()), new HashSet(oldStatement.getIncome().values())) || newStatement != null && oldStatement != null && this.compareAbstractKeyedEntitySets(new HashSet(newStatement.getExpenses().values()), new HashSet(oldStatement.getExpenses().values())) || newStatement != null && oldStatement != null && this.compareAbstractKeyedEntitySets(new HashSet(newStatement.getAssets().values()), new HashSet(oldStatement.getAssets().values())) || newStatement != null && oldStatement != null && this.compareAbstractKeyedEntity(newStatement.getDebt(), oldStatement.getDebt())) {
                    map.put(year, this.createPersonChangeLogEntry(updatedPerson, year));
                    continue;
                }
                if (newStatement == null || oldStatement == null || !this.compareSpouseFinancialsSets(newSpouseFinancial = newStatement.getSpouseFinancials(), oldSpouseFinancial = oldStatement.getSpouseFinancials())) continue;
                map.put(year, this.createPersonChangeLogEntry(updatedPerson, year));
            }
        }
        if (updatedPerson.getChangeEvents().containsKey("FIN_DEPENDENT_CHANGE")) {
            Integer iy2 = new Integer((String)updatedPerson.getChangeEvents().get("FIN_DEPENDENT_CHANGE"));
            map.put(iy2, this.createPersonChangeLogEntry(updatedPerson, iy2));
        }
        logs.addAll(map.values());
    }

    private boolean compareAbstractKeyedEntitySets(Set newSet, Set oldSet) {
        if (newSet == null || newSet.isEmpty()) {
            return false;
        }
        if (oldSet == null || oldSet.isEmpty()) {
            return true;
        }
        for (AbstractKeyedEntity newObject : newSet) {
            boolean foundOldObjectWithSameKey = false;
            for (AbstractKeyedEntity oldObject : oldSet) {
                if (newObject.getEntityKey() == null || !newObject.getEntityKey().equals(oldObject.getEntityKey())) continue;
                foundOldObjectWithSameKey = true;
                if (newObject.getVersion() == null) break;
                if (oldObject.getVersion() == null) {
                    return true;
                }
                if (newObject.getVersion() > oldObject.getVersion()) {
                    return true;
                }
                if (!foundOldObjectWithSameKey) continue;
                break;
            }
            if (foundOldObjectWithSameKey) continue;
            return true;
        }
        return false;
    }

    private boolean compareRelation(Relation newRelation, Relation oldRelation) {
        if (this.compareAbstractKeyedEntity(newRelation, oldRelation)) {
            return true;
        }
        if (newRelation != null && oldRelation != null) {
            return this.compareAbstractKeyedEntitySets(newRelation.getSsns(), oldRelation.getSsns());
        }
        return false;
    }

    private SSAVerificationStatus getSSAVerificationStatus(Relation relation) {
        SSN ssn = relation == null ? null : relation.getOfficialSsn();
        SSAVerificationStatus status = ssn == null ? null : ssn.getSsaVerificationStatus();
        return status;
    }

    private boolean compareSpouseFinancialsSets(Set newSet, Set oldSet) {
        if (newSet == null || newSet.isEmpty()) {
            return false;
        }
        if (oldSet == null || oldSet.isEmpty()) {
            return true;
        }
        for (SpouseFinancials newFinancials : newSet) {
            boolean foundOldObjectWithSameKey = false;
            for (SpouseFinancials oldFinancials : oldSet) {
                if (newFinancials.getEntityKey() == null || !newFinancials.getEntityKey().equals(oldFinancials.getEntityKey())) continue;
                foundOldObjectWithSameKey = true;
                if (newFinancials.getVersion() == null) break;
                if (oldFinancials.getVersion() == null) {
                    return true;
                }
                if (newFinancials.getVersion() > oldFinancials.getVersion()) {
                    return true;
                }
                if (!this.compareRelation(newFinancials.getReportedOn(), oldFinancials.getReportedOn())) break;
                return true;
            }
            if (foundOldObjectWithSameKey) continue;
            return true;
        }
        return false;
    }

    private boolean compareDependentFinancialsSets(Set newSet, Set oldSet) {
        if (newSet == null || newSet.isEmpty()) {
            return false;
        }
        if (oldSet == null || oldSet.isEmpty()) {
            return true;
        }
        for (DependentFinancials newFinancials : newSet) {
            boolean foundOldObjectWithSameKey = false;
            for (DependentFinancials oldFinancials : oldSet) {
                if (newFinancials.getEntityKey() == null || !newFinancials.getEntityKey().equals(oldFinancials.getEntityKey())) continue;
                foundOldObjectWithSameKey = true;
                if (newFinancials.getVersion() == null) break;
                if (oldFinancials.getVersion() == null) {
                    return true;
                }
                if (newFinancials.getVersion() > oldFinancials.getVersion()) {
                    return true;
                }
                if (!this.compareRelation(newFinancials.getReportedOn(), oldFinancials.getReportedOn())) break;
                return true;
            }
            if (foundOldObjectWithSameKey) continue;
            return true;
        }
        return false;
    }

    private boolean compareLookup(Lookup newLookup, Lookup oldLookup) {
        String oldCode;
        String newCode = newLookup == null ? null : newLookup.getCode();
        String string = oldCode = oldLookup == null ? null : oldLookup.getCode();
        if (newCode == null && oldCode == null) {
            return false;
        }
        return newCode != null && oldCode == null || newCode == null && oldCode != null || newCode != null && oldCode != null && !newCode.equals(oldCode);
    }

    private boolean compareAbstractKeyedEntity(AbstractKeyedEntity newObject, AbstractKeyedEntity oldObject) {
        Integer oldVersion;
        Integer newVersion;
        Integer n = newVersion = newObject != null ? newObject.getVersion() : null;
        if (newVersion == null) {
            return false;
        }
        Integer n2 = oldVersion = oldObject != null ? oldObject.getVersion() : null;
        if (oldVersion == null) {
            return true;
        }
        return newVersion > oldVersion;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"A PersonService is required");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager entityCacheManager) {
        this.entityCacheManager = entityCacheManager;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public IVMDMService getIvmDMService() {
        return this.ivmDMService;
    }

    public void setIvmDMService(IVMDMService ivmDMService) {
        this.ivmDMService = ivmDMService;
    }
}

