/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.lookup.hibernate;

import gov.va.med.esr.common.model.lookup.City;
import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.common.persistent.lookup.ZipCodeDAO;
import gov.va.med.esr.common.persistent.lookup.hibernate.LookupsDAOImpl;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ZipCodeDAOImpl
extends LookupsDAOImpl
implements ZipCodeDAO {
    private static final long serialVersionUID = 57308331910383004L;
    private String queryNameGetPartialByCode = null;
    private String queryNameGetZipCodeByCityState = null;
    private String queryNameGetZipCodeByCity = null;

    @Override
    public ZipCode getPartialZipCodeByCode(String code) throws DAOException {
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("code", code);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(ZipCodeDAOImpl.this.queryNameGetPartialByCode);
                    query.setString("code", (String)this.getContextData().get("code"));
                    if (ZipCodeDAOImpl.this.isCacheQuery()) {
                        query.setCacheable(true);
                        query.setCacheRegion(ZipCodeDAOImpl.this.getCacheRegion());
                    }
                    return query.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (results.size() == 0) {
                return null;
            }
            ZipCode zipCode = new ZipCode();
            for (int index = 0; index < results.size(); ++index) {
                Object[] data = (Object[])results.get(index);
                if (index == 0) {
                    this.setZipCodeId(zipCode, (BigDecimal)data[0]);
                    this.setZipCode(zipCode, (String)data[1] == null ? "" : (String)data[1]);
                    State state = new State();
                    zipCode.setState(state);
                    state.setName((String)data[2] == null ? "" : (String)data[2]);
                    County county = new County();
                    zipCode.setCounty(county);
                    county.setName((String)data[3] == null ? "" : (String)data[3]);
                }
                City city = new City();
                this.setCityId(city, new BigDecimal(index));
                this.setCityName(city, (String)data[4] == null ? "" : (String)data[4]);
                zipCode.addCity(city);
            }
            return zipCode;
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get the list of zip codes by code.", (Throwable)e);
        }
    }

    @Override
    public List getPartialZipCodeByCityState(String cityName, String stateCode) throws DAOException {
        ArrayList<ZipCode> returnList = new ArrayList<ZipCode>();
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("cityName", cityName);
            contextData.put("stateCode", stateCode);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(ZipCodeDAOImpl.this.queryNameGetZipCodeByCityState);
                    query.setString("state", (String)this.getContextData().get("stateCode"));
                    query.setString("city", (String)this.getContextData().get("cityName"));
                    if (ZipCodeDAOImpl.this.isCacheQuery()) {
                        query.setCacheable(true);
                        query.setCacheRegion(ZipCodeDAOImpl.this.getCacheRegion());
                    }
                    return query.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            for (int index = 0; index < results.size(); ++index) {
                ZipCode zipCode = new ZipCode();
                Object[] data = (Object[])results.get(index);
                this.setZipCodeId(zipCode, (BigDecimal)data[0]);
                this.setZipCode(zipCode, (String)data[1] == null ? "" : (String)data[1]);
                returnList.add(zipCode);
            }
            return returnList;
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get the list of zip codes by city name and state name.", (Throwable)e);
        }
    }

    @Override
    public List getPartialZipCodeByCity(String cityName) throws DAOException {
        ArrayList<ZipCode> returnList = new ArrayList<ZipCode>();
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("cityName", cityName);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(ZipCodeDAOImpl.this.queryNameGetZipCodeByCity);
                    query.setString("city", (String)this.getContextData().get("cityName"));
                    if (ZipCodeDAOImpl.this.isCacheQuery()) {
                        query.setCacheable(true);
                        query.setCacheRegion(ZipCodeDAOImpl.this.getCacheRegion());
                    }
                    return query.list();
                }
            };
            List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            for (int index = 0; index < results.size(); ++index) {
                ZipCode zipCode = new ZipCode();
                Object[] data = (Object[])results.get(index);
                this.setZipCodeId(zipCode, (BigDecimal)data[0]);
                this.setZipCode(zipCode, (String)data[1] == null ? "" : (String)data[1]);
                returnList.add(zipCode);
            }
            return returnList;
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get the list of zip codes by city name.", (Throwable)e);
        }
    }

    public String getQueryNameGetPartialByCode() {
        return this.queryNameGetPartialByCode;
    }

    public void setQueryNameGetPartialByCode(String queryNameGetPartialByCode) {
        this.queryNameGetPartialByCode = queryNameGetPartialByCode;
    }

    public String getQueryNameGetZipCodeByCityState() {
        return this.queryNameGetZipCodeByCityState;
    }

    public void setQueryNameGetZipCodeByCityState(String queryNameGetZipCodeByCityState) {
        this.queryNameGetZipCodeByCityState = queryNameGetZipCodeByCityState;
    }

    public String getQueryNameGetZipCodeByCity() {
        return this.queryNameGetZipCodeByCity;
    }

    public void setQueryNameGetZipCodeByCity(String queryNameGetZipCodeByCity) {
        this.queryNameGetZipCodeByCity = queryNameGetZipCodeByCity;
    }

    private void setZipCodeId(ZipCode zipCode, BigDecimal id) {
        try {
            Class<?> clazz = Class.forName(AbstractLookup.class.getName());
            Method method = clazz.getDeclaredMethod("setIdentifier", BigDecimal.class);
            method.setAccessible(true);
            method.invoke((Object)zipCode, id);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set zip code identifier.", e);
        }
    }

    private void setZipCode(ZipCode zipCode, String code) {
        try {
            zipCode.setZipCode(code);
            Class<?> clazz = Class.forName(AbstractLookup.class.getName());
            Method method = clazz.getDeclaredMethod("setCode", String.class);
            method.setAccessible(true);
            method.invoke((Object)zipCode, code);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set zipcode code.", e);
        }
    }

    private void setCityId(City city, BigDecimal id) {
        try {
            Class<?> clazz = Class.forName(AbstractLookup.class.getName());
            Method method = clazz.getDeclaredMethod("setIdentifier", BigDecimal.class);
            method.setAccessible(true);
            method.invoke((Object)city, id);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set city identifier.", e);
        }
    }

    private void setCityName(City city, String cityName) {
        try {
            Class<?> clazz = Class.forName(AbstractNamedLookup.class.getName());
            Method method = clazz.getDeclaredMethod("setName", String.class);
            method.setAccessible(true);
            method.invoke((Object)city, cityName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set city name.", e);
        }
    }
}

