/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.lookup.hibernate;

import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.springframework.orm.hibernate3.HibernateCallback;

public class LookupsDAOImpl
extends AbstractDAOImpl
implements LookupsDAO {
    private static final long serialVersionUID = -8031874358812536848L;
    private boolean cacheQuery = false;
    private String cacheRegion = null;
    private String queryNameFindAll = null;
    private String queryNameGetByCode = null;
    private String sortByColumnName = null;
    private boolean reverseSort = false;
    private boolean filterInactiveRows = true;
    private List validCodes = null;

    public boolean isCacheQuery() {
        return this.cacheQuery;
    }

    public void setCacheQuery(boolean cacheQuery) {
        this.cacheQuery = cacheQuery;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public String getQueryNameFindAll() {
        return this.queryNameFindAll;
    }

    public void setQueryNameFindAll(String queryNameFindAll) {
        this.queryNameFindAll = queryNameFindAll;
    }

    public String getQueryNameGetByCode() {
        return this.queryNameGetByCode;
    }

    public void setQueryNameGetByCode(String queryNameGetByCode) {
        this.queryNameGetByCode = queryNameGetByCode;
    }

    @Override
    public List findAll(Class lookupType) throws DAOException {
        List data = null;
        try {
            if (this.getQueryNameFindAll() != null) {
                AbstractDAOAction callback = new AbstractDAOAction(){

                    public Object execute(Session session) {
                        Query query = session.getNamedQuery(LookupsDAOImpl.this.getQueryNameFindAll());
                        if (LookupsDAOImpl.this.isCacheQuery()) {
                            query.setCacheable(true);
                            query.setCacheRegion(LookupsDAOImpl.this.getCacheRegion());
                        }
                        return query.list();
                    }
                };
                data = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            } else {
                HashMap<String, Class> contextData = new HashMap<String, Class>();
                contextData.put("lookupType", lookupType);
                AbstractDAOAction callback = new AbstractDAOAction(contextData){

                    public Object execute(Session session) {
                        Criteria criteria = LookupsDAOImpl.this.createBaseCriteria(session, (Class)this.getContextData().get("lookupType"));
                        String orderColumn = LookupsDAOImpl.this.getSortByColumnName();
                        if (orderColumn != null) {
                            if (LookupsDAOImpl.this.isReverseSort()) {
                                criteria.addOrder(Order.desc((String)orderColumn));
                            } else {
                                criteria.addOrder(Order.asc((String)orderColumn));
                            }
                        }
                        return criteria.list();
                    }
                };
                data = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            }
            return data;
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to find all the lookups.", (Throwable)e);
        }
    }

    private Criteria createBaseCriteria(Session session, Class lookupType) {
        return this.createBaseCriteria(session, lookupType, true);
    }

    private Criteria createBaseCriteria(Session session, Class lookupType, boolean doFiltering) {
        Criteria criteria = session.createCriteria(lookupType);
        if (doFiltering) {
            if (this.isFilterInactiveRows()) {
                criteria.add((Criterion)Expression.eq((String)"active", (Object)Boolean.TRUE));
            }
            if (this.getValidCodes() != null) {
                criteria.add(Expression.in((String)"code", (Collection)this.getValidCodes()));
            }
        }
        criteria.setCacheable(true);
        criteria.setCacheRegion(this.cacheRegion);
        criteria.setCacheMode(CacheMode.NORMAL);
        return criteria;
    }

    @Override
    public AbstractLookup getByCode(Class lookupType, String code) throws DAOException {
        AbstractLookup lookupObj = null;
        try {
            if (this.getQueryNameGetByCode() != null) {
                HashMap<String, Object> contextData = new HashMap<String, Object>();
                contextData.put("lookupType", lookupType);
                contextData.put("code", code);
                AbstractDAOAction callback = new AbstractDAOAction(contextData){

                    public Object execute(Session session) {
                        Query query = session.getNamedQuery(LookupsDAOImpl.this.getQueryNameGetByCode());
                        query.setString("code", (String)this.getContextData().get("code"));
                        if (LookupsDAOImpl.this.isCacheQuery()) {
                            query.setCacheable(true);
                            query.setCacheRegion(LookupsDAOImpl.this.getCacheRegion());
                            query.setCacheMode(CacheMode.NORMAL);
                        }
                        return query.setMaxResults(1).uniqueResult();
                    }
                };
                lookupObj = (AbstractLookup)this.getHibernateTemplate().execute((HibernateCallback)callback);
            } else {
                HashMap<String, Object> contextData = new HashMap<String, Object>();
                contextData.put("lookupType", lookupType);
                contextData.put("code", code);
                AbstractDAOAction callback = new AbstractDAOAction(contextData){

                    public Object execute(Session session) {
                        Criteria criteria = LookupsDAOImpl.this.createBaseCriteria(session, (Class)this.getContextData().get("lookupType"), false);
                        criteria.add((Criterion)Expression.eq((String)"code", (Object)((String)this.getContextData().get("code"))));
                        Iterator iter = criteria.list().iterator();
                        return iter.hasNext() ? iter.next() : null;
                    }
                };
                lookupObj = (AbstractLookup)this.getHibernateTemplate().execute((HibernateCallback)callback);
            }
            return lookupObj;
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get the lookup by code.  \n LookupType = " + lookupType.getName() + ", code = " + code + ".\n exception = " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public AbstractLookup getByDescription(Class lookupType, String description) throws DAOException {
        try {
            HashMap<String, Object> contextData = new HashMap<String, Object>();
            contextData.put("lookupType", lookupType);
            contextData.put("description", description);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Criteria criteria = LookupsDAOImpl.this.createBaseCriteria(session, (Class)this.getContextData().get("lookupType"));
                    criteria.add(Expression.ilike((String)"description", (Object)((String)this.getContextData().get("description") + "%")));
                    Iterator iter = criteria.list().iterator();
                    return iter.hasNext() ? iter.next() : null;
                }
            };
            return (AbstractLookup)this.getHibernateTemplate().execute((HibernateCallback)callback);
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get the lookup by description.  \n LookupType = " + lookupType.getName() + ", description = " + description + ".\n exception = " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public AbstractLookup getByName(Class lookupType, String name) throws DAOException {
        try {
            HashMap<String, Object> contextData = new HashMap<String, Object>();
            contextData.put("lookupType", lookupType);
            contextData.put("name", name);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Criteria criteria = LookupsDAOImpl.this.createBaseCriteria(session, (Class)this.getContextData().get("lookupType"));
                    criteria.add(Expression.ilike((String)"name", (Object)((String)this.getContextData().get("name") + "%")));
                    Iterator iter = criteria.list().iterator();
                    return iter.hasNext() ? iter.next() : null;
                }
            };
            return (AbstractLookup)this.getHibernateTemplate().execute((HibernateCallback)callback);
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get the lookup by description.  \n LookupType = " + lookupType.getName() + ", description = " + name + ".\n exception = " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSortByColumnName() {
        return this.sortByColumnName;
    }

    public void setSortByColumnName(String sortByColumnName) {
        this.sortByColumnName = sortByColumnName;
    }

    private boolean isReverseSort() {
        return this.reverseSort;
    }

    public void setReverseSort(boolean reverseSort) {
        this.reverseSort = reverseSort;
    }

    private boolean isFilterInactiveRows() {
        return this.filterInactiveRows;
    }

    public void setFilterInactiveRows(boolean filterInactiveRows) {
        this.filterInactiveRows = filterInactiveRows;
    }

    public List getValidCodes() {
        return this.validCodes;
    }

    public void setValidCodes(List validCodes) {
        this.validCodes = validCodes;
    }
}

