/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.lookup.hibernate;

import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.persistent.lookup.CountyDAO;
import gov.va.med.esr.common.persistent.lookup.hibernate.LookupsDAOImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.util.HashMap;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public class CountyDAOImpl
extends LookupsDAOImpl
implements CountyDAO {
    private static final long serialVersionUID = 6092897369012916434L;
    private String queryByCountyNameAndStateCode = null;

    @Override
    public County getCountyByCountyNameAndStateCode(String countyName, String stateCode) throws DAOException {
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("countyName", countyName);
            contextData.put("stateCode", stateCode);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(CountyDAOImpl.this.queryByCountyNameAndStateCode);
                    query.setString("countyName", (String)this.getContextData().get("countyName"));
                    query.setString("stateCode", (String)this.getContextData().get("stateCode"));
                    if (CountyDAOImpl.this.isCacheQuery()) {
                        query.setCacheable(true);
                        query.setCacheRegion(CountyDAOImpl.this.getCacheRegion());
                    }
                    return query.setMaxResults(1).uniqueResult();
                }
            };
            return (County)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
        }
        catch (HibernateException e) {
            throw new DAOException("Failed to get State by name.", (Throwable)e);
        }
    }

    public String getQueryByCountyNameAndStateCode() {
        return this.queryByCountyNameAndStateCode;
    }

    public void setQueryByCountyNameAndStateCode(String queryByCountyNameAndStateCode) {
        this.queryByCountyNameAndStateCode = queryByCountyNameAndStateCode;
    }
}

