/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.persistent.history.FinancialsHistoryDAOImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.FinancialsChangeEvent;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.persistent.DAOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;

public class DependentHistoryDAOImpl
extends FinancialsHistoryDAOImpl {
    private static final long serialVersionUID = 7443861181862802236L;
    private static final String[][] getHistoryByChangeTimeQueries = new String[][]{{"spouseQuery_GetHistoryId", "spouseQuery_GetHistoryByChangeTime"}, {"dependentQuery_GetHistoryId", "dependentQuery_GetHistoryByChangeTime"}};
    private int RELATION_SPOUSE = 0;
    private int RELATION_DEPENDENT = 1;

    @Override
    protected AbstractVersionedEntity getHistoricalEntity(Session session, ChangeEvent changeEvent) throws DAOException {
        Validate.isTrue((boolean)(changeEvent instanceof FinancialsChangeEvent), (String)"changeEvent must be instance of FinancialsChangeEvent!");
        FinancialsChangeEvent fce = (FinancialsChangeEvent)changeEvent;
        Person p = new Person();
        Integer incomeYear = fce.getIncomeYear();
        FinancialStatement fs = new FinancialStatement(p, incomeYear);
        p.setFinancialStatement(incomeYear, fs);
        Set spouses = null;
        Set dependents = null;
        Iterator iter = null;
        Spouse sp2 = null;
        spouses = this.getHistoricalRelations(session, fce, this.RELATION_SPOUSE);
        for (Spouse sp2 : spouses) {
            fs.addSpouseFinancials(new SpouseFinancials(sp2));
        }
        Dependent dep2 = null;
        dependents = this.getHistoricalRelations(session, fce, this.RELATION_DEPENDENT);
        for (Dependent dep2 : dependents) {
            fs.addDependentFinancials(new DependentFinancials(dep2));
        }
        iter = spouses.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
        iter = dependents.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DependentHistoryDaoImpl getEntity: " + (Object)((Object)p)));
        }
        return p;
    }

    private Set getHistoricalRelations(Session session, FinancialsChangeEvent changeEvent, int relation) {
        BigDecimal id2 = null;
        AbstractVersionedEntity entity2 = null;
        HashSet<AbstractVersionedEntity> relations = new HashSet<AbstractVersionedEntity>();
        List objResults = null;
        Iterator objIter = null;
        Query q = session.getNamedQuery(getHistoryByChangeTimeQueries[relation][0]);
        q.setParameter("parent_id", (Object)((BigDecimal)changeEvent.getEntityKey().getKeyValue()));
        List keyResults = q.list();
        if (keyResults == null) {
            return null;
        }
        for (BigDecimal id2 : keyResults) {
            q = session.getNamedQuery(getHistoryByChangeTimeQueries[relation][1]);
            q.setParameter("id", (Object)id2);
            objResults = q.list();
            if (objResults != null) {
                for (AbstractVersionedEntity entity2 : objResults) {
                }
            }
            relations.add(entity2);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DependentHistoryDaoImpl getRelations: " + relations));
        }
        return relations;
    }

    @Override
    protected void removeDeletedRecords(AbstractVersionedEntity entity) throws DAOException {
        Iterator i;
        Person p = (Person)entity;
        Map fsMap = p.getFinancialStatements();
        Set keySet = fsMap.keySet();
        if (keySet != null && (i = keySet.iterator()).hasNext()) {
            FinancialStatement fs = (FinancialStatement)((Object)fsMap.get(i.next()));
            this.processDelete(fs.getSpouseFinancials(), fs, this.RELATION_SPOUSE);
            this.processDelete(fs.getDependentFinancials(), fs, this.RELATION_DEPENDENT);
        }
    }

    protected void processDelete(Set financials, FinancialStatement fs, int relationType) throws DAOException {
        FinancialInformation fi2 = null;
        Relation reportedOn = null;
        HashSet<FinancialInformation> toBeDeletedSet = null;
        if (financials != null) {
            for (FinancialInformation fi2 : financials) {
                reportedOn = relationType == this.RELATION_SPOUSE ? ((SpouseFinancials)fi2).getReportedOn() : ((DependentFinancials)fi2).getReportedOn();
                if (reportedOn.isDeleted().booleanValue()) {
                    if (toBeDeletedSet == null) {
                        toBeDeletedSet = new HashSet<FinancialInformation>();
                    }
                    toBeDeletedSet.add(fi2);
                    continue;
                }
                Set ssns = reportedOn.getSsns();
                if (ssns == null) continue;
                this.processDelete(ssns, reportedOn);
            }
        }
        if (toBeDeletedSet != null) {
            if (relationType == this.RELATION_SPOUSE) {
                fs.removeSpouseFinancials(toBeDeletedSet);
            } else {
                fs.removeDependentFinancials(toBeDeletedSet);
            }
        }
    }

    protected void processDelete(Set ssns, Relation reportedOn) throws DAOException {
        SSN ssn2 = null;
        HashSet<SSN> toBeDeletedSet = null;
        for (SSN ssn2 : ssns) {
            if (!ssn2.isDeleted().booleanValue()) continue;
            if (toBeDeletedSet == null) {
                toBeDeletedSet = new HashSet<SSN>();
            }
            toBeDeletedSet.add(ssn2);
        }
        if (toBeDeletedSet != null) {
            Iterator i = toBeDeletedSet.iterator();
            while (i.hasNext()) {
                reportedOn.removeSsn((SSN)((Object)i.next()));
            }
        }
    }
}

