/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.persistent.history.HistoryDAOImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractSingleAssocHistoryDAOImpl
extends HistoryDAOImpl {
    private static final long serialVersionUID = -1370346746640850300L;
    private String singleEndPropertyName = null;
    private String manyEndParentClassName = null;

    @Override
    protected AbstractVersionedEntity getHistoricalEntity(Session session, ChangeEvent changeEvent) throws DAOException {
        AbstractVersionedEntity rootEntity = null;
        AbstractVersionedEntity p = null;
        try {
            rootEntity = super.getHistoricalEntity(session, changeEvent);
            if (rootEntity != null && (p = this.getManyEndParent(rootEntity)) != null) {
                EntityKey key = ((AbstractKeyedEntity)p).getEntityKey();
                AbstractVersionedEntity c = this.getHistoricalSingleEndedChild(session, changeEvent, key);
                if (c != null) {
                    this.setSingleEndChild(p, c);
                }
                this.evict(c);
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to get Historical Entity for changeEvent: " + changeEvent, (Throwable)e);
        }
        return rootEntity;
    }

    protected AbstractVersionedEntity getManyEndParent(AbstractVersionedEntity rootEntity) {
        return rootEntity;
    }

    private AbstractVersionedEntity getHistoricalSingleEndedChild(Session session, ChangeEvent changeEvent, EntityKey key) throws Exception {
        Iterator iter;
        Criteria criteria = session.createCriteria(Class.forName(this.getManyEndParentClassName()));
        criteria.add((Criterion)Restrictions.eq((String)"identifier", (Object)key.getKeyValue()));
        Criteria rtCriteria = criteria.createCriteria(this.getSingleEndPropertyName(), "child");
        rtCriteria.addOrder(Order.desc((String)"modifiedOn"));
        rtCriteria.addOrder(Order.desc((String)"historyId"));
        Filter f = this.getSession().getEnabledFilter("asOfDate");
        if (f != null) {
            rtCriteria.add((Criterion)Expression.le((String)"modifiedOn", (Object)changeEvent.getTimeStamp()));
        } else {
            f = this.getSession().getEnabledFilter("priorToDate");
            if (f != null) {
                rtCriteria.add((Criterion)Expression.lt((String)"modifiedOn", (Object)changeEvent.getTimeStamp()));
            }
        }
        criteria.setFetchMode(this.getSingleEndPropertyName(), FetchMode.JOIN);
        criteria.setMaxResults(1);
        criteria.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        AbstractVersionedEntity c = null;
        List results = criteria.list();
        if (results != null && (iter = results.iterator()).hasNext()) {
            Map map = (Map)iter.next();
            c = (AbstractVersionedEntity)map.get("child");
        }
        return c;
    }

    protected void processDeleteSimpleSetNoReflection(Set set, AbstractVersionedEntity proxiedObject) throws DAOException {
        AbstractVersionedEntity obj2 = null;
        HashSet<AbstractVersionedEntity> toBeDeletedSet = null;
        for (AbstractVersionedEntity obj2 : set) {
            if (!obj2.isDeleted().booleanValue()) continue;
            if (toBeDeletedSet == null) {
                toBeDeletedSet = new HashSet<AbstractVersionedEntity>();
            }
            toBeDeletedSet.add(obj2);
        }
        if (toBeDeletedSet != null) {
            Iterator i = toBeDeletedSet.iterator();
            while (i.hasNext()) {
                this.removeChildOfProxiedObject(proxiedObject, (AbstractVersionedEntity)i.next());
            }
        }
    }

    protected void removeChildOfProxiedObject(AbstractVersionedEntity parent, AbstractVersionedEntity child) {
    }

    protected abstract AbstractVersionedEntity getSingleEndChild(AbstractVersionedEntity var1);

    protected abstract void setSingleEndChild(AbstractVersionedEntity var1, AbstractVersionedEntity var2);

    @Override
    protected void removeDeletedRecords(AbstractVersionedEntity entity) throws DAOException {
        AbstractVersionedEntity c;
        super.removeDeletedRecords(entity);
        AbstractVersionedEntity p = this.getManyEndParent(entity);
        if (p != null && (c = this.getSingleEndChild(p)) != null && c.isDeleted().booleanValue()) {
            this.setSingleEndChild(p, null);
            return;
        }
    }

    public String getSingleEndPropertyName() {
        return this.singleEndPropertyName;
    }

    public void setSingleEndPropertyName(String singleEndPropertyName) {
        this.singleEndPropertyName = singleEndPropertyName;
    }

    public String getManyEndParentClassName() {
        return this.manyEndParentClassName;
    }

    public void setManyEndParentClassName(String manyEndParentClassName) {
        this.manyEndParentClassName = manyEndParentClassName;
    }
}

