/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.HandbookBatchRequestStatistics;
import gov.va.med.esr.common.model.comms.HandbookStatsColumnInfo;
import gov.va.med.esr.common.model.lookup.HandBookRequestStatusType;
import gov.va.med.esr.common.persistent.comms.HandbookBatchStatisticsDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class HandbookBatchStatisticsDAOImpl
extends AbstractDAOImpl
implements HandbookBatchStatisticsDAO {
    private static final long serialVersionUID = 7438726047987826137L;
    private static final String QRY_HANDBOOK_BATCH_STAT_BATCHINFO = "handBookBatchRequest_statistics_batchInfo";
    private static final String QRY_HANDBOOK_BATCH_STAT_SENTTOCMS = "handBookBatchRequest_statistics_sentToCMS";
    private static final String QRY_HANDBOOK_BATCH_STAT_REJ_HEC = "handBookBatchRequest_statistics_rejectedByHEC";
    private static final String QRY_HANDBOOK_BATCH_STAT_MAILEDBYCMS = "handBookBatchRequest_statistics_mailedByCMS";
    private static final String QRY_HANDBOOK_BATCH_STAT_ONLINE = "handBookBatchRequest_statistics_onLine";
    private static final String QRY_HANDBOOK_BATCH_STAT_ERRCMS = "handBookBatchRequest_statistics_erroredByCMS";
    private static final String QRY_HANDBOOK_BATCH_STAT_CODE1REJ = "handBookBatchRequest_statistics_code1Reject";
    private static final String QRY_HANDBOOK_BATCH_STAT_RETUSPS = "handBookBatchRequest_statistics_returnedByUSPS";
    private static final String QRY_HANDBOOK_BATCH_STAT_VBR_HB = "handBookBatchRequest_statistics_handbooksInVBR";
    private static final String QRY_HANDBOOK_BATCH_STAT_VBR_BAG = "handBookBatchRequest_statistics_benefitsAtAGlanceInVBR";
    private static final HandbookStatsColumnInfo[] queryToCountIndexMapList = new HandbookStatsColumnInfo[]{new HandbookStatsColumnInfo("handBookBatchRequest_statistics_rejectedByHEC", 0), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_sentToCMS", 1), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_mailedByCMS", 5), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_onLine", 6), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_handbooksInVBR", 7), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_benefitsAtAGlanceInVBR", 8), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_erroredByCMS", 9), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_code1Reject", 10), new HandbookStatsColumnInfo("handBookBatchRequest_statistics_returnedByUSPS", 11)};

    @Override
    public List<HandbookBatchRequestStatistics> getHandbookBatchRequestStatistics(Date releaseDate) throws DAOException {
        ArrayList<HandbookBatchRequestStatistics> requestStats = new ArrayList<HandbookBatchRequestStatistics>();
        this.getBatchRequestInfo(requestStats, releaseDate);
        List<BigDecimal> completedBatchIds = this.getCompletedBatchIds(requestStats);
        if (!completedBatchIds.isEmpty()) {
            this.getBatchStatistics(requestStats, completedBatchIds);
            this.getTotalCounts(requestStats);
        }
        return requestStats;
    }

    private void getBatchRequestInfo(List<HandbookBatchRequestStatistics> requestStats, Date releaseDate) throws DAOException {
        try {
            String[] batchIdParamFields = new String[]{"releaseDate"};
            Object[] batchIdParamValues = new Object[]{releaseDate};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_HANDBOOK_BATCH_STAT_BATCHINFO, batchIdParamFields, batchIdParamValues);
            for (Object[] data : results) {
                HandbookBatchRequestStatistics stat = this.buildBatchRequestStat(data);
                requestStats.add(stat);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get handbook statistics by release date", (Throwable)e);
        }
    }

    private HandbookBatchRequestStatistics buildBatchRequestStat(Object[] data) {
        HandbookBatchRequestStatistics stat = new HandbookBatchRequestStatistics();
        stat.setBatchRequestId((BigDecimal)data[0]);
        stat.setBatchRequestStatus((String)data[1]);
        stat.setRequestNote((String)data[2]);
        stat.setMaxPerJobNumber((Integer)data[3]);
        stat.setBatchReleaseSize((Integer)data[4]);
        return stat;
    }

    private List<BigDecimal> getCompletedBatchIds(List<HandbookBatchRequestStatistics> requestStats) {
        ArrayList<BigDecimal> completedIds = new ArrayList<BigDecimal>();
        for (HandbookBatchRequestStatistics stat : requestStats) {
            if (!HandBookRequestStatusType.COMPLETED.getCode().equals(stat.getBatchRequestStatus())) continue;
            completedIds.add(stat.getBatchRequestId());
        }
        return completedIds;
    }

    private void getBatchStatistics(List<HandbookBatchRequestStatistics> requestStats, List<BigDecimal> batchIds) {
        for (HandbookStatsColumnInfo queryCountIndexSet : queryToCountIndexMapList) {
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(queryCountIndexSet.getQueryName(), "batchRequestIds", batchIds);
            for (Object[] data : results) {
                BigDecimal id = (BigDecimal)data[0];
                Integer count = (Integer)data[1];
                HandbookBatchRequestStatistics stat = this.findStatById(requestStats, id);
                if (stat == null) continue;
                stat.setCounts(queryCountIndexSet.getCountIndex(), count);
            }
        }
    }

    private HandbookBatchRequestStatistics findStatById(List<HandbookBatchRequestStatistics> requestStats, BigDecimal requestId) {
        if (requestId != null) {
            for (HandbookBatchRequestStatistics stat : requestStats) {
                if (!requestId.equals(stat.getBatchRequestId())) continue;
                return stat;
            }
        }
        return null;
    }

    private void getTotalCounts(List<HandbookBatchRequestStatistics> requestStats) {
        HandbookBatchRequestStatistics totalStats = new HandbookBatchRequestStatistics();
        totalStats.setRequestNote("Total Count:");
        for (HandbookBatchRequestStatistics stat : requestStats) {
            for (HandbookStatsColumnInfo queryCountIndex : queryToCountIndexMapList) {
                int index = queryCountIndex.getCountIndex();
                totalStats.setCounts(index, totalStats.getCounts(index) + stat.getCounts(index));
            }
            totalStats.setMaxPerJobNumber(totalStats.getMaxPerJobNumber() + stat.getMaxPerJobNumber());
            totalStats.setBatchReleaseSize(totalStats.getBatchReleaseSize() + stat.getBatchReleaseSize());
        }
        requestStats.add(totalStats);
    }

    public List<Date> getHandbookBatchFileProcessDateList() throws DAOException {
        return null;
    }
}

