/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.HandbookBatchFileProcessStatistics;
import gov.va.med.esr.common.model.comms.HandbookStatsColumnInfo;
import gov.va.med.esr.common.persistent.comms.HandbookBatchFileProcessStatisticsDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class HandbookBatchFileProcessStatisticsDAOImpl
extends AbstractDAOImpl
implements HandbookBatchFileProcessStatisticsDAO {
    private static final long serialVersionUID = 7438726047987826137L;
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_BATCHNUM = "handBookBatchFileProcess_statistics_FileProcessBatchNum";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_TOTALRECORDSNUM = "handBookBatchFileProcess_statistics_FileProcessRecordsNum";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_PFINSERT_SENTTOCMS = "handBookBatchFileProcess_statistics_sentToCMS_400F";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_HB_SENTTOCMS = "handBookBatchFileProcess_statistics_sentToCMS_400H";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_BENEFITINSERT_SENTTOCMS = "handBookBatchFileProcess_statistics_sentToCMS_400B";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_REJ_HEC = "handBookBatchFileProcess_statistics_rejectedByHEC";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_MAILEDBYCMS = "handBookBatchFileProcess_statistics_mailedByCMS";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_ONLINE = "handBookBatchFileProcess_statistics_onLine";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_ERRCMS = "handBookBatchFileProcess_statistics_erroredByCMS";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_CODE1REJ = "handBookBatchFileProcess_statistics_code1Reject";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_RETUSPS = "handBookBatchFileProcess_statistics_returnedByUSPS";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_VBR_HB = "handBookBatchFileProcess_statistics_handbooksInVBR";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_VBR_BAG = "handBookBatchFileProcess_statistics_benefitsAtAGlanceInVBR";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_DATE_LIST = "jobResultDateListQuery";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_MINJOBSTARTDATE = "jobResultMinJobStartDate";
    private static final String QRY_HANDBOOK_BATCH_FILE_PROCESS_MAXJOBENDDATE = "jobResultMaxJobEndDate";
    private static final HandbookStatsColumnInfo[] queryToCountIndexMapList = new HandbookStatsColumnInfo[]{new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_rejectedByHEC", 0), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_sentToCMS_400F", 2), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_sentToCMS_400H", 3), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_sentToCMS_400B", 4), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_mailedByCMS", 5), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_onLine", 6), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_handbooksInVBR", 7), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_benefitsAtAGlanceInVBR", 8), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_erroredByCMS", 9), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_code1Reject", 10), new HandbookStatsColumnInfo("handBookBatchFileProcess_statistics_returnedByUSPS", 11)};

    @Override
    public HandbookBatchFileProcessStatistics getHandbookBatchFileProcessStatistics(Date selectedDate, Date minJobStartDate, Date maxJobEndDate) throws DAOException {
        HandbookBatchFileProcessStatistics fileProcessStats = new HandbookBatchFileProcessStatistics();
        this.getBatchFileProcessInfo(fileProcessStats, selectedDate, minJobStartDate, maxJobEndDate);
        this.getBatchFileProcessStatistics(fileProcessStats, minJobStartDate, maxJobEndDate);
        return fileProcessStats;
    }

    private void getBatchFileProcessInfo(HandbookBatchFileProcessStatistics fileProcessStats, Date selectedDate, Date minJobStartDate, Date maxJobEndDate) throws DAOException {
        try {
            String[] jobDateParamFields = new String[]{"minJobStartDate", "maxJobEndDate"};
            Object[] jobDateParamValues = new Object[]{minJobStartDate, maxJobEndDate};
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_BATCHNUM, jobDateParamFields, jobDateParamValues);
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
            String jobStartDateStr = formatter.format((Object)selectedDate);
            fileProcessStats.setFileProcessBatchStartDateStr(jobStartDateStr);
            for (Integer batchNum : results) {
                fileProcessStats.setNumFileBatchRequest(batchNum != null ? batchNum : new Integer(0));
            }
            results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_HANDBOOK_BATCH_FILE_PROCESS_STAT_TOTALRECORDSNUM, jobDateParamFields, jobDateParamValues);
            for (Integer recordsNum : results) {
                fileProcessStats.setNumRecordsFromFileBatchRequest(recordsNum != null ? recordsNum : new Integer(0));
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get handbook statistics by job start date and job end date", (Throwable)e);
        }
    }

    private void getBatchFileProcessStatistics(HandbookBatchFileProcessStatistics fileProcessStats, Date minJobStartDate, Date maxJobEndDate) {
        String[] jobDateParamFields = new String[]{"minJobStartDate", "maxJobEndDate"};
        Object[] jobDateParamValues = new Object[]{minJobStartDate, maxJobEndDate};
        for (HandbookStatsColumnInfo queryCountIndexSet : queryToCountIndexMapList) {
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(queryCountIndexSet.getQueryName(), jobDateParamFields, jobDateParamValues);
            for (Integer count : results) {
                fileProcessStats.setCounts(queryCountIndexSet.getCountIndex(), count != null ? count : new Integer(0));
            }
        }
    }

    @Override
    public List<Date> getHandbookBatchFileProcessDateList() throws DAOException {
        ArrayList<Date> hbfDateList = new ArrayList();
        hbfDateList = super.getHibernateTemplate().findByNamedQuery(QRY_HANDBOOK_BATCH_FILE_PROCESS_DATE_LIST);
        return hbfDateList;
    }

    @Override
    public Date getHandbookBatchFileProcessMinJobStartDate(Date selectedDate) throws DAOException {
        String[] selectedDateParamFields = new String[]{"selectedDate"};
        Object[] selectedDateParamValues = new Object[]{selectedDate};
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_HANDBOOK_BATCH_FILE_PROCESS_MINJOBSTARTDATE, selectedDateParamFields, selectedDateParamValues);
        return results == null || results.isEmpty() ? null : (Date)results.get(0);
    }

    @Override
    public Date getHandbookBatchFileProcessMaxJobEndDate(Date selectedDate) throws DAOException {
        String[] selectedDateParamFields = new String[]{"selectedDate"};
        Object[] selectedDateParamValues = new Object[]{selectedDate};
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(QRY_HANDBOOK_BATCH_FILE_PROCESS_MAXJOBENDDATE, selectedDateParamFields, selectedDateParamValues);
        return results == null || results.isEmpty() ? null : (Date)results.get(0);
    }
}

