/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.Directory;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.persistent.comms.DocumentReceiptDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class DocumentReceiptDAOImpl
extends AbstractDAOImpl
implements DocumentReceiptDAO {
    private static final long serialVersionUID = 6392209931355445693L;
    private static final String FIND_LATEST_BY_PERSON = "DocumentReceipt_All_ByReceiptDate_Desc";
    private DAOOperations dao = null;

    public DAOOperations getDao() {
        return this.dao;
    }

    @Override
    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    @Override
    public DocumentReceipt findDocumentReceiptById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("DocumentReceipt_Identifier", "identifier", (Object)identifier);
            return results.isEmpty() ? null : (DocumentReceipt)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", (Throwable)e);
        }
    }

    @Override
    public DocumentReceipt findDocumentReceiptByVersion(String vpid, String versionNumber) throws DAOException {
        try {
            String[] paramNames = new String[]{"personVpid", "versionNumber"};
            Object[] params = new Object[]{vpid, versionNumber};
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("DocumentReceipt_Version", paramNames, params);
            return results.isEmpty() ? null : (DocumentReceipt)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public List findDocumentReceipts(String vpid) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("DocumentReceipt_All", "personVpid", (Object)vpid);
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public List findLatestDocumentReceipts(String vpid) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_LATEST_BY_PERSON, "personVpid", (Object)vpid);
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public DocumentReceipt findDocumentReceiptByReceiptString(String receiptString) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("DocumentReceipt_findByReceiptString", "receiptString", (Object)receiptString);
            if (results != null && results.size() > 0) {
                return (DocumentReceipt)((Object)results.get(0));
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public Directory getActiveVBRDirectoty() throws DAOException {
        HibernateTemplate tpl = this.getHibernateTemplate();
        List results = tpl.findByNamedQueryAndNamedParam("findActiveVBADirectory", "inUseFlag", (Object)"Y");
        if (results != null && results.size() > 0) {
            return (Directory)((Object)results.get(0));
        }
        return null;
    }

    @Override
    public void deleteDocumentReceipt(DocumentReceipt documentReceipt) throws DAOException {
        super.removeObject(documentReceipt.getEntityKey());
    }
}

